/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.mtp.TransportAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class HTTPClientConnection
extends Connection {
    private static final int READY = 0;
    private static final int WRITTEN = 1;
    private static final int CLOSED = -1;
    private HttpURLConnection hc;
    private String url;
    private InputStream is;
    private OutputStream os;
    private int state;

    public HTTPClientConnection(TransportAddress ta) {
        this.url = this.getProtocol() + ta.getHost() + ":" + ta.getPort() + "/jade";
        this.state = 0;
        Authenticator.setDefault(new Authenticator(){
            private String username = null;
            private String password = null;

            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.username == null) {
                    this.username = System.getProperty("http.username");
                    this.password = System.getProperty("http.password");
                    if (this.username == null) {
                        JTextField usrTF = new JTextField();
                        JPasswordField pwdTF = new JPasswordField();
                        Object[] message = new Object[]{"Insert username and password", usrTF, pwdTF};
                        int ret = JOptionPane.showConfirmDialog(null, message, null, 2);
                        if (ret == 0) {
                            this.username = usrTF.getText();
                            this.password = pwdTF.getText();
                        }
                    }
                }
                return new PasswordAuthentication(this.username, this.password.toCharArray());
            }
        });
    }

    protected String getProtocol() {
        return "http://";
    }

    protected HttpURLConnection open(String url) throws MalformedURLException, IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public int writePacket(JICPPacket pkt) throws IOException {
        if (this.state == 0) {
            int ret = 0;
            this.hc = this.open(this.url);
            this.hc.setDoOutput(true);
            this.hc.setRequestMethod("POST");
            this.hc.connect();
            this.os = this.hc.getOutputStream();
            ret = pkt.writeTo(this.os);
            this.state = 1;
            return ret;
        }
        throw new IOException("Write not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JICPPacket readPacket() throws IOException {
        if (this.state == 1) {
            JICPPacket jICPPacket;
            try {
                this.is = this.hc.getInputStream();
                jICPPacket = JICPPacket.readFrom(this.is);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return jICPPacket;
        }
        throw new IOException("Wrong connection state " + this.state);
    }

    public void close() throws IOException {
        this.state = -1;
        try {
            this.is.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.is = null;
        try {
            this.os.close();
        }
        catch (Exception e3) {
            // empty catch block
        }
        this.os = null;
        try {
            this.hc.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hc = null;
    }

    public String getRemoteHost() throws Exception {
        throw new Exception("Unsupported operation");
    }
}

