/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.AID;
import jade.imtp.leap.Command;
import jade.imtp.leap.LEAPSerializationException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class SerializationEngine {
    private static final byte NULL_ID = 0;
    private static final byte STRING_ID = 1;
    private static final byte ACL_ID = 2;
    private static final byte STRING_ARRAY_ID = 3;
    private static final byte BOOLEAN_ID = 4;
    private static final byte INTEGER_ID = 5;
    private static final byte AID_ID = 6;

    SerializationEngine() {
    }

    static final byte[] serialize(Command cmd) throws LEAPSerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(cmd.getCode());
            int paramCnt = cmd.getParamCnt();
            dos.writeByte(paramCnt);
            for (int i = 0; i < paramCnt; ++i) {
                SerializationEngine.serializeObject(cmd.getParamAt(i), dos);
            }
            byte[] bb = baos.toByteArray();
            return bb;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Command");
        }
    }

    static final Command deserialize(byte[] data) throws LEAPSerializationException {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            byte type = dis.readByte();
            Command cmd = new Command(type);
            int paramCnt = dis.readByte();
            for (int i = 0; i < paramCnt; ++i) {
                cmd.addParam(SerializationEngine.deserializeObject(dis, data));
            }
            return cmd;
        }
        catch (Exception e2) {
            throw new LEAPSerializationException("Error deserializing Command " + e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void serializeObject(Object o, DataOutputStream dos) throws LEAPSerializationException {
        try {
            if (o != null) {
                if (o instanceof String) {
                    dos.writeByte(1);
                    dos.writeUTF((String)o);
                    return;
                } else if (o instanceof ACLMessage) {
                    dos.writeByte(2);
                    LEAPACLCodec.serializeACL((ACLMessage)o, dos);
                    return;
                } else if (o instanceof AID) {
                    dos.writeByte(6);
                    LEAPACLCodec.serializeAID((AID)o, dos);
                    return;
                } else if (o instanceof String[]) {
                    dos.writeByte(3);
                    SerializationEngine.serializeStringArray((String[])o, dos);
                    return;
                } else if (o instanceof Boolean) {
                    dos.writeByte(4);
                    dos.writeBoolean((Boolean)o);
                    return;
                } else {
                    if (!(o instanceof Integer)) throw new LEAPSerializationException("Unknown class " + o.getClass().getName());
                    dos.writeByte(5);
                    dos.writeInt((Integer)o);
                }
                return;
            } else {
                dos.writeByte(0);
            }
            return;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("I/O Error Serializing object " + o + ". " + ioe.getMessage());
        }
    }

    private static final Object deserializeObject(DataInputStream dis, byte[] data) throws LEAPSerializationException {
        try {
            byte id = dis.readByte();
            switch (id) {
                case 0: {
                    return null;
                }
                case 1: {
                    return dis.readUTF();
                }
                case 2: {
                    return LEAPACLCodec.deserializeACL(dis);
                }
                case 6: {
                    return LEAPACLCodec.deserializeAID(dis);
                }
                case 3: {
                    return SerializationEngine.deserializeStringArray(dis);
                }
                case 4: {
                    return new Boolean(dis.readBoolean());
                }
                case 5: {
                    return new Integer(dis.readInt());
                }
            }
            throw new LEAPSerializationException("Unknown class ID: " + id);
        }
        catch (IOException e2) {
            throw new LEAPSerializationException("I/O Error Deserializing a generic object");
        }
    }

    private static final void serializeStringArray(String[] ss, DataOutputStream dos) throws IOException, LEAPSerializationException {
        dos.writeByte(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            dos.writeUTF(ss[i]);
        }
    }

    private static final String[] deserializeStringArray(DataInputStream dis) throws IOException, LEAPSerializationException {
        String[] ss = new String[dis.readByte()];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = dis.readUTF();
        }
        return ss;
    }
}

