/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.imtp.leap.ICPException;
import jade.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSLHelper {
    public static final List supportedKeys = Collections.unmodifiableList(Arrays.asList("SSL_DH_anon_WITH_RC4_128_MD5"));
    private static Logger logger = Logger.getJADELogger(SSLHelper.class.getName());

    public static String[] getSupportedKeys() {
        return supportedKeys.toArray(new String[0]);
    }

    private SSLHelper() {
    }

    public static boolean needAuth(String keystore) {
        return new File(keystore).canRead();
    }

    public static boolean needAuth() {
        return SSLHelper.needAuth(System.getProperty("javax.net.ssl.keyStore"));
    }

    public static SSLContext createContext() throws ICPException {
        return SSLHelper.createContext("keystore", "passphrase");
    }

    public static SSLContext createContext(String keystore, String passphrase) throws ICPException {
        SSLContext ctx = null;
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", keystore);
        }
        if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
            System.setProperty("javax.net.ssl.keyStorePassword", passphrase);
        }
        if (SSLHelper.needAuth()) {
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "keyStore found!");
            }
            ctx = SSLHelper.createContextWithAuth();
        } else {
            ctx = SSLHelper.createContextNoAuth();
        }
        return ctx;
    }

    public static SSLContext createContextNoAuth() throws ICPException {
        SSLContext ctx = null;
        if (ctx == null) {
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(null, null, null);
            }
            catch (Exception e2) {
                throw new ICPException("Error creating SSLContext.", e2);
            }
        }
        return ctx;
    }

    public static SSLContext createContextWithAuth() throws ICPException {
        SSLContext ctx = null;
        try {
            char[] passphrase = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(System.getProperty("javax.net.ssl.keyStore")), passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e2) {
            throw new ICPException("Error creating SSLContext.", e2);
        }
        return ctx;
    }
}

