/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.IMTPException;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NATUtils {
    private String serverAddr;
    private int serverPort;

    public NATUtils(String serverAddr, int serverPort) {
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetSocketAddress[] getNATMapping(final String localAddress, final int localPort, int timeout) throws Exception {
        InetSocketAddress[] inetSocketAddressArray;
        JICPAddress ta = new JICPAddress(this.serverAddr, String.valueOf(this.serverPort), null, null);
        JICPConnection con = null;
        try {
            con = new JICPConnection(ta){

                protected void bindSocket(Socket sc) {
                    try {
                        if (localPort > 0) {
                            if (localAddress != null) {
                                sc.bind(new InetSocketAddress(localAddress, localPort));
                            } else {
                                sc.bind(new InetSocketAddress(localPort));
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            };
            JICPPacket pkt = new JICPPacket(21, 0, new byte[]{0});
            con.writePacket(pkt);
            InetSocketAddress internalEndPoint = new InetSocketAddress(con.getLocalHost(), con.getLocalPort());
            JICPPacket rsp = con.readPacket();
            if (rsp.getType() == 100) throw new IMTPException("JICP Protocol error");
            byte[] data = rsp.getData();
            if (data == null) throw new IMTPException("Null JICP response");
            String str = new String(data);
            System.out.println("Received data " + str);
            String[] ss = str.split(":");
            if (ss.length != 2) throw new IMTPException("Missing port information in JICP response");
            try {
                InetSocketAddress externalEndPoint = new InetSocketAddress(ss[0], Integer.parseInt(ss[1]));
                inetSocketAddressArray = new InetSocketAddress[]{internalEndPoint, externalEndPoint};
            }
            catch (NumberFormatException nfe) {
                throw new IMTPException("Wrong port format in JICP response");
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            try {
                con.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return inetSocketAddressArray;
        }
        con.close();
        return inetSocketAddressArray;
    }

    public static void main(String[] args) {
        NATUtils nat = new NATUtils(args[0], Integer.parseInt(args[1]));
        try {
            InetSocketAddress[] aa = nat.getNATMapping(null, 8888, 10000);
            System.out.println("local =    " + aa[0]);
            System.out.println("external = " + aa[1]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

