/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.SSLHelper;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.IOException;
import java.net.BindException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JICPSConnection
extends JICPConnection {
    private static SSLSocketFactory scsf = null;
    protected static Logger myLogger = Logger.getMyLogger(JICPSConnection.class.getName());

    protected JICPSConnection() {
    }

    public JICPSConnection(TransportAddress ta) throws IOException {
        this.constructJICPSConnectionNoAuth(ta);
    }

    public JICPSConnection(TransportAddress ta, boolean useSSLAuth) throws IOException {
        if (useSSLAuth) {
            this.constructJICPSConnectionWithAuth(ta);
        } else {
            this.constructJICPSConnectionNoAuth(ta);
        }
    }

    private void constructJICPSConnectionNoAuth(TransportAddress ta) throws IOException {
        myLogger.log(Logger.INFO, "Creating JICPSConnection with NO-AUTHENTICATION (only confidentiality).");
        if (scsf == null) {
            try {
                SSLContext ctx = SSLHelper.createContextNoAuth();
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e2) {
                throw new IOException("Error creating SSLSocketFactory. " + e2.toString());
            }
        }
        while (true) {
            try {
                this.sc = scsf.createSocket(ta.getHost(), Integer.parseInt(ta.getPort()));
                ((SSLSocket)this.sc).setEnabledCipherSuites(SSLHelper.getSupportedKeys());
                this.sc.setTcpNoDelay(true);
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException bindException) {
                continue;
            }
            break;
        }
    }

    private void constructJICPSConnectionWithAuth(TransportAddress ta) throws IOException {
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Creating JICPSConnection with MUTUAL AUTHENTICATION.");
        }
        if (scsf == null) {
            try {
                SSLContext ctx = SSLHelper.createContextWithAuth();
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e2) {
                throw new IOException("Error creating SSLSocketFactory. " + e2.toString());
            }
        }
        while (true) {
            try {
                this.sc = scsf.createSocket(ta.getHost(), Integer.parseInt(ta.getPort()));
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException bindException) {
                continue;
            }
            break;
        }
    }

    public JICPSConnection(Socket s) {
        super(s);
    }
}

