/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.BackEnd;
import jade.core.FEConnectionManager;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Specifier;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndStub;
import jade.imtp.leap.ConnectionListener;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndSkel;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.MicroSkeleton;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Vector;

public class BIFEDispatcher
implements FEConnectionManager,
Dispatcher,
TimerListener,
Runnable {
    protected static final byte INP = 1;
    protected static final byte OUT = 0;
    private static final int RESPONSE_TIMEOUT = 30000;
    protected String myMediatorClass = "jade.imtp.leap.JICP.BIBEDispatcher";
    private MicroSkeleton mySkel = null;
    private BackEndStub myStub = null;
    protected TransportAddress mediatorTA;
    private String myMediatorID;
    private long retryTime = 10000L;
    private long maxDisconnectionTime = 600000L;
    private long keepAliveTime = 60000L;
    private long connectionDropDownTime = -1L;
    private Timer kaTimer;
    private Timer cdTimer;
    private Properties props;
    protected Connection outConnection;
    protected InputManager myInputManager;
    private ConnectionListener myConnectionListener;
    private boolean active = true;
    private boolean connectionDropped = false;
    private boolean waitingForFlush = false;
    protected boolean refreshingInput = false;
    protected boolean refreshingOutput = false;
    private byte lastSid = (byte)15;
    private int outCnt = 0;
    private Thread terminator;
    private String beAddrsText;
    private String[] backEndAddresses;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private JICPPacket lastResponse = null;
    private int cnt = 0;

    public BackEnd getBackEnd(FrontEnd fe, Properties props) throws IMTPException {
        this.props = props;
        this.myMediatorID = props.getProperty("mediator-id");
        try {
            String tmp;
            this.beAddrsText = props.getProperty("beaddrs");
            this.backEndAddresses = this.parseBackEndAddresses(this.beAddrsText);
            String host = props.getProperty("host");
            if (host == null) {
                host = "localhost";
            }
            int port = 1099;
            try {
                port = Integer.parseInt(props.getProperty("port"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.mediatorTA = JICPProtocol.getInstance().buildAddress(host, String.valueOf(port), null, null);
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Remote URL=" + JICPProtocol.getInstance().addrToString(this.mediatorTA));
            }
            if ((tmp = props.getProperty("mediator-class")) != null) {
                this.myMediatorClass = tmp;
            } else {
                props.setProperty("mediator-class", this.myMediatorClass);
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Mediator class=" + this.myMediatorClass);
            }
            tmp = props.getProperty("reconnection-retry-time");
            try {
                this.retryTime = Long.parseLong(tmp);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Reconnection time=" + this.retryTime);
            }
            tmp = props.getProperty("max-disconnection-time");
            try {
                this.maxDisconnectionTime = Long.parseLong(tmp);
            }
            catch (Exception e3) {
                props.setProperty("max-disconnection-time", String.valueOf(this.maxDisconnectionTime));
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Max discon. time=" + this.maxDisconnectionTime);
            }
            tmp = props.getProperty("keep-alive-time");
            try {
                this.keepAliveTime = Long.parseLong(tmp);
            }
            catch (Exception e4) {
                props.setProperty("keep-alive-time", String.valueOf(this.keepAliveTime));
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Keep-alive time=" + this.keepAliveTime);
            }
            tmp = props.getProperty("drop-down-time");
            try {
                this.connectionDropDownTime = Long.parseLong(tmp);
            }
            catch (Exception e5) {
                // empty catch block
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Connection-drop-down time=" + this.connectionDropDownTime);
            }
            try {
                Object obj = props.get("connection-listener");
                this.myConnectionListener = obj instanceof ConnectionListener ? (ConnectionListener)obj : (ConnectionListener)Class.forName(obj.toString()).newInstance();
            }
            catch (Exception e6) {
                // empty catch block
            }
            this.myStub = new BackEndStub(this, props);
            this.mySkel = new FrontEndSkel(fe);
            this.outConnection = this.createBackEnd();
            return this.myStub;
        }
        catch (ICPException icpe) {
            throw new IMTPException("Connection error", icpe);
        }
    }

    public synchronized void shutdown() {
        this.active = false;
        this.terminator = Thread.currentThread();
        if (this.terminator != this.myInputManager) {
            JICPPacket terminationPacket = null;
            try {
                if (this.connectionDropped) {
                    this.outConnection = this.openConnection(this.mediatorTA, 30000);
                    terminationPacket = new JICPPacket(23, 64, this.mediatorTA.getFile(), new byte[]{0});
                } else {
                    terminationPacket = new JICPPacket(0, 64, null);
                }
                if (this.outConnection != null) {
                    this.myLogger.log(Logger.INFO, "Sending termination notification");
                    this.writePacket(terminationPacket, this.outConnection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JICPConnection createBackEnd() throws IMTPException {
        StringBuffer sb = BackEndStub.encodeCreateMediatorRequest(this.props);
        if (this.myMediatorID != null) {
            BackEndStub.appendProp(sb, "mediator-id", this.myMediatorID);
            BackEndStub.appendProp(sb, "outcnt", String.valueOf(this.outCnt));
            BackEndStub.appendProp(sb, "lastsid", String.valueOf(this.lastSid));
        }
        JICPPacket pkt = new JICPPacket(22, 0, null, sb.toString().getBytes());
        for (int i = -1; i < this.backEndAddresses.length; ++i) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                this.myLogger.log(Logger.INFO, "Creating BackEnd on jicp://" + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort());
                JICPConnection con = this.openConnection(this.mediatorTA, 30000);
                this.writePacket(pkt, con);
                pkt = con.readPacket();
                String replyMsg = new String(pkt.getData());
                if (pkt.getType() != 100) {
                    BackEndStub.parseCreateMediatorResponse(replyMsg, this.props);
                    this.myMediatorID = this.props.getProperty("mediator-id");
                    this.mediatorTA = new JICPAddress(this.mediatorTA.getHost(), this.mediatorTA.getPort(), this.myMediatorID, null);
                    this.myLogger.log(Logger.INFO, "BackEnd OK: mediator-id = " + this.myMediatorID);
                    this.refreshInp();
                    return con;
                }
                this.myLogger.log(Logger.WARNING, "Mediator error: " + replyMsg);
                if (this.myConnectionListener == null || replyMsg == null || !replyMsg.startsWith("Not-authorized")) continue;
                this.myConnectionListener.handleConnectionEvent(7, replyMsg);
                continue;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connection error. " + ioe.toString());
            }
        }
        throw new IMTPException("Error creating the BackEnd.");
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush, int oldSessionId) throws ICPException {
        if (this.connectionDropped) {
            this.dispatchWhileDropped();
            throw new ICPException("Connection dropped");
        }
        if (this.outConnection != null) {
            if (this.waitingForFlush && !flush) {
                throw new ICPException("Upsetting dispatching order");
            }
            this.waitingForFlush = false;
            int status = 0;
            JICPPacket pkt = new JICPPacket(0, 0, payload);
            if (flush && oldSessionId != -1) {
                this.outCnt = oldSessionId;
            }
            pkt.setSessionID((byte)this.outCnt);
            this.myLogger.log(Logger.FINE, "Issuing outgoing command " + this.outCnt);
            try {
                this.writePacket(pkt, this.outConnection);
                status = 1;
                pkt = this.outConnection.readPacket();
                if (pkt.getSessionID() != this.outCnt) {
                    pkt = this.outConnection.readPacket();
                }
                status = 2;
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, "Response received " + pkt.getSessionID());
                }
                if (pkt.getType() == 100) {
                    throw new ICPException(new String(pkt.getData()));
                }
                if ((pkt.getInfo() & 0x10) != 0) {
                    this.refreshInp();
                }
                byte[] byArray = pkt.getData();
                return byArray;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "IOException OC[" + status + "]" + ioe);
                this.refreshOut();
                throw new ICPException("Dispatching error.", ioe);
            }
            finally {
                this.outCnt = this.outCnt + 1 & 0xF;
            }
        }
        System.out.println("Out Connection null: refreshingOut = " + this.refreshingOutput);
        throw new ICPException("Unreachable");
    }

    protected synchronized void refreshInp() {
        if (this.active && !this.refreshingInput && !this.connectionDropped) {
            if (this.myInputManager != null && this.myInputManager.isConnected()) {
                this.myInputManager.close();
                if (this.outConnection != null && this.myConnectionListener != null) {
                    this.myConnectionListener.handleConnectionEvent(2, null);
                }
            }
            this.refreshingInput = true;
            this.myInputManager = new InputManager();
            this.myInputManager.start();
        }
    }

    protected synchronized void refreshOut() {
        if (!this.refreshingOutput) {
            if (this.outConnection != null) {
                try {
                    this.outConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.outConnection = null;
                if (this.myInputManager.isConnected() && this.myConnectionListener != null) {
                    this.myConnectionListener.handleConnectionEvent(2, null);
                }
            }
            this.refreshingOutput = true;
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void run() {
        this.connectOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectInp() {
        int cnt = 0;
        while (this.active) {
            try {
                BIFEDispatcher bIFEDispatcher = this;
                synchronized (bIFEDispatcher) {
                    this.myLogger.log(Logger.INFO, "Connecting to " + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort() + " " + cnt + " (INP)");
                    JICPConnection c = this.openConnection(this.mediatorTA, -1);
                    JICPPacket pkt = new JICPPacket(23, 0, this.mediatorTA.getFile(), new byte[]{1});
                    this.writePacket(pkt, c);
                    pkt = ((Connection)c).readPacket();
                    if (pkt.getType() == 100) {
                        String errorMsg = new String(pkt.getData());
                        this.myLogger.log(Logger.WARNING, "JICP Error (INP). " + errorMsg);
                        ((Connection)c).close();
                        this.refreshOut();
                        this.refreshingInput = false;
                    } else {
                        this.props.setProperty("local-host", new String(pkt.getData()));
                        this.myLogger.log(Logger.INFO, "Connect OK (INP)");
                        this.handleInpReconnection(c);
                    }
                    return;
                }
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connect failed (INP). " + ioe);
                ++cnt;
                this.waitABit(this.retryTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectOut() {
        int cnt = 0;
        long startTime = System.currentTimeMillis();
        boolean backEndExists = true;
        while (this.active) {
            try {
                Object c;
                if (backEndExists) {
                    this.myLogger.log(Logger.INFO, "Connecting to " + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort() + " " + cnt + " (OUT)");
                    c = this.openConnection(this.mediatorTA, 30000);
                    JICPPacket pkt = new JICPPacket(23, 0, this.mediatorTA.getFile(), new byte[]{0});
                    this.writePacket(pkt, (Connection)c);
                    pkt = ((Connection)c).readPacket();
                    if (pkt.getType() == 100) {
                        String errorMsg = new String(pkt.getData());
                        this.myLogger.log(Logger.WARNING, "JICP Error (OUT). " + errorMsg);
                        ((Connection)c).close();
                        if (errorMsg.equals("Not-found")) {
                            this.handleBENotFound();
                            backEndExists = false;
                            continue;
                        }
                        this.handleError();
                        return;
                    }
                    this.props.setProperty("local-host", new String(pkt.getData()));
                    this.myLogger.log(Logger.INFO, "Connect OK (OUT)");
                    this.handleOutReconnection((Connection)c);
                    return;
                }
                c = this;
                synchronized (c) {
                    JICPConnection c2 = this.createBackEnd();
                    this.handleOutReconnection(c2);
                    return;
                }
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connect failed (OUT). " + ioe);
            }
            catch (IMTPException imtpe) {
                this.myLogger.log(Logger.WARNING, "BE recreation failed.");
            }
            if (System.currentTimeMillis() - startTime > this.maxDisconnectionTime) {
                this.handleError();
                return;
            }
            ++cnt;
            this.waitABit(this.retryTime);
        }
    }

    private void waitABit(long period) {
        try {
            Thread.sleep(period);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void handleInpReconnection(Connection c) {
        this.myInputManager.setConnection(c);
        this.refreshingInput = false;
        if (this.outConnection != null && this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(3, null);
        }
    }

    protected synchronized void handleOutReconnection(Connection c) {
        if (this.connectionDropped) {
            this.connectionDropped = false;
            this.refreshInp();
        }
        this.outConnection = c;
        this.refreshingOutput = false;
        this.waitingForFlush = this.myStub.flush();
        if (this.myInputManager.isConnected() && this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(3, null);
        }
    }

    private void handleError() {
        this.myLogger.log(Logger.SEVERE, "Can't reconnect (" + System.currentTimeMillis() + ")");
        new Exception("Dummy").printStackTrace();
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(5, null);
        }
        this.myInputManager.close();
        this.active = false;
    }

    private String[] parseBackEndAddresses(String addressesText) {
        Vector addrs = Specifier.parseList(addressesText, ';');
        String[] result = new String[addrs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)addrs.elementAt(i);
        }
        return result;
    }

    protected void writePacket(JICPPacket pkt, Connection c) throws IOException {
        c.writePacket(pkt);
        if (Thread.currentThread() == this.terminator) {
            this.myInputManager.close();
        } else {
            this.updateKeepAlive();
            if (pkt.getType() != 2 && pkt.getType() != 30) {
                this.updateConnectionDropDown();
            }
        }
    }

    private synchronized void updateKeepAlive() {
        if (this.keepAliveTime > 0L) {
            TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
            if (this.kaTimer != null) {
                td.remove(this.kaTimer);
            }
            this.kaTimer = td.add(new Timer(System.currentTimeMillis() + this.keepAliveTime, this));
        }
    }

    private synchronized void updateConnectionDropDown() {
        if (this.connectionDropDownTime > 0L) {
            TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
            if (this.cdTimer != null) {
                td.remove(this.cdTimer);
            }
            this.cdTimer = td.add(new Timer(System.currentTimeMillis() + this.connectionDropDownTime, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTimeOut(Timer t) {
        BIFEDispatcher bIFEDispatcher = this;
        synchronized (bIFEDispatcher) {
            if (t == this.kaTimer) {
                this.sendKeepAlive();
            } else if (t == this.cdTimer) {
                this.dropDownConnection();
            }
        }
    }

    protected void sendKeepAlive() {
        if (this.outConnection != null) {
            JICPPacket pkt = new JICPPacket(2, 0, null);
            try {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Writing KA.");
                }
                this.writePacket(pkt, this.outConnection);
                pkt = this.outConnection.readPacket();
                if ((pkt.getInfo() & 0x10) != 0) {
                    this.refreshInp();
                }
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "IOException OC sending KA. " + ioe);
                this.refreshOut();
            }
        }
    }

    private void dropDownConnection() {
        block8: {
            if (this.outConnection != null && !this.refreshingInput && !this.connectionDropped) {
                this.myLogger.log(Logger.INFO, "Writing DROP_DOWN request");
                JICPPacket pkt = this.prepareDropDownRequest();
                try {
                    this.writePacket(pkt, this.outConnection);
                    JICPPacket rsp = this.outConnection.readPacket();
                    this.myLogger.log(Logger.INFO, "DROP_DOWN response received");
                    if (rsp.getType() != 100) {
                        try {
                            this.outConnection.close();
                            this.outConnection = null;
                        }
                        catch (IOException ioe) {
                            this.myLogger.log(Logger.WARNING, "Exception in connection drop-down closing the OUT connection. " + ioe);
                        }
                        this.myLogger.log(Logger.INFO, "Connection dropped");
                        this.connectionDropped = true;
                        if (this.myConnectionListener != null) {
                            this.myConnectionListener.handleConnectionEvent(4, null);
                        }
                        break block8;
                    }
                    this.myLogger.log(Logger.INFO, "DROP_DOWN refused");
                    if ((rsp.getInfo() & 0x10) != 0) {
                        this.myLogger.log(Logger.INFO, "INP connection refresh request from BE");
                        this.refreshInp();
                    }
                }
                catch (IOException ioe) {
                    this.myLogger.log(Logger.WARNING, "IOException sending DROP_DOWN request. " + ioe);
                    this.refreshOut();
                }
            }
        }
    }

    protected JICPPacket prepareDropDownRequest() {
        return new JICPPacket(30, 0, null);
    }

    protected void dispatchWhileDropped() {
        this.myLogger.log(Logger.INFO, "Dispatch with connection dropped. Reconnecting.");
        this.refreshOut();
    }

    private JICPConnection openConnection(TransportAddress ta, int timeout) throws IOException {
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(1, null);
        }
        JICPConnection c = this.getConnection(ta);
        if (timeout > 0) {
            c.setReadTimeout(timeout);
        }
        return c;
    }

    protected JICPConnection getConnection(TransportAddress ta) throws IOException {
        return new JICPConnection(ta);
    }

    private void handleBENotFound() {
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(6, null);
        }
    }

    private class InputManager
    extends Thread {
        private int myId;
        private Connection myConnection = null;

        private InputManager() {
        }

        public void run() {
            block14: {
                this.myId = BIFEDispatcher.this.cnt++;
                if (BIFEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                    BIFEDispatcher.this.myLogger.log(Logger.INFO, "IM-" + this.myId + " started");
                }
                int status = 0;
                BIFEDispatcher.this.connectInp();
                try {
                    while (this.isConnected()) {
                        status = 0;
                        JICPPacket pkt = this.myConnection.readPacket();
                        if (pkt.getType() == 1) {
                            BIFEDispatcher.this.myLogger.log(Logger.WARNING, "Unexpected response packet received on INP connection. Ignore it");
                            continue;
                        }
                        status = 1;
                        byte sid = pkt.getSessionID();
                        if (sid == BIFEDispatcher.this.lastSid) {
                            if (BIFEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                                BIFEDispatcher.this.myLogger.log(Logger.WARNING, "Duplicated packet from BE: pkt-type=" + pkt.getType() + " info=" + pkt.getInfo() + " SID=" + sid);
                            }
                            pkt = BIFEDispatcher.this.lastResponse;
                        } else {
                            if (pkt.getType() == 2) {
                                pkt = new JICPPacket(1, 0, null);
                            } else {
                                if (BIFEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                                    BIFEDispatcher.this.myLogger.log(Logger.FINE, "Incoming command received " + sid + " pkt-type=" + pkt.getType());
                                }
                                byte[] rspData = BIFEDispatcher.this.mySkel.handleCommand(pkt.getData());
                                if (BIFEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                                    BIFEDispatcher.this.myLogger.log(Logger.FINER, "Incoming command served " + sid);
                                }
                                pkt = new JICPPacket(1, 0, rspData);
                            }
                            pkt.setSessionID(sid);
                            if (Thread.currentThread() == BIFEDispatcher.this.terminator) {
                                pkt.setTerminatedInfo(true);
                            }
                            BIFEDispatcher.this.lastSid = sid;
                            BIFEDispatcher.this.lastResponse = pkt;
                        }
                        status = 2;
                        BIFEDispatcher.this.writePacket(pkt, this.myConnection);
                        status = 3;
                    }
                }
                catch (IOException ioe) {
                    if (!BIFEDispatcher.this.active) break block14;
                    BIFEDispatcher.this.myLogger.log(Logger.WARNING, "IOException IC[" + status + "]" + ioe);
                    BIFEDispatcher.this.refreshInp();
                }
            }
            if (BIFEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                BIFEDispatcher.this.myLogger.log(Logger.INFO, "IM-" + this.myId + " terminated");
            }
        }

        private void close() {
            try {
                this.myConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myConnection = null;
        }

        private final void setConnection(Connection c) {
            this.myConnection = c;
        }

        private final boolean isConnected() {
            return this.myConnection != null;
        }
    }
}

