/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.BackEnd;
import jade.core.IMTPException;
import jade.core.MicroRuntime;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.Specifier;
import jade.imtp.leap.Command;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.MicroStub;
import jade.lang.acl.ACLMessage;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.util.Vector;

public class BackEndStub
extends MicroStub
implements BackEnd {
    static final int BORN_AGENT = 20;
    static final int DEAD_AGENT = 21;
    static final int SUSPENDED_AGENT = 22;
    static final int RESUMED_AGENT = 23;
    static final int MESSAGE_OUT = 24;
    static final int SERVICE_INVOKATION = 25;
    private long defaultMessageStoreAndForwardTimeout = -1L;

    public BackEndStub(Dispatcher d, Properties props) {
        super(d);
        try {
            String str = props.getProperty("default-sf-timeout");
            this.defaultMessageStoreAndForwardTimeout = Long.parseLong(str != null ? str : "-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String bornAgent(String name) throws JADESecurityException, IMTPException {
        Command c = new Command(20);
        c.addParam(name);
        Command r = this.executeRemotely(c, 0L);
        if (r.getCode() == 2) {
            throw new JADESecurityException((String)r.getParamAt(2));
        }
        if (r.getParamCnt() > 0) {
            return (String)r.getParamAt(0);
        }
        return null;
    }

    public void deadAgent(String name) throws IMTPException {
        Command c = new Command(21);
        c.addParam(name);
        this.executeRemotely(c, -1L);
    }

    public void suspendedAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(22);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public void resumedAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(23);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public void messageOut(ACLMessage msg, String sender) throws NotFoundException, IMTPException {
        Command r;
        Command c = new Command(24);
        c.addParam(msg);
        c.addParam(sender);
        long timeout = this.defaultMessageStoreAndForwardTimeout;
        String messageSFTimeout = msg.getUserDefinedParameter("JADE-SF-timeout");
        if (messageSFTimeout != null) {
            try {
                timeout = Long.parseLong(messageSFTimeout);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if ((r = this.executeRemotely(c, timeout)) != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public Object serviceInvokation(String actor, String serviceName, String methodName, Object[] methodParams) throws NotFoundException, ServiceException, IMTPException {
        Command r;
        Command c = new Command(25);
        c.addParam(actor);
        c.addParam(serviceName);
        c.addParam(methodName);
        if (methodParams != null) {
            for (int i = 0; i < methodParams.length; ++i) {
                c.addParam(methodParams[i]);
            }
        }
        if ((r = this.executeRemotely(c, 0L)) != null && r.getCode() == 2) {
            if (((String)r.getParamAt(1)).equals("jade.core.NotFoundException")) {
                throw new NotFoundException((String)r.getParamAt(2));
            }
            if (((String)r.getParamAt(1)).equals("jade.core.ServiceException")) {
                throw new ServiceException((String)r.getParamAt(2));
            }
        }
        if (r.getParamCnt() > 0) {
            return r.getParamAt(0);
        }
        return null;
    }

    protected void handlePostponedCommandExpired(Command c, ICPException exception) {
        if (c.getCode() == 24) {
            ACLMessage msg = (ACLMessage)c.getParamAt(0);
            String sender = (String)c.getParamAt(1);
            String cause = exception != null ? ". Caused by - " + exception.getMessage() : "";
            int kOp = cause.indexOf(91);
            int kCl = cause.indexOf(93);
            if (kOp >= 0 && kCl == kOp + 2) {
                cause = cause.substring(0, kCl + 1);
            }
            MicroRuntime.notifyFailureToSender(msg, sender, "Cannot deliver message in due time" + cause);
        }
    }

    public static final void parseCreateMediatorResponse(String responseMessage, Properties pp) {
        Vector v = Specifier.parseList(responseMessage, '#');
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s.length() <= 0) continue;
            try {
                int index = s.indexOf(61);
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                pp.setProperty(key, value);
            }
            catch (Exception e2) {
                Logger.println("Property format error: " + s);
                e2.printStackTrace();
            }
            String mediatorId = pp.getProperty("mediator-id");
            if (mediatorId == null) continue;
            pp.setProperty("container-name", mediatorId);
        }
    }

    public static final StringBuffer encodeCreateMediatorRequest(Properties pp) {
        StringBuffer sb = new StringBuffer();
        BackEndStub.appendProp(sb, "mediator-class", pp.getProperty("mediator-class"));
        BackEndStub.appendProp(sb, "max-disconnection-time", pp.getProperty("max-disconnection-time"));
        BackEndStub.appendProp(sb, "beaddrs", pp.getProperty("beaddrs"));
        BackEndStub.appendProp(sb, "owner", pp.getProperty("owner"));
        BackEndStub.appendProp(sb, "agents", pp.getProperty("agents"));
        BackEndStub.appendProp(sb, "be-required-services", pp.getProperty("be-required-services"));
        BackEndStub.appendProp(sb, "keep-alive-time", pp.getProperty("keep-alive-time"));
        BackEndStub.appendProp(sb, "platform-id", pp.getProperty("platform-id"));
        BackEndStub.appendProp(sb, "msisdn", pp.getProperty("msisdn"));
        BackEndStub.appendProp(sb, "version", pp.getProperty("version"));
        BackEndStub.appendProp(sb, "get-server-time", pp.getProperty("get-server-time"));
        return sb;
    }

    public static void appendProp(StringBuffer sb, String key, String val) {
        if (val != null && val.length() != 0) {
            sb.append(key);
            sb.append('=');
            sb.append(val);
            sb.append('#');
        }
    }
}

