/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.gui.StringDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class VisualStringList
extends JPanel {
    Component owner;
    JList genericList;
    JScrollPane pane;
    DefaultListModel listModel;
    JPopupMenu popUp;
    JMenuItem editItem;
    JMenuItem addItem;
    JMenuItem removeItem;
    static String VIEW_LABEL = "View";
    static String EDIT_LABEL = "Edit";
    static String ADD_LABEL = "Add";
    static String REMOVE_LABEL = "Remove";

    public VisualStringList(Iterator content, Component ownerGui) {
        this.owner = ownerGui;
        this.listModel = new DefaultListModel();
        try {
            while (content.hasNext()) {
                this.listModel.addElement(content.next());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.create();
    }

    private void create() {
        this.genericList = new JList(this.listModel);
        this.genericList.setCellRenderer(new VisualListCellRenderer(this));
        this.genericList.setSelectionMode(0);
        this.genericList.setSelectedIndex(0);
        this.pane = new JScrollPane(this.genericList);
        this.genericList.setToolTipText("Right mouse click to show the popup menu");
        this.genericList.addMouseListener(new PopupMouser());
        this.popUp = new JPopupMenu();
        this.popUp.setLightWeightPopupEnabled(false);
        this.editItem = new JMenuItem(EDIT_LABEL);
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                String param = e2.getActionCommand();
                if (param.equals(EDIT_LABEL)) {
                    VisualStringList.this.editAction();
                } else if (param.equals(VIEW_LABEL)) {
                    VisualStringList.this.viewAction();
                }
            }
        });
        this.popUp.add(this.editItem);
        this.addItem = new JMenuItem(ADD_LABEL);
        this.addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Object el;
                String param = e2.getActionCommand();
                if (param.equals(ADD_LABEL) && (el = VisualStringList.this.editElement(null, true)) != null) {
                    VisualStringList.this.addElement(el);
                }
            }
        });
        this.popUp.insert(this.addItem, 0);
        this.removeItem = new JMenuItem(REMOVE_LABEL);
        this.removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Object el;
                String param = e2.getActionCommand();
                if (param.equals(REMOVE_LABEL) && VisualStringList.this.genericList.getModel().getSize() > 0 && (el = VisualStringList.this.genericList.getSelectedValue()) != null) {
                    VisualStringList.this.removeElement(el);
                }
            }
        });
        this.popUp.insert(this.removeItem, 2);
        this.add(this.pane);
    }

    private void viewAction() {
        Object el;
        if (this.genericList.getModel().getSize() > 0 && (el = this.genericList.getSelectedValue()) != null) {
            this.editElement(el, false);
        }
    }

    private void editAction() {
        if (this.genericList.getModel().getSize() > 0) {
            Object new_el;
            Object el = this.genericList.getSelectedValue();
            int index = this.genericList.getSelectedIndex();
            if (el != null && (new_el = this.editElement(el, true)) != null) {
                this.listModel.set(index, new_el);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addItem.setEnabled(enabled);
        this.removeItem.setEnabled(enabled);
        if (!enabled) {
            this.editItem.setText(VIEW_LABEL);
        }
    }

    protected String getElementName(Object el) {
        return el.toString();
    }

    private void addElement(Object el) {
        this.listModel.addElement(el);
    }

    protected void removeElement(Object el) {
        this.listModel.removeElement(el);
    }

    protected void resetContent(Iterator content) {
        this.listModel = new DefaultListModel();
        try {
            while (content.hasNext()) {
                this.listModel.addElement(content.next());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.genericList.setModel(this.listModel);
    }

    protected Object editElement(Object el, boolean isEditable) {
        String out = null;
        if (isEditable) {
            StringDlg dlgString = new StringDlg(this.owner, "Insert a new value:");
            out = dlgString.editString((String)el);
        } else {
            StringDlg dlgString = new StringDlg(this.owner, "Value:");
            dlgString.viewString((String)el);
        }
        return out;
    }

    public Enumeration getContent() {
        return this.listModel.elements();
    }

    public void setDimension(Dimension d) {
        this.pane.setPreferredSize(d);
        this.pane.setMinimumSize(d);
        this.pane.setMaximumSize(d);
    }

    private class PopupMouser
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                VisualStringList.this.popUp.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }

        public void mousePressed(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                VisualStringList.this.popUp.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }

        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                if (e2.getComponent().getParent().getParent().getParent().isEnabled()) {
                    ((VisualStringList)e2.getComponent().getParent().getParent().getParent()).editAction();
                } else {
                    ((VisualStringList)e2.getComponent().getParent().getParent().getParent()).viewAction();
                }
            }
        }
    }

    private class VisualListCellRenderer
    extends DefaultListCellRenderer {
        private VisualStringList myList;

        VisualListCellRenderer(VisualStringList l) {
            this.myList = l;
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font courier = new Font("Courier", 1, 12);
            this.setFont(courier);
            this.setText(this.myList.getElementName(value));
            this.setBackground(isSelected ? Color.lightGray : Color.white);
            return this;
        }
    }
}

