/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.gui.AIDGui;
import jade.gui.TimeChooser;
import jade.gui.VisualServicesList;
import jade.gui.VisualStringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class DFAgentDscDlg
extends JDialog
implements ActionListener {
    Dialog dlgParent = this;
    DFAgentDescription dfdAgent;
    DFAgentDescription out;
    AID newAID = null;
    boolean editable;
    boolean checkSlots;
    private VisualStringList ontologiesListPanel;
    private VisualStringList languagesListPanel;
    private VisualStringList protocolsListPanel;
    private VisualServicesList servicesListPanel;
    private JTextField agentName;
    private JButton setLTDateb;
    private Date absDateLeaseTime;
    private JTextField textFieldLeaseTime;

    public DFAgentDscDlg(Frame parent) {
        super(parent);
    }

    public DFAgentDscDlg(Dialog parent) {
        super(parent);
    }

    public DFAgentDescription ShowDFDGui(DFAgentDescription dfd, boolean ed, boolean checkMandatorySlots) {
        this.setTitle("DF description");
        this.out = null;
        this.editable = ed;
        this.checkSlots = checkMandatorySlots;
        if (dfd != null) {
            this.dfdAgent = dfd;
            this.newAID = dfd.getName();
        } else {
            this.dfdAgent = new DFAgentDescription();
        }
        JPanel p = new JPanel();
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        p.setLayout(new BoxLayout(p, 0));
        Border raised = BorderFactory.createRaisedBevelBorder();
        main.setBorder(raised);
        main.add(Box.createRigidArea(new Dimension(300, 5)));
        JLabel l = new JLabel("Agent-name:");
        l.setPreferredSize(new Dimension(80, 26));
        p.add(l);
        p.add(Box.createHorizontalGlue());
        this.agentName = new JTextField();
        this.agentName.setEditable(false);
        this.agentName.setPreferredSize(new Dimension(250, 26));
        this.agentName.setMinimumSize(new Dimension(250, 26));
        this.agentName.setMaximumSize(new Dimension(250, 26));
        this.agentName.setBackground(Color.white);
        AID aidtemp = this.dfdAgent.getName();
        if (aidtemp == null) {
            this.agentName.setText("");
        } else {
            this.agentName.setText(aidtemp.getName());
        }
        JButton AIDButton = new JButton(this.editable ? "Set" : "View");
        AIDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                String command = e2.getActionCommand();
                AIDGui guiSender = new AIDGui((Component)DFAgentDscDlg.this.dlgParent);
                if (command.equals("View")) {
                    guiSender.ShowAIDGui(DFAgentDscDlg.this.dfdAgent.getName(), false, false);
                } else if (command.equals("Set")) {
                    DFAgentDscDlg.this.newAID = guiSender.ShowAIDGui(DFAgentDscDlg.this.dfdAgent.getName(), true, DFAgentDscDlg.this.checkSlots);
                    if (DFAgentDscDlg.this.newAID != null) {
                        DFAgentDscDlg.this.agentName.setText(DFAgentDscDlg.this.newAID.getName());
                        DFAgentDscDlg.this.dfdAgent.setName(DFAgentDscDlg.this.newAID);
                    }
                }
            }
        });
        p.add(AIDButton);
        p.add(this.agentName);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel pOntologies = new JPanel();
        pOntologies.setLayout(new BorderLayout());
        pOntologies.setBorder(BorderFactory.createTitledBorder("Ontologies"));
        this.ontologiesListPanel = new VisualStringList(this.dfdAgent.getAllOntologies(), this.dlgParent);
        this.ontologiesListPanel.setDimension(new Dimension(400, 45));
        this.ontologiesListPanel.setEnabled(this.editable);
        pOntologies.add(this.ontologiesListPanel);
        main.add(pOntologies);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel pLanguages = new JPanel();
        pLanguages.setLayout(new BorderLayout());
        pLanguages.setBorder(BorderFactory.createTitledBorder("Languages"));
        this.languagesListPanel = new VisualStringList(this.dfdAgent.getAllLanguages(), this.dlgParent);
        this.languagesListPanel.setDimension(new Dimension(400, 45));
        this.languagesListPanel.setEnabled(this.editable);
        pLanguages.add(this.languagesListPanel);
        main.add(pLanguages);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel pProtocols = new JPanel();
        pProtocols.setLayout(new BorderLayout());
        pProtocols.setBorder(BorderFactory.createTitledBorder("Interaction-protocols"));
        this.protocolsListPanel = new VisualStringList(this.dfdAgent.getAllProtocols(), this.dlgParent);
        this.protocolsListPanel.setDimension(new Dimension(400, 45));
        this.protocolsListPanel.setEnabled(this.editable);
        pProtocols.add(this.protocolsListPanel);
        main.add(pProtocols);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel pServices = new JPanel();
        pServices.setBorder(BorderFactory.createTitledBorder("Agent services"));
        this.servicesListPanel = new VisualServicesList(this.dfdAgent.getAllServices(), this.dlgParent);
        this.servicesListPanel.setDimension(new Dimension(400, 45));
        this.servicesListPanel.setEnabled(this.editable);
        this.servicesListPanel.setCheckMandatorySlots(checkMandatorySlots);
        pServices.add(this.servicesListPanel);
        main.add(pServices);
        JPanel pLeaseTime = new JPanel();
        pLeaseTime.setEnabled(this.editable);
        pLeaseTime.setToolTipText("The duration at which the lease for this registration will expire");
        pLeaseTime.setSize(400, 45);
        pLeaseTime.setBorder(BorderFactory.createTitledBorder("Lease Time"));
        Date dleasetime = this.dfdAgent.getLeaseTime();
        this.textFieldLeaseTime = dleasetime == null ? new JTextField("unlimited") : new JTextField(dleasetime.toString());
        this.textFieldLeaseTime.setPreferredSize(new Dimension(335, 26));
        this.textFieldLeaseTime.setMinimumSize(new Dimension(335, 26));
        this.textFieldLeaseTime.setMaximumSize(new Dimension(335, 26));
        this.textFieldLeaseTime.setEnabled(false);
        this.setLTDateb = new JButton("Set");
        this.setLTDateb.setEnabled(this.editable);
        this.setLTDateb.setToolTipText("Set the date at which the lease time will expire");
        pLeaseTime.add(this.setLTDateb);
        pLeaseTime.add(this.textFieldLeaseTime);
        this.absDateLeaseTime = this.dfdAgent.getLeaseTime();
        this.setLTDateb.addActionListener(this);
        main.add(pLeaseTime);
        this.getContentPane().add((Component)main, "North");
        JPanel bPane = new JPanel();
        bPane.setLayout(new BoxLayout(bPane, 0));
        JButton bOK = new JButton("OK");
        bOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                String param = e2.getActionCommand();
                if (param.equals("OK")) {
                    if (DFAgentDscDlg.this.editable) {
                        DFAgentDscDlg.this.out = new DFAgentDescription();
                        if (DFAgentDscDlg.this.checkSlots && DFAgentDscDlg.this.newAID == null) {
                            JOptionPane.showMessageDialog(DFAgentDscDlg.this.dlgParent, "AID must have a non-empty name.", "Error Message", 0);
                            return;
                        }
                        DFAgentDscDlg.this.out.setName(DFAgentDscDlg.this.newAID);
                        Enumeration onto = DFAgentDscDlg.this.ontologiesListPanel.getContent();
                        while (onto.hasMoreElements()) {
                            DFAgentDscDlg.this.out.addOntologies((String)onto.nextElement());
                        }
                        Enumeration proto = DFAgentDscDlg.this.protocolsListPanel.getContent();
                        while (proto.hasMoreElements()) {
                            DFAgentDscDlg.this.out.addProtocols((String)proto.nextElement());
                        }
                        Enumeration lang = DFAgentDscDlg.this.languagesListPanel.getContent();
                        while (lang.hasMoreElements()) {
                            DFAgentDscDlg.this.out.addLanguages((String)lang.nextElement());
                        }
                        Enumeration serv = DFAgentDscDlg.this.servicesListPanel.getContent();
                        while (serv.hasMoreElements()) {
                            DFAgentDscDlg.this.out.addServices((ServiceDescription)serv.nextElement());
                        }
                        DFAgentDscDlg.this.out.setLeaseTime(DFAgentDscDlg.this.absDateLeaseTime);
                    } else {
                        DFAgentDscDlg.this.out = DFAgentDscDlg.this.dfdAgent;
                    }
                    DFAgentDscDlg.this.dispose();
                }
            }
        });
        bPane.add(bOK);
        if (this.editable) {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    String param = e2.getActionCommand();
                    if (param.equals("Cancel")) {
                        DFAgentDscDlg.this.out = null;
                        DFAgentDscDlg.this.dispose();
                    }
                }
            });
            bPane.add(cancelButton);
        }
        main.add(Box.createRigidArea(new Dimension(300, 20)));
        main.add(bPane);
        main.add(Box.createRigidArea(new Dimension(300, 20)));
        this.getContentPane().add((Component)main, "Center");
        this.setModal(true);
        this.setResizable(false);
        this.ShowCorrect();
        return this.out;
    }

    private void ShowCorrect() {
        this.pack();
        try {
            int x = this.getOwner().getX() + (this.getOwner().getWidth() - this.getWidth()) / 2;
            int y = this.getOwner().getY() + (this.getOwner().getHeight() - this.getHeight()) / 2;
            this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(true);
        this.toFront();
    }

    public void actionPerformed(ActionEvent e2) {
        JButton sourceEvent = (JButton)e2.getSource();
        if (sourceEvent.equals(this.setLTDateb)) {
            TimeChooser timeChooser = new TimeChooser();
            if (timeChooser.showEditTimeDlg(null) == 1) {
                if (timeChooser.getDate() != null) {
                    this.absDateLeaseTime = timeChooser.getDate();
                    this.textFieldLeaseTime.setText(this.absDateLeaseTime.toString());
                } else {
                    this.absDateLeaseTime = new Date(-1L);
                    this.textFieldLeaseTime.setText("unlimited");
                }
            }
            return;
        }
    }
}

