/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.gui.AgentTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class AgentTreePopupManager
extends MouseAdapter {
    AgentTree agentTree;

    public AgentTreePopupManager(AgentTree agentTree) {
        this.agentTree = agentTree;
    }

    public void mouseReleased(MouseEvent e2) {
        this.handleMouseEvent(e2);
    }

    public void mousePressed(MouseEvent e2) {
        this.handleMouseEvent(e2);
    }

    private void handleMouseEvent(MouseEvent e2) {
        JPopupMenu popup;
        if (e2.isPopupTrigger() && (popup = this.getPopup(e2)) != null) {
            popup.show(e2.getComponent(), e2.getX(), e2.getY());
        }
    }

    private JPopupMenu getPopup(MouseEvent e2) {
        int selRow = this.agentTree.tree.getRowForLocation(e2.getX(), e2.getY());
        TreePath selPath = this.agentTree.tree.getPathForLocation(e2.getX(), e2.getY());
        if (selRow != -1) {
            TreePath[] paths = this.agentTree.tree.getSelectionPaths();
            AgentTree.Node current = (AgentTree.Node)selPath.getLastPathComponent();
            String typeNode = current.getType();
            TreeSelectionModel model = this.agentTree.tree.getSelectionModel();
            if (!this.agentTree.tree.isRowSelected(selRow)) {
                model.setSelectionPath(selPath);
            } else {
                model.setSelectionPaths(paths);
            }
            return this.agentTree.getPopupMenu(typeNode);
        }
        return null;
    }
}

