/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.gui.AIDGui;
import jade.gui.TimeChooser;
import jade.gui.VisualAIDList;
import jade.gui.VisualPropertiesList;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ISO8601;
import jade.lang.acl.ParseException;
import jade.tools.sl.SLFormatter;
import jade.util.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class AclGui
extends JPanel {
    static String ADD_NEW_RECEIVER = "Insert receiver";
    private Component ownerGui;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    AID SenderAID = new AID();
    AID newAIDSender = null;
    AID fromAID = new AID();
    AID newAIDFrom = null;
    VisualAIDList receiverListPanel;
    VisualAIDList replyToListPanel;
    VisualPropertiesList propertiesListPanel;
    private boolean guiEnabledFlag = true;
    private JTextField sender;
    private boolean senderEnabledFlag;
    private JComboBox communicativeAct;
    private JTextArea content;
    private JTextField language;
    private JTextField ontology;
    private JComboBox protocol;
    private JTextField conversationId;
    private JTextField inReplyTo;
    private JTextField replyWith;
    private JTextField replyBy;
    private JTextField encoding;
    private JButton replyBySet;
    private Date replyByDate;
    private Date dateDate;
    private Date dateRecDate;
    GridBagLayout lm = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    private int leftBorder;
    private int rightBorder;
    private int topBorder;
    private int bottomBorder;
    private int xSpacing;
    private int ySpacing;
    private int gridNCol;
    private int gridNRow;
    private int[] colWidth;
    private static final int TEXT_SIZE = 30;
    private Vector fipaActVector;
    private static int N_FIPA_PROTOCOLS = 8;
    private static String[] fipaProtocols = new String[]{"fipa-auction-english", "fipa-auction-dutch", "fipa-contract-net", "fipa-iterated-contract-net", "fipa-query", "fipa-request", "fipa-request-when", "fipa-propose"};
    private ArrayList fipaProtocolArrayList;
    private int lastSelectedIndex;
    private String lastSelectedItem;
    private static final String LABEL_TO_ADD_PROT = "ADD USER-DEF PROTOCOL";
    private JPanel aclPanel;
    private Dimension minDim = new Dimension();
    private boolean firstPaintFlag = true;
    private static ACLMessage editedMsg;
    private JButton senderButton;
    private VisualAIDList toPanel;
    private JTextField from;
    private JTextArea comments;
    private JTextField representation;
    private JTextField payloadLength;
    private JTextField payloadEncoding;
    private JTextField date;
    private VisualAIDList intendedReceiverPanel;
    private JButton defaultEnvelopeButton;
    private JButton fromButton;
    private JButton dateButton;
    private JButton dateRecButton;
    private JTextField by;
    private JTextField fromRec;
    private JTextField dateRec;
    private JTextField via;
    private JTextField id;
    SLFormatter slFormatter;

    public AclGui(Component owner) {
        this.ownerGui = owner;
        JTabbedPane tabbed = new JTabbedPane();
        AclMessagePanel aclPane = new AclMessagePanel();
        EnvelopePanel envelope = new EnvelopePanel();
        tabbed.addTab("ACLMessage", aclPane);
        tabbed.addTab("Envelope", envelope);
        this.updateEnabled();
        this.add(tabbed);
        try {
            this.slFormatter = new SLFormatter();
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    private Component getChildrenOwner() {
        return this.ownerGui != null ? this.ownerGui : this;
    }

    private void formatGrid(int nr, int nc, int lb, int rb, int tb, int bb, int xs, int ys) {
        this.gridNRow = nr;
        this.gridNCol = nc;
        this.colWidth = new int[3];
        this.leftBorder = lb;
        this.rightBorder = rb;
        this.topBorder = tb;
        this.bottomBorder = bb;
        this.xSpacing = xs;
        this.ySpacing = ys;
    }

    private void setGridColumnWidth(int col, int width) {
        this.colWidth[col] = width;
    }

    private void put(JPanel panel, JComponent c, int x, int y, int dx, int dy, boolean fill) {
        this.constraint.gridx = x;
        this.constraint.gridy = y;
        this.constraint.gridwidth = dx;
        this.constraint.gridheight = dy;
        this.constraint.anchor = 17;
        this.constraint.fill = fill ? 1 : 3;
        int leftMargin = x == 0 ? this.leftBorder : 0;
        int rightMargin = x + dx == this.gridNCol ? this.rightBorder : this.xSpacing;
        int topMargin = y == 0 ? this.topBorder : 0;
        int bottomMargin = y + dy == this.gridNRow ? this.bottomBorder : this.ySpacing;
        int preferredWidth = 0;
        for (int i = 0; i < dx; ++i) {
            preferredWidth += this.colWidth[x + i] + this.xSpacing;
        }
        int preferredHeight = c.getPreferredSize().height;
        c.setPreferredSize(new Dimension(preferredWidth -= this.xSpacing, preferredHeight));
        this.constraint.insets = new Insets(topMargin, leftMargin, bottomMargin, rightMargin);
        this.lm.setConstraints(c, this.constraint);
        panel.add(c);
    }

    private void updateEnabled() {
        this.communicativeAct.setEnabled(this.guiEnabledFlag);
        this.senderButton.setText(this.guiEnabledFlag && this.senderEnabledFlag ? "Set" : "View");
        this.receiverListPanel.setEnabled(this.guiEnabledFlag);
        this.replyToListPanel.setEnabled(this.guiEnabledFlag);
        this.propertiesListPanel.setEnabled(this.guiEnabledFlag);
        this.replyWith.setEditable(this.guiEnabledFlag);
        this.inReplyTo.setEditable(this.guiEnabledFlag);
        this.conversationId.setEditable(this.guiEnabledFlag);
        this.replyBy.setEditable(false);
        this.replyBySet.setEnabled(true);
        this.replyBySet.setText(this.guiEnabledFlag ? "Set" : "View");
        this.encoding.setEditable(this.guiEnabledFlag);
        this.protocol.setEnabled(this.guiEnabledFlag);
        this.language.setEditable(this.guiEnabledFlag);
        this.ontology.setEditable(this.guiEnabledFlag);
        this.content.setEditable(this.guiEnabledFlag);
        this.fromButton.setText(this.guiEnabledFlag && this.senderEnabledFlag ? "Set" : "View");
        this.toPanel.setEnabled(this.guiEnabledFlag);
        this.comments.setEnabled(this.guiEnabledFlag);
        this.representation.setEnabled(this.guiEnabledFlag);
        this.payloadLength.setEnabled(this.guiEnabledFlag);
        this.payloadEncoding.setEnabled(this.guiEnabledFlag);
        this.date.setEditable(false);
        this.dateButton.setText(this.guiEnabledFlag ? "Set" : "View");
        this.intendedReceiverPanel.setEnabled(this.guiEnabledFlag);
        this.defaultEnvelopeButton.setVisible(this.guiEnabledFlag);
        this.by.setEditable(this.guiEnabledFlag);
        this.fromRec.setEditable(this.guiEnabledFlag);
        this.dateRec.setEditable(false);
        this.dateRecButton.setText(this.guiEnabledFlag ? "Set" : "View");
        this.id.setEditable(this.guiEnabledFlag);
        this.via.setEditable(this.guiEnabledFlag);
    }

    private void showEnvelope(Envelope envelope) {
        String param;
        try {
            this.fromAID = envelope.getFrom();
            param = this.fromAID.getName();
        }
        catch (NullPointerException e1) {
            param = "";
            this.fromAID = new AID();
        }
        this.from.setText(param);
        this.toPanel.resetContent(envelope.getAllTo());
        try {
            AID fromAID = envelope.getFrom();
            param = fromAID.getName();
        }
        catch (NullPointerException e1) {
            param = "";
        }
        this.from.setText(param);
        try {
            param = envelope.getComments();
        }
        catch (NullPointerException e1) {
            param = "";
        }
        this.comments.setText(param);
        try {
            param = envelope.getAclRepresentation();
        }
        catch (NullPointerException e1) {
            param = "";
        }
        this.representation.setText(param);
        try {
            param = envelope.getPayloadLength().toString();
        }
        catch (NullPointerException e1) {
            param = "-1";
        }
        this.payloadLength.setText(param);
        try {
            param = envelope.getPayloadEncoding();
        }
        catch (NullPointerException e1) {
            param = "";
        }
        this.payloadEncoding.setText(param);
        this.dateDate = envelope.getDate();
        if (this.dateDate != null) {
            this.date.setText(ISO8601.toString(this.dateDate));
        } else {
            this.date.setText("");
        }
        this.intendedReceiverPanel.resetContent(envelope.getAllIntendedReceiver());
        ReceivedObject recObject = envelope.getReceived();
        try {
            param = recObject.getBy();
        }
        catch (NullPointerException e2) {
            param = "";
        }
        this.by.setText(param);
        try {
            param = recObject.getFrom();
        }
        catch (NullPointerException e3) {
            param = "";
        }
        this.fromRec.setText(param);
        try {
            this.dateRecDate = recObject.getDate();
            param = ISO8601.toString(this.dateRecDate);
        }
        catch (NullPointerException e4) {
            param = "";
        }
        this.dateRec.setText(param);
        try {
            param = recObject.getId();
        }
        catch (NullPointerException e5) {
            param = "";
        }
        this.id.setText(param);
        try {
            param = recObject.getVia();
        }
        catch (NullPointerException e6) {
            param = "";
        }
        this.via.setText(param);
    }

    public void setMsg(ACLMessage msg) {
        String param;
        int perf = msg.getPerformative();
        String lowerCase = ACLMessage.getPerformative(perf).toLowerCase();
        this.communicativeAct.setSelectedItem(lowerCase);
        try {
            this.SenderAID = msg.getSender();
            param = this.SenderAID.getName();
        }
        catch (NullPointerException e2) {
            param = "";
            this.SenderAID = new AID();
        }
        this.sender.setText(param);
        this.receiverListPanel.resetContent(msg.getAllReceiver());
        this.replyToListPanel.resetContent(msg.getAllReplyTo());
        Enumeration<?> e3 = msg.getAllUserDefinedParameters().propertyNames();
        ArrayList list2 = new ArrayList();
        while (e3.hasMoreElements()) {
            list2.add(e3.nextElement());
        }
        this.propertiesListPanel.resetContent(list2.iterator());
        this.propertiesListPanel.setContentProperties(msg.getAllUserDefinedParameters());
        param = msg.getReplyWith();
        if (param == null) {
            param = "";
        }
        this.replyWith.setText(param);
        param = msg.getInReplyTo();
        if (param == null) {
            param = "";
        }
        this.inReplyTo.setText(param);
        param = msg.getConversationId();
        if (param == null) {
            param = "";
        }
        this.conversationId.setText(param);
        try {
            param = ISO8601.toString(msg.getReplyByDate());
        }
        catch (Exception exc) {
            param = "";
        }
        this.replyBy.setText(param);
        param = msg.getProtocol();
        if (param == null) {
            this.protocol.setSelectedItem("Null");
        } else if (param.equals("") || param.equalsIgnoreCase("Null")) {
            this.protocol.setSelectedItem("Null");
        } else {
            lowerCase = param.toLowerCase();
            int i = this.fipaProtocolArrayList.indexOf(lowerCase);
            if (i < 0) {
                this.protocol.addItem(param);
                int cnt = this.protocol.getItemCount();
                this.protocol.setSelectedItem(param);
                int n = this.protocol.getSelectedIndex();
                if (n != cnt - 1) {
                    this.protocol.removeItemAt(cnt - 1);
                }
            } else {
                this.protocol.setSelectedIndex(i);
            }
        }
        String lang = msg.getLanguage();
        if (lang == null) {
            lang = "";
        }
        this.language.setText(lang);
        param = msg.getOntology();
        if (param == null) {
            param = "";
        }
        this.ontology.setText(param);
        param = msg.getContent();
        if (param == null) {
            param = "";
        }
        if ((lang.equalsIgnoreCase("fipa-sl0") || lang.equalsIgnoreCase("fipa-sl1") || lang.equalsIgnoreCase("fipa-sl2") || lang.equalsIgnoreCase("fipa-sl")) && this.slFormatter != null) {
            param = SLFormatter.format(param);
        }
        this.content.setText(param);
        param = msg.getEncoding();
        if (param == null) {
            param = "";
        }
        this.encoding.setText(param);
        Envelope envelope = msg.getEnvelope();
        if (envelope != null) {
            this.showEnvelope(envelope);
        }
    }

    public ACLMessage getMsg() {
        String param = (String)this.communicativeAct.getSelectedItem();
        int perf = ACLMessage.getInteger(param);
        ACLMessage msg = new ACLMessage(perf);
        if (this.newAIDSender != null) {
            this.SenderAID = this.newAIDSender;
        }
        if (this.SenderAID.getName().length() > 0) {
            msg.setSender(this.SenderAID);
        }
        Enumeration rec_Enum = this.receiverListPanel.getContent();
        while (rec_Enum.hasMoreElements()) {
            msg.addReceiver((AID)rec_Enum.nextElement());
        }
        Enumeration replyTo_Enum = this.replyToListPanel.getContent();
        while (replyTo_Enum.hasMoreElements()) {
            msg.addReplyTo((AID)replyTo_Enum.nextElement());
        }
        Properties user_Prop = this.propertiesListPanel.getContentProperties();
        Enumeration<?> keys = user_Prop.propertyNames();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            msg.addUserDefinedParameter(k, user_Prop.getProperty(k));
        }
        param = this.replyWith.getText().trim();
        if (param.length() > 0) {
            msg.setReplyWith(param);
        }
        if ((param = this.inReplyTo.getText().trim()).length() > 0) {
            msg.setInReplyTo(param);
        }
        if ((param = this.conversationId.getText().trim()).length() > 0) {
            msg.setConversationId(param);
        }
        param = this.replyBy.getText().trim();
        try {
            msg.setReplyByDate(ISO8601.toDate(param));
        }
        catch (Exception e2) {
            // empty catch block
        }
        param = (String)this.protocol.getSelectedItem();
        if (!param.equals("Null")) {
            msg.setProtocol(param);
        }
        if ((param = this.language.getText().trim()).length() > 0) {
            msg.setLanguage(param);
        }
        if ((param = this.ontology.getText().trim()).length() > 0) {
            msg.setOntology(param);
        }
        if ((param = this.content.getText().trim()).length() > 0) {
            msg.setContent(param);
        }
        if ((param = this.encoding.getText().trim()).length() > 0) {
            msg.setEncoding(param);
        }
        Envelope env = new Envelope();
        Enumeration to_Enum = this.toPanel.getContent();
        while (to_Enum.hasMoreElements()) {
            env.addTo((AID)to_Enum.nextElement());
        }
        if (this.newAIDFrom != null) {
            this.fromAID = this.newAIDFrom;
        }
        if (this.fromAID.getName().length() > 0) {
            env.setFrom(this.fromAID);
        }
        if ((param = this.comments.getText().trim()).length() > 0) {
            env.setComments(param);
        }
        if ((param = this.representation.getText().trim()).length() > 0) {
            env.setAclRepresentation(param);
        }
        try {
            param = this.payloadLength.getText().trim();
            env.setPayloadLength(new Long(param));
        }
        catch (Exception e3) {
            // empty catch block
        }
        param = this.payloadEncoding.getText().trim();
        if (param.length() > 0) {
            env.setPayloadEncoding(param);
        }
        if (this.dateDate != null) {
            env.setDate(this.dateDate);
        }
        Enumeration int_Enum = this.intendedReceiverPanel.getContent();
        while (int_Enum.hasMoreElements()) {
            env.addIntendedReceiver((AID)int_Enum.nextElement());
        }
        param = this.language.getText().trim();
        if (param.length() > 0) {
            msg.setLanguage(param);
        }
        msg.setEnvelope(env);
        return msg;
    }

    public void setEnabled(boolean enabledFlag) {
        this.guiEnabledFlag = enabledFlag;
        this.updateEnabled();
    }

    public void setSenderEnabled(boolean enabledFlag) {
        this.senderEnabledFlag = enabledFlag;
        this.updateEnabled();
    }

    public void paint(Graphics g) {
        if (this.firstPaintFlag) {
            this.firstPaintFlag = false;
            this.minDim = this.aclPanel.getSize();
        } else {
            this.aclPanel.setMinimumSize(this.minDim);
        }
        super.paint(g);
    }

    public static void showMsgInDialog(ACLMessage msg, Frame parent) {
        final JDialog tempAclDlg = new JDialog(parent, "ACL Message", true);
        AclGui aclPanel = new AclGui(parent);
        aclPanel.setEnabled(false);
        aclPanel.setMsg(msg);
        JButton okButton = new JButton("OK");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        tempAclDlg.getContentPane().setLayout(new BorderLayout());
        tempAclDlg.getContentPane().add("Center", aclPanel);
        tempAclDlg.getContentPane().add("South", buttonPanel);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                tempAclDlg.dispose();
            }
        });
        tempAclDlg.pack();
        tempAclDlg.setResizable(false);
        if (parent != null) {
            int locy;
            int locx = parent.getX() + (parent.getWidth() - tempAclDlg.getWidth()) / 2;
            if (locx < 0) {
                locx = 0;
            }
            if ((locy = parent.getY() + (parent.getHeight() - tempAclDlg.getHeight()) / 2) < 0) {
                locy = 0;
            }
            tempAclDlg.setLocation(locx, locy);
        }
        tempAclDlg.setVisible(true);
    }

    public static ACLMessage editMsgInDialog(ACLMessage msg, Frame parent) {
        final JDialog tempAclDlg = new JDialog(parent, "ACL Message", true);
        final AclGui aclPanel = new AclGui(parent);
        aclPanel.setBorder(new BevelBorder(0));
        aclPanel.setSenderEnabled(true);
        aclPanel.setMsg(msg);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setPreferredSize(cancelButton.getPreferredSize());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        tempAclDlg.getContentPane().setLayout(new BorderLayout());
        tempAclDlg.getContentPane().add("Center", aclPanel);
        tempAclDlg.getContentPane().add("South", buttonPanel);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                editedMsg = aclPanel.getMsg();
                tempAclDlg.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                editedMsg = null;
                tempAclDlg.dispose();
            }
        });
        tempAclDlg.pack();
        tempAclDlg.setResizable(false);
        if (parent != null) {
            int x = parent.getX() + (parent.getWidth() - tempAclDlg.getWidth()) / 2;
            int y = parent.getY() + (parent.getHeight() - tempAclDlg.getHeight()) / 2;
            tempAclDlg.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        }
        tempAclDlg.setVisible(true);
        ACLMessage m = null;
        if (editedMsg != null) {
            m = (ACLMessage)editedMsg.clone();
        }
        return m;
    }

    private class EnvelopePanel
    extends JPanel {
        EnvelopePanel() {
            AclGui.this.aclPanel = new JPanel();
            AclGui.this.aclPanel.setLayout(AclGui.this.lm);
            AclGui.this.formatGrid(20, 3, 5, 5, 5, 5, 2, 2);
            AclGui.this.setGridColumnWidth(0, 115);
            AclGui.this.setGridColumnWidth(1, 40);
            AclGui.this.setGridColumnWidth(2, 170);
            JLabel l = new JLabel("To:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 0, 1, 1, false);
            AclGui.this.toPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.getChildrenOwner());
            AclGui.this.toPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.toPanel, 1, 0, 2, 1, false);
            l = new JLabel("From:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 1, 1, 1, false);
            AclGui.this.fromButton = new JButton("Set");
            AclGui.this.fromButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.fromButton, 1, 1, 1, 1, false);
            AclGui.this.from = new JTextField();
            AclGui.this.from.setEditable(false);
            AclGui.this.from.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.from, 2, 1, 1, 1, false);
            AclGui.this.fromButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    String command = e2.getActionCommand();
                    AIDGui guiFrom = new AIDGui(AclGui.this.ownerGui);
                    if (command.equals("Set")) {
                        AID fromToView = AclGui.this.fromAID;
                        if (AclGui.this.newAIDFrom != null) {
                            fromToView = AclGui.this.newAIDFrom;
                        }
                        if ((fromToView = guiFrom.ShowAIDGui(fromToView, true, true)) != null) {
                            AclGui.this.newAIDFrom = fromToView;
                            AclGui.this.from.setText(AclGui.this.newAIDFrom.getName());
                        }
                    } else if (command.equals("View")) {
                        guiFrom.ShowAIDGui(AclGui.this.fromAID, false, false);
                    }
                }
            });
            l = new JLabel("Comments:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 2, 1, 1, false);
            AclGui.this.comments = new JTextArea(4, 30);
            JScrollPane commentsPane = new JScrollPane();
            commentsPane.getViewport().setView(AclGui.this.comments);
            AclGui.this.put(AclGui.this.aclPanel, commentsPane, 0, 3, 3, 4, false);
            commentsPane.setHorizontalScrollBarPolicy(32);
            commentsPane.setVerticalScrollBarPolicy(22);
            l = new JLabel("ACLRepresentation:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 7, 1, 1, false);
            AclGui.this.representation = new JTextField();
            AclGui.this.representation.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.representation, 1, 7, 2, 1, false);
            l = new JLabel("Payload Length:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 8, 1, 1, false);
            AclGui.this.payloadLength = new JTextField();
            AclGui.this.payloadLength.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.payloadLength, 1, 8, 2, 1, false);
            l = new JLabel("Payload Encoding:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 9, 1, 1, false);
            AclGui.this.payloadEncoding = new JTextField();
            AclGui.this.payloadEncoding.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.payloadEncoding, 1, 9, 2, 1, false);
            AclGui.this.dateDate = null;
            l = new JLabel("Date:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 10, 1, 1, false);
            AclGui.this.dateButton = new JButton("Set");
            AclGui.this.dateButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.date = new JTextField();
            AclGui.this.date.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.dateButton, 1, 10, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.date, 2, 10, 1, 1, false);
            AclGui.this.dateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    TimeChooser t;
                    String command;
                    block9: {
                        command = e2.getActionCommand();
                        t = new TimeChooser();
                        String d = AclGui.this.date.getText();
                        if (!d.equals("")) {
                            try {
                                t.setDate(ISO8601.toDate(d));
                            }
                            catch (Exception ee) {
                                if (!AclGui.this.logger.isLoggable(Logger.WARNING)) break block9;
                                AclGui.this.logger.log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (command.equals("Set")) {
                        if (t.showEditTimeDlg(null) == 1) {
                            AclGui.this.dateDate = t.getDate();
                            if (AclGui.this.dateDate == null) {
                                AclGui.this.date.setText("");
                            } else {
                                AclGui.this.date.setText(ISO8601.toString(AclGui.this.dateDate));
                            }
                        }
                    } else if (command.equals("View")) {
                        t.showViewTimeDlg(null);
                    }
                }
            });
            l = new JLabel("Intended Receiver:");
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 11, 1, 1, false);
            AclGui.this.intendedReceiverPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.getChildrenOwner());
            AclGui.this.intendedReceiverPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.intendedReceiverPanel, 1, 11, 2, 1, false);
            JPanel recPanel = new JPanel();
            recPanel.setLayout(new BoxLayout(recPanel, 1));
            JPanel tempPane = new JPanel();
            tempPane.setLayout(new BoxLayout(tempPane, 0));
            recPanel.setBorder(new TitledBorder("Received Object"));
            l = new JLabel("By:");
            l.setPreferredSize(new Dimension(115, 24));
            l.setMinimumSize(new Dimension(115, 24));
            l.setMaximumSize(new Dimension(115, 24));
            tempPane.add(l);
            AclGui.this.by = new JTextField();
            AclGui.this.by.setBackground(Color.white);
            tempPane.add(AclGui.this.by);
            recPanel.add(tempPane);
            tempPane = new JPanel();
            tempPane.setLayout(new BoxLayout(tempPane, 0));
            l = new JLabel("From:");
            l.setPreferredSize(new Dimension(115, 24));
            l.setMinimumSize(new Dimension(115, 24));
            l.setMaximumSize(new Dimension(115, 24));
            tempPane.add(l);
            AclGui.this.fromRec = new JTextField();
            AclGui.this.fromRec.setBackground(Color.white);
            tempPane.add(AclGui.this.fromRec);
            recPanel.add(tempPane);
            tempPane = new JPanel();
            tempPane.setLayout(new BoxLayout(tempPane, 0));
            AclGui.this.dateRecDate = null;
            l = new JLabel("Date:");
            l.setPreferredSize(new Dimension(115, 24));
            l.setMinimumSize(new Dimension(115, 24));
            l.setMaximumSize(new Dimension(115, 24));
            tempPane.add(l);
            AclGui.this.dateRecButton = new JButton("Set");
            tempPane.add(AclGui.this.dateRecButton);
            AclGui.this.dateRecButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    TimeChooser t;
                    String command;
                    block9: {
                        command = e2.getActionCommand();
                        t = new TimeChooser();
                        String d = AclGui.this.dateRec.getText();
                        if (!d.equals("")) {
                            try {
                                t.setDate(ISO8601.toDate(d));
                            }
                            catch (Exception ee) {
                                if (!AclGui.this.logger.isLoggable(Logger.WARNING)) break block9;
                                AclGui.this.logger.log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (command.equals("Set")) {
                        if (t.showEditTimeDlg(null) == 1) {
                            AclGui.this.dateRecDate = t.getDate();
                            if (AclGui.this.dateRecDate == null) {
                                AclGui.this.dateRec.setText("");
                            } else {
                                AclGui.this.dateRec.setText(ISO8601.toString(AclGui.this.dateRecDate));
                            }
                        }
                    } else if (command.equals("View")) {
                        t.showViewTimeDlg(null);
                    }
                }
            });
            AclGui.this.dateRec = new JTextField();
            AclGui.this.dateRec.setBackground(Color.white);
            tempPane.add(AclGui.this.dateRec);
            recPanel.add(tempPane);
            tempPane = new JPanel();
            tempPane.setLayout(new BoxLayout(tempPane, 0));
            l = new JLabel("ID:");
            l.setPreferredSize(new Dimension(115, 24));
            l.setMinimumSize(new Dimension(115, 24));
            l.setMaximumSize(new Dimension(115, 24));
            tempPane.add(l);
            AclGui.this.id = new JTextField();
            AclGui.this.id.setBackground(Color.white);
            tempPane.add(AclGui.this.id);
            recPanel.add(tempPane);
            tempPane = new JPanel();
            tempPane.setLayout(new BoxLayout(tempPane, 0));
            l = new JLabel("Via:");
            l.setPreferredSize(new Dimension(115, 24));
            l.setMinimumSize(new Dimension(115, 24));
            l.setMaximumSize(new Dimension(115, 24));
            tempPane.add(l);
            AclGui.this.via = new JTextField();
            AclGui.this.via.setBackground(Color.white);
            tempPane.add(AclGui.this.via);
            recPanel.add(tempPane);
            AclGui.this.put(AclGui.this.aclPanel, recPanel, 0, 12, 3, 1, false);
            JPanel tmpPanel = new JPanel();
            AclGui.this.defaultEnvelopeButton = new JButton("Set Default Envelope");
            tmpPanel.add(AclGui.this.defaultEnvelopeButton);
            AclGui.this.defaultEnvelopeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    String command = e2.getActionCommand();
                    if (command.equals("Set Default Envelope")) {
                        ACLMessage tmp = AclGui.this.getMsg();
                        tmp.setDefaultEnvelope();
                        Envelope envtmp = tmp.getEnvelope();
                        AclGui.this.showEnvelope(envtmp);
                    }
                }
            });
            AclGui.this.put(AclGui.this.aclPanel, tmpPanel, 0, 17, 3, 1, false);
            this.add(AclGui.this.aclPanel);
        }
    }

    private class AclMessagePanel
    extends JPanel
    implements DropTargetListener {
        AclMessagePanel() {
            int i;
            AclGui.this.fipaProtocolArrayList = new ArrayList();
            for (i = 0; i < N_FIPA_PROTOCOLS; ++i) {
                AclGui.this.fipaProtocolArrayList.add(fipaProtocols[i]);
            }
            AclGui.this.aclPanel = new JPanel();
            new DropTarget(AclGui.this.aclPanel, this);
            AclGui.this.aclPanel.setLayout(AclGui.this.lm);
            AclGui.this.formatGrid(20, 3, 5, 5, 5, 5, 2, 2);
            AclGui.this.setGridColumnWidth(0, 115);
            AclGui.this.setGridColumnWidth(1, 40);
            AclGui.this.setGridColumnWidth(2, 170);
            JLabel l = new JLabel("Sender:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 0, 1, 1, false);
            AclGui.this.senderEnabledFlag = true;
            AclGui.this.sender = new JTextField();
            AclGui.this.sender.setPreferredSize(new Dimension(80, 26));
            AclGui.this.sender.setMinimumSize(new Dimension(80, 26));
            AclGui.this.sender.setMaximumSize(new Dimension(80, 26));
            AclGui.this.sender.setEditable(false);
            AclGui.this.sender.setBackground(Color.white);
            AclGui.this.senderButton = new JButton("Set");
            AclGui.this.senderButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.senderButton, 1, 0, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.sender, 2, 0, 1, 1, false);
            AclGui.this.senderButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    String command = e2.getActionCommand();
                    AIDGui guiSender = new AIDGui(AclGui.this.getChildrenOwner());
                    if (command.equals("Set")) {
                        AID senderToView = AclGui.this.SenderAID;
                        if (AclGui.this.newAIDSender != null) {
                            senderToView = AclGui.this.newAIDSender;
                        }
                        if ((senderToView = guiSender.ShowAIDGui(senderToView, true, true)) != null) {
                            AclGui.this.newAIDSender = senderToView;
                            AclGui.this.sender.setText(AclGui.this.newAIDSender.getName());
                        }
                    } else if (command.equals("View")) {
                        guiSender.ShowAIDGui(AclGui.this.SenderAID, false, false);
                    }
                }
            });
            l = new JLabel("Receivers:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 1, 1, 1, false);
            AclGui.this.receiverListPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.getChildrenOwner());
            AclGui.this.receiverListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.receiverListPanel, 1, 1, 2, 1, false);
            l = new JLabel("Reply-to:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 2, 1, 1, false);
            AclGui.this.replyToListPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.getChildrenOwner());
            AclGui.this.replyToListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyToListPanel, 1, 2, 2, 1, false);
            l = new JLabel("Communicative act:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 3, 1, 1, false);
            AclGui.this.communicativeAct = new JComboBox();
            String[] comm_Act = ACLMessage.getAllPerformativeNames();
            for (int ii = 0; ii < comm_Act.length; ++ii) {
                AclGui.this.communicativeAct.addItem(comm_Act[ii].toLowerCase());
            }
            AclGui.this.communicativeAct.setSelectedIndex(0);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.communicativeAct, 1, 3, 2, 1, true);
            l = new JLabel("Content:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 4, 3, 1, false);
            AclGui.this.content = new JTextArea(5, 30);
            JScrollPane contentPane = new JScrollPane();
            contentPane.getViewport().setView(AclGui.this.content);
            AclGui.this.put(AclGui.this.aclPanel, contentPane, 0, 5, 3, 4, false);
            contentPane.setHorizontalScrollBarPolicy(32);
            contentPane.setVerticalScrollBarPolicy(22);
            l = new JLabel("Language:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 9, 1, 1, false);
            AclGui.this.language = new JTextField();
            AclGui.this.language.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.language, 1, 9, 2, 1, false);
            l = new JLabel("Encoding:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 10, 1, 1, false);
            AclGui.this.encoding = new JTextField();
            AclGui.this.encoding.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.encoding, 1, 10, 2, 1, false);
            l = new JLabel("Ontology:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 11, 1, 1, false);
            AclGui.this.ontology = new JTextField();
            AclGui.this.ontology.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.ontology, 1, 11, 2, 1, false);
            l = new JLabel("Protocol:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 12, 1, 1, false);
            AclGui.this.protocol = new JComboBox();
            for (i = 0; i < AclGui.this.fipaProtocolArrayList.size(); ++i) {
                AclGui.this.protocol.addItem((String)AclGui.this.fipaProtocolArrayList.get(i));
            }
            AclGui.this.protocol.addItem(AclGui.LABEL_TO_ADD_PROT);
            AclGui.this.protocol.addItem("Null");
            AclGui.this.protocol.setSelectedItem("Null");
            AclGui.this.lastSelectedIndex = AclGui.this.protocol.getSelectedIndex();
            AclGui.this.lastSelectedItem = (String)AclGui.this.protocol.getSelectedItem();
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.protocol, 1, 12, 2, 1, true);
            AclGui.this.protocol.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    String param = (String)AclGui.this.protocol.getSelectedItem();
                    if (!AclGui.this.protocol.isEditable()) {
                        if (AclGui.this.fipaProtocolArrayList.indexOf(param) < 0 && !param.equals("Null")) {
                            AclGui.this.protocol.setEditable(true);
                        }
                    } else if (AclGui.this.fipaProtocolArrayList.indexOf(param) >= 0 || param.equals("Null")) {
                        AclGui.this.protocol.setEditable(false);
                        AclGui.this.protocol.setSelectedItem(param);
                    } else if (param.equals(AclGui.LABEL_TO_ADD_PROT)) {
                        AclGui.this.protocol.setSelectedItem(param);
                    } else if (AclGui.this.lastSelectedItem.equals(AclGui.LABEL_TO_ADD_PROT)) {
                        if (!param.equals("")) {
                            AclGui.this.protocol.addItem(param);
                            int cnt = AclGui.this.protocol.getItemCount();
                            AclGui.this.protocol.setSelectedItem(param);
                            int n = AclGui.this.protocol.getSelectedIndex();
                            if (n != cnt - 1) {
                                AclGui.this.protocol.removeItemAt(cnt - 1);
                            }
                        } else {
                            AclGui.this.protocol.setEditable(false);
                            AclGui.this.protocol.setSelectedItem("Null");
                        }
                    } else if (AclGui.this.lastSelectedItem != AclGui.LABEL_TO_ADD_PROT) {
                        AclGui.this.protocol.removeItemAt(AclGui.this.lastSelectedIndex);
                        if (param.equals("")) {
                            AclGui.this.protocol.setEditable(false);
                            AclGui.this.protocol.setSelectedItem("Null");
                        } else {
                            AclGui.this.protocol.addItem(param);
                            AclGui.this.protocol.setSelectedItem(param);
                        }
                    }
                    AclGui.this.lastSelectedIndex = AclGui.this.protocol.getSelectedIndex();
                    AclGui.this.lastSelectedItem = (String)AclGui.this.protocol.getSelectedItem();
                }
            });
            l = new JLabel("Conversation-id:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 13, 1, 1, false);
            AclGui.this.conversationId = new JTextField();
            AclGui.this.conversationId.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.conversationId, 1, 13, 2, 1, false);
            l = new JLabel("In-reply-to:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 14, 1, 1, false);
            AclGui.this.inReplyTo = new JTextField();
            AclGui.this.inReplyTo.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.inReplyTo, 1, 14, 2, 1, false);
            l = new JLabel("Reply-with:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 15, 1, 1, false);
            AclGui.this.replyWith = new JTextField();
            AclGui.this.replyWith.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyWith, 1, 15, 2, 1, false);
            AclGui.this.replyByDate = null;
            l = new JLabel("Reply-by:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 16, 1, 1, false);
            AclGui.this.replyBySet = new JButton("Set");
            AclGui.this.replyBySet.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.replyBy = new JTextField();
            AclGui.this.replyBy.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyBySet, 1, 16, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyBy, 2, 16, 1, 1, false);
            AclGui.this.replyBySet.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    TimeChooser t;
                    String command;
                    block9: {
                        command = e2.getActionCommand();
                        t = new TimeChooser();
                        String d = AclGui.this.replyBy.getText();
                        if (!d.equals("")) {
                            try {
                                t.setDate(ISO8601.toDate(d));
                            }
                            catch (Exception ee) {
                                if (!AclGui.this.logger.isLoggable(Logger.SEVERE)) break block9;
                                AclGui.this.logger.log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (command.equals("Set")) {
                        if (t.showEditTimeDlg(null) == 1) {
                            AclGui.this.replyByDate = t.getDate();
                            if (AclGui.this.replyByDate == null) {
                                AclGui.this.replyBy.setText("");
                            } else {
                                AclGui.this.replyBy.setText(ISO8601.toString(AclGui.this.replyByDate));
                            }
                        }
                    } else if (command.equals("View")) {
                        t.showViewTimeDlg(null);
                    }
                }
            });
            l = new JLabel("User Properties:");
            new DropTarget(l, this);
            AclGui.this.put(AclGui.this.aclPanel, l, 0, 17, 1, 1, false);
            AclGui.this.propertiesListPanel = new VisualPropertiesList(new Properties(), AclGui.this.getChildrenOwner());
            AclGui.this.propertiesListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.propertiesListPanel, 1, 17, 2, 1, false);
            this.setLayout(new BoxLayout(this, 1));
            this.add(AclGui.this.aclPanel);
        }

        public void dragOver(DropTargetDragEvent p1) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragOver");
            }
        }

        public void dropActionChanged(DropTargetDragEvent p1) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dropActionChanged");
            }
        }

        public void dragEnter(DropTargetDragEvent dragEvent) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragEnter");
            }
        }

        public void dragExit(DropTargetEvent p1) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragExit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropEvent) {
            boolean completionStatus = false;
            List fileList = null;
            try {
                dropEvent.acceptDrop(1);
                Transferable xferInfo = dropEvent.getTransferable();
                fileList = (List)xferInfo.getTransferData(DataFlavor.javaFileListFlavor);
                completionStatus = true;
            }
            catch (UnsupportedFlavorException exc) {
                completionStatus = false;
            }
            catch (IOException exc) {
                if (AclGui.this.logger.isLoggable(Logger.WARNING)) {
                    AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                }
                completionStatus = false;
            }
            finally {
                dropEvent.dropComplete(completionStatus);
            }
            if (fileList != null) {
                Iterator fileItor = fileList.iterator();
                ACLParser aclParser = ACLParser.create();
                while (fileItor.hasNext()) {
                    try {
                        File f = (File)fileItor.next();
                        FileReader aclMsgFile = new FileReader(f);
                        Enumeration receivers = AclGui.this.receiverListPanel.getContent();
                        AclGui.this.setMsg(aclParser.parse(aclMsgFile));
                        if (!receivers.hasMoreElements()) continue;
                        if (AclGui.this.logger.isLoggable(Logger.FINE)) {
                            AclGui.this.logger.log(Logger.FINE, "revert to saved list");
                        }
                        ArrayList list2 = new ArrayList();
                        while (receivers.hasMoreElements()) {
                            list2.add(receivers.nextElement());
                        }
                        AclGui.this.receiverListPanel.resetContent(list2.iterator());
                    }
                    catch (IOException exc) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                    catch (ParseException exc) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                    catch (Exception exc) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                    catch (Error exc) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                    catch (Throwable exc) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exc);
                    }
                }
            }
        }
    }
}

