/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.domain.FIPAAgentManagement.APDescription;
import jade.gui.VisualAPServiceList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class APDescriptionPanel
extends JPanel {
    private JTextField platformName_Field;
    private VisualAPServiceList MTPs_List;

    public APDescriptionPanel(Component owner) {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 15;
        this.setLayout(gridBag);
        JLabel label = new JLabel("AgentPlatform Description");
        c.weightx = 0.5;
        c.ipadx = 15;
        c.ipady = 20;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        gridBag.setConstraints(label, c);
        this.add(label);
        label = new JLabel("Platform Name: ");
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        gridBag.setConstraints(label, c);
        this.add(label);
        this.platformName_Field = new JTextField();
        this.platformName_Field.setEditable(false);
        this.platformName_Field.setBackground(Color.white);
        c.ipadx = 30;
        c.gridx = 1;
        c.gridy = 1;
        gridBag.setConstraints(this.platformName_Field, c);
        this.add(this.platformName_Field);
        JPanel profilePanel = new JPanel();
        profilePanel.setLayout(new BoxLayout(profilePanel, 1));
        profilePanel.setBorder(BorderFactory.createTitledBorder("AP Services"));
        this.MTPs_List = new VisualAPServiceList(new ArrayList().iterator(), owner);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        gridBag.setConstraints(profilePanel, c);
        this.MTPs_List.setEnabled(false);
        this.MTPs_List.setDimension(new Dimension(250, 50));
        profilePanel.add(this.MTPs_List);
        this.add(profilePanel);
    }

    public void setAPDescription(APDescription desc) {
        try {
            this.platformName_Field.setText(desc.getName());
            this.MTPs_List.resetContent(desc.getAllAPServices());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void showAPDescriptionInDialog(APDescription desc, Frame parent, String title) {
        final JDialog tempDlg = new JDialog(parent, title, true);
        APDescriptionPanel AP_Panel = new APDescriptionPanel(tempDlg);
        AP_Panel.setAPDescription(desc);
        JButton okButton = new JButton("OK");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        tempDlg.getContentPane().setLayout(new BorderLayout());
        tempDlg.getContentPane().add("Center", AP_Panel);
        tempDlg.getContentPane().add("South", buttonPanel);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                tempDlg.dispose();
            }
        });
        tempDlg.pack();
        tempDlg.setResizable(false);
        if (parent != null) {
            int locy;
            int locx = parent.getX() + (parent.getWidth() - tempDlg.getWidth()) / 2;
            if (locx < 0) {
                locx = 0;
            }
            if ((locy = parent.getY() + (parent.getHeight() - tempDlg.getHeight()) / 2) < 0) {
                locy = 0;
            }
            tempDlg.setLocation(locx, locy);
        }
        tempDlg.setVisible(true);
    }
}

