/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.ContentElementList;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentManager;
import jade.core.ContainerID;
import jade.core.Location;
import jade.core.NameClashException;
import jade.core.NotFoundException;
import jade.core.UnreachableException;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.AMSEventQueueFeeder;
import jade.domain.AMSFipaAgentManagementBehaviour;
import jade.domain.AMSJadeAgentManagementBehaviour;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.FIPAAgentManagement.APService;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.Unauthorised;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.JADEAgentManagement.QueryAgentsOnLocation;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.domain.JADEAgentManagement.WhereIsAgentAction;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.AddedMTP;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.IntrospectionOntology;
import jade.domain.introspection.KillContainerRequested;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.ShutdownPlatformRequested;
import jade.domain.mobility.CloneAction;
import jade.domain.mobility.MobileAgentDescription;
import jade.domain.mobility.MobilityOntology;
import jade.domain.mobility.MoveAction;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.InputQueue;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public class ams
extends Agent {
    public static final String PERIODIC_LOG_DELAY = "jade_domain_ams_periodiclogdelay";
    public static final String MAX_RESULTS = "jade_domain_ams_maxresult";
    public static final String KEEP_NOTIFY_ON_SHUTDOWN = "jade_domain_ams_keepnotifyonshutdown";
    private static final int DEFAULT_MAX_RESULTS = 100;
    private static final int DEFAULT_PERIODIC_LOG_DELAY = -1;
    private int amsMaxResults = 100;
    private Logger logger;
    private AgentManager myPlatform;
    private Codec codec = new SLCodec();
    private ACLMessage toolNotification = new ACLMessage(7);
    private boolean keepNotifyOnShutdown = false;
    private InputQueue eventQueue = new InputQueue();
    private AMSEventQueueFeeder queueFeeder;
    private Hashtable pendingNewAgents = new Hashtable();
    private Hashtable pendingDeadAgents = new Hashtable();
    private Hashtable pendingClonedAgents = new Hashtable();
    private Hashtable pendingMovedAgents = new Hashtable();
    private Hashtable pendingRemovedContainers = new Hashtable();
    private APDescription theProfile = new APDescription();
    private boolean shuttingDown = false;

    public ams(AgentManager ap) {
        this.logger = Logger.getMyLogger("ams");
        this.myPlatform = ap;
    }

    protected void setup() {
        this.theProfile.setName("\"" + this.getHap() + "\"");
        this.writeAPDescription(this.theProfile);
        this.keepNotifyOnShutdown = "true".equals(this.getProperty(KEEP_NOTIFY_ON_SHUTDOWN, null));
        String sLogDelay = this.getProperty(PERIODIC_LOG_DELAY, String.valueOf(-1));
        try {
            int logDelay = Integer.parseInt(sLogDelay);
            if (logDelay > 0) {
                this.addBehaviour(new TickerBehaviour(this, logDelay){

                    public void onTick() {
                        ams.this.logger.log(Logger.INFO, "JADE AMS active...");
                    }
                });
            }
        }
        catch (Exception e2) {
            this.logger.log(Logger.WARNING, "Wrong periodic log delay value " + sLogDelay + ". It must be an integer value.");
        }
        String sMaxResults = this.getProperty(MAX_RESULTS, String.valueOf(100));
        try {
            this.amsMaxResults = Integer.parseInt(sMaxResults);
        }
        catch (Exception e3) {
            this.logger.log(Logger.WARNING, "Wrong max result limit " + sMaxResults + ". It must be an integer value.");
        }
        this.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(IntrospectionOntology.getInstance());
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerLanguage(this.codec, "fipa-sl0");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl1");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl2");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl");
        MessageTemplate mtF = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.MatchOntology("FIPA-Agent-Management"));
        AMSFipaAgentManagementBehaviour fipaResponderB = new AMSFipaAgentManagementBehaviour(this, mtF);
        this.addBehaviour(fipaResponderB);
        MessageTemplate mtJ = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.or(MessageTemplate.MatchOntology("JADE-Agent-Management"), MessageTemplate.MatchOntology("jade-mobility-ontology")));
        AMSJadeAgentManagementBehaviour jadeResponderB = new AMSJadeAgentManagementBehaviour(this, mtJ);
        this.addBehaviour(jadeResponderB);
        RegisterToolBehaviour registerTool = new RegisterToolBehaviour();
        DeregisterToolBehaviour deregisterTool = new DeregisterToolBehaviour();
        EventManager eventManager = new EventManager();
        SequentialBehaviour sb = new SequentialBehaviour();
        sb.addSubBehaviour(new WakerBehaviour(this, 1000L){

            public void onWake() {
            }
        });
        sb.addSubBehaviour(registerTool);
        this.addBehaviour(sb);
        this.addBehaviour(deregisterTool);
        this.addBehaviour(eventManager);
        this.eventQueue.associate(eventManager);
        this.toolNotification.setLanguage("fipa-sl0");
        this.toolNotification.setOntology("JADE-Introspection");
        this.toolNotification.setInReplyTo("tool-subscription");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ams.this.logger.log(Logger.FINE, ">>>>>>>>> Shutdown Hook activated. AMS state = " + ams.this.getState());
                if (!ams.this.shuttingDown && ams.this.getState() != 6) {
                    ams.this.notifyShutdownPlatformRequested();
                    ams.this.shuttingDown = true;
                    try {
                        ams.this.logger.log(Logger.WARNING, ">>>>>>>>> Main Container JVM is terminating. Activate platform shutdown");
                        ams.this.myPlatform.shutdownPlatform(null, null);
                        ams.this.logger.log(Logger.WARNING, ">>>>>>>>> Platform shutdown completed");
                    }
                    catch (Exception e2) {
                        ams.this.logger.log(Logger.SEVERE, ">>>>>>>>> Platform shutdown error", e2);
                        ams.this.shuttingDown = false;
                    }
                }
            }
        });
    }

    void createAgentAction(final CreateAgent ca, final AID requester, final JADEPrincipal requesterPrincipal, final Credentials requesterCredentials) throws FIPAException {
        final String agentName = ca.getAgentName();
        final AID agentID = new AID(agentName, false);
        final String className = ca.getClassName();
        final ContainerID container = ca.getContainer();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Create-agent " + agentID + " on container " + container);
        }
        Iterator it = ca.getAllArguments();
        ArrayList listArg = new ArrayList();
        while (it.hasNext()) {
            listArg.add(it.next());
        }
        final Object[] args = listArg.toArray();
        final JADEPrincipal owner = ca.getOwner();
        final Credentials initialCredentials = ca.getInitialCredentials();
        Thread auxThread = new Thread(){

            public void run() {
                try {
                    ams.this.myPlatform.create(agentName, className, args, container, owner, initialCredentials, requesterPrincipal, requesterCredentials);
                }
                catch (UnreachableException ue) {
                    ams.this.sendFailureNotification(ca, agentID, new InternalError(ue.getMessage()));
                }
                catch (JADESecurityException ae) {
                    if (ams.this.logger.isLoggable(Logger.SEVERE)) {
                        ams.this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Create-agent: " + ae);
                    }
                    ams.this.sendFailureNotification(ca, agentID, new Unauthorised());
                }
                catch (NotFoundException nfe) {
                    ams.this.sendFailureNotification(ca, agentID, new InternalError("Destination container not found. " + nfe.getMessage()));
                }
                catch (NameClashException nce) {
                    ams.this.sendFailureNotification(ca, agentID, new AlreadyRegistered());
                }
                catch (Throwable t) {
                    ams.this.sendFailureNotification(ca, agentID, new InternalError(t.getMessage()));
                }
            }
        };
        auxThread.start();
    }

    void killAgentAction(KillAgent ka, AID requester, JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws FIPAException {
        AID agentID = ka.getAgent();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Kill-agent " + agentID);
        }
        try {
            this.myPlatform.kill(agentID, requesterPrincipal, requesterCredentials);
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action KillAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container not reachable. " + ue.getMessage());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    void cloneAgentAction(CloneAction ca, AID requester) throws FIPAException {
        MobileAgentDescription dsc = ca.getMobileAgentDescription();
        AID agentID = dsc.getName();
        ContainerID where = (ContainerID)dsc.getDestination();
        String newName = ca.getNewName();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + requester + " requesting Clone-agent " + agentID + " on container " + where);
        }
        try {
            this.myPlatform.copy(agentID, where, newName);
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action CloneAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container not reachable. " + ue.getMessage());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("NotFoundException. " + nfe.getMessage());
        }
        catch (NameClashException nce) {
            throw new AlreadyRegistered();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    void moveAgentAction(MoveAction ma, AID requester) throws FIPAException {
        MobileAgentDescription dsc = ma.getMobileAgentDescription();
        AID agentID = dsc.getName();
        ContainerID where = (ContainerID)dsc.getDestination();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Move-agent " + agentID + " on container " + where);
        }
        try {
            this.myPlatform.move(agentID, where);
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action MoveAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container not reachable. " + ue.getMessage());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("NotFoundException. " + nfe.getMessage());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    void killContainerAction(final KillContainer kc, final AID requester, final JADEPrincipal requesterPrincipal, final Credentials requesterCredentials) throws FIPAException {
        final ContainerID cid = kc.getContainer();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Kill-container " + cid);
        }
        KillContainerRequested kcr = new KillContainerRequested();
        kcr.setContainer(cid);
        EventRecord er = new EventRecord(kcr, this.here());
        er.setWhen(new Date());
        try {
            this.notifyTools(er);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Thread auxThread = new Thread(){

            public void run() {
                try {
                    ams.this.myPlatform.killContainer(cid, requesterPrincipal, requesterCredentials);
                }
                catch (JADESecurityException ae) {
                    ams.this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Kill-container: " + ae);
                    ams.this.sendFailureNotification(kc, cid, new Unauthorised());
                }
                catch (NotFoundException nfe) {
                    ams.this.sendFailureNotification(kc, cid, new InternalError("Container not found. " + nfe.getMessage()));
                }
                catch (UnreachableException ue) {
                    ams.this.sendFailureNotification(kc, cid, new InternalError("Container unreachable. " + ue.getMessage()));
                }
                catch (Throwable t) {
                    ams.this.sendFailureNotification(kc, cid, new InternalError(t.getMessage()));
                }
            }
        };
        auxThread.start();
    }

    void shutdownPlatformAction(ShutdownPlatform sp, final AID requester, final JADEPrincipal requesterPrincipal, final Credentials requesterCredentials) throws FIPAException {
        this.logger.log(Logger.INFO, "AMS - Activating platform shutdown. Requester = " + requester.getName());
        this.notifyShutdownPlatformRequested();
        this.shuttingDown = true;
        Thread auxThread = new Thread(){

            public void run() {
                try {
                    ams.this.myPlatform.shutdownPlatform(requesterPrincipal, requesterCredentials);
                }
                catch (JADESecurityException ae) {
                    ams.this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Shutdown-Platform: " + ae);
                    ams.this.shuttingDown = false;
                }
            }
        };
        auxThread.start();
    }

    private void notifyShutdownPlatformRequested() {
        ShutdownPlatformRequested spr = new ShutdownPlatformRequested();
        EventRecord er = new EventRecord(spr, this.here());
        er.setWhen(new Date());
        try {
            this.notifyTools(er);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    MTPDescriptor installMTPAction(InstallMTP im, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Install-MTP");
        }
        try {
            return this.myPlatform.installMTP(im.getAddress(), im.getContainer(), im.getClassName());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Container not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
        catch (MTPException mtpe) {
            throw new InternalError("Error in MTP installation. " + mtpe.getMessage());
        }
    }

    void uninstallMTPAction(UninstallMTP um, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Uninstall-MTP");
        }
        try {
            this.myPlatform.uninstallMTP(um.getAddress(), um.getContainer());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Container not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
        catch (MTPException mtpe) {
            throw new InternalError("Error in MTP de-installation. " + mtpe.getMessage());
        }
    }

    void sniffOnAction(SniffOn so, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Sniff-on");
        }
        try {
            this.myPlatform.sniffOn(so.getSniffer(), so.getCloneOfSniffedAgents());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
    }

    void sniffOffAction(SniffOff so, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Sniff-off");
        }
        try {
            this.myPlatform.sniffOff(so.getSniffer(), so.getCloneOfSniffedAgents());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
    }

    void debugOnAction(DebugOn don, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Debug-on");
        }
        try {
            this.myPlatform.debugOn(don.getDebugger(), don.getCloneOfDebuggedAgents());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
    }

    void debugOffAction(DebugOff doff, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Debug-off");
        }
        try {
            this.myPlatform.debugOff(doff.getDebugger(), doff.getCloneOfDebuggedAgents());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container unreachable. " + ue.getMessage());
        }
    }

    Location whereIsAgentAction(WhereIsAgentAction wia, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Where-is-agent");
        }
        try {
            return this.myPlatform.getContainerID(wia.getAgentIdentifier());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
    }

    List queryPlatformLocationsAction(QueryPlatformLocationsAction qpl, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Query-platform-locations");
        }
        ContainerID[] ids = this.myPlatform.containerIDs();
        ArrayList l = new ArrayList();
        for (int i = 0; i < ids.length; ++i) {
            l.add(ids[i]);
        }
        return l;
    }

    List queryAgentsOnLocationAction(QueryAgentsOnLocation qaol, AID requester) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting Query-agents-on-location");
        }
        try {
            return this.myPlatform.containerAgents((ContainerID)qaol.getLocation());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Location not found. " + nfe.getMessage());
        }
    }

    void registerAction(Register r, AID requester) throws FIPAException {
        AMSAgentDescription amsd = (AMSAgentDescription)r.getDescription();
        AID id = amsd.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting AMS-registration for " + id);
        }
        if (id == null || id.getName() == null || id.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsRegister(amsd);
        }
        catch (AlreadyRegistered ar) {
            throw ar;
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Register");
            }
            throw new Unauthorised();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    void deregisterAction(Deregister d, AID requester) throws FIPAException {
        AMSAgentDescription amsd = (AMSAgentDescription)d.getDescription();
        AID id = amsd.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting AMS-deregistration for " + id);
        }
        if (id == null || id.getName() == null || id.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsDeregister(amsd);
        }
        catch (NotRegistered nr) {
            throw nr;
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Deregister");
            }
            throw new Unauthorised();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    void modifyAction(Modify m, AID requester) throws FIPAException {
        AMSAgentDescription amsd = (AMSAgentDescription)m.getDescription();
        AID id = amsd.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting AMS-modification for " + id);
            this.logger.log(Logger.FINE, "New state is " + amsd.getState() + ". New ownership is " + amsd.getOwnership());
        }
        if (id == null || id.getName() == null || id.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsModify(amsd);
        }
        catch (NotRegistered nr) {
            throw nr;
        }
        catch (UnreachableException ue) {
            throw new InternalError("Container not reachable. " + ue.getMessage());
        }
        catch (NotFoundException nfe) {
            throw new InternalError("Agent not found. " + nfe.getMessage());
        }
        catch (JADESecurityException ae) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + requester.getName() + " does not have permission to perform action Modify");
            }
            throw new Unauthorised();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InternalError("Unexpected exception. " + e2.getMessage());
        }
    }

    List searchAction(Search s, AID requester) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting AMS-search");
        }
        return this.myPlatform.amsSearch((AMSAgentDescription)s.getDescription(), this.getActualMaxResults(s.getConstraints()));
    }

    private long getActualMaxResults(SearchConstraints constraints) {
        long maxResult = constraints.getMaxResults() == null ? 1L : constraints.getMaxResults();
        maxResult = maxResult < 0L ? (long)this.amsMaxResults : maxResult;
        return maxResult;
    }

    APDescription getDescriptionAction(AID requester) {
        if (requester != null && this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + requester + " requesting AMS-get-description");
        }
        this.theProfile.clearAllAPServices();
        Iterator mtps = this.platformMTPs().iterator();
        while (mtps.hasNext()) {
            MTPDescriptor dr = (MTPDescriptor)mtps.next();
            this.theProfile.addAPServices(new APService(dr.getName(), dr.getAddresses()));
        }
        return this.theProfile;
    }

    private void notifyTools(EventRecord er) throws Exception {
        if (!this.shuttingDown || this.keepNotifyOnShutdown) {
            this.toolNotification.clearAllReceiver();
            AID[] allTools = this.myPlatform.agentTools();
            for (int i = 0; i < allTools.length; ++i) {
                AID tool = allTools[i];
                this.toolNotification.addReceiver(tool);
            }
            Occurred o = new Occurred();
            o.setWhat(er);
            this.getContentManager().fillContent(this.toolNotification, o);
            this.send(this.toolNotification);
        }
    }

    public void resetEvents(boolean sendSnapshot) {
        this.queueFeeder = new AMSEventQueueFeeder(this.eventQueue, this.here());
        this.myPlatform.addListener(this.queueFeeder);
        this.eventQueue.clear();
        ResetEvents re = new ResetEvents();
        EventRecord er = new EventRecord(re, this.here());
        this.eventQueue.put(er);
        if (sendSnapshot) {
            try {
                ContainerID[] ids = this.myPlatform.containerIDs();
                for (int i = 0; i < ids.length; ++i) {
                    ContainerID cid = ids[i];
                    AddedContainer ac = new AddedContainer();
                    ac.setContainer(cid);
                    ac.setOwnership(this.getContainerOwnership(cid));
                    er = new EventRecord(ac, this.here());
                    this.eventQueue.put(er);
                    Iterator mtps = this.myPlatform.containerMTPs(cid).iterator();
                    while (mtps.hasNext()) {
                        AddedMTP amtp = new AddedMTP();
                        amtp.setAddress(((MTPDescriptor)mtps.next()).getAddresses()[0]);
                        amtp.setWhere(cid);
                        er = new EventRecord(amtp, this.here());
                        this.eventQueue.put(er);
                    }
                }
                PlatformDescription ap = new PlatformDescription();
                ap.setPlatform(this.getDescriptionAction(null));
                er = new EventRecord(ap, this.here());
                this.eventQueue.put(er);
                AID[] agents = this.myPlatform.agentNames();
                for (int j = 0; j < agents.length; ++j) {
                    ContainerID c;
                    AID agentName = agents[j];
                    AMSAgentDescription amsd = this.myPlatform.getAMSDescription(agentName);
                    if (amsd.getState().equals("latent") || (c = this.myPlatform.getContainerID(agentName)) == null) continue;
                    BornAgent ba = new BornAgent();
                    AID id = agentName;
                    if (amsd != null) {
                        if (amsd.getName() != null) {
                            id = amsd.getName();
                        }
                        ba.setState(amsd.getState());
                        ba.setOwnership(amsd.getOwnership());
                    }
                    ba.setAgent(id);
                    ba.setWhere(c);
                    er = new EventRecord(ba, this.here());
                    this.eventQueue.put(er);
                }
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
            }
        }
    }

    public void setQueueFeeder(AMSEventQueueFeeder feeder) {
        this.queueFeeder = feeder;
        this.queueFeeder.setAms(this);
        this.eventQueue = this.queueFeeder.getQueue();
    }

    public AMSEventQueueFeeder getQueueFeeder() {
        return this.queueFeeder;
    }

    private String getContainerOwnership(ContainerID container) {
        return "none";
    }

    private String getAgentOwnership(AID agent) {
        String ownership = null;
        try {
            AMSAgentDescription amsd = this.myPlatform.getAMSDescription(agent);
            ownership = amsd.getOwnership();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ownership != null ? ownership : "none";
    }

    private void writeAPDescription(APDescription description) {
        try {
            FileWriter f = new FileWriter(this.getProperty("file-dir", "") + "APDescription.txt");
            f.write(description.toString());
            f.write(10);
            f.flush();
            f.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private List platformMTPs() {
        ArrayList mtps = new ArrayList();
        ContainerID[] cc = this.myPlatform.containerIDs();
        for (int i = 0; i < cc.length; ++i) {
            try {
                List l = this.myPlatform.containerMTPs(cc[i]);
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    mtps.add(it.next());
                }
                continue;
            }
            catch (NotFoundException nfe) {
                // empty catch block
            }
        }
        return mtps;
    }

    void storeNotification(Concept action, Object key, ACLMessage notification) {
        if (action instanceof CreateAgent) {
            this.pendingNewAgents.put(key, notification);
        }
        if (action instanceof KillAgent) {
            this.pendingDeadAgents.put(key, notification);
        } else if (action instanceof CloneAction) {
            this.pendingClonedAgents.put(key, notification);
        } else if (action instanceof MoveAction) {
            this.pendingMovedAgents.put(key, notification);
        } else if (action instanceof KillContainer) {
            this.pendingRemovedContainers.put(key, notification);
        }
    }

    private void sendFailureNotification(final Concept action, final Object key, final FIPAException fe) {
        this.addBehaviour(new OneShotBehaviour(this){

            public void action() {
                ACLMessage notification = null;
                if (action instanceof CreateAgent) {
                    notification = (ACLMessage)ams.this.pendingNewAgents.remove(key);
                } else if (action instanceof KillContainer) {
                    notification = (ACLMessage)ams.this.pendingRemovedContainers.remove(key);
                }
                if (notification != null) {
                    notification.setPerformative(6);
                    Action slAction = new Action(ams.this.getAID(), action);
                    ContentElementList cel = new ContentElementList();
                    cel.add(slAction);
                    cel.add(fe);
                    try {
                        ams.this.getContentManager().fillContent(notification, cel);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        notification.setContent("(" + fe.getMessage() + ")");
                    }
                    ams.this.send(notification);
                }
            }
        });
    }

    private class EventManager
    extends CyclicBehaviour {
        private Map handlers = new HashMap();

        public EventManager() {
            this.handlers.put("Removed-Container", new Handler(){

                public void handle(Event ev) {
                    RemovedContainer rc = (RemovedContainer)ev;
                    ContainerID cid = rc.getContainer();
                    ACLMessage notification = (ACLMessage)ams.this.pendingRemovedContainers.remove(cid);
                    if (notification != null) {
                        ams.this.send(notification);
                    }
                }
            });
            this.handlers.put("Dead-Agent", new Handler(){

                public void handle(Event ev) {
                    DeadAgent da = (DeadAgent)ev;
                    AID agentID = da.getAgent();
                    ACLMessage notification = (ACLMessage)ams.this.pendingDeadAgents.remove(agentID);
                    if (notification != null) {
                        ams.this.send(notification);
                    }
                }
            });
            this.handlers.put("Moved-Agent", new Handler(){

                public void handle(Event ev) {
                    MovedAgent ma = (MovedAgent)ev;
                    AID agentID = ma.getAgent();
                    ACLMessage notification = (ACLMessage)ams.this.pendingMovedAgents.remove(agentID);
                    if (notification != null) {
                        ams.this.send(notification);
                    }
                }
            });
            this.handlers.put("Born-Agent", new Handler(){

                public void handle(Event ev) {
                    BornAgent ba = (BornAgent)ev;
                    AID agentID = ba.getAgent();
                    ACLMessage notification = (ACLMessage)ams.this.pendingNewAgents.remove(agentID);
                    if (notification == null) {
                        notification = (ACLMessage)ams.this.pendingClonedAgents.remove(agentID);
                    }
                    if (notification != null) {
                        ams.this.send(notification);
                    }
                }
            });
            this.handlers.put("platform-description", new Handler(){

                public void handle(Event ev) {
                    ams.this.writeAPDescription(((PlatformDescription)ev).getPlatform());
                }
            });
        }

        public void action() {
            try {
                EventRecord er = (EventRecord)ams.this.eventQueue.get();
                if (er != null) {
                    Handler handler;
                    Event ev = er.getWhat();
                    if (ams.this.logger.isLoggable(Logger.FINE)) {
                        ams.this.logger.log(Logger.FINE, "EventManager serving event " + ev.getName());
                    }
                    if ((handler = (Handler)this.handlers.get(ev.getName())) != null) {
                        handler.handle(ev);
                    }
                    ams.this.notifyTools(er);
                } else {
                    this.block();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static interface Handler {
        public void handle(Event var1);
    }

    private class DeregisterToolBehaviour
    extends CyclicBehaviour {
        private MessageTemplate cancellationTemplate;

        DeregisterToolBehaviour() {
            MessageTemplate mt1 = MessageTemplate.MatchLanguage("fipa-sl0");
            MessageTemplate mt2 = MessageTemplate.MatchOntology("JADE-Introspection");
            MessageTemplate mt12 = MessageTemplate.and(mt1, mt2);
            mt1 = MessageTemplate.MatchReplyWith("tool-cancellation");
            mt2 = MessageTemplate.MatchPerformative(2);
            this.cancellationTemplate = MessageTemplate.and(mt1, mt2);
            this.cancellationTemplate = MessageTemplate.and(this.cancellationTemplate, mt12);
        }

        public void action() {
            ACLMessage current = ams.this.receive(this.cancellationTemplate);
            if (current != null) {
                ams.this.myPlatform.removeTool(current.getSender());
            } else {
                this.block();
            }
        }
    }

    private class RegisterToolBehaviour
    extends CyclicBehaviour {
        private MessageTemplate subscriptionTemplate;

        RegisterToolBehaviour() {
            MessageTemplate mt1 = MessageTemplate.MatchLanguage("fipa-sl0");
            MessageTemplate mt2 = MessageTemplate.MatchOntology("JADE-Introspection");
            MessageTemplate mt12 = MessageTemplate.and(mt1, mt2);
            mt1 = MessageTemplate.MatchReplyWith("tool-subscription");
            mt2 = MessageTemplate.MatchPerformative(19);
            this.subscriptionTemplate = MessageTemplate.and(mt1, mt2);
            this.subscriptionTemplate = MessageTemplate.and(this.subscriptionTemplate, mt12);
        }

        public void action() {
            ACLMessage current = ams.this.receive(this.subscriptionTemplate);
            if (current != null) {
                AID newTool = current.getSender();
                ams.this.toolNotification.clearAllReceiver();
                ams.this.toolNotification.addReceiver(newTool);
                try {
                    ResetEvents re = new ResetEvents();
                    EventRecord er = new EventRecord(re, ams.this.here());
                    Occurred o = new Occurred();
                    o.setWhat(er);
                    try {
                        ams.this.getContentManager().fillContent(ams.this.toolNotification, o);
                        ams.this.send(ams.this.toolNotification);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    ContainerID[] ids = ams.this.myPlatform.containerIDs();
                    for (int i = 0; i < ids.length; ++i) {
                        ContainerID cid = ids[i];
                        AddedContainer ac = new AddedContainer();
                        ac.setContainer(cid);
                        ac.setOwnership(ams.this.getContainerOwnership(cid));
                        er = new EventRecord(ac, ams.this.here());
                        o = new Occurred();
                        o.setWhat(er);
                        try {
                            ams.this.getContentManager().fillContent(ams.this.toolNotification, o);
                            ams.this.send(ams.this.toolNotification);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                        Iterator mtps = ams.this.myPlatform.containerMTPs(cid).iterator();
                        while (mtps.hasNext()) {
                            AddedMTP amtp = new AddedMTP();
                            amtp.setAddress(((MTPDescriptor)mtps.next()).getAddresses()[0]);
                            amtp.setWhere(cid);
                            er = new EventRecord(amtp, ams.this.here());
                            o = new Occurred();
                            o.setWhat(er);
                            try {
                                ams.this.getContentManager().fillContent(ams.this.toolNotification, o);
                                ams.this.send(ams.this.toolNotification);
                            }
                            catch (Exception e4) {
                                e4.printStackTrace();
                            }
                        }
                    }
                    AID[] agents = ams.this.myPlatform.agentNames();
                    for (int i = 0; i < agents.length; ++i) {
                        AID agentName = agents[i];
                        ContainerID cid = ams.this.myPlatform.getContainerID(agentName);
                        AMSAgentDescription amsd = ams.this.myPlatform.getAMSDescription(agentName);
                        BornAgent ba = new BornAgent();
                        AID id = agentName;
                        if (amsd != null) {
                            if (amsd.getName() != null) {
                                id = amsd.getName();
                            }
                            ba.setState(amsd.getState());
                            ba.setOwnership(amsd.getOwnership());
                            ba.setClassName(id.getAllUserDefinedSlot().getProperty("JADE-agent-classname"));
                        }
                        ba.setAgent(id);
                        ba.setWhere(cid);
                        er = new EventRecord(ba, ams.this.here());
                        o = new Occurred();
                        o.setWhat(er);
                        try {
                            ams.this.getContentManager().fillContent(ams.this.toolNotification, o);
                            ams.this.send(ams.this.toolNotification);
                            continue;
                        }
                        catch (Exception e5) {
                            e5.printStackTrace();
                        }
                    }
                    PlatformDescription ap = new PlatformDescription();
                    ap.setPlatform(ams.this.getDescriptionAction(null));
                    er = new EventRecord(ap, ams.this.here());
                    o = new Occurred();
                    o.setWhat(er);
                    try {
                        ams.this.getContentManager().fillContent(ams.this.toolNotification, o);
                        ams.this.send(ams.this.toolNotification);
                    }
                    catch (Exception e6) {
                        e6.printStackTrace();
                    }
                    ams.this.myPlatform.addTool(newTool);
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (Exception e7) {
                    e7.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }
}

