/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.AgentAction;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnrecognisedValue;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;
import jade.util.leap.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class RequestFIPAServiceBehaviour
extends SimpleAchieveREInitiator {
    private ACLMessage lastMsg;
    private boolean notYetReady;
    private long timeout = 300000L;
    private FIPAException outcome = null;

    public RequestFIPAServiceBehaviour(Agent a, AID receiver, String actionName, Object agentDescription, SearchConstraints constraints) throws FIPAException {
        super(a, new ACLMessage(16));
        AgentAction action;
        ACLMessage msg = FIPAService.createRequestMessage(a, receiver);
        Action act = new Action();
        act.setActor(receiver);
        if (actionName.equalsIgnoreCase("register")) {
            action = new Register();
            ((Register)action).setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("deregister")) {
            action = new Deregister();
            ((Deregister)action).setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("modify")) {
            action = new Modify();
            ((Modify)action).setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("search")) {
            action = new Search();
            ((Search)action).setDescription(agentDescription);
            ((Search)action).setConstraints(constraints);
            act.setAction(action);
            msg.setReplyByDate(new Date(System.currentTimeMillis() + this.timeout));
        } else {
            throw new UnsupportedFunction();
        }
        if (a.getContentManager().lookupOntology("FIPA-Agent-Management") == null) {
            a.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        }
        if (a.getContentManager().lookupLanguage("fipa-sl0") == null) {
            a.getContentManager().registerLanguage(new SLCodec(0), "fipa-sl0");
        }
        try {
            a.getContentManager().fillContent(msg, act);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new UnrecognisedValue("content");
        }
        this.reset(msg);
        this.notYetReady = true;
    }

    public RequestFIPAServiceBehaviour(Agent a, AID receiver, String actionName, Object agentDescription) throws FIPAException {
        this(a, receiver, actionName, agentDescription, new SearchConstraints());
    }

    protected void handleNotUnderstood(ACLMessage reply) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)reply.clone();
    }

    protected void handleRefuse(ACLMessage reply) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)reply.clone();
    }

    protected void handleAgree(ACLMessage reply) {
    }

    protected void handleFailure(ACLMessage reply) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)reply.clone();
    }

    protected void handleInform(ACLMessage reply) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)reply.clone();
    }

    protected void handleOutOfSequence(ACLMessage reply) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)reply.clone();
    }

    protected void handleAllResponses(Vector reply) {
        this.notYetReady = false;
        this.lastMsg = reply.size() == 0 ? new ACLMessage(10) : (ACLMessage)((ACLMessage)reply.elementAt(0)).clone();
    }

    public ACLMessage getLastMsg() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        return this.lastMsg;
    }

    public java.util.List getSearchResult() throws FIPAException, NotYetReady {
        Object[] r = this.getSearchResults();
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < r.length; ++i) {
            l.add(r[i]);
        }
        return l;
    }

    public Object[] getSearchResults() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        List l = null;
        try {
            Result r = (Result)this.myAgent.getContentManager().extractContent(this.lastMsg);
            l = r.getItems();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new UnrecognisedValue("content");
        }
        return l.toArray();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

