/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.ContentManager;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsPredicate;
import jade.domain.DFMemKB;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.KBManagement.KB;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Enumeration;

class KBSubscriptionManager
implements SubscriptionResponder.SubscriptionManager {
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Map subscriptionsCache = new HashMap();
    private SubscriptionInfo[] subscriptions = null;
    KB kBase;
    ContentManager cm;

    public KBSubscriptionManager(KB k) {
        this.kBase = k;
    }

    public void setContentManager(ContentManager c) {
        this.cm = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(SubscriptionResponder.Subscription sub) throws RefuseException, NotUnderstoodException {
        DFAgentDescription dfdTemplate = null;
        SearchConstraints constraints = null;
        AbsIRE absIota = null;
        try {
            ACLMessage subMessage = sub.getMessage();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Registering subscription " + subMessage.getConversationId() + ". Agent is " + subMessage.getSender().getName());
            }
            absIota = (AbsIRE)this.cm.extractAbsContent(subMessage);
            AbsPredicate absResult = absIota.getProposition();
            AbsAgentAction absAction = (AbsAgentAction)absResult.getAbsObject("action");
            AbsAgentAction absSearch = (AbsAgentAction)absAction.getAbsObject("action");
            Search search = (Search)FIPAManagementOntology.getInstance().toObject(absSearch);
            dfdTemplate = (DFAgentDescription)search.getDescription();
            constraints = search.getConstraints();
            this.kBase.subscribe(dfdTemplate, sub);
            Map map = this.subscriptionsCache;
            synchronized (map) {
                if (this.subscriptions != null) {
                    this.subscriptionsCache.put(subMessage.getConversationId(), new SubscriptionInfo(sub, dfdTemplate, absIota));
                    this.subscriptions = KBSubscriptionManager.toArray(this.subscriptionsCache);
                }
            }
        }
        catch (Exception e2) {
            throw new NotUnderstoodException(e2.getMessage());
        }
        List results = this.kBase.search(dfdTemplate, -1);
        if (results.size() > 0) {
            this.notify(sub, results, absIota);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregister(SubscriptionResponder.Subscription sub) throws FailureException {
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            ACLMessage subMessage = sub.getMessage();
            this.myLogger.log(Logger.CONFIG, "Deregistering subscription " + subMessage.getConversationId() + ". Agent is " + subMessage.getSender().getName());
        }
        this.kBase.unsubscribe(sub);
        Map map = this.subscriptionsCache;
        synchronized (map) {
            if (this.subscriptions != null) {
                this.subscriptionsCache.remove(sub.getMessage().getConversationId());
                this.subscriptions = KBSubscriptionManager.toArray(this.subscriptionsCache);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChange(DFAgentDescription dfd, DFAgentDescription oldDfd) {
        Map map = this.subscriptionsCache;
        synchronized (map) {
            if (this.subscriptions == null) {
                this.subscriptionsCache = this.loadSubscriptionsCache();
                this.subscriptions = KBSubscriptionManager.toArray(this.subscriptionsCache);
            }
        }
        for (int i = 0; i < this.subscriptions.length; ++i) {
            SubscriptionInfo info = this.subscriptions[i];
            DFAgentDescription template = info.getTemplate();
            if (!DFMemKB.compare(template, dfd) && (oldDfd == null || !DFMemKB.compare(template, oldDfd))) continue;
            ArrayList results = new ArrayList();
            results.add(dfd);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                ACLMessage subMessage = info.getSubscription().getMessage();
                this.myLogger.log(Logger.FINE, "Notifying subscribed agent " + subMessage.getSender().getName() + " [" + subMessage.getConversationId() + "] ");
            }
            this.notify(info.getSubscription(), results, info.getAbsIota());
        }
    }

    private Map loadSubscriptionsCache() {
        HashMap m = new HashMap();
        Enumeration e2 = this.kBase.getSubscriptions();
        while (e2.hasMoreElements()) {
            SubscriptionResponder.Subscription sub = (SubscriptionResponder.Subscription)e2.nextElement();
            try {
                AbsIRE absIota = (AbsIRE)this.cm.extractAbsContent(sub.getMessage());
                AbsPredicate absResult = absIota.getProposition();
                AbsAgentAction absAction = (AbsAgentAction)absResult.getAbsObject("action");
                AbsAgentAction absSearch = (AbsAgentAction)absAction.getAbsObject("action");
                Search search = (Search)FIPAManagementOntology.getInstance().toObject(absSearch);
                DFAgentDescription template = (DFAgentDescription)search.getDescription();
                m.put(sub.getMessage().getConversationId(), new SubscriptionInfo(sub, template, absIota));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return m;
    }

    private void notify(SubscriptionResponder.Subscription sub, List results, AbsIRE absIota) {
        try {
            ACLMessage notification = sub.getMessage().createReply();
            notification.addUserDefinedParameter("JADE-ignore-failure", "true");
            notification.setPerformative(7);
            AbsPredicate absEquals = new AbsPredicate("=");
            absEquals.set("left", absIota);
            absEquals.set("right", FIPAManagementOntology.getInstance().fromObject(results));
            this.cm.fillContent(notification, absEquals);
            sub.notify(notification);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static final SubscriptionInfo[] toArray(Map m) {
        Collection c = m.values();
        SubscriptionInfo[] result = new SubscriptionInfo[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i] = (SubscriptionInfo)it.next();
            ++i;
        }
        return result;
    }

    private class SubscriptionInfo {
        private SubscriptionResponder.Subscription subscription;
        private DFAgentDescription template;
        private AbsIRE absIota;

        private SubscriptionInfo(SubscriptionResponder.Subscription subscription, DFAgentDescription template, AbsIRE absIota) {
            this.subscription = subscription;
            this.template = template;
            this.absIota = absIota;
        }

        public SubscriptionResponder.Subscription getSubscription() {
            return this.subscription;
        }

        public DFAgentDescription getTemplate() {
            return this.template;
        }

        public AbsIRE getAbsIota() {
            return this.absIota;
        }
    }
}

