/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.FIPAAgentManagement;

import jade.content.Concept;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Date;

public class Envelope
implements Concept,
Serializable {
    private static final int EXPECTED_LIST_SIZE = 2;
    private ArrayList to = new ArrayList(2);
    private AID from;
    private String comments;
    private String aclRepresentation;
    private Long payloadLength;
    private String payloadEncoding;
    private Date date;
    private ArrayList intendedReceiver = new ArrayList(2);
    private Properties transportBehaviour;
    private ArrayList stamps = new ArrayList(2);
    private ArrayList properties = new ArrayList(2);

    public Envelope() {
        this.payloadLength = new Long(-1L);
    }

    public void addTo(AID id) {
        this.to.add(id);
    }

    public boolean removeTo(AID id) {
        return this.to.remove(id);
    }

    public void clearAllTo() {
        this.to.clear();
    }

    public Iterator getAllTo() {
        return this.to.iterator();
    }

    public void setFrom(AID id) {
        this.from = id;
    }

    public AID getFrom() {
        return this.from;
    }

    public void setComments(String c) {
        this.comments = c;
    }

    public String getComments() {
        return this.comments;
    }

    public void setAclRepresentation(String r) {
        this.aclRepresentation = r;
    }

    public String getAclRepresentation() {
        return this.aclRepresentation;
    }

    public void setPayloadLength(Long l) {
        this.payloadLength = l;
    }

    public Long getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadEncoding(String e2) {
        this.payloadEncoding = e2;
    }

    public String getPayloadEncoding() {
        return this.payloadEncoding;
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public Date getDate() {
        return this.date;
    }

    public void addIntendedReceiver(AID id) {
        this.intendedReceiver.add(id);
    }

    public boolean removeIntendedReceiver(AID id) {
        return this.intendedReceiver.remove(id);
    }

    public void clearAllIntendedReceiver() {
        this.intendedReceiver.clear();
    }

    public Iterator getAllIntendedReceiver() {
        return this.intendedReceiver.iterator();
    }

    public void setReceived(ReceivedObject ro) {
        this.addStamp(ro);
    }

    public ReceivedObject getReceived() {
        if (this.stamps.isEmpty()) {
            return null;
        }
        return (ReceivedObject)this.stamps.get(this.stamps.size() - 1);
    }

    public void addStamp(ReceivedObject ro) {
        this.stamps.add(ro);
    }

    public ReceivedObject[] getStamps() {
        ReceivedObject[] ret = new ReceivedObject[this.stamps.size()];
        int counter = 0;
        Iterator it = this.stamps.iterator();
        while (it.hasNext()) {
            ret[counter++] = (ReceivedObject)it.next();
        }
        return ret;
    }

    public void addProperties(Property p) {
        this.properties.add(p);
    }

    public boolean removeProperties(Property p) {
        return this.properties.remove(p);
    }

    public void clearAllProperties() {
        this.properties.clear();
    }

    public Iterator getAllProperties() {
        return this.properties.iterator();
    }

    public String toString() {
        int j;
        ReceivedObject[] ro;
        Iterator ii;
        String s = "(Envelope ";
        Iterator i = this.getAllTo();
        if (i.hasNext()) {
            s = s + " :to (sequence ";
            ii = i;
            while (ii.hasNext()) {
                s = s + " " + ii.next().toString();
            }
            s = s + ") ";
        }
        if (this.getFrom() != null) {
            s = s + " :from " + this.getFrom().toString();
        }
        if (this.getComments() != null) {
            s = s + " :comments " + this.getComments();
        }
        if (this.getAclRepresentation() != null) {
            s = s + " :acl-representation " + this.getAclRepresentation();
        }
        if (this.getPayloadLength() != null) {
            s = s + " :payload-length " + this.getPayloadLength().toString();
        }
        if (this.getPayloadEncoding() != null) {
            s = s + " :payload-encoding " + this.getPayloadEncoding();
        }
        if (this.getDate() != null) {
            s = s + " :date " + this.getDate().toString();
        }
        if ((i = this.getAllIntendedReceiver()).hasNext()) {
            s = s + " :intended-receiver (sequence ";
            ii = i;
            while (ii.hasNext()) {
                s = s + " " + ii.next().toString();
            }
            s = s + ") ";
        }
        if ((ro = this.getStamps()).length > 0) {
            s = s + " :received-object (sequence ";
            for (j = 0; j < ro.length; ++j) {
                if (ro[j] == null) continue;
                s = s + " " + ro[j].toString();
            }
            s = s + ") ";
        }
        if (this.properties.size() > 0) {
            s = s + " :properties (set";
            for (j = 0; j < this.properties.size(); ++j) {
                Property p = (Property)this.properties.get(j);
                s = s + " " + p.getName() + " " + p.getValue();
            }
            s = s + ")";
        }
        return s + ")";
    }

    public Object clone() {
        AID id;
        int i;
        Envelope env = new Envelope();
        env.to = new ArrayList(this.to.size());
        for (i = 0; i < this.to.size(); ++i) {
            id = (AID)this.to.get(i);
            env.to.add(id.clone());
        }
        env.intendedReceiver = new ArrayList(this.intendedReceiver.size());
        for (i = 0; i < this.intendedReceiver.size(); ++i) {
            id = (AID)this.intendedReceiver.get(i);
            env.intendedReceiver.add(id.clone());
        }
        env.stamps = (ArrayList)this.stamps.clone();
        if (this.from != null) {
            env.from = (AID)this.from.clone();
        }
        env.comments = this.comments;
        env.aclRepresentation = this.aclRepresentation;
        env.payloadLength = this.payloadLength;
        env.payloadEncoding = this.payloadEncoding;
        env.date = this.date;
        env.transportBehaviour = this.transportBehaviour;
        env.properties = new ArrayList(this.properties.size());
        for (i = 0; i < this.properties.size(); ++i) {
            Property p = (Property)this.properties.get(i);
            env.properties.add(p.clone());
        }
        return env;
    }

    private void setTo(ArrayList al) {
        this.to = al;
    }

    private ArrayList getTo() {
        return this.to;
    }

    private void setIntendedReceivers(ArrayList al) {
        this.intendedReceiver = al;
    }

    private ArrayList getIntendedReceivers() {
        return this.intendedReceiver;
    }

    private void setProperties(ArrayList al) {
        this.properties = al;
    }

    private ArrayList getProperties() {
        return this.properties;
    }
}

