/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.ServiceNotActiveException;
import jade.core.sam.AverageMeasureProviderImpl;
import jade.core.sam.SAMHelper;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.RequestManagementBehaviour;
import jade.domain.df;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.List;

class DFFipaAgentManagementBehaviour
extends RequestManagementBehaviour {
    private df theDF;
    private AverageMeasureProviderImpl serveRequestTimeProvider;

    protected DFFipaAgentManagementBehaviour(df a, MessageTemplate mt) {
        super(a, mt);
        this.theDF = a;
    }

    public void onStart() {
        super.onStart();
        try {
            SAMHelper samHelper = (SAMHelper)this.myAgent.getHelper("jade.core.sam.SAM");
            this.serveRequestTimeProvider = new AverageMeasureProviderImpl();
            samHelper.addEntityMeasureProvider("DF-Serve-Request-Avg-Time", this.serveRequestTimeProvider);
        }
        catch (ServiceNotActiveException snae) {
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error initializing SAM providers", e2);
        }
    }

    protected ACLMessage performAction(Action slAction, ACLMessage request) throws JADESecurityException, FIPAException {
        Concept action = slAction.getAction();
        List result = null;
        boolean asynchNotificationRequired = false;
        if (action instanceof Register) {
            this.theDF.registerAction((Register)action, request.getSender());
        } else if (action instanceof Deregister) {
            this.theDF.deregisterAction((Deregister)action, request.getSender());
        } else if (action instanceof Modify) {
            this.theDF.modifyAction((Modify)action, request.getSender());
        } else if (action instanceof Search) {
            this.theDF.storePendingRequest(action, request);
            result = this.theDF.searchAction((Search)action, request.getSender());
            if (result == null) {
                asynchNotificationRequired = true;
            }
        } else {
            throw new UnsupportedFunction();
        }
        if (!asynchNotificationRequired) {
            this.theDF.removePendingRequest(action);
            ACLMessage notification = request.createReply();
            notification.setPerformative(7);
            Predicate p = null;
            p = result != null ? new Result(slAction, result) : new Done(slAction);
            try {
                this.theDF.getContentManager().fillContent(notification, p);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            long serveTime = System.currentTimeMillis() - request.getPostTimeStamp();
            if (this.serveRequestTimeProvider != null) {
                this.serveRequestTimeProvider.addSample(serveTime);
            }
            return notification;
        }
        return null;
    }
}

