/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.Service;
import jade.core.ServiceException;
import jade.core.sam.SAMInfo;
import jade.core.sam.SAMInfoHandler;
import jade.core.sam.SAMService;
import jade.core.sam.SAMSlice;
import jade.util.Logger;
import java.util.Date;

class Poller
extends Thread {
    private SAMService myService;
    private volatile SAMInfoHandler[] handlers;
    private long period;
    private boolean active;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    Poller(SAMService service, long p, SAMInfoHandler[] hh) {
        this.myService = service;
        this.period = p;
        this.handlers = hh;
        this.setName("SAMService-Poller");
    }

    public synchronized void startPolling() {
        this.active = true;
        this.start();
    }

    public synchronized void stopPolling() {
        this.active = false;
        this.interrupt();
    }

    public synchronized void addHandler(SAMInfoHandler h, boolean first) {
        SAMInfoHandler[] newHandlers = new SAMInfoHandler[this.handlers.length + 1];
        int k = 0;
        if (first) {
            newHandlers[0] = h;
            k = 1;
        }
        for (int i = 0; i < this.handlers.length; ++i) {
            newHandlers[k + i] = this.handlers[i];
        }
        if (!first) {
            newHandlers[this.handlers.length] = h;
        }
        this.handlers = newHandlers;
    }

    public synchronized void removeHandler(SAMInfoHandler handler) {
        boolean found = false;
        for (SAMInfoHandler h : this.handlers) {
            if (h != handler) continue;
            found = true;
            break;
        }
        if (found) {
            SAMInfoHandler[] newHandlers = new SAMInfoHandler[this.handlers.length - 1];
            int k = 0;
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == handler) continue;
                newHandlers[k++] = this.handlers[i];
            }
            this.handlers = newHandlers;
        }
    }

    public void run() {
        block4: {
            this.myLogger.log(Logger.INFO, "SAMService poller thread started");
            try {
                while (this.active) {
                    Thread.sleep(this.period);
                    this.poll();
                }
            }
            catch (InterruptedException ie) {
                if (!this.active) break block4;
                this.myLogger.log(Logger.WARNING, "SAMService poller thread unexpectedly interrupted");
            }
        }
        for (SAMInfoHandler h : this.handlers) {
            h.shutdown();
        }
        this.myLogger.log(Logger.CONFIG, "SAMService poller thread terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() {
        this.myLogger.log(Logger.FINE, "Retrieving SAM information from all nodes");
        Date timeStamp = new Date();
        SAMInfo globalInfo = new SAMInfo();
        try {
            Service.Slice[] slices = this.myService.getAllSlices();
            for (int i = 0; i < slices.length; ++i) {
                SAMSlice s = (SAMSlice)slices[i];
                try {
                    this.startWatchDog();
                    SAMInfo sliceInfo = s.getSAMInfo();
                    globalInfo.update(sliceInfo);
                    this.myLogger.log(Logger.FINER, "SAM information successfully retrieved from node " + s.getNode().getName());
                    continue;
                }
                catch (Exception imtpe) {
                    this.myLogger.log(Logger.WARNING, "Error retrieving SAM information from node " + s.getNode().getName(), imtpe);
                    continue;
                }
                finally {
                    this.stopWatchDog();
                }
            }
            for (SAMInfoHandler h : this.handlers) {
                h.handle(timeStamp, globalInfo);
            }
        }
        catch (ServiceException se) {
            this.myLogger.log(Logger.WARNING, "Error retrieving SAM slices", se);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Unexpected error polling SAM information", e2);
        }
    }

    private void startWatchDog() {
    }

    private void stopWatchDog() {
    }
}

