/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.Profile;
import jade.core.sam.AverageMeasure;
import jade.core.sam.SAMInfo;
import jade.core.sam.SAMInfoHandler;
import jade.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class DefaultSAMInfoHandlerImpl
implements SAMInfoHandler {
    private static final String SAM_PREFIX = "SAM_";
    private Map<String, PrintStream> entityFiles = new HashMap<String, PrintStream>();
    private Map<String, CounterInfo> counters = new HashMap<String, CounterInfo>();
    private SimpleDateFormat timeStampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private String csvSeparator;
    private File samInfoDirectory;
    private String fileSeparator;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    DefaultSAMInfoHandlerImpl() {
    }

    public void initialize(Profile p) throws Exception {
        this.fileSeparator = System.getProperty("file.separator");
        String samInfoDirectoryName = p.getParameter("jade_core_sam_SAMService_csvdirectory", ".");
        this.samInfoDirectory = new File(samInfoDirectoryName);
        if (!this.samInfoDirectory.exists()) {
            this.myLogger.log(Logger.CONFIG, "SAM csv directory " + this.samInfoDirectory + " does not exists. Creating it ...");
            boolean success = this.samInfoDirectory.mkdirs();
            if (!success) {
                throw new IOException("Cannot create SAM csv directory " + samInfoDirectoryName + ".");
            }
        } else if (!this.samInfoDirectory.isDirectory()) {
            throw new IOException("SAM csv location " + samInfoDirectoryName + " is not a directory.");
        }
        this.csvSeparator = p.getParameter("jade_core_sam_SAMService_csvseparator", ";");
    }

    public void shutdown() {
        for (PrintStream ps : this.entityFiles.values()) {
            ps.close();
        }
        for (CounterInfo ci : this.counters.values()) {
            ci.stream.close();
        }
    }

    public void handle(Date timeStamp, SAMInfo info) {
        Map<String, AverageMeasure> entityMeasures = info.getEntityMeasures();
        for (String entityName : entityMeasures.keySet()) {
            this.myLogger.log(Logger.FINE, "Handling measure of entity " + entityName);
            try {
                AverageMeasure m = entityMeasures.get(entityName);
                PrintStream stream = this.entityFiles.get(entityName);
                if (stream == null) {
                    this.myLogger.log(Logger.INFO, "Creating CSV file for measures of entity " + entityName);
                    File f = this.createFile(entityName);
                    stream = new PrintStream(f);
                    stream.println("Time-stamp" + this.csvSeparator + "Average-value" + this.csvSeparator + "N-samples");
                    this.entityFiles.put(entityName, stream);
                }
                stream.println(this.timeStampFormatter.format(timeStamp) + this.csvSeparator + m.getValue() + this.csvSeparator + m.getNSamples());
            }
            catch (Exception e2) {
                this.myLogger.log(Logger.WARNING, "Error writing to CSV file of entity " + entityName, e2);
                this.entityFiles.remove(entityName);
            }
        }
        Map<String, Long> counterValues = info.getCounterValues();
        for (String counterName : counterValues.keySet()) {
            this.myLogger.log(Logger.FINE, "Handling value of counter " + counterName);
            try {
                long value = counterValues.get(counterName);
                CounterInfo ci = this.counters.get(counterName);
                if (ci == null) {
                    this.myLogger.log(Logger.INFO, "Creating CSV file for values of counter " + counterName);
                    File f = this.createFile(counterName);
                    PrintStream stream = new PrintStream(f);
                    stream.println("Time-stamp" + this.csvSeparator + "Value" + this.csvSeparator + "Total-value");
                    ci = new CounterInfo(stream);
                    this.counters.put(counterName, ci);
                }
                ci.totValue += value;
                ci.stream.println(this.timeStampFormatter.format(timeStamp) + this.csvSeparator + value + this.csvSeparator + ci.totValue);
            }
            catch (Exception e3) {
                this.myLogger.log(Logger.WARNING, "Error writing to CSV file of counter " + counterName, e3);
                this.counters.remove(counterName);
            }
        }
    }

    private File createFile(String name) throws IOException {
        File dir = this.samInfoDirectory;
        String[] ss = name.split("/");
        if (ss.length > 1) {
            String dirName = this.samInfoDirectory.getPath();
            for (int i = 0; i < ss.length - 1; ++i) {
                dirName = dirName + this.fileSeparator + ss[i];
            }
            dir = new File(dirName);
            if (!dir.exists()) {
                this.myLogger.log(Logger.INFO, "Creating directory " + dir + " ...");
                boolean success = dir.mkdirs();
                if (!success) {
                    throw new IOException("Cannot create directory " + dirName + ".");
                }
            }
            name = ss[ss.length - 1];
        }
        String fileName = dir.getPath() + this.fileSeparator + SAM_PREFIX + name + ".csv";
        File file = new File(fileName);
        file.createNewFile();
        return file;
    }

    private class CounterInfo {
        PrintStream stream;
        long totValue = 0L;

        CounterInfo(PrintStream ps) {
            this.stream = ps;
        }
    }
}

