/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainerImpl;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.NotFoundException;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.VerticalCommand;
import jade.core.replication.MainReplicationSlice;
import jade.domain.AMSEventQueueFeeder;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.mtp.MTPDescriptor;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.InputQueue;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class MainReplicationService
extends BaseService {
    public static final String NAME = "jade.core.replication.MainReplication";
    public static final String SNAPSHOT_ON_FAILURE = "jade_core_replication_MainReplicationService_snapshotonfailure";
    public static final int REMOVE_NODE = 0;
    public static final int WAIT = 1;
    public static final int SUICIDE = 2;
    private static final boolean EXCLUDE_MYSELF = false;
    private static final boolean INCLUDE_MYSELF = true;
    private static final String[] OWNED_COMMANDS = new String[]{"Leadership-Acquired"};
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private Filter outFilter;
    private Filter inFilter;
    private int myLabel = -1;
    private final List replicas = new LinkedList();
    private boolean snapshotOnFailure = false;
    private MainContainerImpl myMain;
    private PlatformManagerImpl myPlatformManager;
    private Map cachedServiceMethods = new HashMap();

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.localSlice = new ServiceComponent();
        this.outFilter = new CommandOutgoingFilter();
        this.inFilter = new CommandIncomingFilter();
        this.snapshotOnFailure = p.getBooleanProperty(SNAPSHOT_ON_FAILURE, false);
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.replication.MainReplicationSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.outFilter;
        }
        return this.inFilter;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile p) throws ServiceException {
        try {
            int i;
            Service.Slice[] slices = this.getAllSlices();
            this.myLabel = slices.length - 1;
            MainReplicationSlice[] temp = new MainReplicationSlice[slices.length];
            NodeDescriptor dsc = this.myContainer.getNodeDescriptor();
            Vector localServices = this.myContainer.getServiceManager().getLocalServices();
            String localNodeName = this.getLocalNode().getName();
            for (i = 0; i < slices.length; ++i) {
                try {
                    MainReplicationSlice slice = (MainReplicationSlice)slices[i];
                    String sliceName = slice.getNode().getName();
                    int label = slice.getLabel();
                    temp[label] = slice;
                    if (!sliceName.equals(localNodeName)) {
                        slice.addReplica(localNodeName, this.myPlatformManager.getLocalAddress(), this.myLabel, dsc, localServices);
                    }
                    if (label != this.myLabel - 1) continue;
                    this.localSlice.attachTo(label, slice);
                    continue;
                }
                catch (IMTPException imtpe) {
                    // empty catch block
                }
            }
            for (i = 0; i < temp.length; ++i) {
                this.replicas.add(temp[i]);
            }
            if (this.myLabel > 0) {
                this.myLogger.log(Logger.INFO, "Main container ring re-arranged: label = " + this.myLabel + " monitored label = " + this.localSlice.monitoredLabel);
            }
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("An error occurred during service startup.", imtpe);
        }
    }

    public void shutdown() {
        if (this.localSlice != null) {
            this.localSlice.stopMonitoring();
        }
    }

    protected int checkConnectivity(Node unreachableNode) {
        return 0;
    }

    void broadcastToReplicas(HorizontalCommand cmd, boolean includeSelf) throws IMTPException, ServiceException {
        Object[] slices = this.replicas.toArray();
        String localNodeName = this.getLocalNode().getName();
        for (int i = 0; i < slices.length; ++i) {
            MainReplicationSlice slice = (MainReplicationSlice)slices[i];
            String sliceName = slice.getNode().getName();
            if (!includeSelf && sliceName.equals(localNodeName)) continue;
            slice.serve(cmd);
            Object ret = cmd.getReturnValue();
            if (!(ret instanceof Throwable)) continue;
            this.myLogger.log(Logger.SEVERE, "Error propagating H-command " + cmd.getName() + " to slice " + sliceName, (Throwable)ret);
        }
    }

    public String dump(String key) {
        StringBuffer sb = new StringBuffer();
        sb.append("- Replicas:\n");
        try {
            Object[] slices = this.replicas.toArray();
            String localNodeName = this.getLocalNode().getName();
            for (int i = 0; i < slices.length; ++i) {
                MainReplicationSlice slice = (MainReplicationSlice)slices[i];
                String sliceName = slice.getNode().getName();
                if (sliceName.equals(localNodeName)) continue;
                sb.append("  - " + sliceName + "\n");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            sb.append(e2.toString());
        }
        sb.append("- Label = " + this.myLabel + "\n");
        sb.append("- Monitored Label = ").append(this.localSlice.monitoredLabel).append("\n");
        sb.append("- Monitored PlatformManager replica = ").append(this.localSlice.monitoredSvcMgr).append("\n");
        String monitoredNodeStr = "UNKNOWN(Monitor null)";
        if (this.localSlice.nodeMonitor != null) {
            Node n = this.localSlice.nodeMonitor.getNode();
            monitoredNodeStr = n != null ? n.getName() : "null";
        }
        sb.append("- Monitored Node = ").append(monitoredNodeStr).append("\n");
        sb.append(super.dump(key));
        return sb.toString();
    }

    private class ServiceComponent
    implements Service.Slice,
    NodeEventListener {
        NodeFailureMonitor nodeMonitor;
        int monitoredLabel;
        String monitoredSvcMgr;
        private Node toBeMonitored;
        private boolean monitoredNodeUnreachable = false;

        public ServiceComponent() {
            MainReplicationService.this.myMain = (MainContainerImpl)MainReplicationService.this.myContainer.getMain();
            MainReplicationService.this.myPlatformManager = (PlatformManagerImpl)MainReplicationService.this.myMain.getPlatformManager();
        }

        public void stopMonitoring() {
            if (this.nodeMonitor != null) {
                if (MainReplicationService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    MainReplicationService.this.myLogger.log(Logger.CONFIG, "Stop monitoring node <" + this.nodeMonitor.getNode().getName() + ">");
                }
                this.nodeMonitor.stop();
            }
        }

        private void attachTo(int label, MainReplicationSlice slice) throws IMTPException, ServiceException {
            this.stopMonitoring();
            this.monitoredLabel = label;
            if (this.monitoredLabel == MainReplicationService.this.myLabel) {
                return;
            }
            this.monitoredSvcMgr = slice.getPlatformManagerAddress();
            this.nodeMonitor = NodeFailureMonitor.getFailureMonitor();
            this.nodeMonitor.start(slice.getNode(), this);
        }

        public Service getService() {
            return MainReplicationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return MainReplicationService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    Integer i = new Integer(this.getLabel());
                    cmd.setReturnValue(i);
                } else if (cmdName.equals("14")) {
                    String serviceName = (String)params[0];
                    String methodName = (String)params[1];
                    Object[] methodParams = (Object[])params[2];
                    this.invokeServiceMethod(serviceName, methodName, methodParams);
                } else if (cmdName.equals("2")) {
                    cmd.setReturnValue(this.getPlatformManagerAddress());
                } else if (cmdName.equals("3")) {
                    String sliceName = (String)params[0];
                    String smAddr = (String)params[1];
                    int sliceIndex = (Integer)params[2];
                    NodeDescriptor dsc = (NodeDescriptor)params[3];
                    Vector services = (Vector)params[4];
                    this.addReplica(sliceName, smAddr, sliceIndex, dsc, services);
                } else if (cmdName.equals("4")) {
                    String smAddr = (String)params[0];
                    int sliceIndex = (Integer)params[1];
                    this.removeReplica(smAddr, sliceIndex);
                } else if (cmdName.equals("5")) {
                    AID[] agents = (AID[])params[0];
                    ContainerID[] containers = (ContainerID[])params[1];
                    this.fillGADT(agents, containers);
                } else if (cmdName.equals("6")) {
                    AID name = (AID)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    this.bornAgent(name, cid, cmd.getPrincipal(), cmd.getCredentials());
                } else if (cmdName.equals("7")) {
                    AID name = (AID)params[0];
                    this.deadAgent(name);
                } else if (cmdName.equals("8")) {
                    AID name = (AID)params[0];
                    this.suspendedAgent(name);
                } else if (cmdName.equals("9")) {
                    AID name = (AID)params[0];
                    this.resumedAgent(name);
                } else if (cmdName.equals("10")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    this.newMTP(mtp, cid);
                } else if (cmdName.equals("11")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    this.deadMTP(mtp, cid);
                } else if (cmdName.equals("12")) {
                    AID tool = (AID)params[0];
                    this.newTool(tool);
                } else if (cmdName.equals("13")) {
                    AID tool = (AID)params[0];
                    this.deadTool(tool);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }

        private int getLabel() throws IMTPException {
            return MainReplicationService.this.myLabel;
        }

        private void invokeServiceMethod(String serviceName, String methodName, Object[] args) throws Throwable {
            Service svc = MainReplicationService.this.myContainer.getServiceFinder().findService(serviceName);
            Method m = this.getMethod(svc, methodName);
            try {
                MainReplicationService.this.myLogger.log(Logger.INFO, "Invoking replicated method " + methodName + " on service " + serviceName);
                m.invoke((Object)svc, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        private Method getMethod(Service svc, String methodName) throws Exception {
            String key = svc.getName() + '#' + methodName;
            Method m = (Method)MainReplicationService.this.cachedServiceMethods.get(key);
            if (m == null) {
                Method[] mm = svc.getClass().getMethods();
                for (int i = 0; i < mm.length; ++i) {
                    if (!mm[i].getName().equals(methodName)) continue;
                    m = mm[i];
                    MainReplicationService.this.cachedServiceMethods.put(key, m);
                    break;
                }
            }
            if (m == null) {
                throw new NoSuchMethodException("Method " + methodName + " not found is service " + svc.getName());
            }
            return m;
        }

        private String getPlatformManagerAddress() throws IMTPException {
            return MainReplicationService.this.myPlatformManager.getLocalAddress();
        }

        private void addReplica(String sliceName, String smAddr, int sliceIndex, NodeDescriptor dsc, Vector services) throws IMTPException, ServiceException {
            MainReplicationSlice slice = (MainReplicationSlice)MainReplicationService.this.getFreshSlice(sliceName);
            MainReplicationService.this.replicas.add(sliceIndex, slice);
            if (MainReplicationService.this.myLabel == 0) {
                this.attachTo(sliceIndex, slice);
                AID[] names = MainReplicationService.this.myMain.agentNames();
                ContainerID[] containers = new ContainerID[names.length];
                for (int i = 0; i < names.length; ++i) {
                    try {
                        containers[i] = MainReplicationService.this.myMain.getContainerID(names[i]);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        nfe.printStackTrace();
                    }
                }
                slice.fillGADT(names, containers);
                AMSAgentDescription amsd = new AMSAgentDescription();
                amsd.setState("suspended");
                List suspendedAgents = MainReplicationService.this.myMain.amsSearch(amsd, -1L);
                Iterator it = suspendedAgents.iterator();
                while (it.hasNext()) {
                    AMSAgentDescription desc = (AMSAgentDescription)it.next();
                    try {
                        slice.suspendedAgent(desc.getName());
                    }
                    catch (NotFoundException nfe) {
                        nfe.printStackTrace();
                    }
                }
                AID[] tools = MainReplicationService.this.myMain.agentTools();
                for (int i = 0; i < tools.length; ++i) {
                    slice.newTool(tools[i]);
                }
                try {
                    MainReplicationService.this.myPlatformManager.addMainContainerNode(dsc, services);
                }
                catch (JADESecurityException jse) {
                    MainReplicationService.this.myLogger.log(Logger.WARNING, "Unauthorized Main Container node " + dsc.getNode().getName(), jse);
                }
            }
            MainReplicationService.this.myLogger.log(Logger.INFO, "Main container ring re-arranged: label = " + MainReplicationService.this.myLabel + " monitored label = " + this.monitoredLabel);
        }

        private void removeReplica(String smAddr, int index) throws IMTPException {
            MainReplicationService.this.replicas.remove(index);
            this.adjustLabels(index);
        }

        private void adjustLabels(int index) {
            if (index < MainReplicationService.this.myLabel) {
                MainReplicationService.this.myLabel--;
                --this.monitoredLabel;
                if (this.monitoredLabel == -1) {
                    this.monitoredLabel += MainReplicationService.this.replicas.size();
                }
            } else if (MainReplicationService.this.myLabel == 0) {
                --this.monitoredLabel;
            }
            MainReplicationService.this.myLogger.log(Logger.INFO, "Main container ring re-arranged: label = " + MainReplicationService.this.myLabel + " monitored label = " + this.monitoredLabel);
        }

        private void fillGADT(AID[] agents, ContainerID[] containers) throws JADESecurityException {
            for (int i = 0; i < agents.length; ++i) {
                try {
                    MainReplicationService.this.myMain.bornAgent(agents[i], containers[i], null, null, true);
                    if (!MainReplicationService.this.myLogger.isLoggable(Logger.CONFIG)) continue;
                    MainReplicationService.this.myLogger.log(Logger.CONFIG, "Agent " + agents[i].getName() + " inserted into GADT");
                    continue;
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                    continue;
                }
                catch (NameClashException nce) {
                    nce.printStackTrace();
                }
            }
        }

        private void bornAgent(AID name, ContainerID cid, JADEPrincipal principal, Credentials credentials) throws NameClashException, NotFoundException {
            block7: {
                JADEPrincipal ownerPr;
                String ownership = "NONE";
                if (credentials != null && (ownerPr = credentials.getOwner()) != null) {
                    ownership = ownerPr.getName();
                }
                try {
                    MainReplicationService.this.myMain.bornAgent(name, cid, principal, ownership, false);
                    if (MainReplicationService.this.myLogger.isLoggable(Logger.CONFIG)) {
                        MainReplicationService.this.myLogger.log(Logger.CONFIG, "Agent " + name.getName() + " inserted into GADT");
                    }
                }
                catch (NameClashException nce) {
                    try {
                        ContainerID oldCid = MainReplicationService.this.myMain.getContainerID(name);
                        Node n = MainReplicationService.this.myMain.getContainerNode(oldCid).getNode();
                        n.ping(false);
                        throw nce;
                    }
                    catch (NameClashException nce2) {
                        throw nce2;
                    }
                    catch (Exception e2) {
                        MainReplicationService.this.myMain.bornAgent(name, cid, principal, ownership, true);
                        if (!MainReplicationService.this.myLogger.isLoggable(Logger.CONFIG)) break block7;
                        MainReplicationService.this.myLogger.log(Logger.CONFIG, "Agent " + name.getName() + " inserted into GADT");
                    }
                }
            }
        }

        private void deadAgent(AID name) throws NotFoundException {
            MainReplicationService.this.myMain.deadAgent(name, false);
        }

        private void suspendedAgent(AID name) throws NotFoundException {
            MainReplicationService.this.myMain.suspendedAgent(name);
        }

        private void resumedAgent(AID name) throws NotFoundException {
            MainReplicationService.this.myMain.resumedAgent(name);
        }

        private void newMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException {
            MainReplicationService.this.myMain.newMTP(mtp, cid);
        }

        private void deadMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException {
            MainReplicationService.this.myMain.deadMTP(mtp, cid);
        }

        private void newTool(AID tool) throws IMTPException {
            MainReplicationService.this.myMain.toolAdded(tool);
        }

        private void deadTool(AID tool) throws IMTPException {
            MainReplicationService.this.myMain.toolRemoved(tool);
        }

        public void dumpReplicas() {
            try {
                System.out.println("--- " + MainReplicationService.this.getLocalNode().getName() + "[" + MainReplicationService.this.myLabel + "] ---");
                System.out.println("--- Monitoring node [" + this.monitoredLabel + "] ---");
                System.out.println("--- Replica list ---");
                Object[] slices = MainReplicationService.this.replicas.toArray();
                for (int i = 0; i < slices.length; ++i) {
                    MainReplicationSlice slice = (MainReplicationSlice)slices[i];
                    System.out.println("----- " + slice.getNode().getName() + "[" + i + "] -----");
                }
                System.out.println("--- End ---");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void dumpGADT() {
            AID[] agents = MainReplicationService.this.myMain.agentNames();
            System.out.println("--- Agent List ---");
            for (int i = 0; i < agents.length; ++i) {
                System.out.println("    Agent: " + agents[i].getLocalName());
            }
            System.out.println("------------------");
        }

        public void nodeAdded(Node n) {
            MainReplicationService.this.myLogger.log(Logger.INFO, "Start monitoring main node <" + n.getName() + ">");
            this.monitoredNodeUnreachable = false;
        }

        public void nodeRemoved(Node n) {
            int action = 0;
            if (this.monitoredNodeUnreachable) {
                action = MainReplicationService.this.checkConnectivity(n);
            }
            switch (action) {
                case 0: {
                    this.removeTerminatedNode(n);
                    break;
                }
                case 1: {
                    MainReplicationService.this.myLogger.log(Logger.WARNING, "Network problems are preventing the monitoring of main node <" + n.getName() + ">. Stop monitor it");
                    this.toBeMonitored = n;
                    break;
                }
                case 2: {
                    this.suicide();
                }
            }
        }

        public void nodeUnreachable(Node n) {
            MainReplicationService.this.myLogger.log(Logger.WARNING, "Main node <" + n.getName() + "> UNREACHABLE");
            this.monitoredNodeUnreachable = true;
        }

        public void nodeReachable(Node n) {
            MainReplicationService.this.myLogger.log(Logger.INFO, "Main Node <" + n.getName() + "> REACHABLE");
            this.monitoredNodeUnreachable = false;
        }

        private void removeTerminatedNode(Node n) {
            MainReplicationService.this.myLogger.log(Logger.INFO, "Main node <" + n.getName() + "> TERMINATED");
            try {
                MainReplicationService.this.replicas.remove(this.monitoredLabel);
                AMSEventQueueFeeder feeder = null;
                if (!MainReplicationService.this.snapshotOnFailure) {
                    feeder = new AMSEventQueueFeeder(new InputQueue(), MainReplicationService.this.myContainer.getID());
                    MainReplicationService.this.myMain.addListener(feeder);
                }
                MainReplicationService.this.myPlatformManager.removeReplica(this.monitoredSvcMgr, false);
                MainReplicationService.this.myPlatformManager.removeNode(new NodeDescriptor(n), false);
                GenericCommand hCmd = new GenericCommand("4", MainReplicationService.NAME, null);
                hCmd.addParam(this.monitoredSvcMgr);
                hCmd.addParam(new Integer(this.monitoredLabel));
                MainReplicationService.this.broadcastToReplicas(hCmd, false);
                int oldLabel = MainReplicationService.this.myLabel;
                this.adjustLabels(this.monitoredLabel);
                MainReplicationSlice newSlice = (MainReplicationSlice)MainReplicationService.this.replicas.get(this.monitoredLabel);
                this.attachTo(this.monitoredLabel, newSlice);
                if (oldLabel != 0 && MainReplicationService.this.myLabel == 0) {
                    MainReplicationService.this.myLogger.log(Logger.INFO, "-- I'm the new leader ---");
                    MainReplicationService.this.myContainer.becomeLeader(feeder);
                    GenericCommand cmd = new GenericCommand("Leadership-Acquired", MainReplicationService.NAME, null);
                    MainReplicationService.this.submit(cmd);
                } else if (feeder != null) {
                    MainReplicationService.this.myMain.removeListener(feeder);
                }
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }

        private void suicide() {
            MainReplicationService.this.myLogger.log(Logger.WARNING, "Due to network problems I'm isolated --> The rest of the platform will consider me dead. Suicide now!!!!!!!!");
            System.exit(0);
        }

        private void handleOrphanNode(String nodeId) {
            if (this.toBeMonitored != null && this.toBeMonitored.getName().equals(nodeId)) {
                MainReplicationService.this.myLogger.log(Logger.INFO, "Ping received from node " + nodeId + " --> The network is working again. Re-start monitoring node");
                this.nodeMonitor = NodeFailureMonitor.getFailureMonitor();
                this.nodeMonitor.start(this.toBeMonitored, this);
                this.toBeMonitored = null;
            }
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        public void postProcess(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                } else if (name.equals("Inform-Killed")) {
                    this.handleInformKilled(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("New-MTP")) {
                    this.handleNewMTP(cmd);
                } else if (name.equals("Dead-MTP")) {
                    this.handleDeadMTP(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleInformCreated(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object ret = cmd.getReturnValue();
            if (ret == null || !(ret instanceof NameClashException)) {
                Object[] params = cmd.getParams();
                AID agentID = (AID)params[0];
                ContainerID cid = (ContainerID)params[1];
                GenericCommand hCmd = new GenericCommand("6", MainReplicationService.NAME, null);
                hCmd.addParam(agentID);
                hCmd.addParam(cid);
                hCmd.setPrincipal(cmd.getPrincipal());
                hCmd.setCredentials(cmd.getCredentials());
                MainReplicationService.this.broadcastToReplicas(hCmd, false);
            }
        }

        private void handleInformKilled(VerticalCommand cmd) throws IMTPException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            GenericCommand hCmd = new GenericCommand("7", MainReplicationService.NAME, null);
            hCmd.addParam(agentID);
            MainReplicationService.this.broadcastToReplicas(hCmd, false);
        }

        private void handleInformStateChanged(VerticalCommand cmd) throws IMTPException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            String newState = (String)params[1];
            if (newState.equals("suspended")) {
                GenericCommand hCmd = new GenericCommand("8", MainReplicationService.NAME, null);
                hCmd.addParam(agentID);
                MainReplicationService.this.broadcastToReplicas(hCmd, false);
            } else if (newState.equals("active")) {
                GenericCommand hCmd = new GenericCommand("9", MainReplicationService.NAME, null);
                hCmd.addParam(agentID);
                MainReplicationService.this.broadcastToReplicas(hCmd, false);
            }
        }

        private void handleNewMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            GenericCommand hCmd = new GenericCommand("10", MainReplicationService.NAME, null);
            hCmd.addParam(mtp);
            hCmd.addParam(cid);
            MainReplicationService.this.broadcastToReplicas(hCmd, false);
        }

        private void handleDeadMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            GenericCommand hCmd = new GenericCommand("11", MainReplicationService.NAME, null);
            hCmd.addParam(mtp);
            hCmd.addParam(cid);
            MainReplicationService.this.broadcastToReplicas(hCmd, false);
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Add-Tool")) {
                    this.handleNewTool(cmd);
                } else if (name.equals("Remove-Tool")) {
                    this.handleDeadTool(cmd);
                } else if (name.equals("Orphan-Node")) {
                    this.handleOrphanNode(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            return true;
        }

        private void handleNewTool(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            AID tool = (AID)params[0];
            GenericCommand hCmd = new GenericCommand("12", MainReplicationService.NAME, null);
            hCmd.addParam(tool);
            MainReplicationService.this.broadcastToReplicas(hCmd, false);
        }

        private void handleDeadTool(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            AID tool = (AID)params[0];
            GenericCommand hCmd = new GenericCommand("13", MainReplicationService.NAME, null);
            hCmd.addParam(tool);
            MainReplicationService.this.broadcastToReplicas(hCmd, false);
        }

        private void handleOrphanNode(VerticalCommand cmd) throws IMTPException, ServiceException {
            String nodeId = (String)cmd.getParam(0);
            MainReplicationService.this.localSlice.handleOrphanNode(nodeId);
        }
    }
}

