/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.VerticalCommand;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.core.replication.AgentReplicationHandle;
import jade.core.replication.AgentReplicationHelper;
import jade.core.replication.AgentReplicationSlice;
import jade.core.replication.GlobalReplicationInfo;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class AgentReplicationService
extends BaseService {
    public static final String NAME = "jade.core.replication.AgentReplication";
    private AgentContainer myContainer;
    private MessagingService theMessagingService;
    private Filter outFilter;
    private Filter incFilter;
    private ServiceComponent localSlice;
    private Map<AID, GlobalReplicationInfo> globalReplications = new Hashtable<AID, GlobalReplicationInfo>();
    private Map<AID, AID> replicaToVirtualMap = new Hashtable<AID, AID>();
    private Map<AID, List<ReplicaInfo>> pendingReplicaCreationRequests = new Hashtable<AID, List<ReplicaInfo>>();
    private Map<String, Method> cachedAgentMethods = new HashMap<String, Method>();

    public String getName() {
        return NAME;
    }

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.outFilter = new CommandOutgoingFilter();
        this.incFilter = new CommandIncomingFilter();
        this.localSlice = new ServiceComponent();
    }

    public void boot(Profile p) throws ServiceException {
        super.boot(p);
        try {
            this.theMessagingService = (MessagingService)this.myContainer.getServiceFinder().findService("jade.core.messaging.Messaging");
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("Cannot retrieve the local MessagingService.", imtpe);
        }
        try {
            if (this.myContainer.getServiceFinder().findService("jade.core.mobility.AgentMobility") == null) {
                throw new ServiceException("AgentMobilityService not installed. AgentReplicationService cannot work properly");
            }
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("Cannot retrieve the local MessagingService.", imtpe);
        }
    }

    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return new AgentReplicationHelperImpl();
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.outFilter;
        }
        return this.incFilter;
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.replication.AgentReplicationSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    private void localNotifyReplicaAddedToMaster(AID masterAid, ReplicaInfo r) {
        Agent agent = this.myContainer.acquireLocalAgent(masterAid);
        if (agent != null) {
            this.myContainer.releaseLocalAgent(masterAid);
            try {
                if (agent instanceof AgentReplicationHelper.Listener) {
                    ((AgentReplicationHelper.Listener)((Object)agent)).replicaAdded(r.replicaAid, r.where);
                }
            }
            catch (Exception e2) {
                this.myLogger.log(Logger.WARNING, "Unexpected exception notifying master agent (replicaAdded())", e2);
            }
        }
    }

    private void notifyReplicaRemovedToMaster(AID masterAid, AID removedReplica, Location where) {
        try {
            if (where == null) {
                try {
                    where = this.getAgentLocation(removedReplica);
                }
                catch (NotFoundException nfe) {
                    // empty catch block
                }
            }
            ContainerID masterLocation = this.getAgentLocation(masterAid);
            AgentReplicationSlice slice = (AgentReplicationSlice)this.getFreshSlice(masterLocation.getName());
            slice.notifyReplicaRemoved(masterAid, removedReplica, where);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error notifying master replica " + masterAid.getLocalName() + " that replica " + removedReplica.getLocalName() + " has been removed", e2);
        }
    }

    private void localNotifyReplicaRemovedToMaster(AID masterAid, AID removedReplica, Location where) {
        Agent agent = this.myContainer.acquireLocalAgent(masterAid);
        if (agent != null) {
            this.myContainer.releaseLocalAgent(masterAid);
            try {
                if (agent instanceof AgentReplicationHelper.Listener) {
                    ((AgentReplicationHelper.Listener)((Object)agent)).replicaRemoved(removedReplica, where);
                }
            }
            catch (Exception e2) {
                this.myLogger.log(Logger.WARNING, "Unexpected exception notifying master agent (becomeMaster())", e2);
            }
        }
    }

    private void notifyBecomeMasterToMaster(AID masterAid) {
        try {
            ContainerID masterLocation = this.getAgentLocation(masterAid);
            AgentReplicationSlice slice = (AgentReplicationSlice)this.getFreshSlice(masterLocation.getName());
            slice.notifyBecomeMaster(masterAid);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error notifying new master replica " + masterAid.getLocalName() + " it just took the leadership", e2);
        }
    }

    private void localNotifyBecomeMasterToMaster(AID masterAid) {
        Agent agent = this.myContainer.acquireLocalAgent(masterAid);
        if (agent != null) {
            this.myContainer.releaseLocalAgent(masterAid);
            try {
                if (agent instanceof AgentReplicationHelper.Listener) {
                    ((AgentReplicationHelper.Listener)((Object)agent)).becomeMaster();
                }
            }
            catch (Exception e2) {
                this.myLogger.log(Logger.WARNING, "Unexpected exception notifying master agent (becomeMaster())", e2);
            }
        }
    }

    private Location getLocation(AID aid) throws Exception {
        if (this.myContainer.isLocalAgent(aid)) {
            return this.myContainer.getID();
        }
        AgentReplicationSlice mainSlice = (AgentReplicationSlice)this.getSlice("$$$Main-Slice$$$");
        try {
            return mainSlice.getAgentLocation(aid);
        }
        catch (IMTPException imtpe) {
            mainSlice = (AgentReplicationSlice)this.getFreshSlice("$$$Main-Slice$$$");
            return mainSlice.getAgentLocation(aid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AID getVirtualAid(AID aid) {
        Agent agent = this.myContainer.acquireLocalAgent(aid);
        if (agent != null) {
            try {
                AgentReplicationHelper helper = (AgentReplicationHelper)agent.getHelper(NAME);
                AID aID = helper.getVirtualAid();
                return aID;
            }
            catch (ServiceException se) {
                this.myLogger.log(Logger.WARNING, "Unexpected error retrieving AgentReplicationHelper for agent " + aid.getName());
                AID aID = null;
                return aID;
            }
            finally {
                this.myContainer.releaseLocalAgent(aid);
            }
        }
        return null;
    }

    private void broadcastNewVirtualAgent(AID virtualAid, AID masterAid, int replicationMode) {
        this.myLogger.log(Logger.CONFIG, "Broadcasting new virtual agent " + virtualAid.getLocalName());
        GenericCommand cmd = new GenericCommand("NE", NAME, null);
        cmd.addParam(virtualAid);
        cmd.addParam(masterAid);
        cmd.addParam(replicationMode);
        try {
            this.broadcast(cmd, true);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.SEVERE, "Error broadcasting new virtual agent " + virtualAid.getLocalName(), e2);
        }
    }

    private void broadcastAddReplica(AID masterAid, ReplicaInfo r) {
        AID virtualAid = this.getVirtualAid(masterAid);
        if (virtualAid != null) {
            this.myLogger.log(Logger.CONFIG, "Broadcasting new replica " + r.replicaAid.getLocalName() + " of virtual agent " + virtualAid.getLocalName());
            GenericCommand cmd = new GenericCommand("A", NAME, null);
            cmd.addParam(virtualAid);
            cmd.addParam(r.replicaAid);
            cmd.addParam(r.where);
            try {
                this.broadcast(cmd, true);
            }
            catch (Exception e2) {
                this.myLogger.log(Logger.SEVERE, "Error broadcasting new replica " + r.replicaAid.getLocalName() + " of virtual agent " + virtualAid.getLocalName(), e2);
            }
        } else {
            this.myLogger.log(Logger.WARNING, "Cannot find virtual agent for master replica " + masterAid.getLocalName());
        }
    }

    private void broadcastMasterReplicaChanged(AID virtualAid, AID newMasterAid) {
        this.myLogger.log(Logger.CONFIG, "Broadcasting master replica changed for virtual agent " + virtualAid.getLocalName() + ". New master replica = " + newMasterAid.getLocalName());
        GenericCommand cmd = new GenericCommand("M", NAME, null);
        cmd.addParam(virtualAid);
        cmd.addParam(newMasterAid);
        try {
            this.broadcast(cmd, false);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error broadcasting master replica changed for virtual agent " + virtualAid.getLocalName(), e2);
        }
    }

    private void broadcastVirtualAgentDead(AID virtualAid) {
        this.myLogger.log(Logger.CONFIG, "Broadcasting virtual agent " + virtualAid.getLocalName() + " dead");
        GenericCommand cmd = new GenericCommand("V", NAME, null);
        cmd.addParam(virtualAid);
        try {
            this.broadcast(cmd, true);
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error broadcasting master replica changed for virtual agent " + virtualAid.getLocalName(), e2);
        }
    }

    private void cloneReplica(AID aid, String replicaName, Location where) {
        Agent agent = this.myContainer.acquireLocalAgent(aid);
        if (agent != null) {
            this.myLogger.log(Logger.CONFIG, "Cloning agent " + aid.getLocalName() + " to create replica " + replicaName + " on container " + where.getName());
            agent.doClone(where, replicaName);
            this.myContainer.releaseLocalAgent(aid);
        }
    }

    private void asynchCloneReplica(AID aid, final String replicaName, final Location where) {
        Agent agent = this.myContainer.acquireLocalAgent(aid);
        if (agent != null) {
            agent.addBehaviour(new OneShotBehaviour(agent){

                public void action() {
                    AgentReplicationService.this.myLogger.log(Logger.CONFIG, "Cloning agent " + this.myAgent.getLocalName() + " to create replica " + replicaName + " on container " + where.getName());
                    this.myAgent.doClone(where, replicaName);
                }
            });
            this.myContainer.releaseLocalAgent(aid);
        }
    }

    private final void sendMessage(AID sender, GenericMessage gMsg, AID receiver) {
        GenericCommand cmd = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
        cmd.addParam(sender);
        cmd.addParam(gMsg);
        cmd.addParam(receiver);
        try {
            this.theMessagingService.submit(cmd);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    private void invokeAgentMethod(AID aid, String methodName, Object[] arguments) throws NotFoundException, ServiceException {
        Agent agent = this.myContainer.acquireLocalAgent(aid);
        if (agent != null) {
            this.myContainer.releaseLocalAgent(aid);
            try {
                Method m = this.getMethod(agent, methodName);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Invoking replicated method " + methodName + " on agent " + aid.getLocalName());
                }
                AgentReplicationHandle.enterReplicatedCall();
                m.invoke((Object)agent, arguments);
            }
            catch (NoSuchMethodException nsme) {
                throw new ServiceException("Method " + methodName + " not found in class " + agent.getClass().getName() + " of agent " + agent.getLocalName());
            }
            catch (IllegalAccessException iae) {
                throw new ServiceException("Method " + methodName + " of class " + agent.getClass().getName() + " of agent " + agent.getLocalName() + " cannot be accessed");
            }
            catch (InvocationTargetException ite) {
                throw new ServiceException("Exception excecuting method " + methodName + " of agent " + aid.getLocalName(), ite.getCause());
            }
            finally {
                AgentReplicationHandle.exitReplicatedCall();
            }
        } else {
            throw new NotFoundException("Agent " + aid.getLocalName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplica(AID virtualAid, AID replicaAid, Location where) throws Exception {
        this.myLogger.log(Logger.CONFIG, "Received new replica information: virtual=" + virtualAid.getLocalName() + ", replica=" + replicaAid.getLocalName() + ", location=" + where.getName());
        this.addReplicaVirtualMapping(replicaAid, virtualAid);
        GlobalReplicationInfo info = this.globalReplications.get(virtualAid);
        if (info != null) {
            AID[] currentReplicas = info.getAllReplicas();
            for (int i = 0; i < currentReplicas.length; ++i) {
                AID aid = currentReplicas[i];
                Agent agent = this.myContainer.acquireLocalAgent(aid);
                if (agent == null) continue;
                try {
                    AgentReplicationHelperImpl helper = (AgentReplicationHelperImpl)agent.getHelper(NAME);
                    helper.addPeerReplica(new ReplicaInfo(replicaAid, where));
                    continue;
                }
                catch (ServiceException se) {
                    this.myLogger.log(Logger.WARNING, "Unexpected error retrieving AgentReplicationHelper for agent " + aid.getName(), se);
                    continue;
                }
                finally {
                    this.myContainer.releaseLocalAgent(aid);
                }
            }
            info.addReplica(replicaAid);
        } else {
            this.myLogger.log(Logger.WARNING, "Global Replication information for virtual agent " + virtualAid.getLocalName() + " not found in container " + this.myContainer.getID().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReplica(AID virtualAid, AID replicaAid) {
        this.removeReplicaVirtualMapping(replicaAid);
        GlobalReplicationInfo info = this.globalReplications.get(virtualAid);
        if (info != null) {
            info.removeReplica(replicaAid);
            AID[] currentReplicas = info.getAllReplicas();
            for (int i = 0; i < currentReplicas.length; ++i) {
                AID aid = currentReplicas[i];
                Agent agent = this.myContainer.acquireLocalAgent(aid);
                if (agent == null) continue;
                try {
                    AgentReplicationHelperImpl helper = (AgentReplicationHelperImpl)agent.getHelper(NAME);
                    helper.removePeerReplica(new ReplicaInfo(replicaAid, null));
                    continue;
                }
                catch (ServiceException se) {
                    this.myLogger.log(Logger.WARNING, "Unexpected error retrieving AgentReplicationHelper for agent " + aid.getLocalName(), se);
                    continue;
                }
                finally {
                    this.myContainer.releaseLocalAgent(aid);
                }
            }
        }
    }

    private void addReplicaVirtualMapping(AID replicaAid, AID virtualAid) {
        AID oldVirtualAid = this.replicaToVirtualMap.put(replicaAid, virtualAid);
        if (oldVirtualAid == null || !oldVirtualAid.equals(virtualAid)) {
            this.myLogger.log(Logger.CONFIG, "Added replica-to-virtual mapping: " + replicaAid.getLocalName() + "-->" + virtualAid.getLocalName());
        }
    }

    private void removeReplicaVirtualMapping(AID replicaAid) {
        AID virtualAid = this.replicaToVirtualMap.remove(replicaAid);
        if (virtualAid != null) {
            this.myLogger.log(Logger.CONFIG, "Removed replica-to-virtual mapping: " + replicaAid.getLocalName() + "-->" + virtualAid.getLocalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalReplicationInfo newVirtualAgent(AID virtualAid, AID masterAid, int replicationMode) throws Exception {
        GlobalReplicationInfo info = null;
        Map<AID, GlobalReplicationInfo> map = this.globalReplications;
        synchronized (map) {
            info = this.globalReplications.get(virtualAid);
            if (info == null) {
                this.myLogger.log(Logger.CONFIG, "New virtual agent: virtual=" + virtualAid.getLocalName() + ", master=" + masterAid.getLocalName());
                info = new GlobalReplicationInfo(virtualAid, masterAid, replicationMode);
                this.globalReplications.put(virtualAid, info);
            } else if (!masterAid.equals(info.getMaster())) {
                throw new ServiceException("Inconsistent replication information for virtual agent " + virtualAid.getLocalName() + ": current-master = " + info.getMaster().getLocalName() + ", new-master = " + masterAid.getLocalName());
            }
        }
        this.addReplicaVirtualMapping(masterAid, virtualAid);
        return info;
    }

    private ContainerID getAgentLocation(AID aid) throws NotFoundException {
        MainContainer impl = this.myContainer.getMain();
        if (impl != null) {
            return impl.getContainerID(aid);
        }
        throw new NotFoundException("getAgentLocation() invoked on a non-main container");
    }

    private void handleMasterReplicaDead(GlobalReplicationInfo info) {
        AID newMasterAid;
        MainContainer impl = this.myContainer.getMain();
        while ((newMasterAid = info.masterReplicaDead()) != null) {
            if (impl.acquireAgentDescriptor(newMasterAid) == null) continue;
            impl.releaseAgentDescriptor(newMasterAid);
            this.broadcastMasterReplicaChanged(info.getVirtual(), newMasterAid);
            this.notifyBecomeMasterToMaster(newMasterAid);
            return;
        }
        try {
            impl.deadAgent(info.getVirtual(), false);
        }
        catch (NotFoundException nfe) {
            // empty catch block
        }
        this.broadcastVirtualAgentDead(info.getVirtual());
    }

    private void checkAllReplications() {
        GlobalReplicationInfo[] gg;
        MainContainer impl = this.myContainer.getMain();
        for (GlobalReplicationInfo info : gg = this.globalReplications.values().toArray(new GlobalReplicationInfo[0])) {
            AID[] allReplicas;
            AID masterAid = info.getMaster();
            if (impl.acquireAgentDescriptor(masterAid) != null) {
                impl.releaseAgentDescriptor(masterAid);
                this.myLogger.log(Logger.INFO, "Master replica " + masterAid.getLocalName() + " of virtual agent " + info.getVirtual().getLocalName() + " ALIVE");
            } else {
                this.handleMasterReplicaDead(info);
                masterAid = info.getMaster();
            }
            for (AID replicaAid : allReplicas = info.getAllReplicas()) {
                if (replicaAid.equals(masterAid)) continue;
                if (impl.acquireAgentDescriptor(replicaAid) != null) {
                    impl.releaseAgentDescriptor(replicaAid);
                    this.myLogger.log(Logger.INFO, "Replica " + replicaAid.getLocalName() + " of virtual agent " + info.getVirtual().getLocalName() + " ALIVE");
                    continue;
                }
                this.notifyReplicaRemovedToMaster(masterAid, replicaAid, null);
            }
        }
    }

    private Method getMethod(Agent agent, String methodName) throws NoSuchMethodException {
        String key = agent.getLocalName() + '#' + methodName;
        Method m = this.cachedAgentMethods.get(key);
        if (m == null) {
            Method[] mm = agent.getClass().getMethods();
            for (int i = 0; i < mm.length; ++i) {
                if (!mm[i].getName().equals(methodName)) continue;
                m = mm[i];
                this.cachedAgentMethods.put(key, m);
                break;
            }
        }
        if (m == null) {
            throw new NoSuchMethodException(methodName);
        }
        return m;
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return AgentReplicationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AgentReplicationService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Error retrieving local node", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                if (cmdName.equals("I")) {
                    AID aid = (AID)cmd.getParam(0);
                    String methodName = (String)cmd.getParam(1);
                    Object[] arguments = (Object[])cmd.getParam(2);
                    AgentReplicationService.this.invokeAgentMethod(aid, methodName, arguments);
                } else if (cmdName.equals("A")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AID replicaAid = (AID)cmd.getParam(1);
                    Location where = (Location)cmd.getParam(2);
                    AgentReplicationService.this.addReplica(virtualAid, replicaAid, where);
                } else if (cmdName.equals("NE")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AID masterAid = (AID)cmd.getParam(1);
                    int replicationMode = (Integer)cmd.getParam(2);
                    AgentReplicationService.this.newVirtualAgent(virtualAid, masterAid, replicationMode);
                } else if (cmdName.equals("G")) {
                    AID aid = (AID)cmd.getParam(0);
                    cmd.setReturnValue(AgentReplicationService.this.getAgentLocation(aid));
                } else if (cmdName.equals("R")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AID replicaAid = (AID)cmd.getParam(1);
                    AgentReplicationService.this.addReplicaVirtualMapping(replicaAid, virtualAid);
                } else if (cmdName.equals("S")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AID masterAid = (AID)cmd.getParam(1);
                    int replicationMode = (Integer)cmd.getParam(2);
                    AID[] allReplicas = (AID[])cmd.getParam(3);
                    GlobalReplicationInfo info = AgentReplicationService.this.newVirtualAgent(virtualAid, masterAid, replicationMode);
                    for (AID replicaAid : allReplicas) {
                        if (replicaAid.equals(masterAid)) continue;
                        info.addReplica(replicaAid);
                        AgentReplicationService.this.addReplicaVirtualMapping(replicaAid, virtualAid);
                    }
                } else if (cmdName.equals("M")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AID newMasterAid = (AID)cmd.getParam(1);
                    GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(virtualAid);
                    if (info != null) {
                        info.masterReplicaChanged(newMasterAid);
                    }
                } else if (cmdName.equals("V")) {
                    AID virtualAid = (AID)cmd.getParam(0);
                    AgentReplicationService.this.globalReplications.remove(virtualAid);
                    AgentReplicationService.this.myLogger.log(Logger.CONFIG, "Virtual agent " + virtualAid.getLocalName() + " removed");
                } else if (cmdName.equals("NB")) {
                    AID newMasterAid = (AID)cmd.getParam(0);
                    AgentReplicationService.this.localNotifyBecomeMasterToMaster(newMasterAid);
                } else if (cmdName.equals("NR")) {
                    AID masterAid = (AID)cmd.getParam(0);
                    AID removedReplica = (AID)cmd.getParam(1);
                    Location where = (Location)cmd.getParam(2);
                    AgentReplicationService.this.localNotifyReplicaRemovedToMaster(masterAid, removedReplica, where);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }
    }

    private class ReplicaInfo {
        private AID replicaAid;
        private Location where;

        private ReplicaInfo(AID replicaAid, Location where) {
            this.replicaAid = replicaAid;
            this.where = where;
        }

        public int hashCode() {
            return this.replicaAid.hashCode();
        }

        public boolean equals(Object obj) {
            return this.replicaAid.equals(((ReplicaInfo)obj).replicaAid);
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        public CommandIncomingFilter() {
            this.setPreferredPosition(2);
        }

        public final boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            if (AgentReplicationService.this.myContainer.getMain() != null) {
                if (name.equals("Inform-Killed")) {
                    AID deadAgent = (AID)cmd.getParam(0);
                    this.handleInformKilled(deadAgent);
                } else if (name.equals("New-Slice")) {
                    if (cmd.getService().equals(AgentReplicationService.NAME)) {
                        String sliceName = (String)cmd.getParam(0);
                        this.handleNewSlice(sliceName);
                    }
                } else if (name.equals("Dead-Node")) {
                    AgentReplicationService.this.checkAllReplications();
                }
            } else if (name.equals("Reattached")) {
                this.handleReattached();
            }
            return true;
        }

        private void handleInformKilled(AID deadAid) {
            GlobalReplicationInfo info;
            AID virtualAid = (AID)AgentReplicationService.this.replicaToVirtualMap.remove(deadAid);
            if (virtualAid != null && (info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(virtualAid)) != null) {
                if (deadAid.equals(info.getMaster())) {
                    AgentReplicationService.this.handleMasterReplicaDead(info);
                } else {
                    AgentReplicationService.this.notifyReplicaRemovedToMaster(info.getMaster(), deadAid, null);
                }
            }
        }

        private void handleNewSlice(String newSliceName) {
            try {
                GlobalReplicationInfo[] allInfos;
                AgentReplicationSlice newSlice = (AgentReplicationSlice)AgentReplicationService.this.getFreshSlice(newSliceName);
                for (GlobalReplicationInfo info : allInfos = AgentReplicationService.this.globalReplications.values().toArray(new GlobalReplicationInfo[0])) {
                    newSlice.synchReplication(info);
                }
            }
            catch (Throwable t) {
                AgentReplicationService.this.myLogger.log(Logger.WARNING, "Error notifying new slice " + newSliceName + " about current replication information", t);
            }
        }

        private void handleReattached() {
            try {
                AgentReplicationSlice mainSlice = (AgentReplicationSlice)AgentReplicationService.this.getFreshSlice("$$$Main-Slice$$$");
                AID[] aa = AgentReplicationService.this.replicaToVirtualMap.keySet().toArray(new AID[0]);
                ArrayList<AID> vv = new ArrayList<AID>();
                for (AID aid : aa) {
                    AID virtualAid;
                    if (!AgentReplicationService.this.myContainer.isLocalAgent(aid) || (virtualAid = (AID)AgentReplicationService.this.replicaToVirtualMap.get(aid)) == null || vv.contains(virtualAid)) continue;
                    GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(virtualAid);
                    if (info != null) {
                        try {
                            mainSlice.synchReplication(info);
                        }
                        catch (Exception e2) {
                            AgentReplicationService.this.myLogger.log(Logger.WARNING, "Error notifying main slice about current local replication information", e2);
                        }
                    }
                    vv.add(virtualAid);
                }
            }
            catch (Throwable t) {
                AgentReplicationService.this.myLogger.log(Logger.WARNING, "Error retrieving main slice.", t);
            }
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        public CommandOutgoingFilter() {
            this.setPreferredPosition(2);
        }

        public final boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            if (name.equals("Send-Message")) {
                AID receiver = (AID)cmd.getParam(2);
                GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(receiver);
                if (info != null) {
                    AID replica = info.getReplica();
                    AID sender = (AID)cmd.getParam(0);
                    GenericMessage gMsg = (GenericMessage)cmd.getParam(1);
                    gMsg.setModifiable(false);
                    ACLMessage msg = gMsg.getACLMessage();
                    if (msg != null) {
                        msg.addUserDefinedParameter("JADE-virtual-receiver", receiver.getLocalName());
                    }
                    AgentReplicationService.this.sendMessage(sender, gMsg, replica);
                    return false;
                }
            } else if (name.equals("Notify-Failure")) {
                String virtualName;
                GenericMessage gMsg = (GenericMessage)cmd.getParam(0);
                ACLMessage msg = gMsg.getACLMessage();
                if (msg != null && (virtualName = msg.getUserDefinedParameter("JADE-virtual-receiver")) != null) {
                    AID virtualAid = new AID(AID.createGUID(virtualName, AgentReplicationService.this.myContainer.getPlatformID()), true);
                    AID receiver = (AID)cmd.getParam(1);
                    AgentReplicationService.this.removeReplica(virtualAid, receiver);
                    GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(virtualAid);
                    if (info != null) {
                        AID newReplica = info.getReplica();
                        AgentReplicationService.this.myLogger.log(Logger.FINE, "Redirecting message " + ACLMessage.getPerformative(msg.getPerformative()) + "[" + msg.getContent() + "] from dirty replica " + receiver.getLocalName() + " to new replica " + newReplica.getLocalName());
                        if (receiver.equals(newReplica)) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        AgentReplicationService.this.sendMessage(msg.getSender(), gMsg, newReplica);
                        return false;
                    }
                }
            } else if (name.equals("Leadership-Acquired")) {
                AgentReplicationService.this.checkAllReplications();
            }
            return true;
        }

        public final void postProcess(VerticalCommand cmd) {
            if (cmd.getName().equals("Inform-Cloned")) {
                ReplicaInfo r;
                AID id = (AID)cmd.getParam(0);
                Location where = (Location)cmd.getParam(1);
                String newName = (String)cmd.getParam(2);
                List rr = (List)AgentReplicationService.this.pendingReplicaCreationRequests.get(id);
                if (rr != null && (r = (ReplicaInfo)rr.get(0)).where.equals(where) && r.replicaAid.getLocalName().equals(newName)) {
                    boolean success;
                    rr.remove(0);
                    boolean bl = success = cmd.getReturnValue() == null;
                    if (success) {
                        AgentReplicationService.this.broadcastAddReplica(id, r);
                        AgentReplicationService.this.localNotifyReplicaAddedToMaster(id, r);
                    }
                    if (rr.size() > 0) {
                        ReplicaInfo nextR = (ReplicaInfo)rr.get(0);
                        AgentReplicationService.this.asynchCloneReplica(id, nextR.replicaAid.getLocalName(), nextR.where);
                    } else {
                        AgentReplicationService.this.pendingReplicaCreationRequests.remove(id);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AgentReplicationHelperImpl
    implements AgentReplicationHelper {
        private AID myAid;
        private AID virtualAid;
        private List<ReplicaInfo> peerReplicas = new ArrayList<ReplicaInfo>();
        private ReplicaInfo[] peerReplicasArray = new ReplicaInfo[0];

        private AgentReplicationHelperImpl() {
        }

        @Override
        public void init(Agent a) {
            this.myAid = a.getAID();
            this.virtualAid = (AID)AgentReplicationService.this.replicaToVirtualMap.get(this.myAid);
            if (this.virtualAid != null) {
                GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(this.virtualAid);
                if (info != null) {
                    AID[] currentReplicas;
                    for (AID replica : currentReplicas = info.getAllReplicas()) {
                        if (replica.equals(this.myAid)) continue;
                        try {
                            Location location = AgentReplicationService.this.getLocation(replica);
                            this.addPeerReplica(new ReplicaInfo(replica, location));
                        }
                        catch (NotFoundException nfe) {
                            AgentReplicationService.this.myLogger.log(Logger.WARNING, "Replica " + replica.getLocalName() + " not found. Likely it died in the meanwhile");
                        }
                        catch (Exception e2) {
                            AgentReplicationService.this.myLogger.log(Logger.SEVERE, "Error retrieving location for agent " + replica.getLocalName(), e2);
                        }
                    }
                } else {
                    AgentReplicationService.this.myLogger.log(Logger.SEVERE, "Virtual agent " + this.virtualAid.getLocalName() + " for replica agent " + this.myAid.getLocalName() + " not found");
                }
            }
        }

        @Override
        public AID makeVirtual(String virtualName, int replicationMode) throws ServiceException {
            if (this.virtualAid == null) {
                this.virtualAid = new AID(AID.createGUID(virtualName, AgentReplicationService.this.myContainer.getPlatformID()), true);
                AMSAgentDescription amsd = new AMSAgentDescription();
                amsd.setName(this.virtualAid);
                amsd.setState("active");
                Agent agent = AgentReplicationService.this.myContainer.acquireLocalAgent(this.myAid);
                AgentReplicationService.this.myContainer.releaseLocalAgent(this.myAid);
                if (agent != null) {
                    try {
                        AMSService.register(agent, amsd);
                    }
                    catch (Exception e2) {
                        throw new ServiceException("Error registering virtual name " + virtualName, e2);
                    }
                }
                AgentReplicationService.this.broadcastNewVirtualAgent(this.virtualAid, this.myAid, replicationMode);
                return this.virtualAid;
            }
            throw new ServiceException("Agent " + this.myAid.getLocalName() + " has already been made virtual");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void createReplica(String replicaName, Location where) throws ServiceException {
            if (this.virtualAid == null) throw new ServiceException("Agent " + this.myAid.getLocalName() + " has not been made virtual");
            if (!this.isMaster()) throw new ServiceException("Agent " + this.myAid.getLocalName() + " is not the master replica");
            AgentReplicationSlice slice = (AgentReplicationSlice)AgentReplicationService.this.getSlice(where.getName());
            if (slice == null) throw new ServiceException("AgentReplicationService not installed in the destination container " + where.getName() + " for replica " + replicaName);
            AID replicaAid = new AID(AID.createGUID(replicaName, AgentReplicationService.this.myContainer.getPlatformID()), true);
            try {
                slice.replicaCreationRequested(this.virtualAid, replicaAid);
            }
            catch (IMTPException imtpe) {
                slice = (AgentReplicationSlice)AgentReplicationService.this.getFreshSlice(where.getName());
                try {
                    slice.replicaCreationRequested(this.virtualAid, replicaAid);
                }
                catch (IMTPException imtpe1) {
                    throw new ServiceException("IMTP error contacting destination slice", imtpe1);
                }
            }
            ArrayList<ReplicaInfo> rr = (ArrayList<ReplicaInfo>)AgentReplicationService.this.pendingReplicaCreationRequests.get(this.myAid);
            if (rr == null) {
                rr = new ArrayList<ReplicaInfo>();
                AgentReplicationService.this.pendingReplicaCreationRequests.put(this.myAid, rr);
            }
            rr.add(new ReplicaInfo(replicaAid, where));
            if (rr.size() != 1) return;
            AgentReplicationService.this.cloneReplica(this.myAid, replicaName, where);
        }

        @Override
        public AID getVirtualAid() {
            return this.virtualAid;
        }

        @Override
        public AID getMasterAid() {
            if (this.virtualAid != null) {
                GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(this.virtualAid);
                return info.getMaster();
            }
            return null;
        }

        @Override
        public boolean isMaster() {
            if (this.virtualAid != null) {
                GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(this.virtualAid);
                return this.myAid.equals(info.getMaster());
            }
            return false;
        }

        @Override
        public Map<AID, Location> getReplicas() {
            return null;
        }

        @Override
        public void invokeReplicatedMethod(String methodName, Object[] arguments) {
            ReplicaInfo[] tmp = this.peerReplicasArray;
            AgentReplicationService.this.myLogger.log(Logger.FINE, "Invoking method " + methodName + " on " + tmp.length + " replica(s)");
            for (ReplicaInfo r : tmp) {
                try {
                    if (this.invokeOnReplica(methodName, arguments, r)) continue;
                    this.removePeerReplica(r);
                    GlobalReplicationInfo info = (GlobalReplicationInfo)AgentReplicationService.this.globalReplications.get(this.virtualAid);
                    if (info == null) continue;
                    info.removeReplica(r.replicaAid);
                }
                catch (Exception e2) {
                    AgentReplicationService.this.myLogger.log(Logger.SEVERE, "Error propagating call to method " + methodName + " to agent " + r.replicaAid.getLocalName(), e2);
                }
            }
        }

        private boolean invokeOnReplica(String methodName, Object[] arguments, ReplicaInfo r) throws Exception {
            AgentReplicationService.this.myLogger.log(Logger.FINER, "Invoking method " + methodName + " on replica " + r.replicaAid.getLocalName());
            while (true) {
                AgentReplicationSlice slice;
                if ((slice = (AgentReplicationSlice)AgentReplicationService.this.getSlice(r.where.getName())) != null) {
                    try {
                        try {
                            slice.invokeAgentMethod(r.replicaAid, methodName, arguments);
                        }
                        catch (IMTPException imtpe) {
                            slice = (AgentReplicationSlice)AgentReplicationService.this.getFreshSlice(r.where.getName());
                            slice.invokeAgentMethod(r.replicaAid, methodName, arguments);
                        }
                        break;
                    }
                    catch (NotFoundException nfe) {
                        // empty catch block
                    }
                }
                try {
                    AgentReplicationService.this.myLogger.log(Logger.CONFIG, "Updating location of replica " + r.replicaAid.getLocalName());
                    Location l = AgentReplicationService.this.getLocation(r.replicaAid);
                    r.where = l;
                }
                catch (NotFoundException nfe1) {
                    return false;
                }
            }
            return true;
        }

        private synchronized void addPeerReplica(ReplicaInfo r) {
            if (!this.peerReplicas.contains(r)) {
                AgentReplicationService.this.myLogger.log(Logger.CONFIG, "Adding replica " + r.replicaAid.getLocalName() + " to Helper of agent " + this.myAid.getLocalName());
                this.peerReplicas.add(r);
                this.peerReplicasArray = this.peerReplicas.toArray(new ReplicaInfo[0]);
            }
        }

        private synchronized void removePeerReplica(ReplicaInfo r) {
            if (this.peerReplicas.remove(r)) {
                AgentReplicationService.this.myLogger.log(Logger.CONFIG, "Removing replica " + r.replicaAid.getLocalName() + " from Helper of agent " + this.myAid.getLocalName());
                this.peerReplicasArray = this.peerReplicas.toArray(new ReplicaInfo[0]);
            }
        }
    }
}

