/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.IMTPException;
import jade.core.Profile;
import jade.core.nodeMonitoring.NetworkChecker;
import jade.core.nodeMonitoring.UDPNodeFailureMonitor;
import jade.core.nodeMonitoring.UDPNodeMonitoringService;
import jade.util.Logger;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class UDPMonitorServer {
    private Logger logger;
    private UDPNodeMonitoringService myService = null;
    private String host;
    private boolean acceptLocalHostOnly;
    private int port;
    private int pingDelay;
    private int pingDelayLimit;
    private int unreachLimit;
    private NetworkChecker checker;
    private DatagramChannel server;
    private Selector selector;
    private Hashtable targets = new Hashtable();
    private PingHandler pingHandler;
    private Timer timer;
    private Hashtable deadlines = new Hashtable();
    private int orphanNodePingsCnt;
    private int maxTracedUnknownPings;
    private Hashtable unknownPingCounters = new Hashtable();
    private static long currentId = 0L;

    private static synchronized long getUniqueId() {
        return currentId++;
    }

    UDPMonitorServer(UDPNodeMonitoringService s, String h, boolean alho, int p, int pd, int pdl, int ul, int onpc, int mtup, NetworkChecker ch) {
        this.myService = s;
        this.host = h;
        this.acceptLocalHostOnly = alho;
        this.port = p;
        this.pingDelay = pd;
        this.pingDelayLimit = pdl;
        this.unreachLimit = ul;
        this.orphanNodePingsCnt = onpc;
        this.maxTracedUnknownPings = mtup;
        this.checker = ch;
        this.logger = Logger.getMyLogger("jade.core.nodeMonitoring.UDPNodeMonitoring");
        try {
            this.server = DatagramChannel.open();
        }
        catch (Exception e2) {
            this.logger.log(Logger.SEVERE, "Cannot open UDP channel. " + e2);
            e2.printStackTrace();
        }
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    int getPingDelay() {
        return this.pingDelay;
    }

    int getPingDelayLimit() {
        return this.pingDelayLimit;
    }

    int getUnreachableLimit() {
        return this.unreachLimit;
    }

    synchronized void start() throws Exception {
        this.server.configureBlocking(false);
        try {
            if (this.acceptLocalHostOnly) {
                this.logger.log(Logger.INFO, "Binding UDP Server Socket on host " + this.host + ", port " + this.port);
                this.server.socket().bind(new InetSocketAddress(this.host, this.port));
            } else {
                this.logger.log(Logger.INFO, "Binding UDP Server Socket on port " + this.port);
                this.server.socket().bind(new InetSocketAddress(this.port));
            }
        }
        catch (BindException e2) {
            if (!this.acceptLocalHostOnly || Profile.isLocalHost(this.host)) {
                this.logger.log(Logger.WARNING, "Cannot bind UDP Server Socket on port " + this.port + ". Let the system select a free one.");
                if (this.acceptLocalHostOnly) {
                    this.server.socket().bind(new InetSocketAddress(this.host, 0));
                } else {
                    this.server.socket().bind(new InetSocketAddress(0));
                }
                this.port = this.server.socket().getLocalPort();
            }
            throw e2;
        }
        this.selector = Selector.open();
        this.server.register(this.selector, 1);
        this.pingHandler = new PingHandler("UDPNodeFailureMonitor-PingHandler");
        this.pingHandler.start();
        this.timer = new Timer();
    }

    synchronized void stop() {
        block3: {
            try {
                this.pingHandler.stop();
                this.timer.cancel();
                this.deadlines.clear();
                this.server.disconnect();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, "UDP monitoring server has been stopped.");
                }
            }
            catch (Exception e2) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block3;
                this.logger.log(Logger.SEVERE, "Error shutting down the UDP monitor server");
            }
        }
    }

    public void register(UDPNodeFailureMonitor m) {
        String nodeID = m.getNode().getName();
        this.targets.put(nodeID, m);
        this.addDeadline(nodeID, this.pingDelayLimit);
    }

    public void deregister(UDPNodeFailureMonitor m) {
        String nodeId = m.getNode().getName();
        this.targets.remove(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingReceived(String nodeID, boolean isTerminating) {
        UDPNodeFailureMonitor mon;
        TimerTask currDeadline;
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "UDP ping message for node '" + nodeID + "' received. (termination-flag: " + isTerminating + ")");
        }
        if ((currDeadline = (TimerTask)this.deadlines.remove(nodeID)) != null) {
            currDeadline.cancel();
        }
        if ((mon = (UDPNodeFailureMonitor)this.targets.get(nodeID)) != null) {
            this.unknownPingCounters.remove(nodeID);
            UDPNodeFailureMonitor uDPNodeFailureMonitor = mon;
            synchronized (uDPNodeFailureMonitor) {
                mon.setLastPing(System.currentTimeMillis());
                int state = mon.getState();
                if (isTerminating) {
                    mon.setState(2);
                } else {
                    if (state == 1) {
                        mon.setState(0);
                    }
                    this.addDeadline(nodeID, this.pingDelayLimit);
                }
            }
        } else {
            this.handleUnknownPing(nodeID);
        }
    }

    private void handleUnknownPing(String nodeID) {
        Counter cnt = (Counter)this.unknownPingCounters.get(nodeID);
        if (cnt == null) {
            cnt = new Counter();
            this.unknownPingCounters.put(nodeID, cnt);
        }
        if (cnt.getValue() < this.maxTracedUnknownPings) {
            this.logger.log(Logger.WARNING, "UDP ping message with the unknown node ID '" + nodeID + "' received");
            cnt.increment();
            if (cnt.getValue() == this.orphanNodePingsCnt) {
                final String id = nodeID;
                Thread t = new Thread(){

                    public void run() {
                        UDPMonitorServer.this.myService.handleOrphanNode(id);
                    }
                };
                t.start();
            }
        }
    }

    protected void timeout(String nodeID, UDPNodeFailureMonitor mon) {
        int oldState;
        int newState = oldState = mon.getState();
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "Timeout for '" + nodeID + "'");
        }
        if (oldState == 0) {
            try {
                this.myService.pingNode(nodeID);
                this.logger.log(Logger.WARNING, "Missing UDP-PING packets from reachable node " + nodeID);
                this.pingReceived(nodeID, false);
            }
            catch (IMTPException imtpe) {
                newState = 1;
                this.addDeadline(nodeID, this.unreachLimit);
            }
        } else if (oldState == 1) {
            if (this.checker == null || this.checker.isNetworkUp()) {
                newState = 2;
            } else {
                this.logger.log(Logger.WARNING, "Unreachable limit exceeded for node " + nodeID + ", however the network appears to be down --> Give the node another chance");
                this.addDeadline(nodeID, this.unreachLimit);
            }
        }
        if (newState != oldState) {
            mon.setState(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeadline(String nodeID, int delay) {
        Deadline deadline = new Deadline(nodeID);
        UDPNodeFailureMonitor mon = (UDPNodeFailureMonitor)this.targets.get(nodeID);
        if (mon != null) {
            UDPNodeFailureMonitor uDPNodeFailureMonitor = mon;
            synchronized (uDPNodeFailureMonitor) {
                mon.setDeadlineID(deadline.getID());
                this.deadlines.put(nodeID, deadline);
                this.timer.schedule((TimerTask)deadline, delay);
            }
        }
    }

    private class Counter {
        private int value = 0;

        private Counter() {
        }

        private void increment() {
            ++this.value;
        }

        private int getValue() {
            return this.value;
        }
    }

    private class PingHandler
    implements Runnable {
        private final byte TERMINATING_INFO = 1;
        private boolean interrupted = false;
        private Thread thread;

        public PingHandler(String name) {
            this.thread = new Thread((Runnable)this, name);
        }

        private void handlePing() throws IOException {
            ByteBuffer datagramBuffer = ByteBuffer.allocate(65536);
            SocketAddress address = UDPMonitorServer.this.server.receive(datagramBuffer);
            datagramBuffer.position(0);
            if (address != null) {
                int nodeIDLength = datagramBuffer.getInt();
                byte[] bb = new byte[nodeIDLength];
                datagramBuffer.get(bb, 0, nodeIDLength);
                String nodeID = new String(bb);
                byte info = datagramBuffer.get();
                boolean isTerminating = (info & 1) != 0;
                UDPMonitorServer.this.pingReceived(nodeID, isTerminating);
            }
        }

        public void run() {
            while (!this.interrupted) {
                try {
                    UDPMonitorServer.this.selector.select();
                    Set<SelectionKey> keys = UDPMonitorServer.this.selector.selectedKeys();
                    this.interrupted = keys.size() == 0;
                    Iterator<SelectionKey> i = keys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        i.remove();
                        if (!key.isValid() || !key.isReadable()) continue;
                        this.handlePing();
                    }
                }
                catch (Exception e2) {
                    if (!UDPMonitorServer.this.logger.isLoggable(Logger.SEVERE)) continue;
                    UDPMonitorServer.this.logger.log(Logger.SEVERE, "UDP Connection error ");
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.interrupted = true;
        }
    }

    private class Deadline
    extends TimerTask {
        private String nodeID;
        private long id;

        public Deadline(String nodeID) {
            this.nodeID = nodeID;
            this.id = UDPMonitorServer.getUniqueId();
        }

        public long getID() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UDPNodeFailureMonitor mon = (UDPNodeFailureMonitor)UDPMonitorServer.this.targets.get(this.nodeID);
            if (mon != null) {
                UDPNodeFailureMonitor uDPNodeFailureMonitor = mon;
                synchronized (uDPNodeFailureMonitor) {
                    if (mon.getDeadlineID() == this.id) {
                        UDPMonitorServer.this.timeout(this.nodeID, mon);
                    } else {
                        UDPMonitorServer.this.logger.log(Logger.WARNING, "expired Deadline " + this.id + " for node " + this.nodeID + " is not the same as monitor Deadline " + mon.getDeadlineID());
                    }
                }
            }
        }

        public String toString() {
            return "Deadline{nodeID=" + this.nodeID + " id=" + this.id + "}";
        }
    }
}

