/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class GenericMessage
implements Serializable {
    private transient ACLMessage msg;
    private Envelope env;
    private byte[] payload;
    private transient AID sender;
    private transient JADEPrincipal senderPrincipal;
    private transient Credentials senderCredentials;
    private boolean isAMSFailure = false;
    private transient boolean foreignReceiver = false;
    private transient boolean modifiable = true;
    private String traceID = null;
    private long timeStamp = -1L;

    public GenericMessage() {
    }

    public GenericMessage(ACLMessage msg) {
        this.msg = msg;
    }

    public GenericMessage(Envelope env, byte[] payload) {
        this.env = env;
        this.payload = payload;
    }

    public final byte[] getPayload() {
        return this.payload;
    }

    public final Envelope getEnvelope() {
        return this.env;
    }

    public final ACLMessage getACLMessage() {
        return this.msg;
    }

    public final void setACLMessage(ACLMessage msg) {
        this.msg = msg;
    }

    public final void update(ACLMessage msg, Envelope env, byte[] payload) {
        this.msg = msg;
        this.env = env;
        this.payload = payload;
    }

    final void setSenderPrincipal(JADEPrincipal senderPrincipal) {
        this.senderPrincipal = senderPrincipal;
    }

    final JADEPrincipal getSenderPrincipal() {
        return this.senderPrincipal;
    }

    final void setSenderCredentials(Credentials senderCredentials) {
        this.senderCredentials = senderCredentials;
    }

    final Credentials getSenderCredentials() {
        return this.senderCredentials;
    }

    public final boolean isAMSFailure() {
        return this.isAMSFailure;
    }

    public final void setAMSFailure(boolean b) {
        this.isAMSFailure = b;
    }

    final boolean hasForeignReceiver() {
        return this.foreignReceiver;
    }

    final void setForeignReceiver(boolean b) {
        this.foreignReceiver = b;
    }

    public final boolean isModifiable() {
        return this.modifiable;
    }

    public final void setModifiable(boolean b) {
        this.modifiable = b;
    }

    public final String getTraceID() {
        return this.traceID;
    }

    public final void setTraceID(String id) {
        this.traceID = id;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public final void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.payload == null) {
            this.payload = new LEAPACLCodec().encode(this.msg, null);
        }
        out.defaultWriteObject();
    }

    public final void setSender(AID sender) {
        this.sender = sender;
    }

    public final AID getSender() {
        if (this.sender != null) {
            return this.sender;
        }
        if (this.msg != null) {
            return this.msg.getSender();
        }
        if (this.env != null) {
            return this.env.getFrom();
        }
        return null;
    }

    public String toString() {
        return "GenericMessage\n\t" + this.msg + "\n\t" + this.env + "\n\t" + (this.payload == null ? "null payload" : this.payload.toString()) + "\n";
    }

    public final int length() {
        byte[] content;
        int length2 = 0;
        if (this.payload != null) {
            length2 = this.payload.length;
        } else if (this.msg != null && (content = this.msg.getByteSequenceContent()) != null) {
            length2 = content.length;
        }
        return length2;
    }
}

