/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.event.JADEEvent;
import jade.lang.acl.ACLMessage;

public class MessageEvent
extends JADEEvent {
    public static final int SENT_MESSAGE = 1;
    public static final int POSTED_MESSAGE = 2;
    public static final int RECEIVED_MESSAGE = 3;
    public static final int ROUTED_MESSAGE = 4;
    private ACLMessage message = null;
    private AID sender = null;
    private AID receiver = null;
    private Channel from = null;
    private Channel to = null;

    public MessageEvent(int id, ACLMessage msg, AID s, AID r, ContainerID cid) {
        super(id, cid);
        if (this.isRouting()) {
            throw new InternalError("Bad event kind: it must not be a 'message-routed' event.");
        }
        this.message = msg;
        this.sender = s;
        this.receiver = r;
    }

    public MessageEvent(int id, ACLMessage msg, Channel f, Channel t, ContainerID cid) {
        super(id, cid);
        if (!this.isRouting()) {
            throw new InternalError("Bad event kind: it must be a 'message-routed' event.");
        }
        this.message = msg;
        this.from = f;
        this.to = t;
    }

    public ACLMessage getMessage() {
        return this.message;
    }

    public AID getSender() {
        if (this.sender != null) {
            return this.sender;
        }
        return this.message.getSender();
    }

    public AID getReceiver() {
        return this.receiver;
    }

    public AID getAgent() {
        if (this.type == 1) {
            return this.getSender();
        }
        return this.getReceiver();
    }

    public Channel getFrom() {
        return this.from;
    }

    public Channel getTo() {
        return this.to;
    }

    public boolean isRouting() {
        return this.type == 4;
    }
}

