/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.AgentState;
import jade.core.BehaviourID;
import jade.core.ContainerID;
import jade.core.event.JADEEvent;
import jade.security.JADEPrincipal;

public class AgentEvent
extends JADEEvent {
    public static final int CHANGED_AGENT_STATE = 1;
    public static final int ADDED_BEHAVIOUR = 2;
    public static final int REMOVED_BEHAVIOUR = 3;
    public static final int CHANGED_BEHAVIOUR_STATE = 4;
    public static final int CHANGED_AGENT_PRINCIPAL = 5;
    private AID agent;
    private BehaviourID behaviour = null;
    private AgentState from = null;
    private AgentState to = null;
    private String behaviourFrom = null;
    private String behaviourTo = null;
    private JADEPrincipal oldPrincipal = null;
    private JADEPrincipal newPrincipal = null;

    public AgentEvent(int id, AID aid, AgentState f, AgentState t, ContainerID cid) {
        super(id, cid);
        if (!this.isChangedAgentState()) {
            throw new InternalError("Bad Event kind: it must be a 'changed-agent-state' event.");
        }
        this.agent = aid;
        this.behaviour = null;
        this.from = f;
        this.to = t;
    }

    public AgentEvent(int id, AID aid, JADEPrincipal f, JADEPrincipal t, ContainerID cid) {
        super(id, cid);
        if (!this.isChangedAgentPrincipal()) {
            throw new InternalError("Bad Event kind: it must be a 'changed-agent-principal' event.");
        }
        this.agent = aid;
        this.oldPrincipal = f;
        this.newPrincipal = t;
    }

    public AgentEvent(int id, AID aid, BehaviourID bid, ContainerID cid) {
        super(id, cid);
        if (this.isChangedAgentState() || this.isChangedBehaviourState()) {
            throw new InternalError("Bad Event kind: it must be an 'added/removed-behaviour' event.");
        }
        this.agent = aid;
        this.behaviour = bid;
        this.from = null;
        this.to = null;
    }

    public AgentEvent(int id, AID aid, BehaviourID bid, String strFrom, String strTo, ContainerID cid) {
        super(id, cid);
        if (!this.isChangedBehaviourState()) {
            throw new InternalError("Bad Event kind: it must be a 'changed-behaviour-state' event.");
        }
        this.agent = aid;
        this.behaviour = bid;
        this.from = null;
        this.to = null;
        this.behaviourFrom = strFrom;
        this.behaviourTo = strTo;
    }

    public AID getAgent() {
        return this.agent;
    }

    public BehaviourID getBehaviour() {
        return this.behaviour;
    }

    public AgentState getFrom() {
        return this.from;
    }

    public AgentState getTo() {
        return this.to;
    }

    public String getBehaviourFrom() {
        return this.behaviourFrom;
    }

    public String getBehaviourTo() {
        return this.behaviourTo;
    }

    public JADEPrincipal getOldPrincipal() {
        return this.oldPrincipal;
    }

    public JADEPrincipal getNewPrincipal() {
        return this.newPrincipal;
    }

    private boolean isChangedAgentPrincipal() {
        return this.type == 5;
    }

    private boolean isChangedAgentState() {
        return this.type == 1;
    }

    private boolean isChangedBehaviourState() {
        return this.type == 4;
    }
}

