/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.NotFoundException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.DataStore;
import jade.util.Logger;
import jade.util.leap.Collection;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class ThreadedBehaviourFactory {
    private static final String CREATED_STATE = "CREATED";
    private static final String RUNNING_STATE = "RUNNING";
    private static final String CHECKING_STATE = "CHECKING";
    private static final String BLOCKED_STATE = "BLOCKED";
    private static final String SUSPENDED_STATE = "SUSPENDED";
    private static final String TERMINATED_STATE = "TERMINATED";
    private static final String INTERRUPTED_STATE = "INTERRUPTED";
    private static final String ERROR_STATE = "ERROR";
    private Vector threadedBehaviours = new Vector();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public Behaviour wrap(Behaviour b) {
        return new ThreadedBehaviourWrapper(b);
    }

    public int size() {
        return this.threadedBehaviours.size();
    }

    public void interrupt() {
        ThreadedBehaviourWrapper[] tt = this.getWrappers();
        for (int i = 0; i < tt.length; ++i) {
            tt[i].interrupt();
        }
    }

    public synchronized boolean waitUntilEmpty(long timeout) {
        long time2 = System.currentTimeMillis();
        long deadline = time2 + timeout;
        try {
            while (!(this.threadedBehaviours.isEmpty() || timeout > 0L && time2 >= deadline)) {
                this.wait(deadline - time2);
                time2 = System.currentTimeMillis();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return this.threadedBehaviours.isEmpty();
    }

    public Thread interrupt(Behaviour b) throws NotFoundException {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            return wrapper.interrupt();
        }
        throw new NotFoundException(b.getBehaviourName());
    }

    public void suspend(Behaviour b) {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            wrapper.suspend();
        }
    }

    public void resume(Behaviour b) {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            wrapper.resume();
        }
    }

    public Thread getThread(Behaviour b) {
        ThreadedBehaviourWrapper tb = this.getWrapper(b);
        if (tb != null) {
            return tb.getThread();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedBehaviourWrapper[] getWrappers() {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            ThreadedBehaviourWrapper[] wrappers = new ThreadedBehaviourWrapper[this.threadedBehaviours.size()];
            for (int i = 0; i < wrappers.length; ++i) {
                wrappers[i] = (ThreadedBehaviourWrapper)this.threadedBehaviours.elementAt(i);
            }
            return wrappers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadedBehaviourWrapper getWrapper(Behaviour b) {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            Enumeration e2 = this.threadedBehaviours.elements();
            while (e2.hasMoreElements()) {
                ThreadedBehaviourWrapper tb = (ThreadedBehaviourWrapper)e2.nextElement();
                if (!tb.getBehaviour().equals(b)) continue;
                return tb;
            }
            return null;
        }
    }

    private void invokeMethod(Object obj, String methodName) {
        try {
            Method m = obj.getClass().getMethod(methodName, new Class[0]);
            m.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (Exception e2) {
            this.myLogger.log(Logger.WARNING, "Error invoking callback method " + methodName, e2);
        }
    }

    private class DummyParentBehaviour
    extends CompositeBehaviour {
        private ThreadedBehaviourWrapper myChild;

        private DummyParentBehaviour(Agent a, ThreadedBehaviourWrapper b) {
            super(a);
            this.myChild = b;
        }

        public boolean isRunnable() {
            return false;
        }

        protected void handle(Behaviour.RunnableChangedEvent rce) {
            if (rce.isRunnable()) {
                this.myChild.go();
            }
        }

        public Behaviour root() {
            Behaviour r = this.myChild.root();
            if (r == this.myChild) {
                return this.myChild.getBehaviour();
            }
            return r;
        }

        protected void scheduleFirst() {
        }

        protected void scheduleNext(boolean currentDone, int currentResult) {
        }

        protected boolean checkTermination(boolean currentDone, int currentResult) {
            return false;
        }

        protected Behaviour getCurrent() {
            return null;
        }

        public Collection getChildren() {
            return null;
        }
    }

    public class ThreadedBehaviourWrapper
    extends Behaviour
    implements Runnable {
        private Thread myThread;
        private Behaviour myBehaviour;
        private volatile boolean restarted;
        private boolean finished;
        private volatile boolean suspended;
        private int exitValue;
        private volatile String threadState;

        private ThreadedBehaviourWrapper(Behaviour b) {
            super(b.myAgent);
            this.restarted = false;
            this.finished = false;
            this.suspended = false;
            this.threadState = ThreadedBehaviourFactory.CREATED_STATE;
            this.myBehaviour = b;
            this.myBehaviour.setParent(new DummyParentBehaviour(this.myAgent, this));
        }

        public void onStart() {
            this.myBehaviour.setAgent(this.myAgent);
            this.myBehaviour.parent.setAgent(this.myAgent);
            this.start();
        }

        private void start() {
            this.myThread = new Thread(this);
            this.myThread.setName(this.myAgent.getLocalName() + "#" + this.myBehaviour.getBehaviourName());
            this.myThread.start();
        }

        public void action() {
            if (!this.finished) {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }

        public int onEnd() {
            if (!this.myBehaviour.isRunnable()) {
                this.block();
            }
            return this.exitValue;
        }

        protected void setParent(CompositeBehaviour parent) {
            super.setParent(parent);
            this.myBehaviour.setWrappedParent(parent);
        }

        public void setDataStore(DataStore ds) {
            this.myBehaviour.setDataStore(ds);
        }

        public DataStore getDataStore() {
            return this.myBehaviour.getDataStore();
        }

        public void reset() {
            this.restarted = false;
            this.finished = false;
            this.suspended = false;
            this.myBehaviour.reset();
            super.reset();
        }

        public void restart() {
            this.myBehaviour.restart();
        }

        protected void handle(Behaviour.RunnableChangedEvent rce) {
            super.handle(rce);
            if (!rce.isUpwards()) {
                this.myBehaviour.handle(rce);
                if (rce.isRunnable()) {
                    this.go();
                }
            }
        }

        private synchronized void go() {
            this.restarted = true;
            this.notifyAll();
        }

        private synchronized void suspend() {
            if (Thread.currentThread() == this.myThread) {
                this.suspended = true;
            }
        }

        private synchronized void resume() {
            if (this.suspended) {
                this.suspended = false;
                if (this.myThread == null) {
                    this.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.threadState == ThreadedBehaviourFactory.CREATED_STATE) {
                ThreadedBehaviourFactory.this.threadedBehaviours.addElement(this);
            } else if (this.threadState == ThreadedBehaviourFactory.SUSPENDED_STATE) {
                ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "onResumed");
            }
            this.threadState = ThreadedBehaviourFactory.RUNNING_STATE;
            try {
                while (true) {
                    this.restarted = false;
                    this.myBehaviour.actionWrapper();
                    ThreadedBehaviourWrapper threadedBehaviourWrapper = this;
                    synchronized (threadedBehaviourWrapper) {
                        block25: {
                            if (this.restarted) {
                                this.myBehaviour.myEvent.init(true, 1);
                                this.myBehaviour.handle(this.myBehaviour.myEvent);
                            }
                            if (this.myBehaviour.done()) {
                                break;
                            }
                            if (Thread.currentThread().isInterrupted() || this.threadState == ThreadedBehaviourFactory.INTERRUPTED_STATE) {
                                throw new InterruptedException();
                            }
                            if (!this.suspended) break block25;
                            this.threadState = ThreadedBehaviourFactory.SUSPENDED_STATE;
                            this.myThread = null;
                            return;
                        }
                        if (!this.myBehaviour.isRunnable()) {
                            this.threadState = ThreadedBehaviourFactory.BLOCKED_STATE;
                            this.wait();
                        }
                    }
                    this.threadState = ThreadedBehaviourFactory.RUNNING_STATE;
                }
                this.exitValue = this.myBehaviour.onEnd();
                this.threadState = ThreadedBehaviourFactory.TERMINATED_STATE;
            }
            catch (InterruptedException ie) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                ThreadedBehaviourFactory.this.myLogger.log(Logger.WARNING, "Threaded behaviour " + this.myBehaviour.getBehaviourName() + " interrupted before termination");
            }
            catch (Agent.Interrupted ae) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                ThreadedBehaviourFactory.this.myLogger.log(Logger.WARNING, "Threaded behaviour " + this.myBehaviour.getBehaviourName() + " interrupted before termination");
            }
            catch (ThreadDeath td) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                ThreadedBehaviourFactory.this.myLogger.log(Logger.WARNING, "Threaded behaviour " + this.myBehaviour.getBehaviourName() + " stopped before termination");
                throw td;
            }
            catch (Throwable t) {
                this.threadState = ThreadedBehaviourFactory.ERROR_STATE;
                t.printStackTrace();
            }
            finally {
                if (this.threadState == ThreadedBehaviourFactory.SUSPENDED_STATE) {
                    ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "onSuspended");
                } else {
                    this.terminate();
                }
            }
        }

        private synchronized Thread interrupt() {
            if (this.myThread != null) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                this.myThread.interrupt();
                return this.myThread;
            }
            if (this.threadState == ThreadedBehaviourFactory.SUSPENDED_STATE) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                this.terminate();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            if (Thread.currentThread() == this.myThread && (this.threadState == ThreadedBehaviourFactory.INTERRUPTED_STATE || this.threadState == ThreadedBehaviourFactory.ERROR_STATE)) {
                ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "onAborted");
            }
            this.finished = true;
            super.restart();
            ThreadedBehaviourFactory.this.threadedBehaviours.removeElement(this);
            ThreadedBehaviourFactory threadedBehaviourFactory = ThreadedBehaviourFactory.this;
            synchronized (threadedBehaviourFactory) {
                ThreadedBehaviourFactory.this.notifyAll();
            }
        }

        public final Thread getThread() {
            return this.myThread;
        }

        public final Behaviour getBehaviour() {
            return this.myBehaviour;
        }

        public final String getThreadState() {
            return this.threadState;
        }
    }
}

