/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.content.AgentAction;
import jade.content.ContentElement;
import jade.content.ContentException;
import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OntologyServer
extends CyclicBehaviour {
    private static final long serialVersionUID = -2997404961058073783L;
    private static final String[] performativeNames = new String[22];
    private Object serverDelegate;
    private Ontology onto;
    private Codec codec;
    private int[] servedPerformatives;
    private ConversationList ignoredConversations;
    private MessageTemplate template;
    private Set<Integer> performativesRequiringReply = new HashSet<Integer>();
    private transient Map<String, Method> cachedMethods = new HashMap<String, Method>();
    private ContentElement receivedContentElement;
    protected Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public OntologyServer(Agent a, Ontology onto, int performative) {
        this(a, onto, new int[]{performative}, null);
    }

    public OntologyServer(Agent a, Ontology onto, int[] performatives) {
        this(a, onto, performatives, null);
    }

    public OntologyServer(Agent a, Ontology onto, int performative, Object serverDelegate) {
        this(a, onto, new int[]{performative}, serverDelegate);
    }

    public OntologyServer(Agent a, Ontology onto, int[] performatives, Object serverDelegate) {
        super(a);
        this.onto = onto;
        this.servedPerformatives = performatives;
        Object object = this.serverDelegate = serverDelegate != null ? serverDelegate : this;
        if (this.servedPerformatives != null) {
            if (this.servedPerformatives.length == 1) {
                this.setBehaviourName(onto.getName() + "-" + performativeNames[this.servedPerformatives[0]] + "-Serever");
            } else {
                this.setBehaviourName(onto.getName() + "-" + performativeNames[this.servedPerformatives[0]] + "...-Serever");
            }
        } else {
            this.setBehaviourName(onto.getName() + "-Serever");
        }
        this.performativesRequiringReply.add(16);
        this.performativesRequiringReply.add(17);
        this.performativesRequiringReply.add(18);
        this.performativesRequiringReply.add(3);
        this.performativesRequiringReply.add(11);
        this.performativesRequiringReply.add(12);
        this.performativesRequiringReply.add(13);
        this.performativesRequiringReply.add(19);
        this.performativesRequiringReply.add(20);
        this.performativesRequiringReply.add(21);
    }

    public void setLanguage(Codec codec) {
        this.codec = codec;
    }

    public void setMessageTemplate(MessageTemplate template) {
        this.template = template;
    }

    public void setIgnoredConversations(ConversationList l) {
        if (this.ignoredConversations == null) {
            this.ignoredConversations = l;
        }
    }

    public ConversationList getIgnoredConversations() {
        return this.ignoredConversations;
    }

    public void addPerformativeRequiringReply(int performative) {
        this.performativesRequiringReply.add(performative);
    }

    public void removePerformativeRequiringReply(int performative) {
        this.performativesRequiringReply.remove(performative);
    }

    public void onStart() {
        if (this.ignoredConversations == null) {
            this.ignoredConversations = new ConversationList(this.myAgent);
        }
        if (this.template == null) {
            this.template = this.servedPerformatives != null ? MessageTemplate.and(MessageTemplate.MatchOntology(this.onto.getName()), new MessageTemplate(new MessageTemplate.MatchExpression(){

                public boolean match(ACLMessage msg) {
                    int perf = msg.getPerformative();
                    for (int p : OntologyServer.this.servedPerformatives) {
                        if (p != perf) continue;
                        return true;
                    }
                    return false;
                }
            })) : MessageTemplate.MatchOntology(this.onto.getName());
        }
        this.template = MessageTemplate.and(this.template, this.ignoredConversations.getMessageTemplate());
        ContentManager cm = this.myAgent.getContentManager();
        if (cm.lookupOntology(this.onto.getName()) == null) {
            cm.registerOntology(this.onto);
        }
        Codec codec = this.codec = this.codec != null ? this.codec : new SLCodec();
        if (cm.lookupLanguage(this.codec.getName()) == null) {
            cm.registerLanguage(this.codec);
        }
    }

    public final void action() {
        ACLMessage msg = this.myAgent.receive(this.template);
        if (msg != null) {
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.myAgent.getName() + " - Serving incoming message " + msg);
            }
            this.handleMessage(msg);
        } else {
            this.block();
        }
    }

    protected void handleMessage(ACLMessage msg) {
        try {
            Method m;
            this.receivedContentElement = this.myAgent.getContentManager().extractContent(msg);
            Object keyCel = this.extractKeyContentElement(this.receivedContentElement);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Serving " + keyCel.getClass().getName() + " " + ACLMessage.getPerformative(msg.getPerformative()));
            }
            if ((m = this.findServerMethod(keyCel, msg.getPerformative())) != null) {
                try {
                    m.invoke(this.serverDelegate, keyCel, msg);
                }
                catch (InvocationTargetException ite) {
                    this.handleServingFailure(ite.getCause(), keyCel, msg);
                }
                catch (Exception e2) {
                    this.handleServingFailure(e2, keyCel, msg);
                }
            } else {
                this.handleUnsupported(keyCel, msg);
            }
        }
        catch (ContentException ce) {
            this.handleNotUnderstood(ce, msg);
        }
    }

    public final ContentElement getReceivedContentElement() {
        return this.receivedContentElement;
    }

    protected Object extractKeyContentElement(ContentElement ce) {
        if (ce instanceof Action) {
            return (AgentAction)((Action)ce).getAction();
        }
        if (ce instanceof Done) {
            AgentAction act = (AgentAction)((Done)ce).getAction();
            if (act instanceof Action) {
                return (AgentAction)((Action)act).getAction();
            }
            return act;
        }
        if (ce instanceof Result) {
            AgentAction act = (AgentAction)((Result)ce).getAction();
            if (act instanceof Action) {
                return (AgentAction)((Action)act).getAction();
            }
            return act;
        }
        return ce;
    }

    protected void handleUnsupported(Object keyCel, ACLMessage msg) {
        this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Unsupported content-element " + keyCel.getClass().getName() + ". Sender is " + msg.getSender().getName());
        if (this.performativesRequiringReply.contains(msg.getPerformative())) {
            ACLMessage reply = msg.createReply();
            reply.setPerformative(14);
            reply.setContent("((unsupported-act " + keyCel.getClass().getName() + "))");
            this.myAgent.send(reply);
        }
    }

    protected void handleServingFailure(Throwable t, Object cel, ACLMessage msg) {
        this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + " - Unexpected error serving content-element " + cel.getClass().getName() + ". Sender is " + msg.getSender().getName(), t);
        if (this.performativesRequiringReply.contains(msg.getPerformative())) {
            ACLMessage reply = msg.createReply();
            reply.setPerformative(6);
            reply.setContent("((internal-error \"" + t + "\"))");
            this.myAgent.send(reply);
        }
    }

    protected void handleNotUnderstood(ContentException ce, ACLMessage msg) {
        this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Error decoding " + ACLMessage.getPerformative(msg.getPerformative()) + " message. Sender is " + msg.getSender().getName(), ce);
        if (this.performativesRequiringReply.contains(msg.getPerformative())) {
            ACLMessage reply = msg.createReply();
            reply.setPerformative(10);
            this.myAgent.send(reply);
        }
    }

    private Method findServerMethod(Object cel, int performative) {
        Method m;
        Class<?> c = cel.getClass();
        String performativeName = performativeNames[performative];
        String key = c.getSimpleName() + performativeName;
        if (this.cachedMethods == null) {
            this.cachedMethods = new HashMap<String, Method>();
        }
        if ((m = this.cachedMethods.get(key)) != null) {
            return m;
        }
        while (!c.equals(Object.class)) {
            String methodName = "serve" + c.getSimpleName() + performativeName;
            Class[] methodParamTypes = new Class[]{c, ACLMessage.class};
            try {
                m = this.serverDelegate.getClass().getMethod(methodName, methodParamTypes);
                this.cachedMethods.put(key, m);
                break;
            }
            catch (NoSuchMethodException nsme) {
                c = c.getSuperclass();
            }
        }
        return m;
    }

    public void ignoreConversation(String convId) {
        this.ignoredConversations.registerConversation(convId);
    }

    public void conversationFinished(String convId) {
        this.ignoredConversations.deregisterConversation(convId);
    }

    static {
        OntologyServer.performativeNames[0] = "AcceptProposal";
        OntologyServer.performativeNames[1] = "Agree";
        OntologyServer.performativeNames[2] = "Cancel";
        OntologyServer.performativeNames[3] = "Cfp";
        OntologyServer.performativeNames[4] = "Confirm";
        OntologyServer.performativeNames[5] = "Disconfirm";
        OntologyServer.performativeNames[6] = "Failure";
        OntologyServer.performativeNames[7] = "Inform";
        OntologyServer.performativeNames[8] = "InformIf";
        OntologyServer.performativeNames[9] = "InformRef";
        OntologyServer.performativeNames[10] = "NotUNderstood";
        OntologyServer.performativeNames[11] = "Propose";
        OntologyServer.performativeNames[12] = "QueryIf";
        OntologyServer.performativeNames[13] = "QueryRef";
        OntologyServer.performativeNames[14] = "Refuse";
        OntologyServer.performativeNames[15] = "RejectProposal";
        OntologyServer.performativeNames[16] = "Request";
        OntologyServer.performativeNames[17] = "RequestWhen";
        OntologyServer.performativeNames[18] = "RequestWhenever";
        OntologyServer.performativeNames[19] = "Subscribe";
        OntologyServer.performativeNames[20] = "Proxy";
        OntologyServer.performativeNames[21] = "Propagate";
    }
}

