/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Timer;
import jade.util.Logger;
import java.util.Comparator;
import java.util.TreeSet;

public class TimerDispatcher
implements Runnable {
    private static TimerDispatcher theDispatcher;
    private Thread myThread = null;
    private TimersList timers = new TimersList();
    private boolean active;
    protected Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    void setThread(Thread t) {
        if (this.myThread == null) {
            this.myThread = t;
        }
    }

    public synchronized Timer add(Timer t) {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.start();
        }
        while (!this.addTimer(t)) {
            t.setExpirationTime(t.expirationTime() + 1L);
        }
        if (this.timers.firstElement() == t) {
            this.wakeUp();
        }
        return t;
    }

    public synchronized void remove(Timer t) {
        this.timers.removeElement(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.active) {
                Timer t = null;
                TimerDispatcher timerDispatcher = this;
                synchronized (timerDispatcher) {
                    while (this.active) {
                        long timeToWait = 0L;
                        if (!this.timers.isEmpty()) {
                            t = (Timer)this.timers.firstElement();
                            if (t.isExpired()) {
                                this.timers.removeElement(t);
                                break;
                            }
                            timeToWait = t.expirationTime() - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                timeToWait = 1L;
                            }
                        }
                        this.sleep(timeToWait);
                    }
                }
                if (!this.active) continue;
                t.fire();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.timers.removeAllElements();
    }

    protected void sleep(long sleepTime) throws InterruptedException {
        this.wait(sleepTime);
    }

    protected void wakeUp() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Thread thread = this.myThread;
        synchronized (thread) {
            this.active = true;
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.myThread != null) {
            Thread thread = this.myThread;
            synchronized (thread) {
                if (Thread.currentThread().equals(this.myThread)) {
                    System.out.println("Deadlock avoidance: TimerDispatcher thread calling stop on itself!");
                } else {
                    this.active = false;
                    TimerDispatcher timerDispatcher = this;
                    synchronized (timerDispatcher) {
                        this.wakeUp();
                    }
                    try {
                        this.myThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.myThread = null;
            }
        }
    }

    public static TimerDispatcher getTimerDispatcher() {
        if (theDispatcher == null) {
            theDispatcher = new TimerDispatcher();
        }
        return theDispatcher;
    }

    public static void setTimerDispatcher(TimerDispatcher td) {
        theDispatcher = td;
    }

    private boolean addTimer(Timer t) {
        return this.timers.add(t);
    }

    private class TimerComparator
    implements Comparator {
        private TimerComparator() {
        }

        public int compare(Object o1, Object o2) {
            Timer t1 = (Timer)o1;
            Timer t2 = (Timer)o2;
            if (t1.expirationTime() < t2.expirationTime()) {
                return -1;
            }
            if (t1.expirationTime() == t2.expirationTime()) {
                return 0;
            }
            return 1;
        }
    }

    private class TimersList {
        private TreeSet set;

        private TimersList() {
            this.set = new TreeSet(new TimerComparator());
        }

        private final Object firstElement() {
            return this.set.first();
        }

        private final void removeElement(Object obj) {
            this.set.remove(obj);
        }

        private final void removeAllElements() {
            this.set.clear();
        }

        private final boolean isEmpty() {
            return this.set.isEmpty();
        }

        private boolean add(Object obj) {
            return this.set.add(obj);
        }
    }
}

