/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.MainDetectionManager;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

class MulticastMainDetectionListener
implements Runnable {
    private static final Logger logger = Logger.getMyLogger(MulticastMainDetectionListener.class.getName());
    private static final int DGRAM_BUF_LEN = 1024;
    private ProfileImpl profile;
    private IMTPManager manager;
    private MainDetectionManager.MulticastParams mcast;
    private InetAddress mcastGroupAddress;
    private MulticastSocket socket;
    private boolean active = false;

    public MulticastMainDetectionListener(ProfileImpl profile, IMTPManager manager) throws ProfileException {
        this.profile = profile;
        this.manager = manager;
        this.mcast = new MainDetectionManager.MulticastParams(profile);
        try {
            this.mcastGroupAddress = InetAddress.getByName(this.mcast.address);
        }
        catch (UnknownHostException e2) {
            throw new ProfileException("Cannot resolve address " + this.mcast.address, e2);
        }
        if (!this.mcastGroupAddress.isMulticastAddress()) {
            throw new ProfileException("Address " + this.mcast.address + " is not a multicast address");
        }
        try {
            this.socket = new MulticastSocket(this.mcast.port);
            this.socket.joinGroup(this.mcastGroupAddress);
            this.socket.setTimeToLive(this.mcast.ttl);
        }
        catch (IOException ioe) {
            throw new ProfileException("Error setting up multicast socket", ioe);
        }
    }

    private String errorResponse(String code, String msg) {
        return code + " " + msg;
    }

    void stop() {
        if (this.active) {
            this.active = false;
            if (this.socket != null) {
                try {
                    this.socket.leaveGroup(this.mcastGroupAddress);
                }
                catch (IOException e2) {
                    logger.log(Logger.FINER, "Error leaving multicast group", e2);
                }
                this.socket.close();
            }
        }
    }

    private String serveGetMain(String request) throws IMTPException {
        TransportAddress addr;
        logger.log(Logger.FINER, "MulticastMainDetectionListener::serveGetMain(request=\"" + request + "\")");
        String response = null;
        String proto = null;
        String platformName = null;
        int i = request.indexOf(58);
        if (i > 0) {
            proto = request.substring(i + 1);
            request = request.substring(0, i);
            logger.log(Logger.FINER, "MulticastMainDetectionListener::serveGetMain(): desired proto is \"" + proto + "\"");
        }
        if ((i = request.indexOf(64)) > 0) {
            platformName = request.substring(i + 1);
            request = request.substring(0, i);
            logger.log(Logger.FINER, "MulticastMainDetectionListener::serveGetMain(): request is for platform \"" + platformName + "\"");
        }
        String myPlatform = this.profile.getParameter("platform-id", null);
        if (platformName != null && !platformName.equals(myPlatform)) {
            logger.log(Logger.FINER, "MulticastMainDetectionListener::serveGetMain(): my platform is \"" + myPlatform + "\" while request is for platform \"" + platformName + "\" --> Do not reply");
            return null;
        }
        List addresses = this.manager.getLocalAddresses();
        ArrayList responseAddresses = new ArrayList(addresses.size());
        Iterator iter = addresses.iterator();
        while (iter.hasNext()) {
            addr = (TransportAddress)iter.next();
            if (proto != null) {
                if (!proto.equals(addr.getProto())) continue;
                responseAddresses.add(addr);
                break;
            }
            responseAddresses.add(addr);
        }
        if (responseAddresses.size() < 1) {
            response = this.errorResponse("404 Not Found", "Cannot manage protocol " + proto);
        } else {
            response = "200 OK ";
            iter = responseAddresses.iterator();
            while (iter.hasNext()) {
                addr = (TransportAddress)iter.next();
                response = response + addr.getProto() + ":" + addr.getHost() + ":" + addr.getPort();
                if (!iter.hasNext()) continue;
                response = response + ";";
            }
        }
        return response;
    }

    private String executeRequest(String request) throws Exception {
        logger.log(Logger.FINER, "MulticastMainDetectionListener::executeRequest(request=\"" + request + "\")");
        String result = null;
        if (request.indexOf("get-main") == 0) {
            if (this.profile.isMasterMain()) {
                result = this.serveGetMain(request);
            } else {
                logger.log(Logger.FINER, "MulticastMainDetectionListener::executeRequest(): I'm not master --> Do not reply");
            }
        } else {
            if (request.indexOf("ping") == 0) {
                throw new Exception("Command not implemented yet");
            }
            throw new Exception("Command not implemented");
        }
        return result;
    }

    private String manageRequest(byte[] requestBuffer) {
        logger.log(Logger.FINER, "MulticastMainDetectionListener::manageRequest(...)");
        String result = null;
        String request = MainDetectionManager.decodeData(requestBuffer);
        if (request == null) {
            throw new RuntimeException("Error decoding request");
        }
        try {
            logger.log(Logger.FINER, "MulticastMainDetectionListener::manageRequest(): request.length()=" + request.length());
            if (request.length() <= " MJADE/1.0".length()) {
                throw new Exception("Bad request [request=\"" + request + "\"");
            }
            int i = MainDetectionManager.checkProtocolVersion(request);
            request = request.substring(0, i);
            result = this.executeRequest(request);
        }
        catch (Exception e2) {
            throw new RuntimeException("Error managing request \"" + request + "\"", e2);
        }
        return result;
    }

    public void run() {
        block12: {
            logger.log(Logger.FINE, "MulticastMainDetectionListener::run()");
            try {
                this.active = true;
                while (true) {
                    try {
                        while (true) {
                            String response;
                            byte[] buf = new byte[1024];
                            DatagramPacket packet = new DatagramPacket(buf, buf.length);
                            try {
                                this.socket.receive(packet);
                            }
                            catch (IOException ioe) {
                                if (this.active) {
                                    logger.log(Logger.SEVERE, "Error in receive()", ioe);
                                }
                                break block12;
                            }
                            logger.log(Logger.FINER, "MulticastMainDetectionListener::run(): " + packet.getLength() + " bytes received");
                            try {
                                response = this.manageRequest(packet.getData());
                            }
                            catch (Exception e2) {
                                logger.log(Logger.WARNING, "MulticastMainDetectionListener::run(): error managing request", e2);
                                response = this.errorResponse("500 Internal Server Error", e2.getMessage());
                            }
                            if (response != null) {
                                response = response + " MJADE/1.0";
                                buf = response.getBytes("ISO-8859-1");
                                InetAddress clientAddr = packet.getAddress();
                                int responsePort = packet.getPort();
                                packet = new DatagramPacket(buf, buf.length, clientAddr, responsePort);
                                logger.log(Logger.FINER, "MulticastMainDetectionListener::run(): sending response \"" + response + "\" to " + clientAddr + ":" + responsePort);
                                this.socket.send(packet);
                                continue;
                            }
                            logger.log(Logger.FINE, "MulticastMainDetectionListener::run(): discarded request, sending no response");
                        }
                    }
                    catch (IOException ioe) {
                        logger.log(Logger.WARNING, "Input-output error", ioe);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e3) {
                logger.log(Logger.SEVERE, "Error in listener thread, MulticastMainDetectionListener is no more active", e3);
            }
        }
    }
}

