/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentToolkit;
import jade.core.BackEndWrapper;
import jade.core.CaseInsensitiveString;
import jade.core.ContainerID;
import jade.core.FEListener;
import jade.core.FEService;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.MicroRuntime;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.ServiceNotActiveException;
import jade.core.Specifier;
import jade.core.TimerDispatcher;
import jade.core.behaviours.Behaviour;
import jade.core.event.ContainerEvent;
import jade.core.event.JADEEvent;
import jade.lang.acl.ACLMessage;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.ObjectManager;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.wrapper.AgentContainer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FrontEndContainer
implements FrontEnd,
AgentToolkit,
Runnable {
    Logger logger = Logger.getMyLogger(this.getClass().getName());
    private Hashtable localAgents = new Hashtable(1);
    private Hashtable localServices = new Hashtable(1);
    private Vector feListeners = new Vector();
    private ContainerID myId;
    Vector platformAddresses;
    private AID amsAID;
    private AID dfAID;
    private Vector pending;
    private Vector senderAgents;
    private BackEndWrapper myBackEnd;
    private Properties configProperties;
    private boolean exiting = false;
    private boolean starting = true;

    FrontEndContainer() {
    }

    void start(Properties p) {
        this.configProperties = p;
        String agents = this.configProperties.getProperty("agents");
        try {
            Vector specs = Specifier.parseSpecifierList(agents);
            Vector<Specifier> successfulAgents = new Vector<Specifier>();
            Enumeration en = specs.elements();
            while (en.hasMoreElements()) {
                Specifier s = (Specifier)en.nextElement();
                try {
                    this.localAgents.put(s.getName(), this.initAgentInstance(s.getName(), s.getClassName(), s.getArgs()));
                    successfulAgents.addElement(s);
                }
                catch (Throwable t) {
                    this.logger.log(Logger.SEVERE, "Exception creating agent " + t);
                }
            }
            this.configProperties.setProperty("agents", Specifier.encodeSpecifierList(successfulAgents));
        }
        catch (Exception e1) {
            this.configProperties.setProperty("agents", null);
            this.logger.log(Logger.SEVERE, "Exception parsing agent specifiers " + e1);
            e1.printStackTrace();
        }
        String feServices = this.configProperties.getProperty("services");
        String beServices = null;
        Vector svcClasses = Specifier.parseList(feServices, ';');
        Enumeration<Object> en = svcClasses.elements();
        while (en.hasMoreElements()) {
            String serviceClassName = (String)en.nextElement();
            try {
                FEService svc = (FEService)Class.forName(serviceClassName).newInstance();
                this.localServices.put(svc.getName(), svc);
                beServices = beServices != null ? beServices + ';' + svc.getBEServiceClassName() : svc.getBEServiceClassName();
            }
            catch (Throwable t) {
                this.logger.log(Logger.SEVERE, "Exception creating service " + t);
            }
        }
        if (beServices != null) {
            this.configProperties.setProperty("be-required-services", beServices);
        }
        this.manageProtoOption(this.configProperties);
        try {
            this.myBackEnd = new BackEndWrapper(this, this.configProperties);
            String startupTag = System.getProperty("startup-tag");
            if (startupTag != null) {
                System.out.println(startupTag + " " + this.myId);
            }
            this.logger.log(Logger.INFO, "--------------------------------------\nAgent container " + this.myId.getName() + " is ready.\n--------------------------------------------");
        }
        catch (IMTPException imtpe) {
            this.logger.log(Logger.SEVERE, "IMTP error " + imtpe);
            imtpe.printStackTrace();
            MicroRuntime.handleTermination(true);
            return;
        }
        catch (Exception e2) {
            this.logger.log(Logger.SEVERE, "Unexpected error " + e2);
            e2.printStackTrace();
            MicroRuntime.handleTermination(true);
            return;
        }
        en = this.localServices.elements();
        while (en.hasMoreElements()) {
            FEService svc = (FEService)en.nextElement();
            svc.init(this.myBackEnd);
        }
        agents = this.configProperties.getProperty("agents");
        try {
            Vector specs = Specifier.parseSpecifierList(agents);
            Enumeration e3 = specs.elements();
            while (e3.hasMoreElements()) {
                Specifier sp = (Specifier)e3.nextElement();
                Agent a = (Agent)this.localAgents.remove(sp.getName());
                if (a != null) {
                    Object[] args = sp.getArgs();
                    if (args != null && args.length > 0) {
                        this.logger.log(Logger.SEVERE, "Error starting agent " + sp.getName() + ". " + sp.getClassName() + " " + args[0]);
                        continue;
                    }
                    String actualName = sp.getClassName();
                    this.activateAgent(actualName, a);
                    continue;
                }
                this.logger.log(Logger.WARNING, "Agent " + sp.getName() + " not found locally.");
            }
        }
        catch (Exception e1) {
            this.logger.log(Logger.SEVERE, "Exception parsing agent specifiers " + e1);
            e1.printStackTrace();
        }
        this.configProperties.remove("agents");
        this.notifyStarted();
    }

    private void manageProtoOption(Properties pp) {
        String proto = pp.getProperty("proto");
        if (proto != null) {
            if (CaseInsensitiveString.equalsIgnoreCase("socket", proto)) {
                pp.setProperty("connection-manager", "jade.imtp.leap.JICP.FrontEndDispatcher");
            } else if (CaseInsensitiveString.equalsIgnoreCase("ssl", proto)) {
                pp.setProperty("connection-manager", "jade.imtp.leap.JICP.FrontEndSDispatcher");
            } else if (CaseInsensitiveString.equalsIgnoreCase("http", proto)) {
                pp.setProperty("connection-manager", "jade.imtp.leap.http.HTTPFEDispatcher");
                pp.setProperty("mediator-class", "jade.imtp.leap.nio.NIOHTTPBEDispatcher");
            } else if (CaseInsensitiveString.equalsIgnoreCase("https", proto)) {
                pp.setProperty("connection-manager", "jade.imtp.leap.http.HTTPFESDispatcher");
                pp.setProperty("mediator-class", "jade.imtp.leap.nio.NIOHTTPBEDispatcher");
            }
        }
    }

    void detach() {
        this.myBackEnd.detach();
    }

    void addListener(FEListener l) {
        if (!this.feListeners.contains(l)) {
            this.feListeners.add(l);
        }
    }

    void removeListener(FEListener l) {
        this.feListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(JADEEvent ev) {
        Vector vector = this.feListeners;
        synchronized (vector) {
            for (int i = 0; i < this.feListeners.size(); ++i) {
                FEListener l = (FEListener)this.feListeners.get(i);
                l.handleEvent(ev);
            }
        }
    }

    final Agent getLocalAgent(String localName) {
        return (Agent)this.localAgents.get(localName);
    }

    public final void createAgent(String name, String className, String[] args) throws IMTPException {
        try {
            Agent a = this.initAgentInstance(name, className, args);
            String newName = this.myBackEnd.bornAgent(name);
            this.activateAgent(newName, a);
        }
        catch (Exception e2) {
            String msg = "Exception creating new agent. ";
            this.logger.log(Logger.SEVERE, msg + e2);
            throw new IMTPException(msg, e2);
        }
    }

    public final void createAgent(String name, String className, Object[] args) throws IMTPException {
        try {
            Agent a = this.initAgentInstance(name, className, args);
            String newName = this.myBackEnd.bornAgent(name);
            this.activateAgent(newName, a);
        }
        catch (Exception e2) {
            String msg = "Exception creating new agent. ";
            this.logger.log(Logger.SEVERE, msg + e2);
            throw new IMTPException(msg, e2);
        }
    }

    public final void killAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            System.out.println("FrontEndContainer killing: " + name + " NOT FOUND");
            throw new NotFoundException("KillAgent failed to find " + name);
        }
        agent.doDelete();
    }

    public final void suspendAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            throw new NotFoundException("SuspendAgent failed to find " + name);
        }
        agent.doSuspend();
    }

    public final void resumeAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            throw new NotFoundException("ResumeAgent failed to find " + name);
        }
        agent.doActivate();
    }

    public final void messageIn(ACLMessage msg, String receiver) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        if (receiver != null) {
            Agent agent = (Agent)this.localAgents.get(receiver);
            if (agent == null) {
                throw new NotFoundException("Receiver " + receiver + " not found");
            }
            agent.postMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exit(boolean self) throws IMTPException {
        if (!this.exiting) {
            this.waitUntilStarted();
            this.exiting = true;
            this.logger.log(Logger.INFO, "Container shut down activated");
            Vector toBeKilled = new Vector();
            Hashtable hashtable = this.localAgents;
            synchronized (hashtable) {
                Enumeration e2 = this.localAgents.elements();
                while (e2.hasMoreElements()) {
                    toBeKilled.addElement(e2.nextElement());
                }
            }
            Enumeration e3 = toBeKilled.elements();
            while (e3.hasMoreElements()) {
                Agent a = (Agent)e3.nextElement();
                a.doDelete();
                a.join();
                a.resetToolkit();
            }
            this.localAgents.clear();
            this.logger.log(Logger.FINE, "Local agents terminated");
            this.myBackEnd.detach();
            this.logger.log(Logger.FINE, "Connection manager closed");
            MicroRuntime.handleTermination(self);
            TimerDispatcher.getTimerDispatcher().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void synch() throws IMTPException {
        Hashtable hashtable = this.localAgents;
        synchronized (hashtable) {
            Enumeration e2 = this.localAgents.keys();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                this.logger.log(Logger.INFO, "Resynching agent " + name);
                try {
                    this.myBackEnd.bornAgent(name);
                }
                catch (IMTPException imtpe) {
                    this.logger.log(Logger.WARNING, "IMTPException resynching. " + imtpe);
                    throw imtpe;
                }
                catch (Exception ex) {
                    this.logger.log(Logger.SEVERE, "Exception resynching agent " + name + ". " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    private synchronized void waitUntilStarted() {
        try {
            while (this.starting) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void notifyStarted() {
        this.starting = false;
        this.notifyAll();
    }

    public AgentContainer getContainerController(JADEPrincipal principal, Credentials credentials) {
        return null;
    }

    public final Location here() {
        return this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleEnd(AID agentID) {
        String name = agentID.getLocalName();
        if (this.pending != null) {
            Vector vector = this.pending;
            synchronized (vector) {
                while (this.senderAgents.contains(name)) {
                    try {
                        this.pending.wait();
                    }
                    catch (Exception e2) {}
                }
            }
        }
        this.notifyListeners(new ContainerEvent(2, agentID, this.myId));
        if (!this.exiting) {
            try {
                this.localAgents.remove(name);
                this.myBackEnd.deadAgent(name);
                if ("true".equals(this.configProperties.getProperty("exitwhenempty")) && this.localAgents.isEmpty()) {
                    this.exit(true);
                }
            }
            catch (IMTPException re) {
                this.logger.log(Logger.SEVERE, re.toString());
            }
        }
    }

    public final void handleChangedAgentState(AID agentID, int from, int to) {
    }

    public final void handleSend(ACLMessage msg, AID sender, boolean needClone) {
        Iterator it = msg.getAllIntendedReceiver();
        boolean hasRemoteReceivers = false;
        while (it.hasNext()) {
            AID id = (AID)it.next();
            Agent a = (Agent)this.localAgents.get(id.getLocalName());
            if (a != null) {
                ACLMessage m = (ACLMessage)msg.clone();
                a.postMessage(m);
                continue;
            }
            hasRemoteReceivers = true;
        }
        if (hasRemoteReceivers) {
            this.post(msg, sender.getLocalName());
        }
    }

    public final void setPlatformAddresses(AID id) {
        id.clearAllAddresses();
        for (int i = 0; i < this.platformAddresses.size(); ++i) {
            id.addAddresses((String)this.platformAddresses.elementAt(i));
        }
    }

    public final AID getAMS() {
        return this.amsAID;
    }

    public final AID getDefaultDF() {
        return this.dfAID;
    }

    public String getProperty(String key, String aDefault) {
        String ret = this.configProperties.getProperty(key);
        return ret != null ? ret : aDefault;
    }

    public Properties getBootProperties() {
        return null;
    }

    public void handleMove(AID agentID, Location where) throws JADESecurityException, IMTPException, NotFoundException {
    }

    public void handleClone(AID agentID, Location where, String newName) throws JADESecurityException, IMTPException, NotFoundException {
    }

    public void handleSave(AID agentID, String repository) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handleReload(AID agentID, String repository) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handleFreeze(AID agentID, String repository, ContainerID bufferContainer) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handlePosted(AID agentID, ACLMessage msg) {
    }

    public void handleReceived(AID agentID, ACLMessage msg) {
    }

    public void handleBehaviourAdded(AID agentID, Behaviour b) {
    }

    public void handleBehaviourRemoved(AID agentID, Behaviour b) {
    }

    public void handleChangeBehaviourState(AID agentID, Behaviour b, String from, String to) {
    }

    public ServiceHelper getHelper(Agent a, String serviceName) throws ServiceException {
        FEService svc = (FEService)this.localServices.get(serviceName);
        if (svc != null) {
            return svc.getHelper(a);
        }
        throw new ServiceNotActiveException(serviceName);
    }

    final void initInfo(Properties pp) {
        this.myId = new ContainerID(pp.getProperty("container-name"), null);
        AID.setPlatformID(pp.getProperty("platform-id"));
        this.platformAddresses = Specifier.parseList(pp.getProperty("addresses"), ';');
        this.amsAID = new AID("ams", false);
        this.setPlatformAddresses(this.amsAID);
        this.dfAID = new AID("df", false);
        this.setPlatformAddresses(this.dfAID);
    }

    private final Agent initAgentInstance(String name, String className, Object[] args) throws Exception {
        Agent agent = null;
        agent = (Agent)ObjectManager.load(className, "agent");
        if (agent == null) {
            agent = (Agent)Class.forName(className).newInstance();
        }
        agent.setArguments(args);
        agent.setToolkit(this);
        agent.initMessageQueue();
        return agent;
    }

    private void activateAgent(String name, Agent a) {
        this.localAgents.put(name, a);
        AID id = new AID(name, false);
        this.notifyListeners(new ContainerEvent(1, id, this.myId));
        a.powerUp(id, new Thread(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(ACLMessage msg, String sender) {
        if (this.pending == null) {
            this.pending = new Vector(4);
            this.senderAgents = new Vector(1);
            Thread t = new Thread(this);
            t.start();
        }
        Vector vector = this.pending;
        synchronized (vector) {
            if (!this.senderAgents.contains(sender)) {
                this.senderAgents.addElement(sender);
            }
            this.pending.addElement(msg.clone());
            this.pending.addElement(sender);
            int size = this.pending.size();
            if (size > 100 && size < 110) {
                this.logger.log(Logger.INFO, size + " pending messages");
            }
            this.pending.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ACLMessage msg = null;
        String sender = null;
        while (true) {
            Vector vector = this.pending;
            synchronized (vector) {
                while (this.pending.size() == 0) {
                    try {
                        this.pending.wait();
                    }
                    catch (InterruptedException ie) {
                        this.logger.log(Logger.SEVERE, ie.toString());
                    }
                }
                msg = (ACLMessage)this.pending.elementAt(0);
                sender = (String)this.pending.elementAt(1);
                this.pending.removeElementAt(1);
                this.pending.removeElementAt(0);
            }
            try {
                this.myBackEnd.messageOut(msg, sender);
            }
            catch (Exception e2) {
                this.logger.log(Logger.SEVERE, "Error delivering message.", e2);
                MicroRuntime.notifyFailureToSender(msg, sender, e2.getMessage());
            }
            vector = this.pending;
            synchronized (vector) {
                if (!this.pending.contains(sender)) {
                    this.senderAgents.removeElement(sender);
                    this.pending.notifyAll();
                }
            }
        }
    }
}

