/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsObject;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;
import jade.content.schema.facets.CardinalityFacet;
import jade.content.schema.facets.TypedAggregateFacet;
import jade.core.CaseInsensitiveString;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ObjectSchemaImpl
extends ObjectSchema {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    static final String RESULT_SLOT_NAME = "__Result_SLOT_123";
    private String typeName = null;
    private Hashtable slots;
    private Vector slotNames;
    private Vector superSchemas;
    private Hashtable facets;

    private ObjectSchemaImpl() {
        this("Object");
    }

    protected ObjectSchemaImpl(String typeName) {
        this.typeName = typeName;
    }

    protected void add(String name, ObjectSchema slotSchema, int optionality) {
        CaseInsensitiveString ciName = new CaseInsensitiveString(name);
        if (this.slots == null) {
            this.slots = new Hashtable();
            this.slotNames = new Vector();
        }
        if (this.slots.put(ciName, new SlotDescriptor(name, slotSchema, optionality)) == null && !name.equals(RESULT_SLOT_NAME)) {
            this.slotNames.addElement(ciName);
        }
    }

    protected void add(String name, ObjectSchema slotSchema) {
        this.add(name, slotSchema, 0);
    }

    protected void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax) {
        this.add(name, elementsSchema, cardMin, cardMax, "sequence");
    }

    protected void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax, String aggType) {
        int optionality = cardMin == 0 ? 1 : 0;
        this.add(name, elementsSchema, cardMin, cardMax, aggType, optionality);
    }

    protected void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax, String aggType, int optionality) {
        try {
            ObjectSchema aggTypeSchema = BasicOntology.getInstance().getSchema(aggType);
            if (aggTypeSchema == null) {
                aggTypeSchema = new AggregateSchema(aggType);
                BasicOntology.getInstance().add(aggTypeSchema);
            }
            ObjectSchema schema = null;
            schema = elementsSchema != null ? new AggregateSchema(aggType, (TermSchema)elementsSchema) : aggTypeSchema;
            this.add(name, schema, optionality);
            if (elementsSchema != null) {
                this.addFacet(name, new TypedAggregateFacet(elementsSchema));
            }
            this.addFacet(name, new CardinalityFacet(cardMin, cardMax));
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    protected void addSuperSchema(ObjectSchema superSchema) {
        if (superSchema != null) {
            if (this.superSchemas == null) {
                this.superSchemas = new Vector();
            }
            this.superSchemas.addElement(superSchema);
        }
    }

    protected void addFacet(String slotName, Facet f) throws OntologyException {
        Vector<Facet> v;
        if (this.containsSlot(slotName)) {
            CaseInsensitiveString ciName = new CaseInsensitiveString(slotName);
            if (this.facets == null) {
                this.facets = new Hashtable();
            }
            if ((v = (Vector<Facet>)this.facets.get(ciName)) == null) {
                v = new Vector<Facet>();
                this.facets.put(ciName, v);
                if (this.logger.isLoggable(Logger.CONFIG)) {
                    this.logger.log(Logger.CONFIG, "Added facet " + f + " to slot " + slotName);
                }
            }
        } else {
            throw new OntologyException(slotName + " is not a valid slot in this schema");
        }
        v.addElement(f);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getNames() {
        Vector allSlotNames = new Vector();
        this.fillAllSlotNames(allSlotNames);
        String[] names = new String[allSlotNames.size()];
        int counter = 0;
        Enumeration e2 = allSlotNames.elements();
        while (e2.hasMoreElements()) {
            names[counter++] = ((CaseInsensitiveString)e2.nextElement()).toString();
        }
        return names;
    }

    public String[] getOwnNames() {
        if (this.slotNames != null) {
            String[] ownNames = new String[this.slotNames.size()];
            int counter = 0;
            Enumeration e2 = this.slotNames.elements();
            while (e2.hasMoreElements()) {
                ownNames[counter++] = ((CaseInsensitiveString)e2.nextElement()).toString();
            }
            return ownNames;
        }
        return new String[0];
    }

    public ObjectSchema getSchema(String name) throws OntologyException {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        if (slot == null) {
            throw new OntologyException("No slot named: " + name + " in schema " + this.typeName);
        }
        return slot.schema;
    }

    public boolean containsSlot(String name) {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        return slot != null;
    }

    public boolean isOwnSlot(String name) {
        SlotDescriptor slot = this.getOwnSlot(new CaseInsensitiveString(name));
        return slot != null;
    }

    public boolean isMandatory(String name) throws OntologyException {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        if (slot == null) {
            throw new OntologyException("No slot named: " + name);
        }
        return slot.optionality == 0;
    }

    public AbsObject newInstance() throws OntologyException {
        throw new OntologyException("AbsObject cannot be instantiated");
    }

    private final void fillAllSlotNames(Vector v) {
        Enumeration e2;
        if (this.superSchemas != null) {
            e2 = this.superSchemas.elements();
            while (e2.hasMoreElements()) {
                ObjectSchemaImpl superSchema = (ObjectSchemaImpl)e2.nextElement();
                superSchema.fillAllSlotNames(v);
            }
        }
        if (this.slotNames != null) {
            e2 = this.slotNames.elements();
            while (e2.hasMoreElements()) {
                v.addElement(e2.nextElement());
            }
        }
    }

    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        this.validateSlots(abs, onto);
    }

    protected void validateSlots(AbsObject abs, Ontology onto) throws OntologyException {
        String[] slotNames = this.getNames();
        for (int i = 0; i < slotNames.length; ++i) {
            AbsObject slotValue = abs.getAbsObject(slotNames[i]);
            CaseInsensitiveString ciName = new CaseInsensitiveString(slotNames[i]);
            this.validate(ciName, slotValue, onto);
        }
    }

    private boolean validate(CaseInsensitiveString slotName, AbsObject value, Ontology onto) throws OntologyException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Validating " + (value != null ? value.toString() : "null") + " as a value for slot " + slotName);
        }
        boolean slotFound = false;
        SlotDescriptor dsc = this.getOwnSlot(slotName);
        if (dsc != null) {
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Slot " + slotName + " is defined in schema " + this);
            }
            if (value == null) {
                if (dsc.optionality == 0) {
                    throw new OntologyException("Missing value for mandatory slot " + slotName + ". Schema is " + this);
                }
                return true;
            }
            ObjectSchema s = onto.getSchema(value.getTypeName());
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Actual schema for " + value + " is " + s);
            }
            if (s == null) {
                throw new OntologyException("No schema found for type " + value.getTypeName() + ". Ontology is " + onto.getName());
            }
            if (!s.isCompatibleWith(dsc.schema)) {
                throw new OntologyException("Schema " + s + " for element " + value + " is not compatible with schema " + dsc.schema + " for slot " + slotName);
            }
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Schema " + s + " for type " + value + " is compatible with schema " + dsc.schema + " for slot " + slotName);
            }
            s.validate(value, onto);
            slotFound = true;
        } else if (this.superSchemas != null) {
            Enumeration e2 = this.superSchemas.elements();
            while (e2.hasMoreElements()) {
                ObjectSchemaImpl s = (ObjectSchemaImpl)e2.nextElement();
                if (!s.validate(slotName, value, onto)) continue;
                slotFound = true;
                break;
            }
        }
        if (slotFound && this.facets != null) {
            Vector ff = (Vector)this.facets.get(slotName);
            if (ff != null) {
                Enumeration e3 = ff.elements();
                while (e3.hasMoreElements()) {
                    Facet f = (Facet)e3.nextElement();
                    if (this.logger.isLoggable(Logger.CONFIG)) {
                        this.logger.log(Logger.CONFIG, "Checking facet " + f + " defined on slot " + slotName);
                    }
                    f.validate(value, onto);
                }
            } else if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "No facets for slot " + slotName);
            }
        }
        return slotFound;
    }

    public boolean isCompatibleWith(ObjectSchema s) {
        if (this.equals(s)) {
            return true;
        }
        if (this.isSubSchemaOf(s)) {
            return true;
        }
        return this.descendsFrom(s);
    }

    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            return s.equals(ObjectSchemaImpl.getBaseSchema());
        }
        return false;
    }

    private boolean isSubSchemaOf(ObjectSchema s) {
        if (this.superSchemas != null) {
            Enumeration e2 = this.superSchemas.elements();
            while (e2.hasMoreElements()) {
                ObjectSchemaImpl s1 = (ObjectSchemaImpl)e2.nextElement();
                if (s1.equals(s)) {
                    return true;
                }
                if (!s1.isSubSchemaOf(s)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.getTypeName();
    }

    public boolean equals(Object o) {
        if (o != null) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public ObjectSchema[] getSuperSchemas() {
        ObjectSchema[] ss = null;
        if (this.superSchemas != null) {
            ss = new ObjectSchema[this.superSchemas.size()];
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = (ObjectSchema)this.superSchemas.elementAt(i);
            }
        } else {
            ss = new ObjectSchema[]{};
        }
        return ss;
    }

    public Facet[] getFacets(String slotName) {
        Vector v = this.getAllFacets(slotName);
        Facet[] ff = null;
        if (v != null) {
            ff = new Facet[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                ff[i] = (Facet)v.elementAt(i);
            }
        }
        return ff;
    }

    Vector getAllFacets(String slotName) {
        Vector v;
        Vector allFacets = new Vector();
        CaseInsensitiveString caseInsensitiveSlotName = new CaseInsensitiveString(slotName);
        if (this.facets != null && (v = (Vector)this.facets.get(caseInsensitiveSlotName)) != null) {
            this.addAll(allFacets, v);
        }
        boolean found = false;
        if (this.getOwnSlot(caseInsensitiveSlotName) == null) {
            if (this.superSchemas != null) {
                for (int i = 0; i < this.superSchemas.size(); ++i) {
                    ObjectSchemaImpl superSchema = (ObjectSchemaImpl)this.superSchemas.elementAt(i);
                    if (!superSchema.containsSlot(slotName)) continue;
                    found = true;
                    this.addAll(allFacets, superSchema.getAllFacets(slotName));
                }
            }
        } else {
            found = true;
        }
        return found ? allFacets : null;
    }

    private final void addAll(Vector v1, Vector v2) {
        for (int i = 0; i < v2.size(); ++i) {
            v1.addElement(v2.elementAt(i));
        }
    }

    private final SlotDescriptor getOwnSlot(CaseInsensitiveString ciName) {
        return this.slots != null ? (SlotDescriptor)this.slots.get(ciName) : null;
    }

    private final SlotDescriptor getSlot(CaseInsensitiveString ciName) {
        SlotDescriptor dsc = this.getOwnSlot(ciName);
        if (dsc == null && this.superSchemas != null) {
            ObjectSchemaImpl sc;
            for (int i = 0; i < this.superSchemas.size() && (dsc = (sc = (ObjectSchemaImpl)this.superSchemas.elementAt(i)).getSlot(ciName)) == null; ++i) {
            }
        }
        return dsc;
    }

    public boolean isAssignableFrom(ObjectSchema s) {
        if (s.isCompatibleWith(this)) {
            return true;
        }
        try {
            String[] destSlotNames = this.getNames();
            for (int i = 0; i < destSlotNames.length; ++i) {
                String destSlotName = destSlotNames[i];
                ObjectSchema destSchema = this.getSchema(destSlotName);
                try {
                    ObjectSchema srcSchema = s.getSchema(destSlotName);
                    if (destSchema.isAssignableFrom(srcSchema)) continue;
                    return false;
                }
                catch (OntologyException e2) {
                    if (!this.isMandatory(destSlotName)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (OntologyException e3) {
            return false;
        }
    }

    static {
        baseSchema = new ObjectSchemaImpl();
    }

    private class SlotDescriptor
    implements Serializable {
        private String name = null;
        private ObjectSchema schema = null;
        private int optionality = 0;

        private SlotDescriptor(String name, ObjectSchema schema, int optionality) {
            this.name = name;
            this.schema = schema;
            this.optionality = optionality;
        }
    }
}

