/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.Term;
import jade.util.leap.List;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;

class SlotAccessData
implements Serializable {
    Class type;
    transient Method getter;
    transient Method setter;
    boolean aggregate;
    boolean mandatory;
    boolean manageAsSerializable;
    Class aggregateClass;
    int cardMin;
    int cardMax;
    Object defaultValue;
    String regex;
    String[] permittedValues;
    String documentation;
    Class declaringClass;
    String getterName;
    String setterName;

    SlotAccessData(Class type, Method getter, Method setter, boolean mandatory, Class aggregateClass, int cardMin, int cardMax, Object defaultValue, String regex, String[] permittedValues, String documentation, boolean manageAsSerializable) {
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        this.aggregate = SlotAccessData.isAggregate(type);
        this.mandatory = mandatory;
        this.manageAsSerializable = manageAsSerializable;
        this.aggregateClass = aggregateClass;
        this.cardMin = cardMin;
        this.cardMax = cardMax;
        this.defaultValue = defaultValue;
        this.regex = regex;
        this.permittedValues = permittedValues;
        this.documentation = documentation;
        this.declaringClass = getter.getDeclaringClass();
        this.getterName = getter.getName();
        this.setterName = setter.getName();
    }

    boolean isTypized() {
        return this.type != null && this.type != Object.class && this.type != Term.class;
    }

    static boolean isAggregate(Class clazz) {
        return clazz.isArray() && clazz != byte[].class || Collection.class.isAssignableFrom(clazz) || jade.util.leap.Collection.class.isAssignableFrom(clazz);
    }

    static boolean isSequence(Class clazz) {
        return clazz.isArray() && clazz != byte[].class || java.util.List.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz);
    }

    static boolean isSet(Class clazz) {
        return Set.class.isAssignableFrom(clazz) || jade.util.leap.Set.class.isAssignableFrom(clazz);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SlotAccessData {");
        sb.append("type=");
        sb.append(this.type.getName());
        sb.append(" getter=");
        sb.append(this.getter.getName());
        sb.append(" setter=");
        sb.append(this.setter.getName());
        sb.append(" aggregate=");
        sb.append(this.aggregate);
        sb.append(" aggregateClass=");
        sb.append(this.aggregateClass != null ? this.aggregateClass.getName() : null);
        sb.append(" mandatory=");
        sb.append(this.mandatory);
        sb.append(" cardMin=");
        sb.append(this.cardMin);
        sb.append(" cardMax=");
        sb.append(this.cardMax);
        if (this.defaultValue != null) {
            sb.append(" defaultValue=");
            sb.append(this.defaultValue);
        }
        if (this.regex != null) {
            sb.append(" regex=");
            sb.append(this.regex);
        }
        if (this.permittedValues != null) {
            sb.append(" permittedValues=");
            sb.append(this.permittedValues);
        }
        sb.append('}');
        return sb.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.getter = this.declaringClass.getMethod(this.getterName, null);
            this.setter = this.declaringClass.getMethod(this.setterName, this.type);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new IOException("Error deserializing ontology associated to class " + this.declaringClass);
        }
    }
}

