/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsConcept;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.schema.ConceptSchema;
import jade.content.schema.PrimitiveSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;

public class SerializableOntology
extends Ontology {
    private static final SerializableOntology theInstance = new SerializableOntology();
    public static final String SERIALIZABLE = "serializable";
    public static final String SERIALIZABLE_VALUE = "value";
    private ClassLoader myClassLoader;

    public static Ontology getInstance() {
        return theInstance;
    }

    private SerializableOntology() {
        super("Serializable-ontology", (Ontology)null, null);
        try {
            PrimitiveSchema stringSchema = (PrimitiveSchema)BasicOntology.getInstance().getSchema("BO_String");
            this.add(stringSchema);
            ConceptSchema serializableSchema = new ConceptSchema(SERIALIZABLE);
            serializableSchema.add(SERIALIZABLE_VALUE, stringSchema);
            this.add(serializableSchema);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setClassLoader(ClassLoader cl) {
        this.myClassLoader = cl;
    }

    protected Object toObject(AbsObject abs, String lcType, Ontology globalOnto) throws UnknownSchemaException, UngroundedException, OntologyException {
        if (SERIALIZABLE.equals(abs.getTypeName())) {
            try {
                AbsPrimitive absValue = (AbsPrimitive)abs.getAbsObject(SERIALIZABLE_VALUE);
                String stringValue = absValue.getString();
                byte[] value = Base64.decodeBase64((byte[])stringValue.getBytes("US-ASCII"));
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(value)){

                    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
                        if (SerializableOntology.this.myClassLoader != null) {
                            return Class.forName(v.getName(), true, SerializableOntology.this.myClassLoader);
                        }
                        return super.resolveClass(v);
                    }
                };
                return in.readObject();
            }
            catch (Throwable t) {
                throw new OntologyException("Error in object deserialization.", t);
            }
        }
        throw new OntologyException("Abs-object " + abs + " is not serializable");
    }

    protected AbsObject fromObject(Object obj, Ontology globalOnto) throws UnknownSchemaException, OntologyException {
        if (obj instanceof AbsObject) {
            return (AbsObject)obj;
        }
        if (obj instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(baos);
                out.writeObject(obj);
                AbsConcept absSerializable = new AbsConcept(SERIALIZABLE);
                String stringValue = new String(Base64.encodeBase64((byte[])baos.toByteArray()), "US-ASCII");
                absSerializable.set(SERIALIZABLE_VALUE, stringValue);
                return absSerializable;
            }
            catch (Throwable t) {
                throw new OntologyException("Error in object serialization.", t);
            }
        }
        throw new OntologyException("Object " + obj + " is not serializable");
    }

    private Object writeReplace() throws ObjectStreamException {
        return new DummySerializableOntology();
    }

    private static class DummySerializableOntology
    implements Serializable {
        private DummySerializableOntology() {
        }

        private Object readResolve() throws ObjectStreamException {
            return SerializableOntology.getInstance();
        }
    }
}

