/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObjectImpl;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.sl.ParseException;
import jade.content.lang.sl.SLCodec;
import jade.content.lang.sl.SLParserConstants;
import jade.content.lang.sl.SLParserTokenManager;
import jade.content.lang.sl.SimpleCharStream;
import jade.content.lang.sl.Token;
import jade.content.lang.sl.TokenMgrError;
import jade.content.onto.Ontology;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

class SLParser
implements SLParserConstants {
    private static final String META_EXCEPTION_MESSAGE = "Meta SL expressions are not allowed";
    private boolean metaAllowed = true;
    Ontology curOntology = null;
    int slType = 3;
    public SLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    private String unescape(String s) {
        StringBuffer result = new StringBuffer(s.length());
        for (int i = 1; i < s.length() - 1; ++i) {
            if (s.charAt(i) == '\\' && s.charAt(i + 1) == '\"') {
                result.append("\"");
                ++i;
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    private AbsTerm toAbsAgentAction(AbsTerm t) {
        if (t instanceof AbsConcept && !(t instanceof AbsAgentAction)) {
            AbsAgentAction act = new AbsAgentAction(t.getTypeName());
            String[] slotNames = t.getNames();
            if (slotNames != null) {
                for (int i = 0; i < slotNames.length; ++i) {
                    act.set(slotNames[i], (AbsTerm)t.getAbsObject(slotNames[i]));
                }
            }
            return act;
        }
        return t;
    }

    void setSLType(int slType) {
        this.slType = slType;
    }

    void reinit(Ontology o, String content) {
        this.curOntology = o;
        if (content == null) {
            content = new String();
        }
        this.ReInit(new StringReader(content));
    }

    AbsContentElement parse(Ontology o, String content) throws ParseException, TokenMgrError {
        this.reinit(o, content);
        AbsContentElementList tuple = this.Content();
        if (tuple.size() > 1) {
            return tuple;
        }
        return tuple.get(0);
    }

    public static void main(String[] args) {
        SLParser theParser = null;
        try {
            theParser = new SLParser(System.in);
            theParser.setSLType(Integer.parseInt(args[0]));
        }
        catch (Exception e2) {
            System.out.println("usage: SLParser SLLevel\n  where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL");
            System.exit(0);
        }
        if (theParser.slType < 3) {
            System.out.println("SL-" + theParser.slType + " Parser Started ...");
        } else {
            System.out.println("Full-SL Parser Started ...");
        }
        SLCodec codec = new SLCodec();
        while (true) {
            System.out.println("insert an SL expression to parse: ");
            try {
                AbsContentElementList result = theParser.Content();
                String resultEncoded = codec.encode(result);
                System.out.println("\n\n RESULT of SLParser.Content()=\n" + resultEncoded);
                AbsContentElement result2 = codec.decode(resultEncoded);
                System.out.println("\n\n RESULT of SLCodec.decode(SLCodec.encode(SLParser.Content()))=\n" + codec.encode(result2));
                System.out.println("\n\n");
                continue;
            }
            catch (Exception pe) {
                pe.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public final AbsContentElementList Content() throws ParseException {
        AbsContentElementList tuple = new AbsContentElementList();
        this.LBrace();
        block3: while (true) {
            AbsContentElement val = this.ContentExpression();
            tuple.add(val);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 12: 
                case 13: 
                case 18: 
                case 23: 
                case 34: 
                case 35: 
                case 36: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        this.RBrace();
        return tuple;
    }

    public final void LBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void RBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final AbsContentElement ContentExpression() throws ParseException {
        AbsContentElement val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                String s = this.String();
                val = new AbsPredicate(s);
                break;
            }
            case 5: 
            case 23: {
                this.LBrace();
                val = this.ContentExpression_NoBrace();
                this.RBrace();
                break;
            }
            case 18: 
            case 36: {
                String s = this.MetaSymbol();
                AbsPredicate val1 = new AbsPredicate(s);
                val1.setIsMetaFormula(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        val.setIsAContentExpression(true);
        return val;
    }

    public final AbsContentElement ContentExpression_NoBrace() throws ParseException {
        AbsObjectImpl val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                val = this.IdentifyingExpression_NoBrace();
                break;
            }
            case 25: 
            case 30: {
                val = this.ActionExpression_NoBrace();
                break;
            }
            case 12: 
            case 13: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                val = this.Wff_NoBrace();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsIRE IdentifyingExpression_NoBrace() throws ParseException {
        AbsIRE ire = null;
        Token t = this.jj_consume_token(26);
        if (this.slType < 2) {
            throw new ParseException("NotFullSL_IdentifyExpression_NotParsable_UseAtLeastSL2");
        }
        AbsTerm term = this.Term();
        AbsPredicate prop = this.Wff();
        ire = new AbsIRE(t.image);
        ire.setTerm(term);
        ire.setProposition(prop);
        return ire;
    }

    public final AbsVariable Variable() throws ParseException {
        AbsVariable val = null;
        Token v = this.jj_consume_token(7);
        val = new AbsVariable();
        val.setName(v.image.substring(1));
        return val;
    }

    public final AbsTerm Term() throws ParseException {
        AbsTerm val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                val = this.Variable();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 34: 
            case 35: {
                val = this.Constant();
                break;
            }
            case 5: 
            case 23: {
                this.LBrace();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 28: 
                    case 34: 
                    case 35: {
                        val = this.FunctionalTerm_NoBrace();
                        break;
                    }
                    case 25: 
                    case 30: {
                        val = this.ActionExpression_NoBrace();
                        break;
                    }
                    case 26: {
                        val = this.IdentifyingExpression_NoBrace();
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.RBrace();
                break;
            }
            case 18: 
            case 36: {
                String s = this.MetaSymbol();
                AbsVariable val1 = new AbsVariable();
                val1.setName(s);
                val1.setIsMetaTerm(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPrimitive Constant() throws ParseException {
        AbsPrimitive val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                String s = this.String();
                if (CaseInsensitiveString.equalsIgnoreCase(s, "true")) {
                    val = AbsPrimitive.wrap(true);
                    break;
                }
                if (CaseInsensitiveString.equalsIgnoreCase(s, "false")) {
                    val = AbsPrimitive.wrap(false);
                    break;
                }
                if (CaseInsensitiveString.equalsIgnoreCase(s, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(s, "\"false\"")) {
                    s = this.unescape(s);
                }
                val = AbsPrimitive.wrap(s);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                val = this.Number();
                break;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                try {
                    Date d = ISO8601.toDate(t.image);
                    val = AbsPrimitive.wrap(d);
                }
                catch (Exception e2) {
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                try {
                    byte[] byteArray = Base64.decodeBase64((byte[])t.image.getBytes("US-ASCII"));
                    val = AbsPrimitive.wrap(byteArray);
                    break;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new ParseException("Error decoding byte-array from Base64 US-ASCII, " + uee.getMessage());
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsConcept FunctionalTerm_NoBrace() throws ParseException {
        AbsConcept val = null;
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                Token t = this.jj_consume_token(28);
                AbsTerm term1 = this.Term();
                AbsTerm term2 = this.Term();
                val = new AbsConcept(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], term2);
                }
                catch (Exception e2) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", term2);
                }
                break;
            }
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                String s = this.String();
                if ("set".equalsIgnoreCase(s) || "sequence".equalsIgnoreCase(s)) {
                    val = new AbsAggregate(s);
                } else {
                    try {
                        val = (AbsConcept)this.curOntology.getSchema(s).newInstance();
                    }
                    catch (Exception e3) {
                        val = new AbsConcept(s);
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 23: 
                    case 34: 
                    case 35: 
                    case 36: {
                        this.FunctionalTermParameters(val);
                        break block2;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final void FunctionalTermParameters(AbsConcept val) throws ParseException {
        int slotNumber = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 34: 
            case 35: 
            case 36: {
                String[] slotNames = null;
                try {
                    slotNames = this.curOntology.getSchema(val.getTypeName()).getNames();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                block14: while (true) {
                    AbsTerm t = this.Term();
                    try {
                        val.set(slotNames[slotNumber], t);
                    }
                    catch (Exception e3) {
                        val.set(Codec.UNNAMEDPREFIX + slotNumber, t);
                    }
                    ++slotNumber;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 23: 
                        case 34: 
                        case 35: 
                        case 36: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            case 14: 
            case 15: {
                block15: while (true) {
                    this.Parameter(val);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: 
                        case 15: {
                            continue block15;
                        }
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Parameter(AbsConcept val) throws ParseException {
        String slotName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                Token t = this.jj_consume_token(14);
                slotName = t.image.substring(1);
                break;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                slotName = this.unescape(t.image.substring(1));
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AbsTerm term = this.Term();
        val.set(slotName, term);
    }

    public final AbsAgentAction ActionExpression_NoBrace() throws ParseException {
        AbsAgentAction val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                Token t = this.jj_consume_token(25);
                AbsTerm term1 = this.Term();
                AbsTerm term2 = this.Term();
                val = new AbsAgentAction(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], this.toAbsAgentAction(term2));
                }
                catch (Exception e2) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(term2));
                }
                break;
            }
            case 30: {
                Token t = this.jj_consume_token(30);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ActionOperatorExpression_NotParsable");
                }
                AbsTerm term1 = this.ActionExpression();
                AbsTerm term2 = this.ActionExpression();
                val = new AbsAgentAction(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], this.toAbsAgentAction(term2));
                }
                catch (Exception e3) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(term2));
                }
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsTerm ActionExpression() throws ParseException {
        AbsObjectImpl val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 23: {
                this.LBrace();
                val = this.ActionExpression_NoBrace();
                this.RBrace();
                break;
            }
            case 18: 
            case 36: {
                String s = this.MetaSymbol();
                AbsVariable val1 = new AbsVariable();
                val1.setName(s);
                val1.setIsMetaTerm(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPredicate Wff() throws ParseException {
        AbsPredicate val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                String s = this.String();
                val = new AbsPredicate(s);
                break;
            }
            case 5: 
            case 23: {
                this.LBrace();
                val = this.Wff_NoBrace();
                this.RBrace();
                break;
            }
            case 18: 
            case 36: {
                String s = this.MetaSymbol();
                val = new AbsPredicate(s);
                val.setIsMetaFormula(true);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPredicate Wff_NoBrace() throws ParseException {
        AbsPredicate val = null;
        String[] slotNames = null;
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                Token t = this.jj_consume_token(31);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_NotExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], arg1);
                }
                catch (Exception e2) {
                    val.set(Codec.UNNAMEDPREFIX + "0", arg1);
                }
                break;
            }
            case 32: {
                Token t = this.jj_consume_token(32);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_BinaryLogicalExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate arg1 = this.Wff();
                AbsPredicate arg2 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], arg1);
                    val.set(slotNames[1], arg2);
                }
                catch (Exception e3) {
                    val.set(Codec.UNNAMEDPREFIX + "0", arg1);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg2);
                }
                break;
            }
            case 33: {
                Token t = this.jj_consume_token(33);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_QuantifierExpression_NotParsable_UseAtLeastSL2");
                }
                AbsVariable var = this.Variable();
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], var);
                    val.set(slotNames[1], arg1);
                }
                catch (Exception e4) {
                    val.set(Codec.UNNAMEDPREFIX + "0", var);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                }
                break;
            }
            case 27: {
                Token t = this.jj_consume_token(27);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ModalOperatorExpression_NotParsable_UseAtLeastSL2");
                }
                AbsTerm term = this.Term();
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term);
                    val.set(slotNames[1], arg1);
                }
                catch (Exception e5) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                }
                break;
            }
            case 29: {
                Token t = this.jj_consume_token(29);
                AbsTerm term = this.ActionExpression();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term);
                }
                catch (Exception e6) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 12: 
                    case 13: 
                    case 18: 
                    case 23: 
                    case 34: 
                    case 35: 
                    case 36: {
                        AbsPredicate arg1 = this.Wff();
                        try {
                            val.set(slotNames[1], arg1);
                        }
                        catch (Exception e7) {
                            val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                        }
                        break block8;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                break;
            }
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                String s = this.String();
                val = new AbsPredicate(s);
                int slotNumber = 0;
                try {
                    slotNames = this.curOntology.getSchema(s).getNames();
                }
                catch (Exception e8) {
                    // empty catch block
                }
                block30: while (true) {
                    AbsTerm term = this.Term();
                    try {
                        val.set(slotNames[slotNumber], term);
                    }
                    catch (Exception e9) {
                        val.set(Codec.UNNAMEDPREFIX + slotNumber, term);
                    }
                    ++slotNumber;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 23: 
                        case 34: 
                        case 35: 
                        case 36: {
                            continue block30;
                        }
                    }
                    break;
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPrimitive Number() throws ParseException {
        AbsPrimitive val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Token t = this.jj_consume_token(8);
                try {
                    val = AbsPrimitive.wrap(Long.parseLong(t.image));
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                val = AbsPrimitive.wrap(t.image);
                break;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                try {
                    double d1 = new Double(t.image);
                    val = AbsPrimitive.wrap(d1);
                }
                catch (NumberFormatException e3) {
                    e3.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                try {
                    double d2 = new Double(t.image);
                    val = AbsPrimitive.wrap(d2);
                }
                catch (NumberFormatException e4) {
                    e4.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final String String() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                Token t = this.jj_consume_token(34);
                return t.image;
            }
            case 35: {
                Token t = this.jj_consume_token(35);
                if (CaseInsensitiveString.equalsIgnoreCase(t.image, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(t.image, "\"false\"")) {
                    return t.image;
                }
                return this.unescape(t.image);
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                return t.image;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                if (CaseInsensitiveString.equalsIgnoreCase(t.image, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(t.image, "\"false\"")) {
                    return t.image;
                }
                return this.unescape(t.image);
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String MetaSymbol() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 36: {
                t = this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.metaAllowed) {
            throw new ParseException(META_EXCEPTION_MESSAGE);
        }
        return t.image;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{8663072, 0x800020, 0x1000040, 8663072, -301977600, 1442852864, 8863648, 212736, 8912800, 0x10003000, 8863648, 49152, 8912800, 49152, 0x42000000, 8650784, 8663072, 8663072, 8863648, -1476382720, 3840, 12288, 262144};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{28, 0, 0, 28, 15, 12, 28, 12, 28, 12, 28, 0, 28, 0, 0, 16, 28, 28, 28, 15, 0, 12, 16};
    }

    public SLParser(InputStream stream) {
        this(stream, null);
    }

    public SLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
        this.token_source = new SLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SLParser(SLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[37];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 37; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SLParser.jj_la1_init_0();
        SLParser.jj_la1_init_1();
    }
}

