/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.ExtendedProperties;
import jade.util.Logger;
import jade.util.leap.Properties;

public class Boot {
    public static final String DEFAULT_FILENAME = "leap.properties";
    private static Logger logger = Logger.getMyLogger("jade.Boot");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            ProfileImpl p = null;
            if (args.length > 0) {
                if (args[0].startsWith("-")) {
                    Properties pp = Boot.parseCmdLineArgs(args);
                    if (pp == null) return;
                    p = new ProfileImpl(pp);
                } else {
                    p = new ProfileImpl(args[0]);
                }
            } else {
                p = new ProfileImpl(DEFAULT_FILENAME);
            }
            Runtime.instance().setCloseVM(true);
            if (p.getBooleanProperty("main", true)) {
                Runtime.instance().createMainContainer(p);
                return;
            } else {
                Runtime.instance().createAgentContainer(p);
            }
            return;
        }
        catch (ProfileException pe) {
            System.err.println("Error creating the Profile [" + pe.getMessage() + "]");
            pe.printStackTrace();
            Boot.printUsage();
            System.exit(-1);
            return;
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Command line arguments format error. " + iae.getMessage());
            iae.printStackTrace();
            Boot.printUsage();
            System.exit(-1);
        }
    }

    public static Properties parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        ExtendedProperties props = new ExtendedProperties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-version")) {
                    logger.log(Logger.INFO, "----------------------------------\n" + Runtime.getCopyrightNotice() + "----------------------------------------");
                    return null;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    Boot.printUsage();
                    return null;
                }
                if (args[i].equalsIgnoreCase("-container")) {
                    props.setProperty("main", "false");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-backupmain")) {
                    props.setProperty("backupmain", "true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gui")) {
                    props.setProperty("gui", "true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nomtp")) {
                    props.setProperty("nomtp", "true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-name")) {
                    if (++i < args.length) {
                        props.setProperty("platform-id", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No platform name specified after \"-name\" option");
                }
                if (args[i].equalsIgnoreCase("-mtp")) {
                    if (++i < args.length) {
                        props.setProperty("mtps", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No mtps specified after \"-mtp\" option");
                }
                if (args[i].equalsIgnoreCase("-conf")) {
                    if (++i < args.length) {
                        try {
                            props.load(args[i]);
                        }
                        catch (Exception e2) {
                            if (!logger.isLoggable(Logger.SEVERE)) continue;
                            logger.log(Logger.SEVERE, "WARNING: error loading properties from file " + args[i] + ". " + e2);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("No configuration file name specified after \"-conf\" option");
                }
                String name = args[i].substring(1);
                if (++i < args.length) {
                    props.setProperty(name, args[i]);
                    continue;
                }
                throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
            }
            if (((java.util.Properties)props).getProperty("agents") != null && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: overriding agents specification set with the \"-agents\" option");
            }
            String agents = args[i];
            props.setProperty("agents", args[i]);
            if (++i >= args.length) break;
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: ignoring command line argument " + args[i] + " occurring after agents specification");
            }
            if (agents != null && agents.indexOf(40) != -1 && !agents.endsWith(")") && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "Note that agent arguments specifications must not contain spaces");
            }
            if (args[i].indexOf(58) == -1 || !logger.isLoggable(Logger.WARNING)) break;
            logger.log(Logger.WARNING, "Note that agent specifications must be separated by a semicolon character \";\" without spaces");
            break;
        }
        if ("true".equals(((java.util.Properties)props).getProperty("nomtp")) && ((java.util.Properties)props).getProperty("mtps") != null) {
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: both \"-mtps\" and \"-nomtp\" options specified. The latter will be ignored");
            }
            props.remove("nomtp");
        }
        return props;
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -cp <classpath> jade.Boot [options] [agents]");
        System.out.println("Main options:");
        System.out.println("    -container");
        System.out.println("    -gui");
        System.out.println("    -name <platform name>");
        System.out.println("    -host <main container host>");
        System.out.println("    -port <main container port>");
        System.out.println("    -local-host <host where to bind the local server socket on>");
        System.out.println("    -local-port <port where to bind the local server socket on>");
        System.out.println("    -conf <property file to load configuration properties from>");
        System.out.println("    -services <semicolon separated list of service classes>");
        System.out.println("    -mtps <semicolon separated list of mtp-specifiers>");
        System.out.println("     where mtp-specifier = [in-address:]<mtp-class>[(comma-separated args)]");
        System.out.println("    -<property-name> <property-value>");
        System.out.println("Agents: [-agents] <semicolon separated list of agent-specifiers>");
        System.out.println("     where agent-specifier = <agent-name>:<agent-class>[(comma separated args)]");
        System.out.println();
        System.out.println("Look at the JADE Administrator's Guide for more details");
    }
}

