/*
 * Decompiled with CFR 0.152.
 */
package c4jason;

import c4jason.ToProlog;
import cartago.OpFeedbackParam;
import cartago.Tuple;
import jason.JasonException;
import jason.NoValueException;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class JavaLibrary {
    private HashMap<String, Object> currentObjects = new HashMap();
    private HashMap<Object, Atom> currentObjects_inverse = new HashMap();
    private long id = 0L;

    public boolean java_new_object(Unifier un, Term className, ListTerm arg, Term id) throws JasonException {
        if (!className.isString()) {
            throw new JasonException("Invalid class name " + className);
        }
        String clName = ((StringTerm)className).getString();
        Signature args = this.parseArg(this.getArrayFromList(arg));
        if (args == null) {
            throw new JasonException("Invalid signature ");
        }
        try {
            Class<?> cl = Class.forName(clName);
            Object[] args_value = args.getValues();
            Constructor co = JavaLibrary.lookupConstructor(cl, args.getTypes(), args_value);
            if (co == null) {
                System.out.println("NO CONSTRUCTOR FOUND FOR " + clName);
                for (int i = 0; i < args_value.length; ++i) {
                    System.out.println("Param: " + args_value[i] + " type " + args.getTypes()[i]);
                }
                throw new JasonException("Constructor not found: class " + clName);
            }
            Object obj = co.newInstance(args_value);
            return this.bindObject(un, id, obj);
        }
        catch (ClassNotFoundException ex) {
            throw new JasonException("Java class not found: " + clName);
        }
        catch (InvocationTargetException ex) {
            throw new JasonException("Invalid constructor arguments.");
        }
        catch (NoSuchMethodException ex) {
            throw new JasonException("Constructor not found: " + args.getTypes());
        }
        catch (InstantiationException ex) {
            throw new JasonException("Objects of class " + clName + " cannot be instantiated");
        }
        catch (IllegalArgumentException ex) {
            throw new JasonException("Illegal constructor arguments  " + args);
        }
        catch (IllegalAccessException ex) {
            throw new JasonException("Illegal access exception");
        }
    }

    public Object newObject(Unifier un, Term className, ListTerm arg) throws JasonException {
        if (!className.isString()) {
            throw new JasonException("Invalid class name " + className);
        }
        String clName = ((StringTerm)className).getString();
        Signature args = this.parseArg(this.getArrayFromList(arg));
        if (args == null) {
            throw new JasonException("Invalid signature ");
        }
        try {
            Class<?> cl = Class.forName(clName);
            Object[] args_value = args.getValues();
            Constructor co = JavaLibrary.lookupConstructor(cl, args.getTypes(), args_value);
            if (co == null) {
                System.out.println("NO CONSTRUCTOR FOUND FOR " + clName);
                for (int i = 0; i < args_value.length; ++i) {
                    System.out.println("Param: " + args_value[i] + " type " + args.getTypes()[i]);
                }
                throw new JasonException("Constructor not found: class " + clName);
            }
            return co.newInstance(args_value);
        }
        catch (ClassNotFoundException ex) {
            throw new JasonException("Java class not found: " + clName);
        }
        catch (InvocationTargetException ex) {
            throw new JasonException("Invalid constructor arguments.");
        }
        catch (NoSuchMethodException ex) {
            throw new JasonException("Constructor not found: " + args.getTypes());
        }
        catch (InstantiationException ex) {
            throw new JasonException("Objects of class " + clName + " cannot be instantiated");
        }
        catch (IllegalArgumentException ex) {
            throw new JasonException("Illegal constructor arguments  " + args);
        }
        catch (IllegalAccessException ex) {
            throw new JasonException("Illegal access exception");
        }
    }

    public boolean java_new_array(Unifier un, Term className, ListTerm elems, Term id) throws JasonException {
        if (!className.isString()) {
            throw new JasonException("Invalid class name " + className);
        }
        String arrayType = ((StringTerm)className).getString();
        Object[] list = this.getArrayFromList(elems);
        int nargs = list.length;
        Object newArray = null;
        try {
            String obtype = arrayType.substring(0, arrayType.length() - 2);
            if (obtype.equals("boolean")) {
                boolean[] array = new boolean[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Boolean)list[i];
                }
                newArray = array;
            } else if (obtype.equals("byte")) {
                byte[] array = new byte[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Byte)list[i];
                }
                newArray = array;
            } else if (obtype.equals("char")) {
                char[] array = new char[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = ((Character)list[i]).charValue();
                }
                newArray = array;
            } else if (obtype.equals("short")) {
                short[] array = new short[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Short)list[i];
                }
                newArray = array;
            } else if (obtype.equals("int")) {
                int[] array = new int[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Integer)list[i];
                }
                newArray = array;
            } else if (obtype.equals("long")) {
                long[] array = new long[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Long)list[i];
                }
                newArray = array;
            } else if (obtype.equals("float")) {
                float[] array = new float[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = ((Float)list[i]).floatValue();
                }
                newArray = array;
            } else if (obtype.equals("double")) {
                double[] array = new double[nargs];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Double)list[i];
                }
                newArray = array;
            } else {
                Class<?> cl = Class.forName(obtype);
                newArray = Array.newInstance(cl, nargs);
                for (int i = 0; i < list.length; ++i) {
                    Array.set(newArray, i, this.termToObject((Term)list[i]));
                }
            }
            return this.bindObject(un, id, newArray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JasonException("Java array creation failed  " + className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean java_call(Unifier un, Term objId, Term method, Term idResult) throws JasonException {
        Object obj = null;
        Signature args = null;
        String methodName = null;
        String forceClassName = null;
        try {
            methodName = method.isAtom() ? ((Atom)method).getFunctor() : ((Structure)method).getFunctor();
            args = this.parseArg(method);
            if (args == null) {
                return false;
            }
            Object res = null;
            if (objId.isAtom()) {
                String objName = ((Atom)objId).getFunctor();
                HashMap<String, Object> hashMap = this.currentObjects;
                synchronized (hashMap) {
                    obj = this.currentObjects.get(objName);
                }
                if (obj == null) throw new JasonException("Method not found: " + methodName + "( signature: " + args + " )");
                Class<?> cl = null;
                cl = forceClassName == null ? obj.getClass() : Class.forName(forceClassName);
                Object[] args_values = args.getValues();
                Method m = JavaLibrary.lookupMethod(cl, methodName, args.getTypes(), args_values);
                if (m == null) throw new JasonException("Method not found: " + methodName + "( signature: " + args + " )");
                try {
                    res = m.invoke(obj, args_values);
                }
                catch (IllegalAccessException ex) {
                    throw new JasonException("Method invocation failed: " + methodName + "( signature: " + args + " )");
                }
            }
            if (!objId.isString()) throw new JasonException("Invalid target: " + objId);
            try {
                Class<?> cl = Class.forName(((StringTerm)objId).getString());
                Method m = cl.getMethod(methodName, args.getTypes());
                res = m.invoke(null, args.getValues());
            }
            catch (ClassNotFoundException ex) {
                throw new JasonException("Class not found: " + objId);
            }
            if (idResult == null) return true;
            return this.parseResult(un, idResult, res);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw new JasonException("Method failed: " + methodName + " - ( signature: " + args + " ) - Original Exception: " + ex.getTargetException());
        }
        catch (NoSuchMethodException ex) {
            throw new JasonException("Method not found: " + methodName + " - ( signature: " + args + " )");
        }
        catch (IllegalArgumentException ex) {
            throw new JasonException("Invalid arguments " + args + " - ( method: " + methodName + " )");
        }
        catch (Exception ex) {
            throw new JasonException("Generic error in method invocation " + methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean javaArrayToList(Unifier un, Atom objId, Term idResult) throws JasonException {
        try {
            String objName = objId.getFunctor();
            Object obj = null;
            HashMap<String, Object> hashMap = this.currentObjects;
            synchronized (hashMap) {
                obj = this.currentObjects.get(objName);
            }
            ListTermImpl list = new ListTermImpl();
            if (obj.getClass().isArray()) {
                int nlen = Array.getLength(obj);
                for (int i = 0; i < nlen; ++i) {
                    Atom id = this.registerDynamic(Array.getInt(obj, i));
                    list.add((Term)id);
                }
            } else if (obj instanceof Collection) {
                for (Object el : (Collection)obj) {
                    Atom id = this.registerDynamic(el);
                    list.add((Term)id);
                }
            }
            return un.unifies(idResult, (Term)list);
        }
        catch (Exception ex) {
            throw new JasonException("Error in arrat_to_list for " + objId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Atom id) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            return this.currentObjects.get(id.getFunctor());
        }
    }

    public Collection<Object> getAllCurrentObjects() {
        return this.currentObjects.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bindObject(Unifier un, Term id, Object obj) {
        if (obj == null) {
            return un.unifies(id, (Term)new VarTerm("_"));
        }
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            Term aKey = (Term)this.currentObjects_inverse.get(obj);
            if (aKey != null) {
                return un.unifies(id, aKey);
            }
            if (id.isVar()) {
                Atom idTerm = this.generateFreshId();
                un.unifies(id, (Term)idTerm);
                this.registerDynamic(idTerm, obj);
                return true;
            }
            Atom id2 = (Atom)id;
            Object linkedobj = this.currentObjects.get(id2.getFunctor());
            if (linkedobj == null) {
                this.registerDynamic(id2, obj);
                return true;
            }
            return obj == linkedobj;
        }
    }

    protected Atom generateFreshId() {
        return new Atom("cobj_" + this.id++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDynamic(Atom id, Object obj) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            this.currentObjects.put(id.getFunctor(), obj);
            this.currentObjects_inverse.put(obj, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Atom registerDynamic(Object obj) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            Atom aKey = this.currentObjects_inverse.get(obj);
            if (aKey != null) {
                return aKey;
            }
            Atom id = this.generateFreshId();
            this.currentObjects.put(id.getFunctor(), obj);
            this.currentObjects_inverse.put(obj, id);
            return id;
        }
    }

    private Signature parseArg(Term meth) {
        if (meth.isStructure()) {
            Structure method = (Structure)meth;
            Object[] values = new Object[method.getArity()];
            Class[] types = new Class[method.getArity()];
            for (int i = 0; i < method.getArity(); ++i) {
                if (this.parse_arg(values, types, i, method.getTerm(i))) continue;
                return null;
            }
            return new Signature(values, types);
        }
        if (meth.isAtom()) {
            Atom method = (Atom)meth;
            Object[] values = new Object[]{};
            Class[] types = new Class[]{};
            return new Signature(values, types);
        }
        return null;
    }

    private Signature parseArg(Object[] objs) {
        Object[] values = new Object[objs.length];
        Class[] types = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            if (this.parse_arg(values, types, i, (Term)objs[i])) continue;
            return null;
        }
        return new Signature(values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse_arg(Object[] values, Class[] types, int i, Term term) {
        block18: {
            try {
                if (term == null) {
                    values[i] = null;
                    types[i] = null;
                    break block18;
                }
                if (term.isString()) {
                    types[i] = String.class;
                    values[i] = ((StringTerm)term).getString();
                    break block18;
                }
                if (term.isAtom()) {
                    String name = ((Atom)term).getFunctor();
                    if (name.equals("true")) {
                        values[i] = Boolean.TRUE;
                        types[i] = Boolean.TYPE;
                        break block18;
                    }
                    if (name.equals("false")) {
                        values[i] = Boolean.FALSE;
                        types[i] = Boolean.TYPE;
                        break block18;
                    }
                    Object obj = null;
                    HashMap<String, Object> hashMap = this.currentObjects;
                    synchronized (hashMap) {
                        obj = this.currentObjects.get(name);
                    }
                    values[i] = obj == null ? name : obj;
                    types[i] = values[i].getClass();
                    break block18;
                }
                if (term.isNumeric()) {
                    int intValue;
                    NumberTerm t = (NumberTerm)term;
                    double value = t.solve();
                    if (value == (double)(intValue = (int)value)) {
                        values[i] = new Integer(intValue);
                        types[i] = Integer.TYPE;
                    } else {
                        values[i] = new Double(value);
                        types[i] = Double.TYPE;
                    }
                    break block18;
                }
                if (term.isList()) {
                    ListTerm lt = (ListTerm)term;
                    int j = 0;
                    Object[] list = new Object[lt.size()];
                    for (Term t1 : lt) {
                        list[j++] = this.termToObject(t1);
                    }
                    values[i] = list;
                    types[i] = list.getClass();
                    return true;
                }
                if (term.isStructure()) {
                    Structure tc = (Structure)term;
                    if (tc.getFunctor().equals("as")) {
                        return this.parse_as(values, types, i, tc.getTerm(0), tc.getTerm(1));
                    }
                    Object obj = this.currentObjects.get(tc.getFunctor());
                    values[i] = obj == null ? tc.toString() : obj;
                    types[i] = values[i].getClass();
                    break block18;
                }
                if (term.isVar() && !((VarTerm)term).isGround()) {
                    values[i] = null;
                    types[i] = Object.class;
                    break block18;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse_as(Object[] values, Class[] types, int i, Term castWhat, Term castTo) {
        block34: {
            try {
                if (!castWhat.isNumeric()) {
                    String castTo_name = ((StringTerm)castTo).getString();
                    String castWhat_name = ((StringTerm)castTo).getString();
                    if (castTo_name.equals("java.lang.String") && castWhat_name.equals("true")) {
                        values[i] = "true";
                        types[i] = String.class;
                        return true;
                    }
                    if (castTo_name.equals("java.lang.String") && castWhat_name.equals("false")) {
                        values[i] = "false";
                        types[i] = String.class;
                        return true;
                    }
                    if (castTo_name.endsWith("[]")) {
                        castTo_name = castTo_name.equals("boolean[]") ? "[Z" : (castTo_name.equals("byte[]") ? "[B" : (castTo_name.equals("short[]") ? "[S" : (castTo_name.equals("char[]") ? "[C" : (castTo_name.equals("int[]") ? "[I" : (castTo_name.equals("long[]") ? "[L" : (castTo_name.equals("float[]") ? "[F" : (castTo_name.equals("double[]") ? "[D" : "[L" + castTo_name.substring(0, castTo_name.length() - 2) + ";")))))));
                    }
                    if (!castWhat_name.equals("null")) {
                        Object obj_to_cast = null;
                        HashMap<String, Object> hashMap = this.currentObjects;
                        synchronized (hashMap) {
                            obj_to_cast = this.currentObjects.get(castWhat_name);
                        }
                        if (obj_to_cast == null) {
                            if (castTo_name.equals("boolean")) {
                                if (castWhat_name.equals("true")) {
                                    values[i] = new Boolean(true);
                                } else if (castWhat_name.equals("false")) {
                                    values[i] = new Boolean(false);
                                } else {
                                    return false;
                                }
                                types[i] = Boolean.TYPE;
                                break block34;
                            }
                            return false;
                        }
                        values[i] = obj_to_cast;
                        try {
                            types[i] = Class.forName(castTo_name);
                            break block34;
                        }
                        catch (ClassNotFoundException ex) {
                            return false;
                        }
                    }
                    values[i] = null;
                    if (castTo_name.equals("byte")) {
                        types[i] = Byte.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("short")) {
                        types[i] = Short.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("char")) {
                        types[i] = Character.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("int")) {
                        types[i] = Integer.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("long")) {
                        types[i] = Long.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("float")) {
                        types[i] = Float.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("double")) {
                        types[i] = Double.TYPE;
                        break block34;
                    }
                    if (castTo_name.equals("boolean")) {
                        types[i] = Boolean.TYPE;
                        break block34;
                    }
                    try {
                        types[i] = Class.forName(castTo_name);
                        break block34;
                    }
                    catch (ClassNotFoundException ex) {
                        return false;
                    }
                }
                Number num = (Number)castWhat;
                String castTo_name = ((StringTerm)castTo).getString();
                if (castTo_name.equals("byte")) {
                    values[i] = new Byte((byte)num.intValue());
                    types[i] = Byte.TYPE;
                    break block34;
                }
                if (castTo_name.equals("short")) {
                    values[i] = new Short((short)num.intValue());
                    types[i] = Short.TYPE;
                    break block34;
                }
                if (castTo_name.equals("int")) {
                    values[i] = new Integer(num.intValue());
                    types[i] = Integer.TYPE;
                    break block34;
                }
                if (castTo_name.equals("long")) {
                    values[i] = new Long(num.longValue());
                    types[i] = Long.TYPE;
                    break block34;
                }
                if (castTo_name.equals("float")) {
                    values[i] = new Float(num.floatValue());
                    types[i] = Float.TYPE;
                    break block34;
                }
                if (castTo_name.equals("double")) {
                    values[i] = new Double(num.doubleValue());
                    types[i] = Double.TYPE;
                    break block34;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private boolean parseResult(Unifier un, Term id, Object obj) {
        if (obj == null) {
            return un.unifies(id, (Term)new VarTerm("_"));
        }
        try {
            if (Boolean.class.isInstance(obj)) {
                if (((Boolean)obj).booleanValue()) {
                    return un.unifies(id, (Term)Atom.LTrue);
                }
                return un.unifies(id, (Term)Atom.LFalse);
            }
            if (Byte.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl((double)((Byte)obj).intValue()));
            }
            if (Short.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl((double)((Short)obj).intValue()));
            }
            if (Integer.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl((double)((Integer)obj).intValue()));
            }
            if (Long.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl((double)((Long)obj).longValue()));
            }
            if (Float.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl((double)((Float)obj).floatValue()));
            }
            if (Double.class.isInstance(obj)) {
                return un.unifies(id, (Term)new NumberTermImpl(((Double)obj).doubleValue()));
            }
            if (String.class.isInstance(obj)) {
                return un.unifies(id, (Term)new StringTermImpl((String)obj));
            }
            if (Character.class.isInstance(obj)) {
                return un.unifies(id, (Term)new StringTermImpl(((Character)obj).toString()));
            }
            return this.bindObject(un, id, obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private Object[] getArrayFromList(ListTerm list) {
        Object[] args = new Object[list.size()];
        ListIterator it = list.listIterator();
        int count = 0;
        while (it.hasNext()) {
            args[count++] = it.next();
        }
        return args;
    }

    private static Method lookupMethod(Class target, String name, Class[] argClasses, Object[] argValues) throws NoSuchMethodException {
        try {
            Method m = target.getMethod(name, argClasses);
            return m;
        }
        catch (NoSuchMethodException e) {
            int i;
            if (argClasses.length == 0) {
                return null;
            }
            Method[] methods = target.getMethods();
            Vector<Method> goodMethods = new Vector<Method>();
            for (i = 0; i != methods.length; ++i) {
                if (!name.equals(methods[i].getName()) || !JavaLibrary.matchClasses(methods[i].getParameterTypes(), argClasses)) continue;
                goodMethods.addElement(methods[i]);
            }
            switch (goodMethods.size()) {
                case 0: {
                    for (i = 0; i != methods.length; ++i) {
                        Class[] types;
                        Object[] val;
                        if (!name.equals(methods[i].getName()) || (val = JavaLibrary.matchClasses(types = methods[i].getParameterTypes(), argClasses, argValues)) == null) continue;
                        for (int j = 0; j < types.length; ++j) {
                            argClasses[j] = types[j];
                            argValues[j] = val[j];
                        }
                        return methods[i];
                    }
                    return null;
                }
                case 1: {
                    return (Method)goodMethods.firstElement();
                }
            }
            return JavaLibrary.mostSpecificMethod(goodMethods);
        }
    }

    private static Constructor lookupConstructor(Class target, Class[] argClasses, Object[] argValues) throws NoSuchMethodException {
        try {
            return target.getConstructor(argClasses);
        }
        catch (NoSuchMethodException e) {
            int i;
            if (argClasses.length == 0) {
                return null;
            }
            Constructor<?>[] constructors = target.getConstructors();
            Vector goodConstructors = new Vector();
            for (i = 0; i != constructors.length; ++i) {
                if (!JavaLibrary.matchClasses(constructors[i].getParameterTypes(), argClasses)) continue;
                goodConstructors.addElement(constructors[i]);
            }
            switch (goodConstructors.size()) {
                case 0: {
                    for (i = 0; i != constructors.length; ++i) {
                        Class[] types = constructors[i].getParameterTypes();
                        Object[] val = JavaLibrary.matchClasses(types, argClasses, argValues);
                        if (val == null) continue;
                        for (int j = 0; j < types.length; ++j) {
                            argClasses[j] = types[j];
                            argValues[j] = val[j];
                        }
                        return constructors[i];
                    }
                    return null;
                }
                case 1: {
                    return (Constructor)goodConstructors.firstElement();
                }
            }
            return JavaLibrary.mostSpecificConstructor(goodConstructors);
        }
    }

    private static boolean matchClasses(Class[] mclasses, Class[] pclasses) {
        if (mclasses.length == pclasses.length) {
            for (int i = 0; i != mclasses.length; ++i) {
                if (JavaLibrary.matchClass(mclasses[i], pclasses[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matchClass(Class mclass, Class pclass) {
        boolean assignable = mclass.isAssignableFrom(pclass);
        if (assignable) {
            return true;
        }
        return mclass.equals(Long.TYPE) && pclass.equals(Integer.TYPE);
    }

    private static Method mostSpecificMethod(Vector methods) throws NoSuchMethodException {
        for (int i = 0; i != methods.size(); ++i) {
            for (int j = 0; j != methods.size(); ++j) {
                if (i == j || !JavaLibrary.moreSpecific((Method)methods.elementAt(i), (Method)methods.elementAt(j))) continue;
                methods.removeElementAt(j);
                if (i > j) {
                    --i;
                }
                --j;
            }
        }
        if (methods.size() == 1) {
            return (Method)methods.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific method");
    }

    private static boolean moreSpecific(Method c1, Method c2) {
        Class<?>[] p1 = c1.getParameterTypes();
        Class<?>[] p2 = c2.getParameterTypes();
        int n = p1.length;
        for (int i = 0; i != n; ++i) {
            if (JavaLibrary.matchClass(p2[i], p1[i])) continue;
            return false;
        }
        return true;
    }

    private static Constructor mostSpecificConstructor(Vector constructors) throws NoSuchMethodException {
        for (int i = 0; i != constructors.size(); ++i) {
            for (int j = 0; j != constructors.size(); ++j) {
                if (i == j || !JavaLibrary.moreSpecific((Constructor)constructors.elementAt(i), (Constructor)constructors.elementAt(j))) continue;
                constructors.removeElementAt(j);
                if (i > j) {
                    --i;
                }
                --j;
            }
        }
        if (constructors.size() == 1) {
            return (Constructor)constructors.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific constructor");
    }

    private static boolean moreSpecific(Constructor c1, Constructor c2) {
        Class<?>[] p1 = c1.getParameterTypes();
        Class<?>[] p2 = c2.getParameterTypes();
        int n = p1.length;
        for (int i = 0; i != n; ++i) {
            if (JavaLibrary.matchClass(p2[i], p1[i])) continue;
            return false;
        }
        return true;
    }

    private static Object[] matchClasses(Class[] mclasses, Class[] pclasses, Object[] values) {
        if (mclasses.length == pclasses.length) {
            Object[] newvalues = new Object[mclasses.length];
            for (int i = 0; i != mclasses.length; ++i) {
                boolean assignable = mclasses[i].isAssignableFrom(pclasses[i]);
                if (assignable || mclasses[i].equals(Long.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = values[i];
                    continue;
                }
                if (mclasses[i].equals(Float.TYPE) && pclasses[i].equals(Double.TYPE)) {
                    newvalues[i] = new Float(((Double)values[i]).floatValue());
                    continue;
                }
                if (mclasses[i].equals(Float.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = new Float(((Integer)values[i]).intValue());
                    continue;
                }
                if (mclasses[i].equals(Double.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = new Double(((Integer)values[i]).doubleValue());
                    continue;
                }
                if (values[i] == null && !mclasses[i].isPrimitive()) {
                    newvalues[i] = null;
                    continue;
                }
                return null;
            }
            return newvalues;
        }
        return null;
    }

    public Object termToObject(Term t) {
        if (t instanceof VarTerm) {
            VarTerm var = (VarTerm)t;
            if (!var.isVar()) {
                return null;
            }
            return new OpFeedbackParam();
        }
        if (t.isAtom()) {
            Atom t2 = (Atom)t;
            if (t2.equals((Object)Atom.LTrue)) {
                return Boolean.TRUE;
            }
            if (t2.equals((Object)Atom.LFalse)) {
                return Boolean.FALSE;
            }
            Object obj = this.getObject(t2);
            if (obj != null) {
                return obj;
            }
            return t2.getFunctor();
        }
        if (t.isNumeric()) {
            NumberTerm nt = (NumberTerm)t;
            double d = 0.0;
            try {
                d = nt.solve();
            }
            catch (NoValueException e) {
                e.printStackTrace();
            }
            if ((double)((byte)d) == d) {
                return (byte)d;
            }
            if ((double)((int)d) == d) {
                return (int)d;
            }
            if ((double)((float)d) == d) {
                return Float.valueOf((float)d);
            }
            if ((double)((long)d) == d) {
                return (long)d;
            }
            return d;
        }
        if (t.isString()) {
            return ((StringTerm)t).getString();
        }
        if (t.isList()) {
            ListTerm lt = (ListTerm)t;
            int i = 0;
            Object[] list = new Object[lt.size()];
            for (Term t1 : lt) {
                list[i++] = this.termToObject(t1);
            }
            return list;
        }
        return t.toString();
    }

    public Term objectToTerm(Object value) throws Exception {
        if (value == null) {
            return ASSyntax.createVar((String)"_");
        }
        if (value instanceof Term) {
            return (Term)value;
        }
        if (value instanceof OpFeedbackParam) {
            return this.objectToTerm(((OpFeedbackParam)value).get());
        }
        if (value instanceof Number) {
            try {
                return ASSyntax.parseNumber((String)value.toString());
            }
            catch (Exception ex) {
                return ASSyntax.createString((String)value.toString());
            }
        }
        if (value instanceof String) {
            return ASSyntax.createString((String)value.toString());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Literal.LTrue : Literal.LFalse;
        }
        if (value.getClass().isArray()) {
            ListTermImpl l;
            ListTermImpl tail = l = new ListTermImpl();
            int lenght = Array.getLength(value);
            for (int i = 0; i < lenght; ++i) {
                tail = tail.append(this.objectToTerm(Array.get(value, i)));
            }
            return l;
        }
        if (value instanceof Map) {
            ListTermImpl l;
            ListTermImpl tail = l = new ListTermImpl();
            Map m = (Map)value;
            for (Object k : m.keySet()) {
                Structure pair = ASSyntax.createStructure((String)"map", (Term[])new Term[]{this.objectToTerm(k), this.objectToTerm(m.get(k))});
                tail = tail.append((Term)pair);
            }
            return l;
        }
        if (value instanceof ToProlog) {
            return ASSyntax.parseTerm((String)((ToProlog)value).getAsPrologStr());
        }
        if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            Structure st = ASSyntax.createStructure((String)t.getLabel(), (Term[])new Term[0]);
            for (int i = 0; i < t.getNArgs(); ++i) {
                st.addTerm(this.objectToTerm(t.getContent(i)));
            }
            return st;
        }
        return this.registerDynamic(value);
    }

    public Term[] objectArray2termArray(Object[] values) throws Exception {
        Term[] result = new Term[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.objectToTerm(values[i]);
        }
        return result;
    }

    public Tuple termToTuple(Term t) {
        if (t.isAtom()) {
            return new Tuple(((Atom)t).getFunctor());
        }
        if (t.isStructure()) {
            Structure st = (Structure)t;
            Term[] ta = st.getTermsArray();
            Object[] objs = new Object[ta.length];
            for (int i = 0; i < ta.length; ++i) {
                objs[i] = this.termToObject(ta[i]);
            }
            return new Tuple(st.getFunctor(), objs);
        }
        throw new IllegalArgumentException();
    }

    public Term tupleToTerm(Tuple t) throws Exception {
        Structure st = new Structure(t.getLabel());
        for (Object obj : t.getContents()) {
            st.addTerm(this.objectToTerm(obj));
        }
        return st;
    }

    public Literal tupleToLiteral(Tuple t) throws Exception {
        Structure st = new Structure(t.getLabel());
        for (Object obj : t.getContents()) {
            st.addTerm(this.objectToTerm(obj));
        }
        return st;
    }

    class Signature
    implements Serializable {
        Class[] types;
        Object[] values;

        public Signature(Object[] v, Class[] c) {
            this.values = v;
            this.types = c;
        }

        public Class[] getTypes() {
            return this.types;
        }

        Object[] getValues() {
            return this.values;
        }

        public String toString() {
            String st = "";
            for (int i = 0; i < this.types.length; ++i) {
                st = st + "\n  Argument " + i + " -  VALUE: " + this.values[i] + " TYPE: " + this.types[i];
            }
            return st;
        }
    }
}

