/*
 * Decompiled with CFR 0.152.
 */
package c4jason;

import c4jason.CAgentArch;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.CartagoService;
import cartago.ICartagoListener;
import cartago.ICartagoSession;
import cartago.security.AgentCredential;
import cartago.security.AgentIdCredential;
import jason.asSyntax.Literal;
import jason.environment.Environment;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CartagoEnvironment
extends Environment {
    private static CartagoEnvironment instance;
    private String wspName;
    private String wspAddress;
    private boolean local;
    private boolean remote;
    private boolean infrastructure;
    private boolean standalone;
    private String serviceType;
    static Logger logger;

    public void init(String[] args) {
        logger.setLevel(Level.WARNING);
        this.wspName = CartagoNode.MAIN_WSP_NAME;
        this.infrastructure = false;
        this.local = false;
        this.remote = false;
        this.standalone = true;
        this.serviceType = "default";
        if (args.length > 0) {
            if (args[0].equals("standalone")) {
                this.standalone = true;
            } else if (args[0].equals("local")) {
                this.local = true;
                this.standalone = false;
            } else if (args[0].equals("infrastructure")) {
                this.infrastructure = true;
                this.standalone = false;
            } else if (args[0].equals("remote")) {
                this.remote = true;
                this.standalone = false;
            } else {
                throw new IllegalArgumentException("Unknown argument: " + args[0] + " (should be local, remote or infrastructure)");
            }
        }
        if (this.standalone) {
            try {
                CartagoService.startNode();
                CartagoService.installInfrastructureLayer((String)"default");
                this.checkProtocols(args);
                logger.info("CArtAgO Environment - standalone setup succeeded.");
            }
            catch (Exception ex) {
                logger.severe("CArtAgO Environment - standalone setup failed.");
                ex.printStackTrace();
            }
        } else if (this.infrastructure) {
            try {
                CartagoService.startNode();
                this.checkProtocols(args);
                int nserv = this.checkServices(args);
                if (!CartagoService.isInfrastructureLayerInstalled((String)"default")) {
                    CartagoService.installInfrastructureLayer((String)"default");
                    logger.info("CArtAgO Environment - default infrastructure layer installed.");
                }
                if (nserv == 0) {
                    CartagoService.startInfrastructureService((String)"default");
                    logger.info("CArtAgO Environment - default infrastructure service installed.");
                }
                logger.info("CArtAgO Environment - infrastructure setup succeeded.");
            }
            catch (Exception ex) {
                logger.severe("CArtAgO Environment - infrastructure setup failed.");
                ex.printStackTrace();
            }
        } else if (this.remote) {
            if (args.length > 1) {
                this.wspName = args[1];
                this.wspAddress = args[2];
            }
            try {
                CartagoService.installInfrastructureLayer((String)"default");
                this.checkProtocols(args);
                logger.info("CArtAgO Environment - remote setup succeeded - Joining a remote workspace: " + this.wspName + "@" + this.wspAddress);
            }
            catch (Exception ex) {
                logger.severe("CArtAgO Environment - remote setup failed.");
                ex.printStackTrace();
            }
        } else if (this.local) {
            if (args.length > 1) {
                this.wspName = args[1];
            }
            logger.info("CArtAgO Environment - local setup succeeded - Joining a local workspace: " + this.wspName);
        }
        instance = this;
    }

    private int checkProtocols(String[] args) {
        int np = 0;
        for (int i = 1; i < args.length; ++i) {
            String prot = args[i];
            try {
                prot = prot.replace('\'', '\"');
                Literal l = Literal.parseLiteral((String)prot);
                if (!l.getFunctor().equals("protocol")) continue;
                String protocol = l.getTerm(0).toString();
                CartagoService.installInfrastructureLayer((String)protocol);
                logger.info("Installed protocol " + protocol);
                ++np;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return np;
    }

    private int checkServices(String[] args) {
        int ns = 0;
        for (int i = 1; i < args.length; ++i) {
            String prot = args[i];
            try {
                prot = prot.replace('\'', '\"');
                Literal l = Literal.parseLiteral((String)prot);
                if (!l.getFunctor().equals("service")) continue;
                String serviceType = l.getTerm(0).toString();
                String address = null;
                if (l.getArity() > 1) {
                    address = l.getTerm(1).toString();
                    if (address.startsWith("\"")) {
                        address = address.substring(1);
                    }
                    if (address.endsWith("\"")) {
                        address = address.substring(0, address.length() - 1);
                    }
                }
                if (!CartagoService.isInfrastructureLayerInstalled((String)serviceType)) {
                    CartagoService.installInfrastructureLayer((String)serviceType);
                }
                if (address == null) {
                    CartagoService.startInfrastructureService((String)serviceType);
                    logger.info("Installed service " + serviceType);
                } else {
                    CartagoService.startInfrastructureService((String)serviceType, (String)address);
                    logger.info("Installed service " + serviceType + " at " + address);
                }
                ++ns;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ns;
    }

    public static CartagoEnvironment getInstance() {
        return instance;
    }

    public ICartagoSession startSession(String agName, CAgentArch arch) throws Exception {
        if (this.wspAddress == null) {
            ICartagoSession context = CartagoService.startSession((String)this.wspName, (AgentCredential)new AgentIdCredential(agName), (ICartagoListener)arch);
            logger.info("NEW AGENT JOINED: " + agName);
            return context;
        }
        ICartagoSession context = CartagoService.startRemoteSession((String)this.wspName, (String)this.wspAddress, (String)this.serviceType, (AgentCredential)new AgentIdCredential(agName), (ICartagoListener)arch);
        return context;
    }

    public void stop() {
        super.stop();
        if (!this.local && !this.remote) {
            try {
                CartagoService.shutdownNode();
            }
            catch (CartagoException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        logger = Logger.getLogger(CartagoEnvironment.class.getName());
    }
}

