/*
 * Decompiled with CFR 0.152.
 */
package c4jason;

import c4jason.CartagoEnvironment;
import c4jason.JavaLibrary;
import c4jason.PendingAction;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.CartagoEvent;
import cartago.IAlignmentTest;
import cartago.ICartagoListener;
import cartago.ICartagoSession;
import cartago.Manual;
import cartago.ObservableArtifactInfo;
import cartago.Op;
import cartago.Tuple;
import cartago.WorkspaceId;
import cartago.events.ActionFailedEvent;
import cartago.events.ActionSucceededEvent;
import cartago.events.ArtifactObsEvent;
import cartago.events.ConsultManualSucceededEvent;
import cartago.events.FocusSucceededEvent;
import cartago.events.FocussedArtifactDisposedEvent;
import cartago.events.JoinWSPSucceededEvent;
import cartago.events.ObsArtListChangedEvent;
import cartago.events.StopFocusSucceededEvent;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.bb.BeliefBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CAgentArch
extends AgArch
implements ICartagoListener {
    protected static final Term OBS_PROP_PERCEPT = ASSyntax.createStructure((String)"percept_type", (Term[])new Term[]{ASSyntax.createString((String)"obs_prop")});
    protected static final Term OBS_EV_PERCEPT = ASSyntax.createStructure((String)"percept_type", (Term[])new Term[]{ASSyntax.createString((String)"obs_ev")});
    protected ICartagoSession envSession;
    protected ConcurrentHashMap<Long, PendingAction> pendingActions;
    protected JavaLibrary lib;
    protected Logger logger;
    protected BeliefBase belBase;
    protected Agent agent;
    List<WorkspaceId> allJoinedWsp = new ArrayList<WorkspaceId>();

    public CAgentArch() {
        this.pendingActions = new ConcurrentHashMap();
        this.logger = Logger.getLogger("CAgentArch");
        this.lib = new JavaLibrary();
    }

    public ICartagoSession getSession() {
        return this.envSession;
    }

    public void init() throws Exception {
        this.initBridge();
    }

    protected void initBridge() {
        String agentName = this.getTS().getUserAgArch().getAgName();
        try {
            this.agent = this.getTS().getAg();
            this.belBase = this.agent.getBB();
            this.envSession = CartagoEnvironment.getInstance().startSession(agentName, this);
            this.allJoinedWsp.addAll(this.envSession.getJoinedWorkspaces());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.warning("[CARTAGO] WARNING: No default workspace found for " + agentName);
        }
    }

    protected void loadBasicPlans() {
        String sensePlan1 = "@sense_plan1[atomic]\t\t\t\t\n+!sense(P) : P.\t\t\t\t\t\n";
        String sensePlan2 = "@sense_plan2[atomic]\t\t\t\t\n+!sense(P) : not P\t<- .wait({+P}).\t\n";
        try {
            this.agent.getPL().add(ASSyntax.parsePlan((String)sensePlan1));
            this.agent.getPL().add(ASSyntax.parsePlan((String)sensePlan2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void act(ActionExec actionExec) {
        Structure action = actionExec.getActionTerm();
        ArtifactId aid = null;
        WorkspaceId wspId = null;
        String artName = null;
        String wspName = null;
        try {
            boolean failed = false;
            ListTerm lt = action.getAnnots();
            if (lt != null) {
                for (Term annot : lt) {
                    Object obj;
                    if (!annot.isStructure()) continue;
                    Structure st = (Structure)annot;
                    if (st.getFunctor().equals("art") || st.getFunctor().equals("artifact_name")) {
                        if (st.getTerm(0).isString()) {
                            artName = ((StringTerm)st.getTerm(0)).getString();
                            continue;
                        }
                        artName = st.getTerm(0).toString();
                        continue;
                    }
                    if (st.getFunctor().equals("aid") || st.getFunctor().equals("artifact_id")) {
                        obj = this.getObject(st.getTerm(0));
                        if (obj == null || !(obj instanceof ArtifactId)) continue;
                        aid = (ArtifactId)obj;
                        continue;
                    }
                    if (st.getFunctor().equals("wid")) {
                        obj = this.getObject(st.getTerm(0));
                        if (obj == null || !(obj instanceof WorkspaceId)) continue;
                        wspId = (WorkspaceId)obj;
                        continue;
                    }
                    if (st.getFunctor().equals("wsp")) {
                        if (st.getTerm(0).isString()) {
                            wspName = ((StringTerm)st.getTerm(0)).getString();
                            continue;
                        }
                        wspName = st.getTerm(0).toString();
                        continue;
                    }
                    this.logger.warning("Use failed: unknown annotation " + annot);
                    Literal reason = Literal.parseLiteral((String)("action_failed(" + action + ",unknown_annotation)"));
                    String msg = "Use  error - unknown annotation " + annot;
                    this.notifyActionFailure(actionExec, (Term)reason, msg);
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                Op op = this.parseOp(action);
                IAlignmentTest test = null;
                long timeout = Long.MAX_VALUE;
                long actId = aid != null ? this.envSession.doAction(aid, op, test, timeout) : (wspId != null ? (artName != null ? this.envSession.doAction(wspId, artName, op, test, timeout) : this.envSession.doAction(wspId, op, test, timeout)) : (wspName != null ? (artName != null ? this.envSession.doAction(wspName, op, artName, test, timeout) : this.envSession.doAction(wspName, op, test, timeout)) : (artName != null ? this.envSession.doAction(op, artName, test, timeout) : this.envSession.doAction(op, test, timeout))));
                PendingAction pa = new PendingAction(actId, action, actionExec);
                this.pendingActions.put(actId, pa);
            }
        }
        catch (Exception ex) {
            this.logger.warning("Op " + action + " on artifact " + aid + "(artifact_name= " + artName + ") by " + this.getAgName() + " failed - op: " + action);
            Literal reasonTerm = Literal.parseLiteral((String)("action_failed(" + action + ",generic_error)"));
            Literal reason = ASSyntax.createLiteral((String)"env_failure", (Term[])new Term[]{reasonTerm});
            String msg = "Action failed: " + actionExec.getActionTerm();
            this.notifyActionFailure(actionExec, (Term)reason, msg);
        }
    }

    public List<Literal> perceive() {
        block63: {
            super.perceive();
            try {
                CartagoEvent evt = this.envSession.fetchNextPercept();
                if (evt == null) break block63;
                Literal l = null;
                if (evt instanceof ActionSucceededEvent) {
                    PendingAction action;
                    ActionSucceededEvent ev = (ActionSucceededEvent)evt;
                    if (ev.getActionId() == -1L) {
                        FocusSucceededEvent ev1;
                        if (ev instanceof FocusSucceededEvent) {
                            ev1 = (FocusSucceededEvent)ev;
                            this.addObsPropertiesBel(ev1.getTargetArtifact(), ev1.getObsProperties());
                        } else if (ev instanceof StopFocusSucceededEvent) {
                            ev1 = (StopFocusSucceededEvent)ev;
                            this.removeObsPropertiesBel(ev1.getTargetArtifact(), ev1.getObsProperties());
                        }
                    }
                    if ((action = this.pendingActions.remove(ev.getActionId())) != null) {
                        Op op = ev.getOp();
                        this.notifyActionSuccess(op, action.getAction(), action.getActionExec());
                        if (ev instanceof FocusSucceededEvent) {
                            FocusSucceededEvent ev1 = (FocusSucceededEvent)ev;
                            this.addObsPropertiesBel(ev1.getTargetArtifact(), ev1.getObsProperties());
                        } else if (ev instanceof StopFocusSucceededEvent) {
                            StopFocusSucceededEvent ev1 = (StopFocusSucceededEvent)ev;
                            this.removeObsPropertiesBel(ev1.getTargetArtifact(), ev1.getObsProperties());
                        } else if (ev instanceof JoinWSPSucceededEvent) {
                            JoinWSPSucceededEvent ev1 = (JoinWSPSucceededEvent)ev;
                            this.allJoinedWsp.add(ev1.getWorkspaceId());
                        } else if (ev instanceof ConsultManualSucceededEvent) {
                            ConsultManualSucceededEvent ev1 = (ConsultManualSucceededEvent)ev;
                            this.consultManual(ev1.getManual());
                        }
                    }
                    break block63;
                }
                if (evt instanceof ActionFailedEvent) {
                    ActionFailedEvent ev = (ActionFailedEvent)evt;
                    PendingAction action = this.pendingActions.remove(ev.getActionId());
                    if (action == null) break block63;
                    try {
                        Term reason = null;
                        Tuple failureInfo = ev.getFailureDescr();
                        try {
                            if (failureInfo != null) {
                                reason = this.lib.tupleToTerm(failureInfo);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        this.notifyActionFailure(action.getActionExec(), reason, ev.getFailureMsg());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break block63;
                }
                if (evt instanceof FocussedArtifactDisposedEvent) {
                    FocussedArtifactDisposedEvent ev = (FocussedArtifactDisposedEvent)evt;
                    this.removeObsPropertiesBel(ev.getArtifactId(), ev.getObsProperties());
                } else if (evt instanceof ArtifactObsEvent) {
                    StringTerm st;
                    ListTerm annots;
                    Literal lold;
                    boolean found;
                    Iterator<Literal> it;
                    String propId;
                    String propName;
                    ArtifactObsProperty[] props;
                    ArtifactObsEvent ev = (ArtifactObsEvent)evt;
                    Tuple signal = ev.getSignal();
                    if (signal != null && (l = this.obsEventToLiteral(ev, this.lib)) != null) {
                        Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, l);
                        this.getTS().updateEvents(new Event(te, Intention.EmptyInt));
                    }
                    if ((props = ev.getChangedProperties()) != null) {
                        for (ArtifactObsProperty prop : props) {
                            propName = prop.getName();
                            propId = prop.getFullId();
                            try {
                                it = this.getObsPropBeliefs(prop);
                                found = false;
                                lold = null;
                                annots = null;
                                if (it != null) {
                                    block13: while (!found && it.hasNext()) {
                                        lold = it.next();
                                        annots = lold.getAnnots("obs_prop_id");
                                        if (annots.isEmpty()) continue;
                                        for (Term annot : annots) {
                                            st = (StringTerm)((Structure)annot).getTerm(0);
                                            if (!st.getString().equals(propId)) continue;
                                            found = true;
                                            continue block13;
                                        }
                                    }
                                }
                                if (found) {
                                    if (annots.size() == 1) {
                                        if (!this.belBase.remove(lold)) {
                                            this.logger.warning("obs prop not found during bel update: " + propName + " " + ev.getArtifactId().getName());
                                        }
                                    } else {
                                        ArtifactId source = ev.getArtifactId();
                                        Iterator it2 = lold.getAnnots().iterator();
                                        while (it2.hasNext()) {
                                            Object artId;
                                            Term t = (Term)it2.next();
                                            if (!t.isStructure()) continue;
                                            Structure st2 = (Structure)t;
                                            if (st2.getFunctor().equals("obs_prop_id")) {
                                                StringTerm sst = (StringTerm)st2.getTerm(0);
                                                if (!sst.getString().equals(propId)) continue;
                                                it2.remove();
                                                continue;
                                            }
                                            if (st2.getArity() <= 0 || (artId = this.lib.termToObject(st2.getTerm(0))) == null || !artId.equals(source)) continue;
                                            it2.remove();
                                        }
                                    }
                                } else {
                                    this.logger.warning("!! obs prop not found during bel update: " + propName + " " + ev.getArtifactId().getName() + " " + annots);
                                }
                                if (this.belBase.add(l = this.obsPropToLiteral(propId, ev.getArtifactId(), propName, prop.getValues(), this.lib))) {
                                    Iterator te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, l.copy());
                                    this.getTS().updateEvents(new Event((Trigger)te, Intention.EmptyInt));
                                    continue;
                                }
                                this.logger.warning("AGENT: " + this.getTS().getUserAgArch().getAgName() + " CANNOT UPDATE THE BELIEF: " + l);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.logger.warning("EXCEPTION - processing update obs prop " + ev + " for agent " + this.getTS().getUserAgArch().getAgName());
                            }
                        }
                    }
                    if ((props = ev.getAddedProperties()) != null) {
                        for (ArtifactObsProperty prop : props) {
                            propName = prop.getName();
                            propId = prop.getFullId();
                            try {
                                it = this.getObsPropBeliefs(prop);
                                found = false;
                                if (it != null) {
                                    lold = null;
                                    block17: while (!found && it.hasNext()) {
                                        lold = it.next();
                                        annots = lold.getAnnots("obs_prop_id");
                                        if (annots.isEmpty()) continue;
                                        for (Term annot : annots) {
                                            st = (StringTerm)((Structure)annot).getTerm(0);
                                            if (!st.getString().equals(propId)) continue;
                                            found = true;
                                            continue block17;
                                        }
                                    }
                                }
                                if (found || !this.belBase.add(l = this.obsPropToLiteral(propId, ev.getArtifactId(), propName, prop.getValues(), this.lib))) continue;
                                Literal l1 = l.copy();
                                Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, l1);
                                this.getTS().updateEvents(new Event(te, Intention.EmptyInt));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.logger.warning("EXCEPTION - processing event " + ev + " for agent " + this.getTS().getUserAgArch().getAgName());
                            }
                        }
                    }
                    if ((props = ev.getRemovedProperties()) != null) {
                        for (ArtifactObsProperty prop : props) {
                            propName = prop.getName();
                            propId = prop.getFullId();
                            it = this.getObsPropBeliefs(prop);
                            found = false;
                            ListTerm annots2 = null;
                            Literal toBeRemoved = null;
                            if (it != null) {
                                block20: while (!found && it.hasNext()) {
                                    toBeRemoved = it.next();
                                    annots2 = toBeRemoved.getAnnots("obs_prop_id");
                                    if (annots2.isEmpty()) continue;
                                    for (Term annot : annots2) {
                                        st = (StringTerm)((Structure)annot).getTerm(0);
                                        if (!st.getString().equals(propId)) continue;
                                        found = true;
                                        continue block20;
                                    }
                                }
                            }
                            if (!found) continue;
                            try {
                                boolean removed = true;
                                if (annots2.size() == 1) {
                                    removed = this.belBase.remove(toBeRemoved);
                                } else {
                                    ArtifactId source = ev.getArtifactId();
                                    Iterator it2 = toBeRemoved.getAnnots().iterator();
                                    while (it2.hasNext()) {
                                        Object artId;
                                        Term t = (Term)it2.next();
                                        if (!t.isStructure()) continue;
                                        Structure st3 = (Structure)t;
                                        if (st3.getFunctor().equals("obs_prop_id")) {
                                            StringTerm sst = (StringTerm)st3.getTerm(0);
                                            if (!sst.getString().equals(propId)) continue;
                                            it2.remove();
                                            continue;
                                        }
                                        if (st3.getArity() <= 0 || (artId = this.lib.termToObject(st3.getTerm(0))) == null || !artId.equals(source)) continue;
                                        it2.remove();
                                    }
                                }
                                if (removed) {
                                    Literal l1 = toBeRemoved.copy();
                                    Trigger te = new Trigger(Trigger.TEOperator.del, Trigger.TEType.belief, l1);
                                    this.getTS().updateEvents(new Event(te, Intention.EmptyInt));
                                    continue;
                                }
                                this.logger.warning("AGENT: " + this.getTS().getUserAgArch().getAgName() + " OBS PROP NOT FOUND when removing: " + propName);
                            }
                            catch (Exception ex) {
                                this.logger.warning("EXCEPTION - processing remove obs prop " + ev + " for agent " + this.getTS().getUserAgArch().getAgName());
                            }
                        }
                    }
                } else if (evt instanceof ObsArtListChangedEvent) {
                    ObsArtListChangedEvent ev = (ObsArtListChangedEvent)evt;
                    List newFocused = ev.getNewFocused();
                    for (ObservableArtifactInfo info : newFocused) {
                        this.addObsPropertiesBel(info.getTargetArtifact(), info.getObsProperties());
                    }
                    List lostFocus = ev.getNoMoreFocused();
                    for (ObservableArtifactInfo info : lostFocus) {
                        this.removeObsPropertiesBel(info.getTargetArtifact(), info.getObsProperties());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.severe("Exception in fetching events from the context.");
            }
        }
        return null;
    }

    protected Iterator<Literal> getObsPropBeliefs(ArtifactObsProperty prop) {
        return this.belBase.getCandidateBeliefs(new PredicateIndicator(prop.getName(), prop.getValues().length));
    }

    protected void addObsPropertiesBel(ArtifactId source, List<ArtifactObsProperty> props) {
        Literal l = null;
        Agent a = this.agent;
        for (ArtifactObsProperty p : props) {
            String propId = p.getFullId();
            try {
                Iterator<Literal> it = this.getObsPropBeliefs(p);
                boolean found = false;
                if (it != null) {
                    Literal lold = null;
                    block3: while (!found && it.hasNext()) {
                        lold = it.next();
                        ListTerm annots = lold.getAnnots("obs_prop_id");
                        if (annots.isEmpty()) continue;
                        for (Term annot : annots) {
                            StringTerm st = (StringTerm)((Structure)annot).getTerm(0);
                            if (!st.getString().equals(propId)) continue;
                            found = true;
                            continue block3;
                        }
                    }
                }
                if (found) continue;
                l = this.obsPropToLiteral(propId, source, p.getName(), p.getValues(), this.lib);
                if (!a.getBB().add(l)) continue;
                Literal l1 = l.copy();
                Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, l1);
                this.getTS().updateEvents(new Event(te, Intention.EmptyInt));
            }
            catch (Exception ex) {
                this.logger.warning("EXCEPTION - processing new obs prop " + p + " artifact " + source + " for agent " + this.getTS().getUserAgArch().getAgName());
            }
        }
    }

    protected void removeObsPropertiesBel(ArtifactId source, List<ArtifactObsProperty> props) {
        Agent a = this.agent;
        for (ArtifactObsProperty p : props) {
            String propName = p.getName();
            String propId = p.getFullId();
            try {
                Structure st;
                Iterator<Literal> it = this.getObsPropBeliefs(p);
                Literal toBeRemoved = null;
                ListTerm annots = null;
                if (it != null) {
                    Literal lold = null;
                    block3: while (toBeRemoved == null && it.hasNext()) {
                        lold = it.next();
                        annots = lold.getAnnots("obs_prop_id");
                        if (annots.isEmpty()) continue;
                        for (Term annot : annots) {
                            st = (StringTerm)((Structure)annot).getTerm(0);
                            if (!st.getString().equals(propId)) continue;
                            toBeRemoved = lold;
                            continue block3;
                        }
                    }
                }
                if (toBeRemoved == null) continue;
                Literal removedLit = toBeRemoved.copy().forceFullLiteralImpl();
                if (annots.size() == 1) {
                    a.getBB().remove(toBeRemoved);
                } else {
                    Iterator it2 = toBeRemoved.getAnnots().iterator();
                    removedLit.clearAnnots();
                    while (it2.hasNext()) {
                        Object artId;
                        Term t = (Term)it2.next();
                        if (!t.isStructure()) continue;
                        st = (Structure)t;
                        if (st.getFunctor().equals("obs_prop_id")) {
                            StringTerm sst = (StringTerm)st.getTerm(0);
                            if (!sst.getString().equals(propId)) continue;
                            it2.remove();
                            removedLit.addAnnot(t);
                            continue;
                        }
                        if (st.getArity() <= 0 || (artId = this.lib.termToObject(st.getTerm(0))) == null || !artId.equals(source)) continue;
                        it2.remove();
                        removedLit.addAnnot(t);
                    }
                }
                Trigger te = new Trigger(Trigger.TEOperator.del, Trigger.TEType.belief, removedLit);
                this.getTS().updateEvents(new Event(te, Intention.EmptyInt));
            }
            catch (Exception ex) {
                this.logger.warning("EXCEPTION - processing remove obs prop " + p + " for agent " + this.getTS().getUserAgArch().getAgName());
            }
        }
    }

    protected Op parseOp(Structure action) {
        Term[] terms = action.getTermsArray();
        Object[] opArgs = new Object[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            opArgs[i] = this.lib.termToObject(terms[i]);
        }
        Op op = new Op(action.getFunctor(), opArgs);
        return op;
    }

    protected boolean bind(Object obj, Term term, ActionExec act) {
        try {
            Term t = this.lib.objectToTerm(obj);
            Unifier un = act.getIntention().peek().getUnif();
            return un.unifies(t, term);
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected Object getObject(Term t) {
        return this.lib.termToObject(t);
    }

    public JavaLibrary getJavaLib() {
        return this.lib;
    }

    protected void notifyActionSuccess(Op op, Structure action, ActionExec actionExec) {
        Object[] values = op.getParamValues();
        for (int i = 0; i < action.getArity(); ++i) {
            if (!action.getTerm(i).isVar()) continue;
            try {
                boolean bound = this.bind(values[i], action.getTerm(i), actionExec);
                if (bound) continue;
                actionExec.setResult(false);
                Literal reason = ASSyntax.createLiteral((String)"bind_param_error", (Term[])new Term[]{action.getTerm(i), ASSyntax.createString((Object)values[i])});
                actionExec.setFailureReason(reason, "Error binding parameters: " + action.getTerm(i) + " with " + values[i]);
                super.actionExecuted(actionExec);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        actionExec.setResult(true);
        super.actionExecuted(actionExec);
    }

    protected void notifyActionFailure(ActionExec actionExec, Term reason, String msg) {
        actionExec.setResult(false);
        Literal descr = null;
        if (reason != null) {
            descr = ASSyntax.createLiteral((String)"env_failure_reason", (Term[])new Term[]{reason});
        }
        actionExec.setFailureReason(descr, msg);
        super.actionExecuted(actionExec);
    }

    public boolean notifyCartagoEvent(CartagoEvent ev) {
        this.getArchInfraTier().wake();
        return true;
    }

    protected Literal obsEventToLiteral(ArtifactObsEvent p, JavaLibrary lib) {
        Tuple signal = p.getSignal();
        Object[] contents = signal.getContents();
        try {
            Literal struct = ASSyntax.createLiteral((String)signal.getLabel(), (Term[])lib.objectArray2termArray(contents));
            struct.addAnnot(OBS_EV_PERCEPT);
            this.addSourceAnnots(p.getArtifactId(), lib, struct);
            return struct;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "error creating literal for " + p.getSignal(), ex);
            return null;
        }
    }

    protected Literal obsPropToLiteral(String propId, ArtifactId source, String propName, Object[] args, JavaLibrary lib) throws Exception {
        Literal struct = ASSyntax.createLiteral((String)propName, (Term[])new Term[0]);
        for (Object obj : args) {
            struct.addTerm(lib.objectToTerm(obj));
        }
        struct.addAnnot(BeliefBase.TPercept);
        struct.addAnnot(OBS_PROP_PERCEPT);
        struct.addAnnot((Term)ASSyntax.createStructure((String)"obs_prop_id", (Term[])new Term[]{ASSyntax.createString((String)propId)}));
        this.addSourceAnnots(source, lib, struct);
        return struct;
    }

    private void addSourceAnnots(ArtifactId source, JavaLibrary lib, Literal struct) throws Exception {
        Term id = lib.objectToTerm(source);
        struct.addAnnot((Term)ASSyntax.createStructure((String)"source", (Term[])new Term[]{id}));
        struct.addAnnot((Term)ASSyntax.createStructure((String)"artifact_id", (Term[])new Term[]{id}));
        struct.addAnnot((Term)ASSyntax.createStructure((String)"artifact_name", (Term[])new Term[]{id, ASSyntax.createAtom((String)source.getName())}));
        struct.addAnnot((Term)ASSyntax.createStructure((String)"artifact_type", (Term[])new Term[]{id, ASSyntax.createString((String)source.getArtifactType())}));
        struct.addAnnot((Term)ASSyntax.createStructure((String)"workspace", (Term[])new Term[]{id, ASSyntax.createAtom((String)source.getWorkspaceId().getName()), lib.objectToTerm(source.getWorkspaceId())}));
    }

    protected void consultManual(Manual man) {
        System.out.println(">> CONSULT MANUAL << " + man.getURI());
    }

    public ICartagoSession getEnvSession() {
        return this.envSession;
    }

    public List<WorkspaceId> getAllJoinedWsps() {
        return this.allJoinedWsp;
    }

    public static CAgentArch getCartagoAgArch(TransitionSystem ts) {
        for (AgArch arch = ts.getUserAgArch().getFirstAgArch(); arch != null; arch = arch.getNextAgArch()) {
            if (!(arch instanceof CAgentArch)) continue;
            return (CAgentArch)arch;
        }
        return null;
    }
}

