/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.sl.SimpleSLTokenizer;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.MultiValueProperty;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.RequestFIPAServiceBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class DFService
extends FIPAService {
    public static final String DF_SEARCH_TIMEOUT_KEY = "jade_domain_dfservice_searchtimeout";
    public static final String DF_SEARCH_TIMEOUT_DEFAULT = "30000";
    private static final long OFFSET = 10000L;
    private static final String SPACE_COLON = " :";
    private static final String SPACE_BRACKET = " (";
    private static Long MINUSONE = new Long(-1L);

    static void checkIsValid(DFAgentDescription dfd, boolean checkServices) throws MissingParameter {
        try {
            if (dfd.getName().getName().length() == 0) {
                throw new MissingParameter("df-agent-description", "name");
            }
        }
        catch (NullPointerException npe) {
            throw new MissingParameter("df-agent-description", "name");
        }
        if (checkServices) {
            Iterator i = dfd.getAllServices();
            while (i.hasNext()) {
                ServiceDescription sd = (ServiceDescription)i.next();
                if (sd.getName() == null) {
                    throw new MissingParameter("service-description", "name");
                }
                if (sd.getType() != null) continue;
                throw new MissingParameter("service-description", "type");
            }
        }
    }

    public static DFAgentDescription register(Agent a, AID dfName, DFAgentDescription dfd) throws FIPAException {
        if (dfd == null) {
            dfd = new DFAgentDescription();
        }
        if (dfd.getName() == null) {
            dfd.setName(a.getAID());
        }
        DFService.checkIsValid(dfd, true);
        ACLMessage request = DFService.createRequestMessage(a, dfName, "register", dfd, null);
        ACLMessage reply = DFService.doFipaRequestClient(a, request);
        if (reply == null) {
            throw new FIPAException("Missing reply");
        }
        return DFService.decodeDone(reply.getContent());
    }

    public static DFAgentDescription register(Agent a, DFAgentDescription dfd) throws FIPAException {
        return DFService.register(a, a.getDefaultDF(), dfd);
    }

    public static void deregister(Agent a, AID dfName, DFAgentDescription dfd) throws FIPAException {
        ACLMessage request;
        ACLMessage reply;
        if (dfd == null) {
            dfd = new DFAgentDescription();
        }
        if (dfd.getName() == null) {
            dfd.setName(a.getAID());
        }
        if ((reply = DFService.doFipaRequestClient(a, request = DFService.createRequestMessage(a, dfName, "deregister", dfd, null))) == null) {
            throw new FIPAException("Missing reply");
        }
    }

    public static void deregister(Agent a, DFAgentDescription dfd) throws FIPAException {
        DFService.deregister(a, a.getDefaultDF(), dfd);
    }

    public static void deregister(Agent a, AID dfName) throws FIPAException {
        DFService.deregister(a, dfName, null);
    }

    public static void deregister(Agent a) throws FIPAException {
        DFService.deregister(a, a.getDefaultDF());
    }

    public static DFAgentDescription modify(Agent a, AID dfName, DFAgentDescription dfd) throws FIPAException {
        if (dfd == null) {
            dfd = new DFAgentDescription();
        }
        if (dfd.getName() == null) {
            dfd.setName(a.getAID());
        }
        DFService.checkIsValid(dfd, true);
        ACLMessage request = DFService.createRequestMessage(a, dfName, "modify", dfd, null);
        ACLMessage reply = DFService.doFipaRequestClient(a, request);
        if (reply == null) {
            throw new FIPAException("Missing reply");
        }
        return DFService.decodeDone(reply.getContent());
    }

    public static DFAgentDescription modify(Agent a, DFAgentDescription dfd) throws FIPAException {
        return DFService.modify(a, a.getDefaultDF(), dfd);
    }

    public static void keepRegistered(Agent a, AID df2, final DFAgentDescription dfd, Date deadline) {
        AID theDF;
        Date lease = dfd.getLeaseTime();
        AID aID = theDF = df2 != null ? df2 : a.getDefaultDF();
        if (lease != null && (deadline == null || lease.getTime() < deadline.getTime())) {
            dfd.setLeaseTime(deadline);
            a.addBehaviour(new WakerBehaviour(a, new Date(lease.getTime() - 10000L)){

                protected void onWake() {
                    try {
                        DFAgentDescription newDfd = DFService.modify(this.myAgent, theDF, dfd);
                        DFService.keepRegistered(this.myAgent, theDF, newDfd, dfd.getLeaseTime());
                    }
                    catch (FIPAException fe) {
                        fe.printStackTrace();
                    }
                }
            });
        }
    }

    public static DFAgentDescription[] search(Agent a, AID dfName, DFAgentDescription dfd, SearchConstraints constraints) throws FIPAException {
        if (dfName == null) {
            dfName = a.getDefaultDF();
        }
        if (dfd == null) {
            dfd = new DFAgentDescription();
        }
        if (constraints == null) {
            constraints = new SearchConstraints();
            constraints.setMaxResults(MINUSONE);
        }
        ACLMessage request = DFService.createRequestMessage(a, dfName, "search", dfd, constraints);
        int timeout = 0;
        try {
            timeout = Integer.parseInt(a.getProperty(DF_SEARCH_TIMEOUT_KEY, DF_SEARCH_TIMEOUT_DEFAULT));
        }
        catch (Exception e) {
            throw new FIPAException("Property jade_domain_dfservice_searchtimeout is not a valid value for integer parameter");
        }
        ACLMessage inform = DFService.doFipaRequestClient(a, request, timeout);
        if (inform == null) {
            throw new FIPAException("Timeout searching for data into df");
        }
        return DFService.decodeResult(inform.getContent());
    }

    public static DFAgentDescription[] search(Agent a, DFAgentDescription dfd, SearchConstraints constraints) throws FIPAException {
        return DFService.search(a, null, dfd, constraints);
    }

    public static DFAgentDescription[] search(Agent a, DFAgentDescription dfd) throws FIPAException {
        return DFService.search(a, null, dfd, null);
    }

    public static DFAgentDescription[] search(Agent a, AID dfName, DFAgentDescription dfd) throws FIPAException {
        return DFService.search(a, dfName, dfd, null);
    }

    public static DFAgentDescription[] searchUntilFound(Agent a, AID dfName, DFAgentDescription dfd, SearchConstraints constraints, long timeout) throws FIPAException {
        ACLMessage subscribe = DFService.createSubscriptionMessage(a, dfName, dfd, constraints);
        ACLMessage inform = DFService.doFipaRequestClient(a, subscribe, timeout);
        ACLMessage cancel = DFService.createCancelMessage(a, dfName, subscribe);
        a.send(cancel);
        DFAgentDescription[] result = null;
        if (inform != null) {
            result = DFService.decodeNotification(inform.getContent());
        }
        return result;
    }

    public static ACLMessage createRequestMessage(Agent a, AID dfName, String action, DFAgentDescription dfd, SearchConstraints constraints) {
        ACLMessage request = DFService.createRequestMessage(a, dfName);
        request.setContent(DFService.encodeAction(dfName, action, dfd, constraints));
        return request;
    }

    public static ACLMessage createSubscriptionMessage(Agent a, AID dfName, DFAgentDescription template, SearchConstraints constraints) {
        ACLMessage subscribe = DFService.createRequestMessage(a, dfName);
        subscribe.setPerformative(19);
        subscribe.setProtocol("fipa-subscribe");
        subscribe.setLanguage("fipa-sl");
        if (constraints == null) {
            constraints = new SearchConstraints();
            constraints.setMaxResults(MINUSONE);
        }
        subscribe.setContent(DFService.encodeIota(dfName, template, constraints));
        return subscribe;
    }

    public static ACLMessage getSubscriptionMessage(Agent a, AID dfName, DFAgentDescription template, SearchConstraints constraints) throws FIPAException {
        return DFService.createSubscriptionMessage(a, dfName, template, constraints);
    }

    public static ACLMessage createCancelMessage(Agent a, AID dfName, ACLMessage subscribe) {
        ACLMessage cancel = new ACLMessage(2);
        cancel.addReceiver(dfName);
        cancel.setLanguage(subscribe.getLanguage());
        cancel.setOntology(subscribe.getOntology());
        cancel.setProtocol(subscribe.getProtocol());
        cancel.setConversationId(subscribe.getConversationId());
        cancel.setContent(DFService.encodeCancel(dfName, subscribe));
        return cancel;
    }

    public static DFAgentDescription decodeDone(String s) throws FIPAException {
        try {
            int start = s.indexOf("df-agent-description");
            return DFService.parseDfd(new SimpleSLTokenizer(s.substring(start)));
        }
        catch (Exception e) {
            throw new FIPAException("Error decoding INFORM Done. " + e.getMessage());
        }
    }

    public static DFAgentDescription[] decodeResult(String s) throws FIPAException {
        try {
            int start = s.indexOf("action");
            start += DFService.countUntilEnclosing(s, start);
            return DFService.decodeDfdSequence(s.substring(start));
        }
        catch (Exception e) {
            throw new FIPAException("Error decoding INFORM Result. " + e.getMessage());
        }
    }

    public static DFAgentDescription[] decodeNotification(String s) throws FIPAException {
        try {
            int start = s.indexOf("iota");
            start += DFService.countUntilEnclosing(s, start);
            return DFService.decodeDfdSequence(s.substring(start));
        }
        catch (Exception e) {
            throw new FIPAException("Error decoding INFORM Equals. " + e.getMessage());
        }
    }

    private static DFAgentDescription parseDfd(SimpleSLTokenizer parser) throws Exception {
        DFAgentDescription dfd = new DFAgentDescription();
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            Iterator it;
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                parser.consumeChar('(');
                dfd.setName(DFService.parseAID(parser));
                continue;
            }
            if (slotName.equals("lease-time")) {
                dfd.setLeaseTime(ISO8601.toDate(parser.getElement()));
                continue;
            }
            if (slotName.equals("protocols")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    dfd.addProtocols((String)it.next());
                }
                continue;
            }
            if (slotName.equals("languages")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    dfd.addLanguages((String)it.next());
                }
                continue;
            }
            if (slotName.equals("ontologies")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    dfd.addOntologies((String)it.next());
                }
                continue;
            }
            if (!slotName.equals("services")) continue;
            it = DFService.parseAggregate(parser).iterator();
            while (it.hasNext()) {
                dfd.addServices((ServiceDescription)it.next());
            }
        }
        parser.consumeChar(')');
        return dfd;
    }

    private static ServiceDescription parseServiceDescription(SimpleSLTokenizer parser) throws Exception {
        ServiceDescription sd = new ServiceDescription();
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            Iterator it;
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                sd.setName(parser.getElement());
                continue;
            }
            if (slotName.equals("type")) {
                sd.setType(parser.getElement());
                continue;
            }
            if (slotName.equals("ownership")) {
                sd.setOwnership(parser.getElement());
                continue;
            }
            if (slotName.equals("protocols")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    sd.addProtocols((String)it.next());
                }
                continue;
            }
            if (slotName.equals("languages")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    sd.addLanguages((String)it.next());
                }
                continue;
            }
            if (slotName.equals("ontologies")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    sd.addOntologies((String)it.next());
                }
                continue;
            }
            if (!slotName.equals("properties")) continue;
            it = DFService.parseAggregate(parser).iterator();
            while (it.hasNext()) {
                sd.addProperties((Property)it.next());
            }
        }
        parser.consumeChar(')');
        return sd;
    }

    private static Property parseProperty(SimpleSLTokenizer parser) throws Exception {
        Property p = new Property();
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                p.setName(parser.getElement());
            }
            if (!slotName.equals("value")) continue;
            p.setValue(parser.getElement());
        }
        parser.consumeChar(')');
        return p;
    }

    private static Property parseMultiValueProperty(SimpleSLTokenizer parser) throws Exception {
        MultiValueProperty mvp = new MultiValueProperty();
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                mvp.setName(parser.getElement());
            }
            if (!slotName.equals("value")) continue;
            mvp.setValues(DFService.parseAggregate(parser));
        }
        parser.consumeChar(')');
        return mvp;
    }

    public static AID parseAID(SimpleSLTokenizer parser) throws Exception {
        AID id = new AID("", true);
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            Iterator it;
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                id.setName(parser.getElement());
                continue;
            }
            if (slotName.equals("addresses")) {
                it = DFService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    id.addAddresses((String)it.next());
                }
                continue;
            }
            if (!slotName.equals("resolvers")) continue;
            it = DFService.parseAggregate(parser).iterator();
            while (it.hasNext()) {
                id.addResolvers((AID)it.next());
            }
        }
        parser.consumeChar(')');
        return id;
    }

    private static List parseAggregate(SimpleSLTokenizer parser) throws Exception {
        ArrayList l = new ArrayList();
        parser.consumeChar('(');
        parser.getElement();
        String next = parser.nextToken();
        while (!next.startsWith(")")) {
            if (!next.startsWith("(")) {
                l.add(parser.getElement());
            } else {
                parser.consumeChar('(');
                next = parser.nextToken();
                if (next.equals("df-agent-description")) {
                    l.add(DFService.parseDfd(parser));
                }
                if (next.equals("agent-identifier")) {
                    l.add(DFService.parseAID(parser));
                } else if (next.equals("service-description")) {
                    l.add(DFService.parseServiceDescription(parser));
                } else if (next.equals("multi-value-property")) {
                    l.add(DFService.parseMultiValueProperty(parser));
                } else if (next.equals("property")) {
                    l.add(DFService.parseProperty(parser));
                }
            }
            next = parser.nextToken();
        }
        parser.consumeChar(')');
        return l;
    }

    private static DFAgentDescription[] decodeDfdSequence(String s) throws Exception {
        List l = DFService.parseAggregate(new SimpleSLTokenizer(s));
        DFAgentDescription[] items = new DFAgentDescription[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            items[i] = (DFAgentDescription)l.get(i);
        }
        return items;
    }

    private static int countUntilEnclosing(String s, int start) {
        int openCnt = 1;
        boolean skipMode = false;
        int cnt = start;
        while (openCnt > 0) {
            char c = s.charAt(cnt++);
            if (!skipMode) {
                if (c == '(') {
                    ++openCnt;
                    continue;
                }
                if (c == ')') {
                    --openCnt;
                    continue;
                }
                if (c != '\"') continue;
                skipMode = true;
                continue;
            }
            if (c == '\\' && s.charAt(cnt) == '\"') {
                ++cnt;
                continue;
            }
            if (c != '\"') continue;
            skipMode = false;
        }
        return cnt - start;
    }

    static String encodeAction(AID df2, String actionName, DFAgentDescription dfd, SearchConstraints sc) {
        StringBuffer sb = new StringBuffer("((");
        sb.append("action");
        sb.append(' ');
        sb.append(df2.toString());
        sb.append(SPACE_BRACKET);
        sb.append(actionName);
        sb.append(' ');
        DFService.encodeDfd(sb, dfd);
        if (actionName.equals("search") && sc == null) {
            sc = new SearchConstraints();
            sc.setMaxResults(MINUSONE);
        }
        if (sc != null) {
            sb.append(SPACE_BRACKET);
            sb.append("search-constraints");
            DFService.encodeField(sb, sc.getMaxResults(), "max-results");
            DFService.encodeField(sb, sc.getMaxDepth(), "max-depth");
            DFService.encodeField(sb, sc.getSearchId(), "search-id");
            sb.append(')');
        }
        sb.append(")))");
        return sb.toString();
    }

    static String encodeIota(AID df2, DFAgentDescription dfd, SearchConstraints sc) {
        StringBuffer sb = new StringBuffer("((iota ?x (");
        sb.append("result");
        sb.append(' ');
        String tmp = DFService.encodeAction(df2, "search", dfd, sc);
        sb.append(tmp.substring(1, tmp.length() - 1));
        sb.append(" ?x)))");
        return sb.toString();
    }

    static String encodeCancel(AID df2, ACLMessage msg) {
        StringBuffer sb = new StringBuffer("((");
        sb.append("action");
        sb.append(' ');
        sb.append(df2.toString());
        sb.append(SPACE_BRACKET);
        sb.append(ACLMessage.getPerformative(msg.getPerformative()));
        DFService.encodeField(sb, msg.getSender(), "sender");
        DFService.encodeAggregate(sb, msg.getAllReceiver(), "sequence", "receivers");
        DFService.encodeField(sb, msg.getProtocol(), "protocol");
        DFService.encodeField(sb, msg.getLanguage(), "language");
        DFService.encodeField(sb, msg.getOntology(), "ontology");
        DFService.encodeField(sb, msg.getReplyWith(), "reply-with");
        DFService.encodeField(sb, msg.getConversationId(), "conversation-id");
        DFService.encodeField(sb, msg.getContent(), "content");
        sb.append(")))");
        return sb.toString();
    }

    private static void encodeDfd(StringBuffer sb, DFAgentDescription dfd) {
        sb.append('(');
        sb.append("df-agent-description");
        DFService.encodeField(sb, dfd.getName(), "name");
        DFService.encodeAggregate(sb, dfd.getAllProtocols(), "set", "protocols");
        DFService.encodeAggregate(sb, dfd.getAllLanguages(), "set", "languages");
        DFService.encodeAggregate(sb, dfd.getAllOntologies(), "set", "ontologies");
        DFService.encodeAggregate(sb, dfd.getAllServices(), "set", "services");
        Date lease = dfd.getLeaseTime();
        if (lease != null) {
            sb.append(SPACE_COLON);
            sb.append("lease-time");
            sb.append(' ');
            sb.append(ISO8601.toString(lease));
        }
        sb.append(')');
    }

    private static void encodeServiceDescription(StringBuffer sb, ServiceDescription sd) {
        sb.append('(');
        sb.append("service-description");
        DFService.encodeField(sb, sd.getName(), "name");
        DFService.encodeField(sb, sd.getType(), "type");
        DFService.encodeField(sb, sd.getOwnership(), "ownership");
        DFService.encodeAggregate(sb, sd.getAllProtocols(), "set", "protocols");
        DFService.encodeAggregate(sb, sd.getAllLanguages(), "set", "languages");
        DFService.encodeAggregate(sb, sd.getAllOntologies(), "set", "ontologies");
        DFService.encodeAggregate(sb, sd.getAllProperties(), "set", "properties");
        sb.append(')');
    }

    private static void encodeProperty(StringBuffer sb, Property p) {
        sb.append('(');
        sb.append("property");
        DFService.encodeField(sb, p.getName(), "name");
        DFService.encodeField(sb, p.getValue(), "value");
        sb.append(')');
    }

    private static void encodeMultiValueProperty(StringBuffer sb, MultiValueProperty mvp) {
        sb.append('(');
        sb.append("multi-value-property");
        DFService.encodeField(sb, mvp.getName(), "name");
        DFService.encodeAggregate(sb, mvp.getValues().iterator(), "sequence", "value");
        sb.append(')');
    }

    private static void encodeField(StringBuffer sb, Object val, String name) {
        if (val != null) {
            sb.append(SPACE_COLON);
            sb.append(name);
            sb.append(' ');
            if (val instanceof String) {
                DFService.encodeString(sb, (String)val);
            } else {
                sb.append(val);
            }
        }
    }

    private static void encodeAggregate(StringBuffer sb, Iterator agg, String aggType, String name) {
        if (agg != null && agg.hasNext()) {
            sb.append(SPACE_COLON);
            sb.append(name);
            sb.append(SPACE_BRACKET);
            sb.append(aggType);
            while (agg.hasNext()) {
                sb.append(' ');
                Object val = agg.next();
                if (val instanceof ServiceDescription) {
                    DFService.encodeServiceDescription(sb, (ServiceDescription)val);
                    continue;
                }
                if (val instanceof MultiValueProperty) {
                    DFService.encodeMultiValueProperty(sb, (MultiValueProperty)val);
                    continue;
                }
                if (val instanceof Property) {
                    DFService.encodeProperty(sb, (Property)val);
                    continue;
                }
                if (val instanceof String) {
                    DFService.encodeString(sb, (String)val);
                    continue;
                }
                sb.append(val);
            }
            sb.append(')');
        }
    }

    private static void encodeString(StringBuffer sb, String s) {
        if (SimpleSLTokenizer.isAWord(s)) {
            sb.append(s);
        } else {
            sb.append(SimpleSLTokenizer.quoteString(s));
        }
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID dfName, String actionName, DFAgentDescription dfd, SearchConstraints constraints) throws FIPAException {
        return new RequestFIPAServiceBehaviour(a, dfName, actionName, dfd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName, DFAgentDescription dfd, SearchConstraints constraints) throws FIPAException {
        return DFService.getNonBlockingBehaviour(a, a.getDefaultDF(), actionName, dfd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName) throws FIPAException {
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(a.getAID());
        SearchConstraints constraints = new SearchConstraints();
        constraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(a, a.getDefaultDF(), actionName, dfd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID dfName, String actionName) throws FIPAException {
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(a.getAID());
        SearchConstraints constraints = new SearchConstraints();
        constraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(a, dfName, actionName, dfd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, String actionName, DFAgentDescription dfd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        constraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(a, a.getDefaultDF(), actionName, dfd, constraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent a, AID dfName, String actionName, DFAgentDescription dfd) throws FIPAException {
        SearchConstraints constraints = new SearchConstraints();
        constraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(a, dfName, actionName, dfd, constraints);
    }
}

