/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.Sink;
import jade.core.SliceProxy;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import java.util.Vector;

public class ServiceManagerImpl
implements ServiceManager,
ServiceFinder {
    private static final int IDLE_STATUS = 0;
    private static final int ACTIVE_STATUS = 1;
    private static final int TERMINATING_STATUS = 2;
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor;
    private PlatformManager myPlatformManager;
    private boolean invalidPlatformManager;
    private String platformName;
    private Node localNode;
    private NodeDescriptor localNodeDescriptor;
    private Map localServices;
    private Map backupManagers;
    private int status = 0;
    private Logger myLogger;

    ServiceManagerImpl(Profile p, PlatformManager pm) throws ProfileException {
        this.myCommandProcessor = p.getCommandProcessor();
        this.myIMTPManager = p.getIMTPManager();
        this.myPlatformManager = pm;
        this.invalidPlatformManager = false;
        this.localServices = new HashMap(5);
        this.backupManagers = new HashMap(1);
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    public String getPlatformName() throws IMTPException {
        if (this.platformName == null) {
            try {
                this.platformName = this.myPlatformManager.getPlatformName();
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    this.platformName = this.myPlatformManager.getPlatformName();
                }
                throw imtpe;
            }
        }
        return this.platformName;
    }

    public synchronized void addAddress(String addr) throws IMTPException {
        this.myLogger.log(Logger.INFO, "Adding PlatformManager address " + addr);
        if (this.invalidPlatformManager || !this.compareTransportAddresses(addr, this.myPlatformManager.getLocalAddress())) {
            this.backupManagers.put(addr, this.myIMTPManager.getPlatformManagerProxy(addr));
            if (this.invalidPlatformManager) {
                this.reconnect();
            }
        }
    }

    public synchronized void removeAddress(String addr) throws IMTPException {
        this.myLogger.log(Logger.INFO, "Removing PlatformManager address " + addr);
        this.backupManagers.remove(addr);
        if (this.compareTransportAddresses(addr, this.myPlatformManager.getLocalAddress())) {
            this.reconnect();
        }
    }

    private boolean compareAddresses(String addr1, String addr2) {
        try {
            TransportAddress ta1 = this.myIMTPManager.stringToAddr(addr1);
            TransportAddress ta2 = this.myIMTPManager.stringToAddr(addr2);
            return CaseInsensitiveString.equalsIgnoreCase(ta1.getProto(), ta2.getProto()) && CaseInsensitiveString.equalsIgnoreCase(ta1.getPort(), ta2.getPort()) && Profile.compareHostNames(ta1.getHost(), ta2.getHost());
        }
        catch (Exception e) {
            return CaseInsensitiveString.equalsIgnoreCase(addr1, addr2);
        }
    }

    public String getLocalAddress() throws IMTPException {
        return this.myPlatformManager.getLocalAddress();
    }

    public void addNode(NodeDescriptor desc, ServiceDescriptor[] services) throws IMTPException, ServiceException, JADESecurityException {
        this.localNodeDescriptor = desc;
        this.localNode = desc.getNode();
        try {
            Vector<ServiceDescriptor> ss = new Vector<ServiceDescriptor>(services != null ? services.length : 0);
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    ServiceDescriptor sd = services[i];
                    try {
                        this.installServiceLocally(sd);
                        if (this.isLocal(sd.getService())) continue;
                        ss.addElement(sd);
                        continue;
                    }
                    catch (Exception e) {
                        if (services[i].isMandatory()) {
                            throw e;
                        }
                        this.myLogger.log(Logger.WARNING, "Exception installing service " + sd.getName(), e);
                    }
                }
            }
            String name = null;
            try {
                name = this.myPlatformManager.addNode(desc, ss, false);
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    name = this.myPlatformManager.addNode(desc, ss, false);
                }
                throw imtpe;
            }
            this.adjustName(name);
            this.status = 1;
        }
        catch (IMTPException imtpe2) {
            throw imtpe2;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (JADESecurityException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ServiceException("Unexpected error activating node", t);
        }
    }

    public void removeNode(NodeDescriptor desc) throws IMTPException, ServiceException {
        this.status = 2;
        Object[] names = this.localServices.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            try {
                String svcName = (String)names[i];
                this.uninstallServiceLocally(svcName);
                continue;
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
        }
        if (desc.getNode().hasPlatformManager()) {
            this.myIMTPManager.unexportPlatformManager(this.myPlatformManager);
        }
    }

    public void activateService(ServiceDescriptor desc) throws IMTPException, ServiceException {
        block5: {
            try {
                this.installServiceLocally(desc);
                if (this.isLocal(desc.getService())) break block5;
                try {
                    this.myPlatformManager.addSlice(desc, this.localNodeDescriptor, false);
                }
                catch (IMTPException imtpe) {
                    if (this.reconnect()) {
                        this.myPlatformManager.addSlice(desc, this.localNodeDescriptor, false);
                        break block5;
                    }
                    throw imtpe;
                }
            }
            catch (IMTPException imtpe2) {
                this.uninstallServiceLocally(desc.getName());
                throw imtpe2;
            }
        }
    }

    private boolean isLocal(Service svc) {
        return svc instanceof BaseService && ((BaseService)svc).isLocal();
    }

    public void deactivateService(String name) throws IMTPException, ServiceException {
        ServiceDescriptor desc = (ServiceDescriptor)this.localServices.get(name);
        if (desc != null) {
            try {
                this.myPlatformManager.removeSlice(name, this.localNode.getName(), false);
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    this.myPlatformManager.removeSlice(name, this.localNode.getName(), false);
                }
                throw imtpe;
            }
            this.uninstallServiceLocally(name);
        }
    }

    public Service findService(String key) throws IMTPException, ServiceException {
        Service svc = null;
        ServiceDescriptor svcDsc = (ServiceDescriptor)this.localServices.get(key);
        if (svcDsc != null) {
            svc = svcDsc.getService();
        }
        return svc;
    }

    public Service.Slice findSlice(String serviceKey, String sliceKey) throws IMTPException, ServiceException {
        Service.Slice slice = null;
        try {
            slice = this.myPlatformManager.findSlice(serviceKey, sliceKey);
        }
        catch (IMTPException imtpe) {
            if (this.reconnect()) {
                slice = this.myPlatformManager.findSlice(serviceKey, sliceKey);
            }
            throw imtpe;
        }
        return this.bindToLocalNode(slice);
    }

    public Service.Slice[] findAllSlices(String serviceKey) throws IMTPException, ServiceException {
        Vector v = null;
        try {
            v = this.myPlatformManager.findAllSlices(serviceKey);
        }
        catch (IMTPException imtpe) {
            if (this.reconnect()) {
                v = this.myPlatformManager.findAllSlices(serviceKey);
            }
            throw imtpe;
        }
        if (v == null) {
            return null;
        }
        Service.Slice[] ss = new Service.Slice[v.size()];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.bindToLocalNode((Service.Slice)v.elementAt(i));
        }
        return ss;
    }

    private void installServiceLocally(ServiceDescriptor svcDsc) throws IMTPException, ServiceException {
        Service.Slice localSlice;
        Sink sTgt;
        Sink sSrc;
        Filter fIn;
        Service svc = svcDsc.getService();
        Filter fOut = svc.getCommandFilter(true);
        if (fOut != null) {
            fOut.setServiceName(svc.getName());
            this.myCommandProcessor.addFilter(fOut, true);
        }
        if ((fIn = svc.getCommandFilter(false)) != null) {
            if (fIn == fOut) {
                this.myCommandProcessor.removeFilter(fOut, true);
                throw new ServiceException("The same filter object cannot be used as both incoming and outgoing filter.");
            }
            fIn.setServiceName(svc.getName());
            this.myCommandProcessor.addFilter(fIn, false);
        }
        if ((sSrc = svc.getCommandSink(false)) != null) {
            this.myCommandProcessor.registerSink(sSrc, false, svc.getName());
        }
        if ((sTgt = svc.getCommandSink(true)) != null) {
            this.myCommandProcessor.registerSink(sTgt, true, svc.getName());
        }
        if ((localSlice = svc.getLocalSlice()) != null) {
            this.localNode.exportSlice(svc.getName(), localSlice);
        }
        this.localServices.put(svc.getName(), svcDsc);
        if (svc instanceof BaseService) {
            BaseService bs = (BaseService)svc;
            bs.setCommandProcessor(this.myCommandProcessor);
        }
    }

    private void uninstallServiceLocally(String name) throws IMTPException, ServiceException {
        ServiceDescriptor svcDsc = (ServiceDescriptor)this.localServices.get(name);
        if (svcDsc != null) {
            Sink sTgt;
            Sink sSrc;
            Filter fIn;
            Service svc = svcDsc.getService();
            svc.shutdown();
            Filter fOut = svc.getCommandFilter(true);
            if (fOut != null) {
                this.myCommandProcessor.removeFilter(fOut, true);
            }
            if ((fIn = svc.getCommandFilter(false)) != null) {
                this.myCommandProcessor.removeFilter(fIn, false);
            }
            if ((sSrc = svc.getCommandSink(false)) != null) {
                this.myCommandProcessor.deregisterSink(false, svc.getName());
            }
            if ((sTgt = svc.getCommandSink(true)) != null) {
                this.myCommandProcessor.deregisterSink(true, svc.getName());
            }
        }
        this.localNode.unexportSlice(name);
        this.localServices.remove(name);
    }

    void platformManagerDead(String deadPMAddr, String notifyingPMAddr) throws IMTPException {
        this.myLogger.log(Logger.INFO, "PlatformManager at " + deadPMAddr + " no longer valid!");
        if (this.compareTransportAddresses(deadPMAddr, this.myPlatformManager.getLocalAddress())) {
            GenericCommand gCmd = new GenericCommand("Dead-Platform-Manager", null, null);
            gCmd.addParam(this.myPlatformManager.getLocalAddress());
            Object result = this.myCommandProcessor.processIncoming(gCmd);
            if (result instanceof Throwable) {
                this.myLogger.log(Logger.WARNING, "Unexpected error processing DEAD_PLATFORM_MANAGER command.");
                ((Throwable)result).printStackTrace();
            }
        }
        if (deadPMAddr.equals(notifyingPMAddr)) {
            this.reattach(notifyingPMAddr);
        } else {
            this.addAddress(notifyingPMAddr);
            this.removeAddress(deadPMAddr);
        }
    }

    private synchronized void reattach(String pmAddr) {
        if (this.invalidPlatformManager || this.compareTransportAddresses(pmAddr, this.myPlatformManager.getLocalAddress())) {
            this.invalidPlatformManager = true;
            try {
                this.myPlatformManager = this.myIMTPManager.getPlatformManagerProxy(pmAddr);
                this.myLogger.log(Logger.INFO, "Re-attaching to PlatformManager at address " + this.myPlatformManager.getLocalAddress());
                String name = this.myPlatformManager.addNode(this.localNodeDescriptor, this.getLocalServices(), false);
                if (!name.equals(this.localNodeDescriptor.getName())) {
                    this.myLogger.log(Logger.WARNING, "Container name changed re-attaching to PlatformManager: new name = " + name);
                }
                this.adjustName(name);
                this.handlePMRefreshed(pmAddr);
                GenericCommand gCmd = new GenericCommand("Reattached", null, null);
                Object result = this.myCommandProcessor.processIncoming(gCmd);
                if (result instanceof Throwable) {
                    this.myLogger.log(Logger.WARNING, "Unexpected error processing REATTACHED command.");
                    ((Throwable)result).printStackTrace();
                }
                this.myLogger.log(Logger.INFO, "Re-attachement OK");
            }
            catch (Exception e) {
                this.myLogger.log(Logger.SEVERE, "Cannot re-attach to PlatformManager at " + pmAddr + ". " + e);
                e.printStackTrace();
            }
        }
    }

    private synchronized boolean reconnect() {
        if (this.status == 1) {
            try {
                this.myPlatformManager.ping();
                return true;
            }
            catch (IMTPException imtpe) {
                this.invalidPlatformManager = true;
                Iterator it = this.backupManagers.keySet().iterator();
                while (it.hasNext()) {
                    String addr = (String)it.next();
                    try {
                        this.myPlatformManager = (PlatformManager)this.backupManagers.get(addr);
                        this.myLogger.log(Logger.INFO, "Reconnecting to PlatformManager at address " + this.myPlatformManager.getLocalAddress());
                        this.myPlatformManager.adopt(this.localNode, null);
                        this.handlePMRefreshed(addr);
                        GenericCommand gCmd = new GenericCommand("Reconnected", null, null);
                        Object result = this.myCommandProcessor.processIncoming(gCmd);
                        if (result instanceof Throwable) {
                            this.myLogger.log(Logger.WARNING, "Unexpected error processing RECONNECTED command.");
                            ((Throwable)result).printStackTrace();
                        }
                        this.myLogger.log(Logger.INFO, "Reconnection OK");
                        return true;
                    }
                    catch (Exception e) {
                        this.myLogger.log(Logger.WARNING, "Reconnection failed");
                    }
                }
            }
        }
        return false;
    }

    private void handlePMRefreshed(String pmAddr) {
        Object[] services = this.localServices.values().toArray();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor svcDsc = (ServiceDescriptor)services[i];
            Service svc = svcDsc.getService();
            if (!(svc instanceof BaseService)) continue;
            ((BaseService)svc).clearCachedSlice("$$$Main-Slice$$$");
        }
        this.myIMTPManager.reconnected(this.myPlatformManager);
        this.backupManagers.remove(pmAddr);
        this.invalidPlatformManager = false;
    }

    public Vector getLocalServices() {
        Object[] services = this.localServices.values().toArray();
        Vector<Object> ss = new Vector<Object>(services.length);
        for (int i = 0; i < services.length; ++i) {
            ss.addElement(services[i]);
        }
        return ss;
    }

    private void adjustName(String name) {
        this.localNodeDescriptor.setName(name);
        this.localNode.setName(name);
        ContainerID cid = this.localNodeDescriptor.getContainer();
        if (cid != null) {
            cid.setName(name);
        }
    }

    private Service.Slice bindToLocalNode(Service.Slice slice) throws ServiceException {
        if (slice != null) {
            Node n;
            if (slice instanceof SliceProxy) {
                ((SliceProxy)slice).setLocalNodeDescriptor(this.localNodeDescriptor);
            }
            if ((n = slice.getNode()).getName().equals(this.localNode.getName()) && !n.equals(this.localNode)) {
                ((SliceProxy)slice).setNode(this.localNode);
            }
        }
        return slice;
    }

    private boolean compareTransportAddresses(String addr1, String addr2) {
        return Profile.compareTransportAddresses(addr1, addr2, this.myIMTPManager);
    }
}

