/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainerImpl;
import jade.core.BECodec;
import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndManager;
import jade.core.FrontEnd;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.LADT;
import jade.core.NameClashException;
import jade.core.NotFoundException;
import jade.core.PostponedException;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Specifier;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.imtp.leap.FrontEndStub;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Properties;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class BackEndContainer
extends AgentContainerImpl
implements BackEnd {
    public static final String USE_BACKEND_MANAGER = "jade_core_BackEndContainer_usebemanager";
    public static final String RESYNCH = "jade_core_BackEndContainer_resynch";
    private static final String ADDR_LIST_DELIMITERS = ", \n\t\r";
    private boolean terminating = false;
    private FrontEnd myFrontEnd;
    private BEConnectionManager myConnectionManager;
    private BackEndManager theBEManager;
    private Map agentImages = new HashMap(1);
    private Map serviceBECodecs = null;
    private Map principals = new HashMap(1);
    private Properties creationProperties;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private boolean synchronizing = false;
    private Object frontEndSynchLock = new Object();
    private List fronEndSynchBuffer = new ArrayList();

    private static Properties adjustProperties(Properties pp) {
        String additionalServices;
        pp.setProperty("main", "false");
        String services = pp.getProperty("services");
        if (services == null) {
            services = "jade.core.event.NotificationService";
        }
        if ((additionalServices = pp.getProperty("additional-services")) != null) {
            services = services + ";" + additionalServices;
        }
        pp.setProperty("services", services);
        String feServices = pp.getProperty("be-required-services");
        if (feServices != null) {
            Vector ss = Specifier.parseList(pp.getProperty("services"), ';');
            Vector fess = Specifier.parseList(feServices, ';');
            for (int i = 0; i < fess.size(); ++i) {
                String s = (String)fess.get(i);
                if (ss.contains(s)) continue;
                ss.add(s);
            }
            pp.setProperty("services", Specifier.encodeList(ss, ';'));
        }
        return pp;
    }

    public BackEndContainer(Properties props, BEConnectionManager cm) throws ProfileException {
        this.myProfile = new ProfileImpl(BackEndContainer.adjustProperties(props));
        this.localAgents = new LADT(1);
        this.creationProperties = props;
        this.myConnectionManager = cm;
    }

    public boolean connect() {
        try {
            if (this.myProfile.getBooleanProperty(USE_BACKEND_MANAGER, false)) {
                this.theBEManager = this.initBEManager();
            }
            Vector agentSpecs = Specifier.parseSpecifierList(this.myProfile.getParameter("agents", null));
            this.myProfile.setParameter("agents", null);
            this.myFrontEnd = this.myConnectionManager.getFrontEnd(this, null);
            this.myLogger.log(Logger.FINE, "BackEnd container " + this.myProfile.getParameter("container-name", null) + " joining the platform ... (FrontEnd version: " + this.myProfile.getParameter("version", "not available") + ")");
            Runtime.instance().beginContainer();
            boolean connected = this.joinPlatform();
            if (connected) {
                this.myLogger.log(Logger.FINE, "Join platform OK");
                AID amsAID = this.getAMS();
                this.myProfile.setParameter("platform-id", amsAID.getHap());
                String[] addresses = amsAID.getAddressesArray();
                if (addresses != null) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < addresses.length; ++i) {
                        sb.append(addresses[i]);
                        if (i >= addresses.length - 1) continue;
                        sb.append(';');
                    }
                    this.myProfile.setParameter("addresses", sb.toString());
                }
                if ("true".equals(this.myProfile.getParameter(RESYNCH, "false"))) {
                    this.myLogger.log(Logger.INFO, "BackEnd container " + this.myProfile.getParameter("container-name", null) + " activating re-synch ...");
                    this.resynch();
                } else {
                    for (int i = 0; i < agentSpecs.size(); ++i) {
                        Specifier sp = (Specifier)agentSpecs.elementAt(i);
                        try {
                            String name = this.bornAgent(sp.getName());
                            sp.setClassName(name);
                            sp.setArgs(null);
                            continue;
                        }
                        catch (Exception e) {
                            this.myLogger.log(Logger.SEVERE, "Error creating agent " + sp.getName(), e);
                            sp.setClassName(e.getClass().getName());
                            sp.setArgs(new Object[]{e.getMessage()});
                        }
                    }
                    this.myProfile.setParameter("agents", Specifier.encodeSpecifierList(agentSpecs));
                }
            }
            return connected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void startNode() throws IMTPException, ProfileException, ServiceException, JADESecurityException, NotFoundException {
        ArrayList services = new ArrayList();
        this.initMandatoryServices(services);
        List l = this.myProfile.getSpecifiers("services");
        this.myProfile.setSpecifiers("services", l);
        this.initAdditionalServices(l.iterator(), services);
        ServiceDescriptor[] descriptors = new ServiceDescriptor[services.size()];
        for (int i = 0; i < descriptors.length; ++i) {
            descriptors[i] = (ServiceDescriptor)services.get(i);
        }
        if (this.theBEManager != null) {
            this.myNodeDescriptor.setParentNode(this.theBEManager.getNode());
        }
        this.getServiceManager().addNode(this.myNodeDescriptor, descriptors);
        if (this.theBEManager != null) {
            this.theBEManager.register(this.myNodeDescriptor);
        }
        this.bootAllServices(services);
    }

    void initMandatoryServices(List services) throws ServiceException {
        ServiceDescriptor dsc = this.startService("jade.core.management.BEAgentManagementService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        dsc = this.startService("jade.core.messaging.MessagingService", false);
        dsc.setMandatory(true);
        services.add(dsc);
    }

    public String bornAgent(String name) throws JADESecurityException, IMTPException {
        name = JADEManagementOntology.adjustAgentName(name, new String[]{this.getID().getName()});
        AID id = new AID(AID.createGUID(name, this.getPlatformID()), true);
        GenericCommand cmd = new GenericCommand("Inform-Created", "jade.core.management.AgentManagement", null);
        cmd.addParam(id);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret instanceof NameClashException) {
            throw new JADESecurityException(((NameClashException)ret).getMessage());
        }
        if (ret instanceof JADESecurityException) {
            throw (JADESecurityException)ret;
        }
        if (ret instanceof IMTPException) {
            throw (IMTPException)ret;
        }
        if (ret instanceof Throwable) {
            throw new IMTPException(null, (Exception)ret);
        }
        return name;
    }

    public void deadAgent(String name) throws IMTPException {
        AID id = new AID(AID.createGUID(name, this.getPlatformID()), true);
        this.myLogger.log(Logger.INFO, this.getID() + " - Handling termination of agent " + id.getLocalName());
        this.handleEnd(id);
    }

    public void suspendedAgent(String name) throws NotFoundException, IMTPException {
        AID id = new AID(AID.createGUID(name, this.getPlatformID()), true);
        this.handleChangedAgentState(id, 2, 4);
    }

    public void resumedAgent(String name) throws NotFoundException, IMTPException {
        AID id = new AID(AID.createGUID(name, this.getPlatformID()), true);
        this.handleChangedAgentState(id, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageOut(ACLMessage msg, String sender) throws NotFoundException, IMTPException {
        AID id = new AID(AID.createGUID(sender, this.getPlatformID()), true);
        Object object = this.frontEndSynchLock;
        synchronized (object) {
            AgentImage image = this.getAgentImage(id);
            if (image == null) {
                if (this.synchronizing) {
                    this.postponeAfterFrontEndSynch(msg, sender);
                    return;
                }
                throw new NotFoundException("No image for agent " + sender + " on the BackEndContainer");
            }
        }
        int size = msg.hasByteSequenceContent() ? msg.getByteSequenceContent().length : (msg.getContent() != null ? msg.getContent().length() : 0);
        this.myLogger.log(Logger.FINE, this.getID() + " - Delivering OUT message " + ACLMessage.getPerformative(msg.getPerformative()) + ", size=" + size);
        this.handleSend(msg, id, false);
    }

    public Object serviceInvokation(String actor, String serviceName, String methodName, Object[] methodParams) throws NotFoundException, ServiceException, IMTPException {
        AID id = new AID(AID.createGUID(actor, this.getPlatformID()), true);
        AgentImage image = this.getAgentImage(id);
        ServiceHelper helper = image.getHelper(serviceName);
        if (helper == null) {
            throw new ServiceException("Service " + serviceName + "does not have a Service-helper");
        }
        BECodec codec = this.getBECodec(serviceName);
        Object[] decodedParams = codec.decodeParams(methodName, methodParams);
        try {
            AccessibleObject m = null;
            Method[] mm = helper.getClass().getMethods();
            for (int i = 0; i < mm.length; ++i) {
                if (!mm[i].getName().equals(methodName) || !this.isCompatible(mm[i], decodedParams)) continue;
                m = mm[i];
                break;
            }
            if (m != null) {
                if (!m.isAccessible()) {
                    try {
                        ((Method)m).setAccessible(true);
                    }
                    catch (SecurityException se) {
                        throw new NoSuchMethodException("Method " + methodName + "() of class " + this.getClass().getName() + " not accessible.");
                    }
                }
                Object result = ((Method)m).invoke(helper, decodedParams);
                return codec.encodeResult(methodName, result);
            }
            throw new ServiceException("No valid " + methodName + " method found in service helper");
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("Unexpected error, ", e);
        }
    }

    private boolean isCompatible(Method method, Object[] params) {
        int length = params != null ? params.length : 0;
        return method.getParameterTypes().length == length;
    }

    private BECodec getBECodec(String serviceName) {
        BECodec codec;
        if (this.serviceBECodecs == null) {
            this.serviceBECodecs = new HashMap(2);
        }
        if ((codec = (BECodec)this.serviceBECodecs.get(serviceName)) == null) {
            try {
                codec = (BECodec)Class.forName(serviceName + "BECodec").newInstance();
            }
            catch (Exception e) {
                codec = new BECodec(){

                    public Object[] decodeParams(String methodName, Object[] methodParams) {
                        return methodParams;
                    }

                    public Object encodeResult(String methodName, Object result) {
                        return result;
                    }
                };
            }
            this.serviceBECodecs.put(serviceName, codec);
        }
        return codec;
    }

    public void createAgentOnFE(String name, String className, String[] args) throws IMTPException {
        this.myFrontEnd.createAgent(name, className, args);
    }

    public void killAgentOnFE(String name) throws IMTPException, NotFoundException {
        try {
            this.myFrontEnd.killAgent(name);
        }
        catch (PostponedException pe) {
            this.deadAgent(name);
        }
    }

    public void suspendAgentOnFE(String name) throws IMTPException, NotFoundException {
        try {
            this.myFrontEnd.suspendAgent(name);
        }
        catch (PostponedException pe) {
            this.suspendedAgent(name);
        }
    }

    public void resumeAgentOnFE(String name) throws IMTPException, NotFoundException {
        try {
            this.myFrontEnd.resumeAgent(name);
        }
        catch (PostponedException pe) {
            this.resumedAgent(name);
        }
    }

    public boolean postMessageToLocalAgent(ACLMessage msg, AID receiverID) {
        boolean found = super.postMessageToLocalAgent(msg, receiverID);
        if (found) {
            return found;
        }
        AgentImage image = (AgentImage)this.agentImages.get(receiverID);
        if (image != null) {
            if (this.agentImages.containsKey(msg.getSender()) && this.isExplicitReceiver(msg, receiverID)) {
                return true;
            }
            try {
                int size = msg.hasByteSequenceContent() ? msg.getByteSequenceContent().length : (msg.getContent() != null ? msg.getContent().length() : 0);
                this.myLogger.log(Logger.FINE, this.getID() + " - Delivering IN message " + ACLMessage.getPerformative(msg.getPerformative()) + ", size=" + size);
                this.myFrontEnd.messageIn(msg, receiverID.getLocalName());
                this.handlePosted(receiverID, msg);
                return true;
            }
            catch (NotFoundException nfe) {
                System.out.println("WARNING: Missing agent in FrontEnd");
                return false;
            }
            catch (IMTPException imtpe) {
                System.out.println("WARNING: Can't deliver message to FrontEnd");
                return false;
            }
        }
        System.out.println("WARNING: Agent " + receiverID + " not found on BackEnd container");
        return false;
    }

    private boolean isExplicitReceiver(ACLMessage msg, AID receiver) {
        Iterator it = msg.getAllIntendedReceiver();
        while (it.hasNext()) {
            if (!receiver.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    public Agent acquireLocalAgent(AID id) {
        Agent ag = super.acquireLocalAgent(id);
        if (ag == null) {
            ag = (Agent)this.agentImages.get(id);
        }
        return ag;
    }

    public void releaseLocalAgent(AID id) {
        super.releaseLocalAgent(id);
    }

    public AID[] agentNames() {
        int i;
        AID[] realAgents = super.agentNames();
        AID[] images = this.getAgentImages();
        AID[] all = new AID[realAgents.length + images.length];
        for (i = 0; i < realAgents.length; ++i) {
            all[i] = realAgents[i];
        }
        for (i = 0; i < images.length; ++i) {
            all[i + realAgents.length] = images[i];
        }
        return all;
    }

    public void enableDebugger(AID debuggerName, AID toBeDebugged) throws IMTPException {
        throw new IMTPException("Unsupported operation");
    }

    public void disableDebugger(AID debuggerName, AID notToBeDebugged) throws IMTPException {
        throw new IMTPException("Unsupported operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        BackEndContainer backEndContainer = this;
        synchronized (backEndContainer) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        try {
            this.myFrontEnd.exit(false);
        }
        catch (IMTPException imtpe) {
            this.myConnectionManager.shutdown();
        }
        this.killAgentImages();
        if (this.theBEManager != null) {
            this.theBEManager.deregister(this.myNodeDescriptor);
        }
        super.shutDown();
    }

    private void killAgentImages() {
        AID[] ids = this.getAgentImages();
        for (int i = 0; i < ids.length; ++i) {
            this.handleEnd(ids[i]);
        }
        if (this.agentImages.size() > 0) {
            this.myLogger.log(Logger.WARNING, "# " + this.agentImages.size() + " zombie agent images found.");
            this.agentImages.clear();
        }
    }

    private String[] parseAddressList(String toParse) {
        StringTokenizer lexer = new StringTokenizer(toParse, ADDR_LIST_DELIMITERS);
        ArrayList addresses = new ArrayList();
        while (lexer.hasMoreTokens()) {
            String tok = lexer.nextToken();
            addresses.add(tok);
        }
        Object[] objs = addresses.toArray();
        String[] result = new String[objs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)objs[i];
        }
        return result;
    }

    private BackEndManager initBEManager() {
        try {
            return BackEndManager.getInstance(null);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Cannot retrieve BackEndManager. " + e);
            e.printStackTrace();
            return null;
        }
    }

    public AgentImage createAgentImage(AID id) {
        return new AgentImage(id);
    }

    public AgentImage addAgentImage(AID id, AgentImage img) {
        return (AgentImage)this.agentImages.put(id, img);
    }

    public AgentImage removeAgentImage(AID id) {
        AgentImage img = (AgentImage)this.agentImages.remove(id);
        this.removePendingMessages(MessageTemplate.MatchReceiver(new AID[]{id}), true);
        return img;
    }

    public AgentImage getAgentImage(AID id) {
        return (AgentImage)this.agentImages.get(id);
    }

    public AID[] getAgentImages() {
        Object[] objs = this.agentImages.keySet().toArray();
        AID[] result = new AID[objs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (AID)objs[i];
        }
        return result;
    }

    public List removePendingMessages(MessageTemplate template, boolean notifyFailure) {
        List pendingMsg = ((FrontEndStub)this.myFrontEnd).removePendingMessages(template);
        if (pendingMsg.size() > 0) {
            this.myLogger.log(Logger.INFO, "Removed " + pendingMsg.size() + " pending messages from BackEnd queue.");
        }
        if (notifyFailure) {
            Iterator it = pendingMsg.iterator();
            while (it.hasNext()) {
                try {
                    Object[] removed = (Object[])it.next();
                    ACLMessage msg = (ACLMessage)removed[0];
                    AID receiver = new AID(AID.createGUID((String)removed[1], this.getPlatformID()), true);
                    ServiceFinder myFinder = this.getServiceFinder();
                    MessagingService msgSvc = (MessagingService)myFinder.findService("jade.core.messaging.Messaging");
                    msgSvc.notifyFailureToSender(new GenericMessage(msg), receiver, new InternalError("Agent dead"));
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Cannot send AMS FAILURE. " + e);
                }
            }
        }
        return pendingMsg;
    }

    private void resynch() {
        this.synchronizing = true;
        Thread synchronizer = new Thread(){

            public void run() {
                while (!BackEndContainer.this.terminating) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        BackEndContainer.this.myLogger.log(Logger.INFO, "BackEnd container " + BackEndContainer.this.here().getName() + " - Sending SYNCH command to FE ...");
                        BackEndContainer.this.myFrontEnd.synch();
                        BackEndContainer.this.notifySynchronized();
                        BackEndContainer.this.myLogger.log(Logger.INFO, "BackEnd container " + BackEndContainer.this.here().getName() + " - Resynch completed");
                        break;
                    }
                    catch (IMTPException imtpe) {
                        BackEndContainer.this.myLogger.log(Logger.WARNING, "BackEnd container " + BackEndContainer.this.here().getName() + " - IMTP Exception in resynch. Wait a bit and retry...");
                    }
                }
            }
        };
        synchronizer.start();
    }

    private void postponeAfterFrontEndSynch(ACLMessage msg, String sender) {
        this.fronEndSynchBuffer.add(new MessageSenderPair(msg, sender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySynchronized() {
        Object object = this.frontEndSynchLock;
        synchronized (object) {
            Iterator it = this.fronEndSynchBuffer.iterator();
            while (it.hasNext()) {
                try {
                    MessageSenderPair msp = (MessageSenderPair)it.next();
                    this.messageOut(msp.getMessage(), msp.getSender());
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (IMTPException imtpe) {
                    imtpe.printStackTrace();
                }
            }
            this.fronEndSynchBuffer.clear();
            this.synchronizing = false;
        }
    }

    private class MessageSenderPair {
        private ACLMessage msg;
        private String sender;

        private MessageSenderPair(ACLMessage msg, String sender) {
            this.msg = msg;
            this.sender = sender;
        }

        private ACLMessage getMessage() {
            return this.msg;
        }

        private String getSender() {
            return this.sender;
        }
    }

    public class AgentImage
    extends Agent {
        private AgentImage(AID id) {
            super(id);
            this.setToolkit(BackEndContainer.this);
        }
    }
}

