/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.ContentManager;
import jade.core.AID;
import jade.core.AgentState;
import jade.core.AgentToolkit;
import jade.core.DummyToolkit;
import jade.core.InternalMessageQueue;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MessageQueue;
import jade.core.Scheduler;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.core.behaviours.Behaviour;
import jade.core.mobility.AgentMobilityHelper;
import jade.core.mobility.Movable;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import jade.wrapper.AgentContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
implements Runnable,
Serializable,
TimerListener {
    private static final long serialVersionUID = 3487495895819000L;
    public static final int AP_MIN = 0;
    public static final int AP_INITIATED = 1;
    public static final int AP_ACTIVE = 2;
    public static final int AP_IDLE = 3;
    public static final int AP_SUSPENDED = 4;
    public static final int AP_WAITING = 5;
    public static final int AP_DELETED = 6;
    public static final int AP_MAX = 13;
    public static final int D_MIN = 9;
    public static final int D_ACTIVE = 10;
    public static final int D_SUSPENDED = 20;
    public static final int D_RETIRED = 30;
    public static final int D_UNKNOWN = 40;
    public static final int D_MAX = 41;
    public static final String MSG_QUEUE_CLASS = "jade_core_Agent_msgQueueClass";
    private transient AgentToolkit myToolkit;
    private transient MessageQueue msgQueue;
    private int msgQueueMaxSize = 0;
    private transient boolean temporaryMessageQueue;
    private transient List o2aQueue;
    private int o2aQueueSize = 0;
    private transient jade.util.leap.Map o2aLocks;
    private Behaviour o2aManager = null;
    private transient Object suspendLock;
    private Map<Class<?>, Object> o2aInterfaces;
    private String myName = null;
    private AID myAID = null;
    private String myHap = null;
    private transient Object stateLock;
    private transient Thread myThread;
    private transient TimerDispatcher theDispatcher;
    private Scheduler myScheduler;
    private transient AssociationTB pendingTimers;
    private boolean restarting = false;
    private LifeCycle myLifeCycle;
    private LifeCycle myBufferedLifeCycle;
    private LifeCycle myActiveLifeCycle;
    private transient LifeCycle myDeletedLifeCycle;
    private transient LifeCycle mySuspendedLifeCycle;
    private boolean terminating = false;
    private boolean generateBehaviourEvents = false;
    private transient AgentContainer myContainer = null;
    private transient Object[] arguments = null;
    private transient AgentMobilityHelper mobHelper;
    private ContentManager theContentManager = null;
    private transient Hashtable helpersTable;
    private transient Set persistentPendingTimers = new HashSet();

    public void restartLater(Behaviour b, long millis) {
        if (millis <= 0L) {
            return;
        }
        Timer t = new Timer(System.currentTimeMillis() + millis, this);
        this.pendingTimers.addPair(b, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTimeOut(Timer t) {
        Behaviour b = null;
        TimerDispatcher timerDispatcher = this.theDispatcher;
        synchronized (timerDispatcher) {
            b = this.pendingTimers.getPeer(t);
            if (b != null) {
                this.pendingTimers.removeMapping(b);
            }
        }
        if (b != null) {
            b.restart();
        } else {
            System.out.println("Warning: No mapping found for expired timer " + t.expirationTime());
        }
    }

    public void notifyRestarted(Behaviour b) {
        Behaviour root = b.root();
        if (root.isRunnable()) {
            this.myScheduler.restart(root);
        }
    }

    public void removeTimer(Behaviour b) {
        Timer t = this.pendingTimers.getPeer(b);
        if (t != null) {
            this.pendingTimers.removeMapping(b);
        }
    }

    public Agent() {
        this.myToolkit = DummyToolkit.instance();
        this.o2aLocks = new HashMap();
        this.suspendLock = new Object();
        this.temporaryMessageQueue = true;
        this.msgQueue = new InternalMessageQueue(this.msgQueueMaxSize, this);
        this.stateLock = new Object();
        this.pendingTimers = new AssociationTB();
        this.myLifeCycle = this.myActiveLifeCycle = new ActiveLifeCycle();
        this.myScheduler = new Scheduler(this);
        this.theDispatcher = TimerDispatcher.getTimerDispatcher();
        this.o2aInterfaces = new Hashtable();
    }

    protected MessageQueue createMessageQueue() {
        String msgQueueClass = this.getProperty(MSG_QUEUE_CLASS, null);
        if (msgQueueClass != null) {
            try {
                return (MessageQueue)Class.forName(msgQueueClass).newInstance();
            }
            catch (Exception e) {
                System.out.println("Error loading MessageQueue of class " + msgQueueClass + " [" + e + "]");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initMessageQueue() {
        if (this.temporaryMessageQueue) {
            this.temporaryMessageQueue = false;
            MessageQueue queue = this.createMessageQueue();
            if (queue != null) {
                queue.setMaxSize(this.msgQueueMaxSize);
                MessageQueue messageQueue = this.msgQueue;
                synchronized (messageQueue) {
                    int size = this.msgQueue.size();
                    if (size > 0) {
                        ArrayList l = new ArrayList(size);
                        this.msgQueue.copyTo(l);
                        Iterator it = l.iterator();
                        while (it.hasNext()) {
                            queue.addLast((ACLMessage)it.next());
                        }
                    }
                    this.msgQueue = queue;
                }
            }
        }
    }

    MessageQueue getMessageQueue() {
        return this.msgQueue;
    }

    private void setMessageQueue(MessageQueue mq) {
        this.msgQueue = mq;
    }

    Agent(AID id) {
        this.setAID(id);
    }

    public AgentContainer getContainerController() {
        if (this.myContainer == null) {
            try {
                JADEPrincipal principal = null;
                Credentials credentials = null;
                try {
                    CredentialsHelper ch = (CredentialsHelper)((Object)this.getHelper("jade.core.security.Security"));
                    principal = ch.getPrincipal();
                    credentials = ch.getCredentials();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                this.myContainer = this.myToolkit.getContainerController(principal, credentials);
            }
            catch (Exception e) {
                throw new IllegalStateException("A ContainerController cannot be got for this agent. Probably the method has been called at an appropriate time before the complete initialization of the agent.");
            }
        }
        return this.myContainer;
    }

    public final void setArguments(Object[] args) {
        this.arguments = args;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    void setRestarting(boolean restarting) {
        this.restarting = restarting;
    }

    public final boolean isRestarting() {
        return this.restarting;
    }

    public final AID getAMS() {
        return this.myToolkit.getAMS();
    }

    public AID getDefaultDF() {
        return this.myToolkit.getDefaultDF();
    }

    public final String getLocalName() {
        return this.myName;
    }

    public final String getName() {
        if (this.myHap != null) {
            return this.myName + '@' + this.myHap;
        }
        return this.myName;
    }

    public final String getHap() {
        return this.myHap;
    }

    public final AID getAID() {
        return this.myAID;
    }

    void setAID(AID id) {
        this.myName = id.getLocalName();
        this.myHap = id.getHap();
        this.myAID = id;
    }

    public final AID getAID(String name) {
        String guid = AID.createGUID(name, this.getHap());
        AID result = new AID(guid, true);
        Iterator it = this.myAID.getAllAddresses();
        while (it.hasNext()) {
            result.addAddresses((String)it.next());
        }
        it = this.myAID.getAllResolvers();
        while (it.hasNext()) {
            result.addResolvers((AID)it.next());
        }
        return result;
    }

    synchronized void addPlatformAddress(String address) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.addAddresses(address);
        }
    }

    synchronized void removePlatformAddress(String address) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.removeAddresses(address);
        }
    }

    public Location here() {
        return this.myToolkit.here();
    }

    public void join() {
        try {
            if (this.myThread == null) {
                return;
            }
            this.myThread.join(5000L);
            if (this.myThread.isAlive()) {
                System.out.println("*** Warning: Agent " + this.myName + " did not terminate when requested to do so.");
                if (!this.myThread.equals(Thread.currentThread())) {
                    this.myThread.interrupt();
                    System.out.println("*** Second interrupt issued.");
                }
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public void setQueueSize(int newSize) throws IllegalArgumentException {
        this.msgQueue.setMaxSize(newSize);
        this.msgQueueMaxSize = newSize;
    }

    public int getCurQueueSize() {
        return this.msgQueue.size();
    }

    public int getQueueSize() {
        return this.msgQueue.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStateTo(LifeCycle newLifeCycle) {
        boolean changed = false;
        newLifeCycle.setAgent(this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.myLifeCycle.equals(newLifeCycle) && this.myLifeCycle.transitionTo(newLifeCycle)) {
                this.myBufferedLifeCycle = this.myLifeCycle;
                this.myLifeCycle = newLifeCycle;
                changed = true;
                this.notifyChangedAgentState(this.myBufferedLifeCycle.getState(), this.myLifeCycle.getState());
            }
        }
        if (changed) {
            this.myLifeCycle.transitionFrom(this.myBufferedLifeCycle);
            if (!Thread.currentThread().equals(this.myThread)) {
                this.interruptThread();
            }
        }
    }

    public void restoreBufferedState() {
        this.changeStateTo(this.myBufferedLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveState(int newState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.myLifeCycle == this.myActiveLifeCycle) {
                int oldState = this.myLifeCycle.getState();
                if (newState != oldState) {
                    ((ActiveLifeCycle)this.myLifeCycle).setState(newState);
                    this.notifyChangedAgentState(oldState, newState);
                }
            } else {
                throw new Interrupted();
            }
        }
    }

    public int getState() {
        return this.myLifeCycle.getState();
    }

    public AgentState getAgentState() {
        return AgentState.getInstance(this.getState());
    }

    Scheduler getScheduler() {
        return this.myScheduler;
    }

    private void initMobHelper() throws ServiceException {
        if (this.mobHelper == null) {
            this.mobHelper = (AgentMobilityHelper)this.getHelper("jade.core.mobility.AgentMobility");
            this.mobHelper.registerMovable(new Movable(){

                public void beforeMove() {
                    Agent.this.beforeMove();
                }

                public void afterMove() {
                    Agent.this.afterMove();
                }

                public void beforeClone() {
                    Agent.this.beforeClone();
                }

                public void afterClone() {
                    Agent.this.afterClone();
                }
            });
        }
    }

    public void doMove(Location destination) {
        try {
            this.initMobHelper();
            this.mobHelper.move(destination);
        }
        catch (ServiceException se) {
            return;
        }
    }

    public void doClone(Location destination, String newName) {
        try {
            this.initMobHelper();
            this.mobHelper.clone(destination, newName);
        }
        catch (ServiceException se) {
            return;
        }
    }

    public void doSuspend() {
        if (this.mySuspendedLifeCycle == null) {
            this.mySuspendedLifeCycle = new SuspendedLifeCycle();
        }
        this.changeStateTo(this.mySuspendedLifeCycle);
    }

    public void doActivate() {
        this.restoreBufferedState();
    }

    public void doWait() {
        this.doWait(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(long millis) {
        if (Thread.currentThread().equals(this.myThread)) {
            this.setActiveState(5);
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                try {
                    this.waitOn(this.msgQueue, millis);
                }
                catch (InterruptedException ie) {
                    if (this.myLifeCycle != this.myActiveLifeCycle && !this.terminating) {
                        throw new Interrupted();
                    }
                    System.out.println("Agent " + this.getName() + " interrupted while waiting");
                }
                this.setActiveState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWake() {
        Object object = this.stateLock;
        synchronized (object) {
            int previous = this.myLifeCycle.getState();
            if (previous == 5 || previous == 3) {
                this.setActiveState(2);
            }
        }
        if (this.myLifeCycle.isMessageAware()) {
            this.activateAllBehaviours();
            object = this.msgQueue;
            synchronized (object) {
                this.msgQueue.notifyAll();
            }
        }
    }

    public void doDelete() {
        if (this.myDeletedLifeCycle == null) {
            this.myDeletedLifeCycle = new DeletedLifeCycle();
        }
        this.changeStateTo(this.myDeletedLifeCycle);
    }

    void idle() throws InterruptedException {
        this.setActiveState(3);
        this.waitOn(this.myScheduler, 0L);
        this.setActiveState(2);
    }

    public void write(OutputStream s) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(s);
        out.writeUTF(this.myName);
        out.writeObject(this);
    }

    public void restore(InputStream s) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putO2AObject(Object o, boolean blocking) throws InterruptedException {
        if (this.o2aQueue == null) {
            return;
        }
        CondVar cond = null;
        List list = this.o2aQueue;
        synchronized (list) {
            if (this.o2aQueueSize != 0 && this.o2aQueue.size() == this.o2aQueueSize) {
                this.o2aQueue.remove(0);
            }
            this.o2aQueue.add(o);
            if (blocking) {
                cond = new CondVar();
                this.o2aLocks.put(o, cond);
            }
        }
        if (this.o2aManager == null) {
            this.activateAllBehaviours();
        } else {
            this.o2aManager.restart();
        }
        if (blocking) {
            cond.waitOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getO2AObject() {
        if (this.o2aQueue == null) {
            return null;
        }
        CondVar cond = null;
        Object result = null;
        List list = this.o2aQueue;
        synchronized (list) {
            if (this.o2aQueue.isEmpty()) {
                return null;
            }
            result = this.o2aQueue.remove(0);
            cond = (CondVar)this.o2aLocks.remove(result);
        }
        if (cond != null) {
            cond.set();
        }
        return result;
    }

    public void setEnabledO2ACommunication(boolean enabled, int queueSize) {
        if (enabled) {
            if (this.o2aQueue == null) {
                this.o2aQueue = new ArrayList(queueSize);
            }
            if (queueSize >= 0) {
                this.o2aQueueSize = queueSize;
            }
        } else {
            Iterator it = this.o2aLocks.values().iterator();
            while (it.hasNext()) {
                CondVar cv = (CondVar)it.next();
                if (cv == null) continue;
                cv.set();
            }
            this.o2aQueue = null;
        }
    }

    public void setO2AManager(Behaviour b) {
        this.o2aManager = b;
    }

    public <T> T getO2AInterface(Class<T> theInterface) {
        return (T)this.o2aInterfaces.get(theInterface);
    }

    public <T> void registerO2AInterface(Class<T> theInterface, T implementation) {
        this.o2aInterfaces.put(theInterface, implementation);
    }

    @Override
    public final void run() {
        try {
            this.myLifeCycle.init();
            while (this.myLifeCycle.alive()) {
                try {
                    this.myLifeCycle.execute();
                    Thread.yield();
                }
                catch (JADESecurityException jse) {
                    System.out.println("JADESecurityException: " + jse.getMessage());
                }
                catch (InterruptedException ie) {
                }
                catch (InterruptedIOException ie) {
                }
                catch (Interrupted i) {}
            }
        }
        catch (Throwable t) {
            System.err.println("***  Uncaught Exception for agent " + this.myName + "  ***");
            t.printStackTrace();
        }
        this.terminating = true;
        this.myLifeCycle.end();
    }

    public void clean(boolean ok) {
        if (!ok) {
            System.out.println("ERROR: Agent " + this.myName + " died without being properly terminated !!!");
            System.out.println("State was " + this.myLifeCycle.getState());
        }
        Thread.interrupted();
        this.myBufferedLifeCycle = this.myLifeCycle;
        this.myLifeCycle = this.myActiveLifeCycle;
        this.takeDown();
        this.pendingTimers.clear();
        this.myToolkit.handleEnd(this.myAID);
        this.myLifeCycle = this.myBufferedLifeCycle;
    }

    protected void setup() {
    }

    protected void takeDown() {
    }

    protected void beforeMove() {
    }

    protected void afterMove() {
    }

    protected void beforeClone() {
    }

    protected void afterClone() {
    }

    synchronized void powerUp(AID id, Thread t) {
        if (this.myThread == null) {
            this.myName = id.getLocalName();
            this.myHap = id.getHap();
            this.myAID = id;
            this.myToolkit.setPlatformAddresses(this.myAID);
            this.myThread = t;
            this.myThread.start();
        }
    }

    Thread getThread() {
        return this.myThread;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.msgQueueMaxSize = this.msgQueue.getMaxSize();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stateLock = new Object();
        this.suspendLock = new Object();
        this.pendingTimers = new AssociationTB();
        this.theDispatcher = TimerDispatcher.getTimerDispatcher();
        if (this.o2aQueueSize > 0) {
            this.o2aQueue = new ArrayList(this.o2aQueueSize);
        }
        this.o2aLocks = new HashMap();
        this.myToolkit = DummyToolkit.instance();
        this.temporaryMessageQueue = true;
        this.msgQueue = new InternalMessageQueue(this.msgQueueMaxSize, this);
        this.persistentPendingTimers = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilWake(long millis) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            try {
                this.waitOn(this.msgQueue, millis);
            }
            catch (InterruptedException ie) {
                throw new Interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilActivate() throws InterruptedException {
        Object object = this.suspendLock;
        synchronized (object) {
            this.waitOn(this.suspendLock, 0L);
        }
    }

    public void addBehaviour(Behaviour b) {
        b.setAgent(this);
        this.myScheduler.add(b);
    }

    public void removeBehaviour(Behaviour b) {
        this.myScheduler.remove(b);
        b.setAgent(null);
    }

    public final void send(ACLMessage msg) {
        try {
            msg.getSender().getName().charAt(0);
        }
        catch (Exception e) {
            msg.setSender(this.myAID);
        }
        boolean cloneMessage = !"true".equals(msg.clearUserDefinedParameter("JADE-no-clone"));
        this.myToolkit.handleSend(msg, this.myAID, cloneMessage);
    }

    public final ACLMessage receive() {
        return this.receive(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage receive(MessageTemplate pattern) {
        ACLMessage msg = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            msg = this.msgQueue.receive(pattern);
            if (msg != null) {
                this.myToolkit.handleReceived(this.myAID, msg);
            }
        }
        return msg;
    }

    public final ACLMessage blockingReceive() {
        return this.blockingReceive(null, 0L);
    }

    public final ACLMessage blockingReceive(long millis) {
        return this.blockingReceive(null, millis);
    }

    public final ACLMessage blockingReceive(MessageTemplate pattern) {
        return this.blockingReceive(pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage blockingReceive(MessageTemplate pattern, long millis) {
        ACLMessage msg = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            msg = this.receive(pattern);
            long timeToWait = millis;
            while (msg == null) {
                long startTime = System.currentTimeMillis();
                if (Thread.currentThread().equals(this.myThread)) {
                    this.doWait(timeToWait);
                } else {
                    this.waitUntilWake(timeToWait);
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                msg = this.receive(pattern);
                if (millis == 0L || (timeToWait -= elapsedTime) > 0L) continue;
                break;
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putBack(ACLMessage msg) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            this.msgQueue.addFirst(msg);
        }
    }

    final void setToolkit(AgentToolkit at) {
        this.myToolkit = at;
    }

    final void resetToolkit() {
        this.myToolkit = DummyToolkit.instance();
    }

    public synchronized void waitUntilStarted() {
        while (this.myLifeCycle.getState() == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyStarted() {
        this.notifyAll();
    }

    void notifyAddBehaviour(Behaviour b) {
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleBehaviourAdded(this.myAID, b);
        }
    }

    void notifyRemoveBehaviour(Behaviour b) {
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleBehaviourRemoved(this.myAID, b);
        }
    }

    public void notifyChangeBehaviourState(Behaviour b, String from, String to) {
        b.setExecutionState(to);
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleChangeBehaviourState(this.myAID, b, from, to);
        }
    }

    public void setGenerateBehaviourEvents(boolean b) {
        this.generateBehaviourEvents = b;
    }

    private boolean getGenerateBehaviourEvents() {
        return this.generateBehaviourEvents;
    }

    private void notifyChangedAgentState(int oldState, int newState) {
        this.myToolkit.handleChangedAgentState(this.myAID, oldState, newState);
    }

    private void activateAllBehaviours() {
        this.myScheduler.restartAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postMessage(ACLMessage msg) {
        msg.setPostTimeStamp();
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            if (msg != null) {
                this.myToolkit.handlePosted(this.myAID, msg);
                this.msgQueue.addLast(msg);
                this.doWake();
            }
        }
    }

    public ContentManager getContentManager() {
        if (this.theContentManager == null) {
            this.theContentManager = new ContentManager();
        }
        return this.theContentManager;
    }

    public ServiceHelper getHelper(String serviceName) throws ServiceException {
        ServiceHelper se = null;
        if (this.helpersTable == null) {
            this.helpersTable = new Hashtable();
        }
        if ((se = (ServiceHelper)this.helpersTable.get(serviceName)) == null) {
            se = this.myToolkit.getHelper(this, serviceName);
            if (se != null) {
                se.init(this);
                this.helpersTable.put(serviceName, se);
            } else {
                throw new ServiceException("Null helper");
            }
        }
        return se;
    }

    public String getProperty(String key, String aDefault) {
        String sval;
        String val = this.myToolkit.getProperty(key, aDefault);
        if ((val == null || val.equals(aDefault)) && (sval = System.getProperty(key)) != null) {
            val = sval;
        }
        return val;
    }

    public Properties getBootProperties() {
        return this.myToolkit.getBootProperties();
    }

    private void interruptThread() {
        this.myThread.interrupt();
    }

    void waitOn(Object lock, long millis) throws InterruptedException {
        lock.wait(millis);
    }

    private Set getBehaviours() {
        Behaviour[] behaviours = this.myScheduler.getBehaviours();
        HashSet<Behaviour> result = new HashSet<Behaviour>();
        result.addAll(Arrays.asList(behaviours));
        return result;
    }

    private void setBehaviours(Set behaviours) {
        Behaviour[] arr = new Behaviour[behaviours.size()];
        arr = behaviours.toArray(arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].setAgent(this);
        }
        this.myScheduler.setBehaviours(arr);
    }

    private Set getPendingTimers() {
        return this.persistentPendingTimers;
    }

    private void setPendingTimers(Set timers) {
        if (!this.persistentPendingTimers.equals(timers)) {
            this.pendingTimers.clear();
            for (TBPair pair : timers) {
                this.pendingTimers.addPair(pair);
            }
        }
        this.persistentPendingTimers = timers;
    }

    private class SuspendedLifeCycle
    extends LifeCycle {
        private static final long serialVersionUID = 11113L;

        private SuspendedLifeCycle() {
            super(4);
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            Agent.this.waitUntilActivate();
        }

        public void end() {
            Agent.this.clean(false);
        }

        public boolean transitionTo(LifeCycle to) {
            return to.getState() == 2 || to.getState() == 6;
        }
    }

    private class DeletedLifeCycle
    extends LifeCycle {
        private static final long serialVersionUID = 11112L;

        private DeletedLifeCycle() {
            super(6);
        }

        public void end() {
            Agent.this.clean(true);
        }

        public boolean alive() {
            return false;
        }
    }

    private class ActiveLifeCycle
    extends LifeCycle {
        private static final long serialVersionUID = 11111L;

        private ActiveLifeCycle() {
            super(1);
        }

        public void setState(int s) {
            this.myState = s;
        }

        public void init() {
            Agent.this.setActiveState(2);
            Agent.this.notifyStarted();
            Agent.this.setup();
            Agent.this.restarting = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            Behaviour currentBehaviour = Agent.this.myScheduler.schedule();
            long oldRestartCounter = currentBehaviour.getRestartCounter();
            currentBehaviour.actionWrapper();
            if (currentBehaviour.done()) {
                currentBehaviour.onEnd();
                Agent.this.myScheduler.remove(currentBehaviour);
                currentBehaviour = null;
            } else {
                Scheduler scheduler = Agent.this.myScheduler;
                synchronized (scheduler) {
                    if (oldRestartCounter != currentBehaviour.getRestartCounter()) {
                        currentBehaviour.handleRestartEvent();
                    }
                    if (!currentBehaviour.isRunnable()) {
                        Agent.this.myScheduler.block(currentBehaviour);
                        currentBehaviour = null;
                    }
                }
            }
        }

        public void end() {
            Agent.this.clean(false);
        }

        public boolean transitionTo(LifeCycle to) {
            if (!Agent.this.terminating) {
                this.myState = 2;
                return true;
            }
            return false;
        }

        public void transitionFrom(LifeCycle from) {
            Agent.this.activateAllBehaviours();
        }

        public boolean isMessageAware() {
            return true;
        }
    }

    private static class CondVar {
        private boolean value = false;

        private CondVar() {
        }

        public synchronized void waitOn() throws InterruptedException {
            while (!this.value) {
                this.wait();
            }
        }

        public synchronized void set() {
            this.value = true;
            this.notifyAll();
        }
    }

    private static class TBPair {
        private Timer myTimer;
        private long expirationTime;
        private Behaviour myBehaviour;
        private Agent owner;

        public TBPair() {
            this.expirationTime = -1L;
        }

        public TBPair(Agent a, Timer t, Behaviour b) {
            this.owner = a;
            this.myTimer = t;
            this.expirationTime = t.expirationTime();
            this.myBehaviour = b;
        }

        public void setTimer(Timer t) {
            this.myTimer = t;
        }

        public Timer getTimer() {
            return this.myTimer;
        }

        public Behaviour getBehaviour() {
            return this.myBehaviour;
        }

        public void setBehaviour(Behaviour b) {
            this.myBehaviour = b;
        }

        public Agent getOwner() {
            return this.owner;
        }

        public void setOwner(Agent o) {
            this.owner = o;
            this.createTimerIfNeeded();
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(long when) {
            this.expirationTime = when;
            this.createTimerIfNeeded();
        }

        private void createTimerIfNeeded() {
            if (this.myTimer == null && this.owner != null && this.expirationTime > 0L) {
                this.myTimer = new Timer(this.expirationTime, this.owner);
            }
        }
    }

    private class AssociationTB {
        private Hashtable BtoT = new Hashtable();
        private Hashtable TtoB = new Hashtable();

        private AssociationTB() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                Enumeration e = this.timers();
                while (e.hasMoreElements()) {
                    Timer t = (Timer)e.nextElement();
                    Agent.this.theDispatcher.remove(t);
                }
                this.BtoT.clear();
                this.TtoB.clear();
                Agent.this.persistentPendingTimers.clear();
            }
        }

        public void addPair(Behaviour b, Timer t) {
            TBPair pair = new TBPair(Agent.this, t, b);
            this.addPair(pair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPair(TBPair pair) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                if (pair.getOwner() == null) {
                    pair.setOwner(Agent.this);
                }
                pair.setTimer(Agent.this.theDispatcher.add(pair.getTimer()));
                TBPair old = this.BtoT.put(pair.getBehaviour(), pair);
                if (old != null) {
                    Agent.this.theDispatcher.remove(old.getTimer());
                    Agent.this.persistentPendingTimers.remove(old);
                    this.TtoB.remove(old.getTimer());
                }
                this.TtoB.put(pair.getTimer(), pair);
                Agent.this.persistentPendingTimers.add(pair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMapping(Behaviour b) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                TBPair pair = (TBPair)this.BtoT.remove(b);
                if (pair != null) {
                    this.TtoB.remove(pair.getTimer());
                    Agent.this.persistentPendingTimers.remove(pair);
                    Agent.this.theDispatcher.remove(pair.getTimer());
                }
            }
        }

        public Timer getPeer(Behaviour b) {
            TBPair pair = (TBPair)this.BtoT.get(b);
            if (pair != null) {
                return pair.getTimer();
            }
            return null;
        }

        public Behaviour getPeer(Timer t) {
            TBPair pair = (TBPair)this.TtoB.get(t);
            if (pair != null) {
                return pair.getBehaviour();
            }
            return null;
        }

        private Enumeration timers() {
            return this.TtoB.keys();
        }
    }

    public static class Interrupted
    extends Error {
    }
}

