/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.runtime.MASColorTextPane;
import jason.runtime.MASConsoleGUI;
import java.awt.Color;
import java.awt.Component;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class MASConsoleColorGUI
extends MASConsoleGUI {
    private Map<String, MASColorTextPane> agsTextArea = new HashMap<String, MASColorTextPane>();
    private Map<String, Color> agsColours = new HashMap<String, Color>();
    private MASColorTextPane output;

    private MASConsoleColorGUI(String title) {
        super(title);
    }

    public static MASConsoleGUI get() {
        if (masConsole == null) {
            masConsole = new MASConsoleColorGUI("MAS Console");
        }
        return masConsole;
    }

    @Override
    public void cleanConsole() {
        this.output.setText("");
    }

    @Override
    protected void initOutput() {
        this.output = new MASColorTextPane(Color.black);
        this.output.setEditable(false);
        ((DefaultCaret)this.output.getCaret()).setUpdatePolicy(2);
        if (this.isTabbed()) {
            this.tabPane.add(" all", new JScrollPane(this.output));
        } else {
            this.pcenter.add("Center", new JScrollPane(this.output));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(final String agName, String s) {
        try {
            MASColorTextPane ta;
            Color c = null;
            if (agName != null && (c = this.agsColours.get(agName)) == null) {
                c = MASColorTextPane.getNextAvailableColor();
                this.agsColours.put(agName, c);
            }
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
            if (this.inPause) {
                this.waitNotPause();
            }
            if (this.isTabbed() && agName != null) {
                ta = this.agsTextArea.get(agName);
                if (ta == null) {
                    ta = new MASColorTextPane(Color.black);
                    ta.setEditable(false);
                    ((DefaultCaret)ta.getCaret()).setUpdatePolicy(2);
                    final MASColorTextPane cta = ta;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            int i;
                            MASConsoleColorGUI.this.agsTextArea.put(agName, cta);
                            for (i = 0; i < MASConsoleColorGUI.this.tabPane.getTabCount() && agName.toUpperCase().compareTo(MASConsoleColorGUI.this.tabPane.getTitleAt(i).toUpperCase()) >= 0; ++i) {
                            }
                            MASConsoleColorGUI.this.tabPane.add((Component)new JScrollPane(cta), i);
                            MASConsoleColorGUI.this.tabPane.setTitleAt(i, agName);
                        }
                    });
                }
                if (ta != null) {
                    if (ta.getDocument().getLength() > 100000) {
                        ta.setText("");
                    }
                    ta.append(s);
                }
            }
            ta = this.output;
            synchronized (ta) {
                if (this.output.getDocument().getLength() > 60000) {
                    this.cleanConsole();
                }
                try {
                    this.output.append(c, s);
                }
                catch (IllegalArgumentException e2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e3) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter("e_r_r_o_r.txt"));
                out.write("Error that can not be printed in the MAS Console!\n" + e3.toString() + "\n");
                e3.printStackTrace(out);
                out.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }
}

