/*
 * Decompiled with CFR 0.152.
 */
package jason.profiling;

import jason.asSemantics.Agent;
import jason.asSyntax.Literal;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class QueryProfiling {
    private int nbUpdateCycles = 0;
    private int nbUpdates = 0;
    private int nbReasoningCycles = 0;
    private int nbCacheHits = 0;
    private int nbQueries = 0;
    private int nbUniqueQueries = 0;
    private long timeForQueries = 0L;
    private long timeForUpdates = 0L;
    private float p = 0.0f;
    private static int nbAgs = -1;
    protected Logger logger = null;
    private Set<String> uniqueQueries = new HashSet<String>();
    private Set<String> lastUniqueQueries = null;
    private Agent ag;
    public static int nbStops = 0;
    public static float nT = 0.0f;
    public static float pT = 0.0f;
    public static float uT = 0.0f;
    public static float cqryT = 0.0f;
    public static float cupdT = 0.0f;
    private static float usesT = 0.0f;
    private static float nbQueriesT = 0.0f;
    private static float nbUniqueQueriesT = 0.0f;
    private static int nbAgsT = 0;
    private static int nbupdateCyclesT = 0;

    public QueryProfiling(Agent ag) {
        this.ag = ag;
        this.logger = Logger.getLogger(QueryProfiling.class.getName() + "-" + ag.getTS().getUserAgArch().getAgName());
    }

    public void incHits() {
        ++this.nbCacheHits;
    }

    public void queryStared(Literal l) {
        this.uniqueQueries.add(l.toString());
        ++this.nbQueries;
    }

    public void queryFinished(Literal l, long time2) {
        this.timeForQueries += time2;
    }

    public void setNbReasoningCycles(int n) {
        this.nbReasoningCycles = n;
    }

    public void newUpdateCycle(int n, int u, long time2) {
        ++this.nbUpdateCycles;
        this.nbUpdates += u;
        this.timeForUpdates += time2;
        int uqSize = this.uniqueQueries.size();
        if (this.lastUniqueQueries != null && uqSize != 0) {
            this.lastUniqueQueries.retainAll(this.uniqueQueries);
            this.p += (float)this.lastUniqueQueries.size() / (float)uqSize;
        }
        this.nbUniqueQueries += uqSize;
        this.lastUniqueQueries = this.uniqueQueries;
        this.uniqueQueries = new HashSet<String>();
        if (nbAgs < 0) {
            try {
                nbAgs = this.ag.getTS().getUserAgArch().getRuntimeServices().getAgentsQty();
            }
            catch (Exception e2) {
                this.logger.fine("Error getting number of agents: " + e2);
            }
        }
    }

    public int getNbUses() {
        return this.nbCacheHits;
    }

    public float getP() {
        return this.p;
    }

    public void show() {
        float N = (float)this.nbQueries / (float)this.nbUpdateCycles;
        float K = (float)this.nbUniqueQueries / (float)this.nbUpdateCycles;
        float n = N / K;
        float u = (float)this.nbUpdates / (float)this.nbUpdateCycles;
        float cqry = (float)this.timeForQueries / (float)this.nbQueries;
        float cupd = (float)this.timeForUpdates / (float)this.nbUpdateCycles;
        this.p /= (float)this.nbUpdateCycles;
        if (K > 0.0f) {
            ++nbAgsT;
            nbQueriesT += N;
            nbUniqueQueriesT += K;
            nT += n;
            pT += this.p;
            uT += u;
            cqryT += cqry;
            cupdT += cupd;
            usesT += (float)this.nbCacheHits / (float)this.nbUpdateCycles;
            nbupdateCyclesT += this.nbUpdateCycles;
        }
        this.logger.info("Number of update cycles               : " + this.nbUpdateCycles);
        this.logger.info("Number of reasoning cycles            : " + this.nbReasoningCycles);
        this.logger.info("Queries by cycle                  (N) : " + N);
        this.logger.info("Number of unique queries by cycle (K) : " + K);
        this.logger.info("N/K                               (n) : " + n);
        this.logger.info("% queries from last cycle         (p) : " + this.p);
        this.logger.info("Query cost                     (Cqry) : " + cqry + " ns");
        this.logger.info("Number of updates by cycle        (U) : " + u);
        this.logger.info("Update cost                    (Cupd) : " + cupd + " ns");
        this.logger.info("Query cache reused by cycle    (hits) : " + (float)this.nbCacheHits / (float)this.nbUpdateCycles);
        if (++nbStops == nbAgs) {
            this.logger.info("* Number of reasoning cycles            : " + nbupdateCyclesT / nbAgsT);
            this.logger.info("* Queries by cycle                  (N) : " + nbQueriesT / (float)nbAgsT);
            this.logger.info("* Number of unique queries by cycle (K) : " + nbUniqueQueriesT / (float)nbAgsT);
            this.logger.info("* N/K                               (n) : " + nT / (float)nbAgsT);
            this.logger.info("* % queries from last cycle         (p) : " + pT / (float)nbAgsT);
            this.logger.info("* Query cost                     (Cqry) : " + cqry / (float)nbAgsT + " ns");
            this.logger.info("* Number of updates by cycle        (U) : " + uT / (float)nbAgsT);
            this.logger.info("* Update cost                    (Cupd) : " + cupdT / (float)nbAgsT + " ns");
            this.logger.info("* Query cache reused by cycle    (hits) : " + usesT / (float)nbAgsT);
        }
    }
}

