/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import jason.jeditplugin.JasonID;
import jason.jeditplugin.NewAgentGUI;
import jason.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class NewProjectGUI
extends NewAgentGUI {
    private static final long serialVersionUID = 1L;
    JTextField projName;
    JTextField projDir;
    JLabel projFinalDir;
    JComboBox projInfra;
    JasonID jasonID;

    public NewProjectGUI(String title, View view, JasonID jasonID) {
        super(title, null, view, ".");
        this.jasonID = jasonID;
    }

    @Override
    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.projName = new JTextField(10);
        this.createField("Project name", this.projName, "Enter he project name here");
        this.projInfra = new JComboBox<String>(Config.get().getAvailableInfrastructures());
        this.projInfra.setSelectedIndex(0);
        this.createField("Infrastructure", this.projInfra, "Set the Infrastructure");
        JPanel jasonHomePanel = new JPanel(new FlowLayout(0));
        this.pLabels.add(new JLabel("Root location:"));
        this.projDir = new JTextField(20);
        this.projDir.setText(System.getProperty("user.home"));
        jasonHomePanel.add(this.projDir);
        JButton setDir = new JButton("Browse");
        setDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    File projDirectory;
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
                    chooser.setDialogTitle("Select the project directory");
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(null) == 0 && (projDirectory = chooser.getSelectedFile()).isDirectory()) {
                        NewProjectGUI.this.projDir.setText(projDirectory.getCanonicalPath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jasonHomePanel.add(setDir);
        this.pFields.add(jasonHomePanel);
        this.projFinalDir = new JLabel();
        this.createField("Directory", this.projFinalDir, "This is the directory that will be created for the new project");
        DocumentListener docLis = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e2) {
                NewProjectGUI.this.updateProjDir();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                NewProjectGUI.this.updateProjDir();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                NewProjectGUI.this.updateProjDir();
            }
        };
        this.projName.getDocument().addDocumentListener(docLis);
        this.projDir.getDocument().addDocumentListener(docLis);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New project parameters", 1, 2));
        p.add((Component)this.pLabels, "Center");
        p.add((Component)this.pFields, "East");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    void updateProjDir() {
        String s = "";
        if (!this.projDir.getText().endsWith(File.separator)) {
            s = File.separator;
        }
        this.projFinalDir.setText(this.projDir.getText() + s + this.projName.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean ok() {
        String projDecl = this.getProjDecl();
        if (projDecl == null) {
            return false;
        }
        File finalDir = new File(this.projFinalDir.getText().trim());
        try {
            boolean ok;
            if (!finalDir.exists() && !(ok = finalDir.mkdirs())) {
                JOptionPane.showMessageDialog(this, "Error creating project directory: " + finalDir);
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, "Error creating project directory: " + finalDir + ": " + e2);
            return false;
        }
        String pFile = finalDir + File.separator + this.projName.getText() + "." + "mas2j";
        boolean newFile = !new File(pFile).exists();
        Buffer b = jEdit.openFile((View)this.view, (String)pFile);
        if (newFile) {
            try {
                b.writeLock();
                b.insert(0, projDecl);
                b.save(this.view, pFile);
            }
            finally {
                b.writeUnlock();
            }
        }
        this.jasonID.textArea.setText("Project created!");
        return true;
    }

    private String getProjDecl() {
        if (this.projName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "A project name must be informed.");
            return null;
        }
        String name = this.projName.getText().trim();
        if (Character.isUpperCase(name.charAt(0))) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        if (this.jasonID.getProjectBuffer(name + "." + "mas2j") != null) {
            JOptionPane.showMessageDialog(this, "There already is a project called " + name);
            return null;
        }
        String projDecl = Config.get().getTemplate("project");
        projDecl = projDecl.replace("<PROJECT_NAME>", name);
        projDecl = projDecl.replace("<INFRA>", this.projInfra.getSelectedItem().toString());
        return projDecl;
    }
}

