/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import jason.jeditplugin.NewAgentGUI;
import jason.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class NewEnvironmentGUI
extends NewAgentGUI {
    private static final long serialVersionUID = 1L;
    private JTextField envClass;

    public NewEnvironmentGUI(String title, Buffer b, View view) {
        super(title, b, view, ".");
    }

    @Override
    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.envClass = new JTextField(20);
        this.createField("Environment class name", this.envClass, "Enter the name of the environment Java class here.");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New environment parameters", 1, 2));
        p.add((Component)this.pLabels, "Center");
        p.add((Component)this.pFields, "East");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean ok() {
        String env = this.getEnvName();
        if (env == null) {
            JOptionPane.showMessageDialog(this, "An environment name must be informed.");
            return false;
        }
        try {
            this.buffer.writeLock();
            String proj = this.buffer.getText(0, this.buffer.getLength());
            int pos = proj.lastIndexOf("agents");
            if (pos < 0) {
                pos = this.buffer.getLength();
            }
            this.buffer.insert(pos, "environment: " + env + "\n\n    ");
        }
        finally {
            this.buffer.writeUnlock();
        }
        String envFile = this.buffer.getDirectory() + env + ".java";
        boolean newFile = !new File(envFile).exists();
        Buffer nb = jEdit.openFile((View)this.view, (String)envFile);
        if (newFile) {
            try {
                nb.writeLock();
                nb.insert(0, this.getEnvText(env));
                nb.save(this.view, envFile);
            }
            finally {
                nb.writeUnlock();
            }
        }
        return true;
    }

    private String getEnvName() {
        String env = this.envClass.getText().trim();
        if (env.length() > 0) {
            return env;
        }
        return null;
    }

    String getEnvText(String className) {
        String envCode = Config.get().getTemplate("environment");
        envCode = envCode.replaceAll("<ENV_NAME>", className);
        envCode = envCode.replaceAll("<PROJECT_NAME>", this.buffer.getName());
        return envCode;
    }
}

