/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTerm;
import jason.asSyntax.parser.ParseException;
import jason.infra.MASLauncherInfraTier;
import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.infra.jade.ContainerAllocation;
import jason.infra.jade.JadeAgArch;
import jason.infra.jade.JadeEnvironment;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.AgentParameters;
import jason.util.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;

public class JadeMASLauncherAnt
extends CentralisedMASLauncherAnt
implements MASLauncherInfraTier {
    public static String snifferConfFile = "sniffer.properties";
    public static String customSnifferConfFile = "c-sniffer.properties";

    @Override
    protected String replaceMarks(String script, boolean debug) {
        File sFile = new File(this.project.getDirectory() + File.separator + snifferConfFile);
        File csFile = new File(this.project.getDirectory() + File.separator + customSnifferConfFile);
        try {
            if (csFile.exists()) {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(csFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(sFile));
                while ((line = in.readLine()) != null) {
                    out.write(line + "\n");
                }
                out.close();
                in.close();
            } else {
                sFile.delete();
                if (Config.get().getBoolean("jadeSniffer")) {
                    PrintWriter out = new PrintWriter(new FileWriter(sFile));
                    out.print("preload=");
                    Iterator<AgentParameters> i = this.project.getAgents().iterator();
                    while (i.hasNext()) {
                        AgentParameters ap = i.next();
                        out.print(ap.name);
                        if (!i.hasNext()) continue;
                        out.print(";");
                    }
                    out.println();
                    out.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String jadeJar = Config.get().getJadeJar();
        if (!Config.checkJar(jadeJar)) {
            System.err.println("The path to the jade.jar file (" + jadeJar + ") was not correctly set. Go to menu Plugin->Options->Jason to configure the path.");
        }
        script = JadeMASLauncherAnt.replace(script, "<PROJECT-RUNNER-CLASS>", RunJadeMAS.class.getName());
        String jadepath = "\t<pathelement location=\"" + Config.get().getJadeJar() + "\"/>";
        script = JadeMASLauncherAnt.replace(script, "<PATH-LIB>", jadepath + "\n<PATH-LIB>");
        String startContainers = "";
        String mainHost = this.project.getInfrastructure().getParameter("main_container_host");
        if (mainHost == null) {
            mainHost = "localhost";
        } else {
            try {
                mainHost = ((StringTerm)ASSyntax.parseLiteral(mainHost).getTerm(0)).getString();
            }
            catch (ParseException e2) {
                e2.printStackTrace();
            }
        }
        int mainHostPort = -1;
        int pos = mainHost.indexOf(":");
        if (pos > 0) {
            try {
                mainHostPort = new Integer(mainHost.substring(pos + 1));
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            mainHost = mainHost.substring(0, pos);
        }
        ContainerAllocation allocator = null;
        String allocationClass = this.project.getInfrastructure().getParameter("container_allocation");
        if (allocationClass != null) {
            try {
                Literal literalArgs = ASSyntax.parseLiteral(allocationClass);
                String className = ((StringTerm)literalArgs.getTerm(0)).getString();
                allocator = (ContainerAllocation)Class.forName(className).newInstance();
                allocator.init(new String[]{((StringTerm)literalArgs.getTerm(1)).getString()}, this.project);
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        HashSet<String> containers = new HashSet<String>();
        containers.add("Main-Container");
        if (allocator == null) {
            for (AgentParameters ap : this.project.getAgents()) {
                if (ap.getHost() == null || ap.getHost().isEmpty()) continue;
                containers.add(ap.getHost());
            }
        } else {
            containers.addAll(allocator.getContainers());
        }
        for (String container : containers) {
            String sep = " ";
            String args = "-container -host " + mainHost + " -container-name " + container + " ";
            if (mainHostPort > 0) {
                args = args + "-port " + mainHostPort;
            }
            StringBuilder agents = new StringBuilder();
            if (container.equals("Main-Container")) {
                if (!JadeAgArch.isCartagoJadeCase(this.project)) {
                    agents.append(RunJadeMAS.environmentName + ":" + JadeEnvironment.class.getName() + "(j-project," + this.project.getProjectFile().getName() + ")");
                    sep = ";";
                }
                args = Config.get().getJadeArgs();
                if (mainHostPort > 0) {
                    args = args + " -port " + mainHostPort;
                }
                if (Config.get().getBoolean("jadeRMA")) {
                    args = args + " -gui ";
                }
            }
            for (AgentParameters ap : this.project.getAgents()) {
                for (int cAg = 0; cAg < ap.getNbInstances(); ++cAg) {
                    String numberedAg = ap.getAgName();
                    if (ap.getNbInstances() > 1) {
                        numberedAg = numberedAg + (cAg + 1);
                    }
                    if (!(container.equals("Main-Container") && ap.getHost() == null && allocator == null || ap.getHost() != null && ap.getHost().equals(container)) && (allocator == null || allocator.allocateAgent(numberedAg) == null || !allocator.allocateAgent(numberedAg).equals(container))) continue;
                    agents.append(sep + numberedAg + ":" + JadeAgArch.class.getName() + "(j-project," + this.project.getProjectFile().getName() + "," + ap.getAgName() + ")");
                    sep = ";";
                }
            }
            startContainers = startContainers + "    <target name=\"" + container + "\" depends=\"compile\" >\n" + "        <echo message=\"Starting JADE Container " + container + "\" />\n" + "        <java classname=\"jade.Boot\" failonerror=\"true\" fork=\"yes\" dir=\"${basedir}\" >\n" + "            <classpath refid=\"project.classpath\"/>\n" + "            <arg line=\"" + args + " -agents " + agents + "\"/>\n" + "            <jvmarg line=\"-Xmx500M -Xss8M\"/>\n" + "        </java>\n" + "    </target>\n\n";
        }
        script = JadeMASLauncherAnt.replace(script, "<OTHER-TASK>", startContainers);
        return super.replaceMarks(script, debug);
    }
}

