/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jason.asSemantics.Message;
import jason.asSyntax.Term;
import jason.infra.jade.JadeAgArch;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public abstract class JadeAg
extends Agent {
    public static final int UNTELL = 1001;
    public static final int ASKALL = 1002;
    public static final int UNACHIEVE = 1003;
    public static final int TELLHOW = 1004;
    public static final int UNTELLHOW = 1005;
    public static final int ASKHOW = 1006;
    private static final long serialVersionUID = 1L;
    protected java.util.logging.Logger logger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());
    private static int rwid = 0;
    protected boolean running = true;
    protected Map<String, String> conversationIds = new HashMap<String, String>();

    public void doDelete() {
        this.running = false;
        super.doDelete();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int incReplyWithId() {
        return rwid++;
    }

    public void sendMsg(Message m) throws Exception {
        String convid;
        ACLMessage acl = this.jasonToACL(m);
        acl.addReceiver(new AID(m.getReceiver(), false));
        if (m.getInReplyTo() != null && (convid = this.conversationIds.get(m.getInReplyTo())) != null) {
            acl.setConversationId(convid);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Sending message: " + acl);
        }
        this.send(acl);
    }

    public void broadcast(final Message m) {
        this.addBehaviour((Behaviour)new OneShotBehaviour(){
            private static final long serialVersionUID = 1L;

            public void action() {
                try {
                    ACLMessage acl = JadeAg.this.jasonToACL(m);
                    JadeAg.this.addAllAgsAsReceivers(acl);
                    JadeAg.this.send(acl);
                }
                catch (Exception e2) {
                    JadeAg.this.logger.log(Level.SEVERE, "Error in broadcast of " + m, e2);
                }
            }
        });
    }

    public void putConversationId(String replyWith, String mId) {
        this.conversationIds.put(replyWith, mId);
    }

    protected ACLMessage ask(ACLMessage m) {
        try {
            String waitingRW = "id" + this.incReplyWithId();
            m.setReplyWith(waitingRW);
            this.send(m);
            ACLMessage r = this.blockingReceive(MessageTemplate.MatchInReplyTo((String)waitingRW), 5000L);
            if (r != null) {
                return r;
            }
            this.logger.warning("ask timeout for " + m.getContent());
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error waiting message.", e2);
        }
        return null;
    }

    public void addAllAgsAsReceivers(ACLMessage m) throws Exception {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("jason");
        sd.setName(JadeAgArch.dfName);
        template.addServices(sd);
        DFAgentDescription[] ans = DFService.search((Agent)this, (DFAgentDescription)template);
        for (int i = 0; i < ans.length; ++i) {
            if (ans[i].getName().equals((Object)this.getAID())) continue;
            m.addReceiver(ans[i].getName());
        }
    }

    protected ACLMessage jasonToACL(Message m) throws IOException {
        ACLMessage acl = JadeAg.kqmlToACL(m.getIlForce());
        if (m.getPropCont() instanceof Term || m.getPropCont() instanceof String) {
            acl.setContent(m.getPropCont().toString());
        } else {
            acl.setContentObject((Serializable)m.getPropCont());
        }
        acl.setReplyWith(m.getMsgId());
        acl.setLanguage("AgentSpeak");
        if (m.getInReplyTo() != null) {
            acl.setInReplyTo(m.getInReplyTo());
        }
        return acl;
    }

    public static ACLMessage kqmlToACL(String p) {
        if (p.equals("tell")) {
            return new ACLMessage(7);
        }
        if (p.equals("askOne")) {
            return new ACLMessage(13);
        }
        if (p.equals("achieve")) {
            return new ACLMessage(16);
        }
        if (p.equals("untell") || p.equals("unachieve") || p.equals("askAll") || p.equals("askHow") || p.equals("tellHow") || p.equals("untellHow")) {
            ACLMessage m = new ACLMessage(9);
            m.addUserDefinedParameter("kqml-performative", p);
            return m;
        }
        return new ACLMessage(ACLMessage.getInteger((String)p));
    }

    public static String aclToKqml(ACLMessage m) {
        switch (m.getPerformative()) {
            case 7: {
                return "tell";
            }
            case 13: {
                return "askOne";
            }
            case 16: {
                return "achieve";
            }
            case 9: {
                String kp = m.getUserDefinedParameter("kqml-performative");
                if (kp == null) break;
                return kp;
            }
        }
        return ACLMessage.getPerformative((int)m.getPerformative()).toLowerCase().replaceAll("-", "_");
    }
}

