/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.infra.MASLauncherInfraTier;
import jason.infra.RunProjectListener;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.MAS2JProject;
import jason.util.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CentralisedMASLauncherAnt
implements MASLauncherInfraTier {
    protected MAS2JProject project;
    protected RunProjectListener listener;
    protected boolean stop = false;
    protected Process masProcess = null;
    protected OutputStream processOut;
    protected boolean useBuildFileName = true;
    public static String bindir = "bin" + File.separator;
    private String task;

    public CentralisedMASLauncherAnt() {
        this.task = "run";
    }

    public CentralisedMASLauncherAnt(String task) {
        this.task = task;
    }

    @Override
    public void setProject(MAS2JProject project) {
        this.project = project;
    }

    @Override
    public void setListener(RunProjectListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String[] command = this.getStartCommandArray();
            if (command == null) {
                System.err.println("Problem defining the command to run the MAS!");
                return;
            }
            String cmdstr = command[0];
            for (int i = 1; i < command.length; ++i) {
                cmdstr = cmdstr + " " + command[i];
            }
            System.out.println("Executing " + cmdstr);
            File dir = new File(new File(this.project.getDirectory()).getAbsolutePath());
            this.masProcess = Runtime.getRuntime().exec(command, null, dir);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.masProcess.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(this.masProcess.getErrorStream()));
            this.processOut = this.masProcess.getOutputStream();
            Thread.sleep(300L);
            this.stop = false;
            while (!this.stop) {
                while (in.ready()) {
                    System.out.println(in.readLine());
                }
                while (err.ready()) {
                    System.out.println(err.readLine());
                }
                Thread.sleep(250L);
                try {
                    this.masProcess.exitValue();
                    this.stop = true;
                }
                catch (Exception e2) {}
            }
            while (in.ready()) {
                System.out.println(in.readLine());
            }
            while (err.ready()) {
                System.out.println(err.readLine());
            }
            System.out.flush();
        }
        catch (Exception e3) {
            System.err.println("Execution error: " + e3);
            e3.printStackTrace();
        }
        finally {
            if (this.listener != null) {
                this.listener.masFinished();
            }
        }
    }

    @Override
    public void stopMAS() {
        try {
            File stop = new File(this.project.getDirectory() + File.separator + ".stop___MAS");
            stop.createNewFile();
        }
        catch (Exception e2) {
            System.err.println("Error stoping RunCentMAS: " + e2);
            e2.printStackTrace();
        }
        finally {
            this.stop = true;
        }
    }

    public String[] getStartCommandArray() {
        String ant;
        String build = bindir + this.getBuildFileName();
        if (this.hasCBuild()) {
            build = bindir + this.getCustomBuildFileName();
        }
        if ((ant = Config.get().getAntJar()) == null) {
            System.err.println("Ant is not properly configured! Current value is " + Config.get().getAntLib());
            return null;
        }
        return new String[]{Config.get().getJavaHome() + "bin" + File.separator + "java", "-classpath", Config.get().getAntLib() + ant, "org.apache.tools.ant.launch.Launcher", "-e", "-f", build, this.task};
    }

    public String getBuildFileName() {
        if (this.useBuildFileName) {
            return "build.xml";
        }
        return this.project.getSocName() + ".xml";
    }

    public String getCustomBuildFileName() {
        if (this.useBuildFileName) {
            return "c-build.xml";
        }
        return "c-" + this.project.getSocName() + ".xml";
    }

    @Override
    public boolean writeScripts(boolean debug, boolean useBuildFileName) {
        this.useBuildFileName = useBuildFileName;
        try {
            String script = Config.get().getTemplate("build-template.xml");
            script = this.replaceMarks(script, debug);
            File bindirfile = new File(this.project.getDirectory() + File.separator + bindir);
            if (!bindirfile.exists()) {
                bindirfile.mkdirs();
            }
            FileWriter out = new FileWriter(this.project.getDirectory() + File.separator + bindir + this.getBuildFileName());
            out.write(script);
            out.close();
            return true;
        }
        catch (Exception e2) {
            System.err.println("Could not write start script for project " + this.project.getSocName());
            e2.printStackTrace();
            return false;
        }
    }

    protected String replaceMarks(String script, boolean debug) {
        script = CentralisedMASLauncherAnt.replace(script, "<VERSION>", Config.get().getJasonVersion());
        script = CentralisedMASLauncherAnt.replace(script, "<DATE>", new SimpleDateFormat("MMMM dd, yyyy - HH:mm:ss").format(new Date()));
        script = CentralisedMASLauncherAnt.replace(script, "<PROJECT-ID>", this.project.getSocName());
        String dDir = this.project.getDirectory();
        if (dDir.endsWith(File.separator + ".")) {
            dDir = dDir.substring(0, dDir.length() - 2);
        }
        if (dDir.endsWith(File.separator)) {
            dDir = dDir.substring(0, dDir.length() - 1);
        }
        script = CentralisedMASLauncherAnt.replace(script, "<PROJECT-DIR>", dDir);
        script = CentralisedMASLauncherAnt.replace(script, "<PROJECT-FILE>", this.project.getProjectFile().getName());
        script = CentralisedMASLauncherAnt.replace(script, "<JASON-JAR>", Config.get().getJasonJar());
        String lib = "";
        if (this.project.isJade() || this.project.getEnvClass() != null && this.project.getEnvClass().getClassName().equals("c4jason.CartagoEnvironment")) {
            String c4jason;
            Config c = Config.get();
            String cartago = Config.findJarInDirectory(new File(c.getJasonHome() + "/libs"), "cartago");
            if (cartago != null) {
                lib = lib + "        <pathelement location=\"" + cartago + "\"/>\n";
            }
            if ((c4jason = Config.findJarInDirectory(new File(c.getJasonHome() + "/libs"), "jaca")) != null) {
                lib = lib + "        <pathelement location=\"" + c4jason + "\"/>\n";
            }
        }
        if (new File(dDir + File.separator + "lib").exists()) {
            lib = lib + "        <fileset dir=\"${basedir}/lib\" >  <include name=\"*.jar\" /> </fileset>\n";
        }
        if (new File(dDir + File.separator + "libs").exists()) {
            lib = lib + "        <fileset dir=\"${basedir}/libs\" >  <include name=\"*.jar\" /> </fileset>\n";
        }
        for (String cp : this.project.getClassPaths()) {
            int apos = cp.indexOf("*");
            if (apos < 0) {
                lib = lib + "        <pathelement location=\"" + cp + "\"/>\n";
                continue;
            }
            cp = cp.replaceAll("\\\\", "/");
            String dir = "${basedir}";
            String files = cp;
            int spos = cp.lastIndexOf("/");
            if (spos >= 0 && spos < apos) {
                dir = cp.substring(0, spos);
                files = cp.substring(spos + 1);
            } else {
                spos = cp.lastIndexOf("/**");
                if (spos >= 0 && spos < apos) {
                    dir = cp.substring(0, spos);
                    files = cp.substring(spos + 1);
                }
            }
            lib = lib + "        <fileset dir=\"" + dir + "\" >  <include name=\"" + files + "\" /> </fileset>\n";
        }
        script = CentralisedMASLauncherAnt.replace(script, "<PATH-LIB>", lib);
        script = CentralisedMASLauncherAnt.replace(script, "<PROJECT-RUNNER-CLASS>", RunCentralisedMAS.class.getName());
        String sDebug = "";
        if (debug) {
            sDebug = " -debug";
        }
        script = CentralisedMASLauncherAnt.replace(script, "<DEBUG>", sDebug);
        script = CentralisedMASLauncherAnt.replace(script, "<OTHER-TASK>", "");
        script = CentralisedMASLauncherAnt.replace(script, "<JASON-HOME>", Config.get().getJasonHome());
        script = CentralisedMASLauncherAnt.replace(script, "<JASON-HOME>", Config.get().getJasonHome());
        script = CentralisedMASLauncherAnt.replace(script, "<RUN-ARGS>", "");
        return script;
    }

    public static String replace(String s, String p, String n) {
        int i = s.indexOf(p);
        if (i >= 0) {
            s = s.substring(0, i) + n + s.substring(i + p.length());
        }
        return s;
    }

    protected boolean hasCBuild() {
        return new File(this.project.getDirectory() + File.separator + bindir + this.getCustomBuildFileName()).exists();
    }
}

