/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.control.ExecutionControl;
import jason.control.ExecutionControlInfraTier;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class CentralisedExecutionControl
implements ExecutionControlInfraTier {
    private ExecutionControl userController;
    private BaseCentralisedMAS masRunner = null;
    private static Logger logger = Logger.getLogger(CentralisedExecutionControl.class.getName());
    protected ExecutorService executor = Executors.newSingleThreadExecutor();

    public CentralisedExecutionControl(ClassParameters userControlClass, BaseCentralisedMAS masRunner) throws JasonException {
        this.masRunner = masRunner;
        try {
            this.userController = (ExecutionControl)Class.forName(userControlClass.getClassName()).newInstance();
            this.userController.setExecutionControlInfraTier(this);
            this.userController.init(userControlClass.getParametersArray());
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error ", e2);
            throw new JasonException("The user execution control class instantiation '" + userControlClass + "' has failed!" + e2.getMessage());
        }
    }

    public void stop() {
        this.userController.stop();
    }

    public ExecutionControl getUserControl() {
        return this.userController;
    }

    public void receiveFinishedCycle(String agName, boolean breakpoint, int cycle) {
        this.userController.receiveFinishedCycle(agName, breakpoint, cycle);
    }

    @Override
    public void informAgToPerformCycle(String agName, int cycle) {
        CentralisedAgArch infraArch = this.masRunner.getAg(agName);
        AgArch arch = infraArch.getUserAgArch();
        arch.setCycleNumber(cycle);
        infraArch.receiveSyncSignal();
    }

    @Override
    public void informAllAgsToPerformCycle(final int cycle) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<String, CentralisedAgArch> map = CentralisedExecutionControl.this.masRunner.getAgs();
                synchronized (map) {
                    for (CentralisedAgArch ag : CentralisedExecutionControl.this.masRunner.getAgs().values()) {
                        ag.getUserAgArch().setCycleNumber(cycle);
                        ag.receiveSyncSignal();
                    }
                }
            }
        });
    }

    @Override
    public Document getAgState(String agName) {
        AgArch arch = this.masRunner.getAg(agName).getUserAgArch();
        if (arch != null) {
            return arch.getTS().getAg().getAgState();
        }
        return null;
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(this.masRunner);
    }
}

